/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.input;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.IllegalComponentStateException;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.swing.SwingUtilities;
import org.assertj.core.util.Preconditions;
import org.assertj.swing.awt.AWT;
import org.assertj.swing.dependency.jsr305.Nonnull;
import org.assertj.swing.dependency.jsr305.Nullable;
import org.assertj.swing.dependency.jsr305.concurrent.GuardedBy;
import org.assertj.swing.dependency.jsr305.concurrent.ThreadSafe;
import org.assertj.swing.exception.UnexpectedException;
import org.assertj.swing.input.DragDropInfo;
import org.assertj.swing.input.EventNormalizer;
import org.assertj.swing.input.MouseInfo;
import org.assertj.swing.listener.EventDispatchThreadedEventListener;

@ThreadSafe
public class InputState {
    @GuardedBy(value="this")
    private final MouseInfo mouseInfo = new MouseInfo();
    @GuardedBy(value="this")
    private final DragDropInfo dragDropInfo = new DragDropInfo();
    @GuardedBy(value="this")
    private int modifiers;
    @GuardedBy(value="this")
    private long lastEventTime;
    private EventNormalizer normalizer;

    public InputState(@Nonnull Toolkit toolkit) {
        long mask = 56L;
        EventDispatchThreadedEventListener listener = new EventDispatchThreadedEventListener(){

            @Override
            protected void processEvent(@Nonnull AWTEvent event) {
                InputState.this.update(event);
            }
        };
        this.normalizer = new EventNormalizer();
        this.normalizer.startListening(toolkit, listener, mask);
    }

    public synchronized void clear() {
        this.mouseInfo.clear();
        this.dragDropInfo.clear();
        this.modifiers = 0;
        this.lastEventTime = 0L;
    }

    public void dispose() {
        this.normalizer.stopListening();
        this.normalizer = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(@Nonnull AWTEvent event) {
        if (event instanceof InputEvent) {
            InputEvent inputEvent = (InputEvent)event;
            if (inputEvent.getWhen() < this.lastEventTime()) {
                return;
            }
            if (inputEvent instanceof KeyEvent) {
                InputState inputState = this;
                synchronized (inputState) {
                    this.lastEventTime(inputEvent);
                    this.modifiers(inputEvent.getModifiers());
                }
            }
            if (inputEvent instanceof MouseEvent) {
                MouseEvent mouseEvent = (MouseEvent)inputEvent;
                Point eventScreenLocation = this.screenLocation(mouseEvent);
                InputState inputState = this;
                synchronized (inputState) {
                    this.lastEventTime(mouseEvent);
                    this.dragDropInfo.update(mouseEvent);
                    this.mouseInfo.modifiers(this.modifiers);
                    this.mouseInfo.update(mouseEvent, eventScreenLocation);
                    this.modifiers(this.mouseInfo.modifiers());
                }
            }
        }
    }

    @Nullable
    private Point screenLocation(@Nonnull MouseEvent event) {
        block3: {
            try {
                Component component = (Component)Preconditions.checkNotNull((Object)event.getComponent());
                return AWT.locationOnScreenOf(component);
            }
            catch (IllegalComponentStateException e) {
            }
            catch (UnexpectedException e) {
                if (e.getCause() instanceof IllegalComponentStateException) break block3;
                throw e;
            }
        }
        return null;
    }

    private void lastEventTime(@Nonnull InputEvent event) {
        this.lastEventTime = event.getWhen();
    }

    private void modifiers(int newModifiers) {
        this.modifiers = newModifiers;
    }

    @Nullable
    public synchronized Component deepestComponentUnderMousePointer() {
        Point mouseLocation;
        Component c = this.mouseComponent();
        if (c != null && (mouseLocation = this.mouseLocation()) != null) {
            c = InputState.childAt(c, mouseLocation);
        }
        return c;
    }

    @Nullable
    public synchronized Component mouseComponent() {
        return this.mouseInfo.component();
    }

    public static Component childAt(@Nonnull Component parent, @Nonnull Point where) {
        return SwingUtilities.getDeepestComponentAt(parent, where.x, where.y);
    }

    public synchronized boolean dragInProgress() {
        return this.dragDropInfo.isDragging();
    }

    public synchronized Component dragSource() {
        return this.dragDropInfo.source();
    }

    public synchronized Point dragOrigin() {
        return this.dragDropInfo.origin();
    }

    public synchronized int clickCount() {
        return this.mouseInfo.clickCount();
    }

    public synchronized long lastEventTime() {
        return this.lastEventTime;
    }

    public synchronized int modifiers() {
        return this.modifiers;
    }

    public synchronized int keyModifiers() {
        return this.modifiers & 0xFFFFFFE3;
    }

    public synchronized int buttons() {
        return this.mouseInfo.buttons();
    }

    @Nullable
    public synchronized Point mouseLocation() {
        return this.mouseInfo.location();
    }

    @Nullable
    public synchronized Point mouseLocationOnScreen() {
        return this.mouseInfo.locationOnScreen();
    }

    public boolean isNativeDragActive() {
        return this.dragDropInfo.isNativeDragActive();
    }
}

