/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.fixture;

import java.awt.Font;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractCharSequenceAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.description.Description;
import org.assertj.core.description.TextDescription;
import org.assertj.core.util.Preconditions;
import org.assertj.core.util.Strings;
import org.assertj.swing.dependency.jsr305.Nonnull;
import org.assertj.swing.dependency.jsr305.Nullable;

public class FontFixture {
    private static final String PROPERTY_SEPARATOR = " - ";
    private static final String BOLD_PROPERTY = "bold";
    private static final String FAMILY_PROPERTY = "family";
    private static final String ITALIC_PROPERTY = "italic";
    private static final String NAME_PROPERTY = "name";
    private static final String PLAIN_PROPERTY = "plain";
    private static final String SIZE_PROPERTY = "size";
    private final Font target;
    private final Description description;

    public FontFixture(@Nonnull Font target) {
        this(target, (Description)null);
    }

    public FontFixture(@Nonnull Font target, @Nonnull String description) {
        this(target, (Description)new TextDescription(description, new Object[0]));
    }

    public FontFixture(@Nonnull Font target, @Nullable Description description) {
        this.target = (Font)Preconditions.checkNotNull((Object)target);
        this.description = description;
    }

    @Nonnull
    public FontFixture requireFamily(@Nonnull String family) {
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)this.target.getFamily()).as(this.property(FAMILY_PROPERTY), new Object[0])).isEqualTo((Object)family);
        return this;
    }

    @Nonnull
    public FontFixture requireName(@Nonnull String name) {
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)this.target.getName()).as(this.property(NAME_PROPERTY), new Object[0])).isEqualTo((Object)name);
        return this;
    }

    @Nonnull
    public FontFixture requireSize(int size) {
        ((AbstractIntegerAssert)Assertions.assertThat((int)this.target.getSize()).as(this.property(SIZE_PROPERTY), new Object[0])).isEqualTo(size);
        return this;
    }

    @Nonnull
    public FontFixture requireBold() {
        return this.requireBold(true);
    }

    @Nonnull
    public FontFixture requireNotBold() {
        return this.requireBold(false);
    }

    @Nonnull
    private FontFixture requireBold(boolean bold) {
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.target.isBold()).as(this.property(BOLD_PROPERTY), new Object[0])).isEqualTo(bold);
        return this;
    }

    @Nonnull
    public FontFixture requireItalic() {
        return this.requireItalic(true);
    }

    @Nonnull
    public FontFixture requireNotItalic() {
        return this.requireItalic(false);
    }

    @Nonnull
    private FontFixture requireItalic(boolean italic) {
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.target.isItalic()).as(this.property(ITALIC_PROPERTY), new Object[0])).isEqualTo(italic);
        return this;
    }

    @Nonnull
    public FontFixture requirePlain() {
        return this.requirePlain(true);
    }

    @Nonnull
    public FontFixture requireNotPlain() {
        return this.requirePlain(false);
    }

    @Nonnull
    private FontFixture requirePlain(boolean plain) {
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.target.isBold()).as(this.property(PLAIN_PROPERTY), new Object[0])).isEqualTo(plain);
        return this;
    }

    @Nonnull
    private String property(@Nonnull String s) {
        if (!Strings.isNullOrEmpty((String)this.description())) {
            return Strings.concat((Object[])new Object[]{this.description.value(), PROPERTY_SEPARATOR, s});
        }
        return s;
    }

    @Nonnull
    public Font target() {
        return this.target;
    }

    @Nullable
    public final String description() {
        return this.description != null ? this.description.value() : null;
    }
}

