/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.driver;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.IllegalComponentStateException;
import java.awt.Insets;
import java.awt.Point;
import javax.swing.JInternalFrame;
import org.assertj.core.util.Preconditions;
import org.assertj.core.util.VisibleForTesting;
import org.assertj.swing.annotation.RunsInCurrentThread;
import org.assertj.swing.annotation.RunsInEDT;
import org.assertj.swing.core.Robot;
import org.assertj.swing.dependency.fest_reflect.core.Reflection;
import org.assertj.swing.dependency.fest_reflect.exception.ReflectionError;
import org.assertj.swing.dependency.jsr305.Nonnull;
import org.assertj.swing.dependency.jsr305.Nullable;
import org.assertj.swing.driver.ComponentDriver;
import org.assertj.swing.driver.ComponentMovableQuery;
import org.assertj.swing.driver.ComponentMoveTask;
import org.assertj.swing.driver.ComponentPreconditions;
import org.assertj.swing.driver.ComponentSetSizeTask;
import org.assertj.swing.edt.GuiActionRunner;
import org.assertj.swing.edt.GuiQuery;
import org.assertj.swing.format.Formatting;
import org.assertj.swing.internal.annotation.InternalApi;
import org.assertj.swing.util.Pair;
import org.assertj.swing.util.Triple;

@InternalApi
public abstract class ContainerDriver
extends ComponentDriver {
    public ContainerDriver(@Nonnull Robot robot) {
        super(robot);
    }

    @RunsInEDT
    protected final void doResizeWidth(@Nonnull Container c, int width) {
        Pair<Dimension, Insets> resizeInfo = this.resizeInfo(c);
        Dimension size = (Dimension)resizeInfo.first;
        this.resizeBy(c, resizeInfo, width - size.width, 0);
    }

    @RunsInEDT
    protected final void doResizeHeight(@Nonnull Container c, int height) {
        Pair<Dimension, Insets> resizeInfo = this.resizeInfo(c);
        Dimension size = (Dimension)resizeInfo.first;
        this.resizeBy(c, resizeInfo, 0, height - size.height);
    }

    @RunsInEDT
    protected final void resize(@Nonnull Container c, int width, int height) {
        Pair<Dimension, Insets> resizeInfo = this.resizeInfo(c);
        Dimension size = (Dimension)resizeInfo.first;
        this.resizeBy(c, resizeInfo, width - size.width, height - size.height);
    }

    @Nonnull
    @RunsInEDT
    private Pair<Dimension, Insets> resizeInfo(final @Nonnull Container c) {
        Pair<Dimension, Insets> result = GuiActionRunner.execute(new GuiQuery<Pair<Dimension, Insets>>(){

            @Override
            @Nullable
            protected Pair<Dimension, Insets> executeInEDT() {
                ContainerDriver.this.checkCanResize(c);
                return Pair.of(c.getSize(), c.getInsets());
            }
        });
        return (Pair)Preconditions.checkNotNull(result);
    }

    @VisibleForTesting
    @RunsInCurrentThread
    void checkCanResize(@Nonnull Container c) {
        if (!this.isResizable(c)) {
            String msg = String.format("Expecting component %s to be resizable by the user", Formatting.format(c));
            throw new IllegalStateException(msg);
        }
        if (c instanceof JInternalFrame) {
            ComponentPreconditions.checkShowing(c);
            return;
        }
        ComponentPreconditions.checkEnabledAndShowing(c);
    }

    @RunsInCurrentThread
    protected boolean isResizable(@Nonnull Container c) {
        try {
            Boolean resizable = Reflection.method("isResizable").withReturnType(Boolean.TYPE).in(c).invoke(new Object[0]);
            return (Boolean)Preconditions.checkNotNull((Object)resizable);
        }
        catch (ReflectionError e) {
            return false;
        }
    }

    @RunsInEDT
    private void resizeBy(@Nonnull Container c, @Nonnull Pair<Dimension, Insets> resizeInfo, int x, int y) {
        this.simulateResizeStarted(c, resizeInfo, x, y);
        Dimension size = (Dimension)resizeInfo.first;
        ComponentSetSizeTask.setComponentSize(c, size.width + x, size.height + y);
        this.robot.waitForIdle();
    }

    @RunsInEDT
    private void simulateResizeStarted(@Nonnull Container c, @Nonnull Pair<Dimension, Insets> resizeInfo, int x, int y) {
        Point p = ContainerDriver.resizeLocation(resizeInfo);
        this.moveMouseIgnoringAnyError(c, p);
        this.moveMouseIgnoringAnyError(c, p.x + x, p.y + y);
    }

    @Nonnull
    private static Point resizeLocation(@Nonnull Pair<Dimension, Insets> resizeInfo) {
        return ContainerDriver.resizeLocation((Dimension)Preconditions.checkNotNull(resizeInfo.first), (Insets)Preconditions.checkNotNull(resizeInfo.second));
    }

    @Nonnull
    private static Point resizeLocation(@Nonnull Dimension size, @Nonnull Insets insets) {
        return ContainerDriver.resizeLocation(size.width, size.height, insets.right, insets.bottom);
    }

    @Nonnull
    private static Point resizeLocation(int width, int height, int right, int bottom) {
        return new Point(width - right / 2, height - bottom / 2);
    }

    @RunsInEDT
    public void move(@Nonnull Container c, int x, int y) {
        Triple<Dimension, Insets, Point> moveInfo = this.moveInfo(c);
        Point locationOnScreen = (Point)moveInfo.third;
        this.moveBy(c, moveInfo, x - locationOnScreen.x, y - locationOnScreen.y);
    }

    @Nonnull
    @RunsInEDT
    private Triple<Dimension, Insets, Point> moveInfo(final @Nonnull Container c) {
        Triple<Dimension, Insets, Point> result = GuiActionRunner.execute(new GuiQuery<Triple<Dimension, Insets, Point>>(){

            @Override
            @Nullable
            protected Triple<Dimension, Insets, Point> executeInEDT() {
                ContainerDriver.this.checkCanMove(c);
                Point locationOnScreen = null;
                try {
                    locationOnScreen = c.getLocationOnScreen();
                }
                catch (IllegalComponentStateException e) {
                    // empty catch block
                }
                if (locationOnScreen == null) {
                    String msg = String.format("Expecting component %s to be showing on the screen", Formatting.format(c));
                    throw new IllegalStateException(msg);
                }
                return Triple.of(c.getSize(), c.getInsets(), locationOnScreen);
            }
        });
        return (Triple)Preconditions.checkNotNull(result);
    }

    @RunsInCurrentThread
    private void checkCanMove(@Nonnull Container c) {
        ComponentPreconditions.checkEnabledAndShowing(c);
        if (!ComponentMovableQuery.isUserMovable(c)) {
            String msg = String.format("Expecting component %s to be movable by the user", Formatting.format(c));
            throw new IllegalStateException(msg);
        }
    }

    @RunsInEDT
    private void moveBy(@Nonnull Container c, @Nonnull Triple<Dimension, Insets, Point> moveInfo, int x, int y) {
        this.simulateMoveStarted(c, moveInfo, x, y);
        Point locationOnScreen = (Point)moveInfo.third;
        Point location = new Point(locationOnScreen.x + x, locationOnScreen.y + y);
        ComponentMoveTask.moveComponent(c, location);
        this.robot.waitForIdle();
    }

    @RunsInEDT
    private void simulateMoveStarted(@Nonnull Container c, @Nonnull Triple<Dimension, Insets, Point> moveInfo, int x, int y) {
        Point p = this.moveLocation((Dimension)Preconditions.checkNotNull((Object)moveInfo.first), (Insets)Preconditions.checkNotNull((Object)moveInfo.second));
        this.moveMouseIgnoringAnyError(c, p);
        this.moveMouseIgnoringAnyError(c, p.x + x, p.y + y);
    }

    @Nonnull
    private Point moveLocation(@Nonnull Dimension size, @Nonnull Insets insets) {
        return new Point(size.width / 2, insets.top / 2);
    }
}

