/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.parquet;

import java.util.List;
import java.util.logging.Handler;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.parquet.Log;
import org.apache.parquet.filter2.predicate.FilterApi;
import org.apache.parquet.filter2.predicate.FilterPredicate;
import org.apache.parquet.hadoop.Footer;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.ParquetInputFormat;
import org.apache.parquet.hadoop.metadata.FileMetaData;
import org.apache.parquet.schema.MessageType;
import org.apache.spark.SparkException;
import org.apache.spark.internal.Logging;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.parser.LegacyTypeStringParser$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetFileFormat$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetFileFormat$$anonfun$13$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetFileFormat$$anonfun$org$apache$spark$sql$execution$datasources$parquet$ParquetFileFormat$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetFilters$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetReadSupport;
import org.apache.spark.sql.execution.datasources.parquet.ParquetReadSupport$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetSchemaConverter;
import org.apache.spark.sql.execution.datasources.parquet.ParquetSchemaConverter$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetWriteSupport$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.util.SerializableConfiguration;
import org.slf4j.Logger;
import org.slf4j.bridge.SLF4JBridgeHandler;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.GenSeq;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.HashSet$;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.util.Failure;
import scala.util.Try$;

public final class ParquetFileFormat$
implements Logging,
Serializable {
    public static final ParquetFileFormat$ MODULE$;
    private final java.util.logging.Logger apacheParquetLogger;
    private final java.util.logging.Logger parquetLogger;
    private final BoxedUnit redirectParquetLogsViaSLF4J;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new ParquetFileFormat$();
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    private void overrideMinSplitSize(long parquetBlockSize, Configuration conf) {
        long minSplitSize = scala.math.package$.MODULE$.max(conf.getLong("mapred.min.split.size", 0L), conf.getLong("mapreduce.input.fileinputformat.split.minsize", 0L));
        if (parquetBlockSize > minSplitSize) {
            String message = new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Parquet's block size (row group size) is larger than "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"mapred.min.split.size/mapreduce.input.fileinputformat.split.minsize. Setting "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"mapred.min.split.size and mapreduce.input.fileinputformat.split.minsize to "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)parquetBlockSize)}))).toString();
            this.logDebug((Function0<String>)new Serializable(message){
                public static final long serialVersionUID = 0L;
                private final String message$1;

                public final String apply() {
                    return this.message$1;
                }
                {
                    this.message$1 = message$1;
                }
            });
            conf.set("mapred.min.split.size", ((Object)BoxesRunTime.boxToLong((long)parquetBlockSize)).toString());
            conf.set("mapreduce.input.fileinputformat.split.minsize", ((Object)BoxesRunTime.boxToLong((long)parquetBlockSize)).toString());
        }
    }

    public void initializeLocalJobFunc(String[] requiredColumns, Filter[] filters, StructType dataSchema, long parquetBlockSize, boolean useMetadataCache, boolean parquetFilterPushDown, boolean assumeBinaryIsString, boolean assumeInt96IsTimestamp, Job job) {
        Configuration conf = job.getConfiguration();
        conf.set("parquet.read.support.class", ParquetReadSupport.class.getName());
        if (parquetFilterPushDown) {
            Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])filters).flatMap((Function1)new Serializable(dataSchema){
                public static final long serialVersionUID = 0L;
                private final StructType dataSchema$1;

                public final Iterable<FilterPredicate> apply(Filter x$7) {
                    return Option$.MODULE$.option2Iterable(ParquetFilters$.MODULE$.createFilter(this.dataSchema$1, x$7));
                }
                {
                    this.dataSchema$1 = dataSchema$1;
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(FilterPredicate.class)))).reduceOption((Function2)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final FilterPredicate apply(FilterPredicate x$1, FilterPredicate x$2) {
                    return FilterApi.and((FilterPredicate)x$1, (FilterPredicate)x$2);
                }
            }).foreach((Function1)new Serializable(conf){
                public static final long serialVersionUID = 0L;
                private final Configuration conf$1;

                public final void apply(FilterPredicate x$8) {
                    ParquetInputFormat.setFilterPredicate((Configuration)this.conf$1, (FilterPredicate)x$8);
                }
                {
                    this.conf$1 = conf$1;
                }
            });
        }
        StructType requestedSchema = new StructType((StructField[])Predef$.MODULE$.refArrayOps((Object[])requiredColumns).map((Function1)new Serializable(dataSchema){
            public static final long serialVersionUID = 0L;
            private final StructType dataSchema$1;

            public final StructField apply(String x$9) {
                return this.dataSchema$1.apply(x$9);
            }
            {
                this.dataSchema$1 = dataSchema$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class))));
        conf.set(ParquetReadSupport$.MODULE$.SPARK_ROW_REQUESTED_SCHEMA(), ParquetSchemaConverter$.MODULE$.checkFieldNames(requestedSchema).json());
        conf.set(ParquetWriteSupport$.MODULE$.SPARK_ROW_SCHEMA(), ParquetSchemaConverter$.MODULE$.checkFieldNames(dataSchema).json());
        conf.setBoolean(SQLConf$.MODULE$.PARQUET_CACHE_METADATA().key(), useMetadataCache);
        conf.setBoolean(SQLConf$.MODULE$.PARQUET_BINARY_AS_STRING().key(), assumeBinaryIsString);
        conf.setBoolean(SQLConf$.MODULE$.PARQUET_INT96_AS_TIMESTAMP().key(), assumeInt96IsTimestamp);
        this.overrideMinSplitSize(parquetBlockSize, conf);
    }

    public void initializeDriverSideJobFunc(FileStatus[] inputFiles2, long parquetBlockSize, Job job) {
        this.logInfo((Function0<String>)new Serializable(inputFiles2){
            public static final long serialVersionUID = 0L;
            private final FileStatus[] inputFiles$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Reading Parquet file(s) from ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])this.inputFiles$1).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Path apply(FileStatus x$10) {
                        return x$10.getPath();
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Path.class)))).mkString(", ")}));
            }
            {
                this.inputFiles$1 = inputFiles$1;
            }
        });
        if (Predef$.MODULE$.refArrayOps((Object[])inputFiles2).nonEmpty()) {
            FileInputFormat.setInputPaths((Job)job, (Path[])((Path[])Predef$.MODULE$.refArrayOps((Object[])inputFiles2).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Path apply(FileStatus x$11) {
                    return x$11.getPath();
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Path.class)))));
        }
        this.overrideMinSplitSize(parquetBlockSize, job.getConfiguration());
    }

    public Option<StructType> readSchema(Seq<Footer> footers, SparkSession sparkSession) {
        HashSet seen = (HashSet)HashSet$.MODULE$.apply((Seq)Nil$.MODULE$);
        Seq finalSchemas = (Seq)footers.flatMap((Function1)new Serializable(sparkSession, seen){
            public static final long serialVersionUID = 0L;
            public final SparkSession sparkSession$1;
            private final HashSet seen$1;

            public final Iterable<StructType> apply(Footer footer) {
                Iterable iterable;
                FileMetaData metadata = footer.getParquetMetadata().getFileMetaData();
                Option serializedSchema = ((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(metadata.getKeyValueMetaData()).asScala()).toMap(Predef$.MODULE$.conforms()).get((Object)ParquetReadSupport$.MODULE$.SPARK_METADATA_KEY());
                if (serializedSchema.isEmpty()) {
                    iterable = Option$.MODULE$.option2Iterable((Option)new Some((Object)ParquetFileFormat$.MODULE$.org$apache$spark$sql$execution$datasources$parquet$ParquetFileFormat$$parseParquetSchema$1(metadata.getSchema(), this.sparkSession$1)));
                } else if (this.seen$1.contains(serializedSchema.get())) {
                    iterable = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                } else {
                    this.seen$1.$plus$eq(serializedSchema.get());
                    iterable = Option$.MODULE$.option2Iterable((Option)new Some(Try$.MODULE$.apply((Function0)new Serializable(this, serializedSchema){
                        public static final long serialVersionUID = 0L;
                        private final Option serializedSchema$1;

                        public final DataType apply() {
                            return DataType$.MODULE$.fromJson((String)this.serializedSchema$1.get());
                        }
                        {
                            this.serializedSchema$1 = serializedSchema$1;
                        }
                    }).recover((PartialFunction)new Serializable(this, serializedSchema){
                        public static final long serialVersionUID = 0L;
                        private final Option serializedSchema$1;

                        public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                            Object object;
                            A1 A1 = x1;
                            if (A1 != null) {
                                ParquetFileFormat$.MODULE$.logInfo((Function0<String>)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final String apply() {
                                        return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Serialized Spark schema in Parquet key-value metadata is not in JSON format, "})).s((Seq)Nil$.MODULE$)).append((Object)"falling back to the deprecated DataType.fromCaseClassString parser.").toString();
                                    }
                                });
                                object = LegacyTypeStringParser$.MODULE$.parse((String)this.serializedSchema$1.get());
                            } else {
                                object = function1.apply(x1);
                            }
                            return (B1)object;
                        }

                        public final boolean isDefinedAt(Throwable x1) {
                            Throwable throwable = x1;
                            boolean bl = throwable != null;
                            return bl;
                        }
                        {
                            this.serializedSchema$1 = serializedSchema$1;
                        }
                    }).recover((PartialFunction)new Serializable(this, serializedSchema){
                        public static final long serialVersionUID = 0L;
                        public final Option serializedSchema$1;

                        public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                            Object object;
                            A1 A1 = x2;
                            if (A1 != null) {
                                A1 A12 = A1;
                                ParquetFileFormat$.MODULE$.logWarning((Function0<String>)new Serializable(this){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ anonfun$13$$anonfun$apply$1 $outer;

                                    public final String apply() {
                                        return new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to parse serialized Spark schema in Parquet key-value metadata:\n                 |\\t", "\n               "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.serializedSchema$1})))).stripMargin();
                                    }
                                    {
                                        if ($outer == null) {
                                            throw new NullPointerException();
                                        }
                                        this.$outer = $outer;
                                    }
                                }, A12);
                                object = BoxedUnit.UNIT;
                            } else {
                                object = function1.apply(x2);
                            }
                            return (B1)object;
                        }

                        public final boolean isDefinedAt(Throwable x2) {
                            Throwable throwable = x2;
                            boolean bl = throwable != null;
                            return bl;
                        }
                        {
                            this.serializedSchema$1 = serializedSchema$1;
                        }
                    }).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final StructType apply(Object x$12) {
                            return (StructType)x$12;
                        }
                    }).getOrElse((Function0)new Serializable(this, metadata){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.13 $outer;
                        private final FileMetaData metadata$1;

                        public final StructType apply() {
                            return ParquetFileFormat$.MODULE$.org$apache$spark$sql$execution$datasources$parquet$ParquetFileFormat$$parseParquetSchema$1(this.metadata$1.getSchema(), this.$outer.sparkSession$1);
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.metadata$1 = metadata$1;
                        }
                    })));
                }
                return iterable;
            }
            {
                this.sparkSession$1 = sparkSession$1;
                this.seen$1 = seen$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
        return finalSchemas.reduceOption((Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final StructType apply(StructType left, StructType right) {
                try {
                    return left.merge(right);
                }
                catch (Throwable throwable) {
                    throw new SparkException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to merge incompatible schemas ", " and ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{left, right})), throwable);
                }
            }
        });
    }

    public StructType mergeMetastoreParquetSchema(StructType metastoreSchema, StructType parquetSchema) {
        StructType mergedParquetSchema = this.mergeMissingNullableFields(metastoreSchema, parquetSchema);
        Predef$.MODULE$.assert(metastoreSchema.size() <= mergedParquetSchema.size(), (Function0)new Serializable(metastoreSchema, parquetSchema){
            public static final long serialVersionUID = 0L;
            private final StructType metastoreSchema$1;
            private final StructType parquetSchema$1;

            public final String apply() {
                return ParquetFileFormat$.MODULE$.org$apache$spark$sql$execution$datasources$parquet$ParquetFileFormat$$schemaConflictMessage$1(this.metastoreSchema$1, this.parquetSchema$1);
            }
            {
                this.metastoreSchema$1 = metastoreSchema$1;
                this.parquetSchema$1 = parquetSchema$1;
            }
        });
        Map ordinalMap = ((TraversableOnce)((TraversableLike)metastoreSchema.zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, Object> apply(Tuple2<StructField, Object> x0$1) {
                Tuple2<StructField, Object> tuple2 = x0$1;
                if (tuple2 != null) {
                    StructField field = (StructField)tuple2._1();
                    int index = tuple2._2$mcI$sp();
                    Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)field.name().toLowerCase()), (Object)BoxesRunTime.boxToInteger((int)index));
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.conforms());
        Seq reorderedParquetSchema = (Seq)mergedParquetSchema.sortBy((Function1)new Serializable(metastoreSchema, ordinalMap){
            public static final long serialVersionUID = 0L;
            public final StructType metastoreSchema$1;
            private final Map ordinalMap$1;

            public final int apply(StructField f) {
                return BoxesRunTime.unboxToInt((Object)this.ordinalMap$1.getOrElse((Object)f.name().toLowerCase(), (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.15 $outer;

                    public final int apply() {
                        return this.apply$mcI$sp();
                    }

                    public int apply$mcI$sp() {
                        return this.$outer.metastoreSchema$1.size() + 1;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }));
            }
            {
                this.metastoreSchema$1 = metastoreSchema$1;
                this.ordinalMap$1 = ordinalMap$1;
            }
        }, (Ordering)Ordering.Int$.MODULE$);
        return StructType$.MODULE$.apply((Seq)((TraversableLike)metastoreSchema.zip((GenIterable)reorderedParquetSchema, Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(metastoreSchema, parquetSchema){
            public static final long serialVersionUID = 0L;
            private final StructType metastoreSchema$1;
            private final StructType parquetSchema$1;

            public final StructField apply(Tuple2<StructField, StructField> x0$2) {
                Tuple2<StructField, StructField> tuple2 = x0$2;
                if (tuple2 != null) {
                    StructField mSchema = (StructField)tuple2._1();
                    StructField pSchema = (StructField)tuple2._2();
                    String string = mSchema.name().toLowerCase();
                    String string2 = pSchema.name().toLowerCase();
                    if (!(string != null ? !string.equals(string2) : string2 != null)) {
                        StructField structField = mSchema.copy(pSchema.name(), mSchema.copy$default$2(), mSchema.copy$default$3(), mSchema.copy$default$4());
                        return structField;
                    }
                }
                throw new SparkException(ParquetFileFormat$.MODULE$.org$apache$spark$sql$execution$datasources$parquet$ParquetFileFormat$$schemaConflictMessage$1(this.metastoreSchema$1, this.parquetSchema$1));
            }
            {
                this.metastoreSchema$1 = metastoreSchema$1;
                this.parquetSchema$1 = parquetSchema$1;
            }
        }, Seq$.MODULE$.canBuildFrom()));
    }

    public StructType mergeMissingNullableFields(StructType metastoreSchema, StructType parquetSchema) {
        Map fieldMap = ((TraversableOnce)metastoreSchema.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, StructField> apply(StructField f) {
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)f.name().toLowerCase()), (Object)f);
            }
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.conforms());
        Seq missingFields = (Seq)((TraversableLike)((TraversableLike)((SeqLike)metastoreSchema.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(StructField x$13) {
                return x$13.name().toLowerCase();
            }
        }, Seq$.MODULE$.canBuildFrom())).diff((GenSeq)parquetSchema.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(StructField x$14) {
                return x$14.name().toLowerCase();
            }
        }, Seq$.MODULE$.canBuildFrom()))).map((Function1)new Serializable(fieldMap){
            public static final long serialVersionUID = 0L;
            private final Map fieldMap$1;

            public final StructField apply(String x$15) {
                return (StructField)this.fieldMap$1.apply((Object)x$15);
            }
            {
                this.fieldMap$1 = fieldMap$1;
            }
        }, Seq$.MODULE$.canBuildFrom())).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(StructField x$16) {
                return x$16.nullable();
            }
        });
        return StructType$.MODULE$.apply((Seq)parquetSchema.$plus$plus((GenTraversableOnce)missingFields, Seq$.MODULE$.canBuildFrom()));
    }

    public Option<StructType> mergeSchemasInParallel(Seq<FileStatus> filesToTouch, SparkSession sparkSession) {
        None$ none$;
        boolean x$18;
        Serializable x$17;
        boolean assumeBinaryIsString = sparkSession.sessionState().conf().isParquetBinaryAsString();
        boolean assumeInt96IsTimestamp = sparkSession.sessionState().conf().isParquetINT96AsTimestamp();
        boolean writeLegacyParquetFormat = sparkSession.sessionState().conf().writeLegacyParquetFormat();
        SerializableConfiguration serializedConf = new SerializableConfiguration(sparkSession.sessionState().newHadoopConf());
        Seq partialFileStatusInfo = (Seq)filesToTouch.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, Object> apply(FileStatus f) {
                return new Tuple2((Object)f.getPath().toString(), (Object)BoxesRunTime.boxToLong((long)f.getLen()));
            }
        }, Seq$.MODULE$.canBuildFrom());
        int numParallelism = Math.min(Math.max(partialFileStatusInfo.size(), 1), sparkSession.sparkContext().defaultParallelism());
        RDD qual$1 = sparkSession.sparkContext().parallelize(partialFileStatusInfo, numParallelism, ClassTag$.MODULE$.apply(Tuple2.class));
        StructType[] partiallyMergedSchemas = (StructType[])qual$1.mapPartitions((Function1)(x$17 = new Serializable(assumeBinaryIsString, assumeInt96IsTimestamp, writeLegacyParquetFormat, serializedConf){
            public static final long serialVersionUID = 0L;
            private final boolean assumeBinaryIsString$1;
            private final boolean assumeInt96IsTimestamp$1;
            private final boolean writeLegacyParquetFormat$1;
            private final SerializableConfiguration serializedConf$1;

            public final Iterator<StructType> apply(Iterator<Tuple2<String, Object>> iterator2) {
                Iterator iterator3;
                Seq fakeFileStatuses = iterator2.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final FileStatus apply(Tuple2<String, Object> x0$3) {
                        Tuple2<String, Object> tuple2 = x0$3;
                        if (tuple2 != null) {
                            String path = (String)tuple2._1();
                            long length = tuple2._2$mcJ$sp();
                            FileStatus fileStatus = new FileStatus(length, false, 0, 0L, 0L, 0L, null, null, null, new Path(path));
                            return fileStatus;
                        }
                        throw new MatchError(tuple2);
                    }
                }).toSeq();
                boolean skipRowGroups = true;
                Buffer footers = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(ParquetFileReader.readAllFootersInParallel((Configuration)this.serializedConf$1.value(), (List)((List)JavaConverters$.MODULE$.seqAsJavaListConverter(fakeFileStatuses).asJava()), (boolean)skipRowGroups)).asScala();
                ParquetSchemaConverter converter = new ParquetSchemaConverter(this.assumeBinaryIsString$1, this.assumeInt96IsTimestamp$1, this.writeLegacyParquetFormat$1);
                if (footers.isEmpty()) {
                    iterator3 = package$.MODULE$.Iterator().empty();
                } else {
                    ObjectRef mergedSchema = new ObjectRef((Object)ParquetFileFormat$.MODULE$.readSchemaFromFooter((Footer)footers.head(), converter));
                    ((IterableLike)footers.tail()).foreach((Function1)new Serializable(this, converter, mergedSchema){
                        public static final long serialVersionUID = 0L;
                        private final ParquetSchemaConverter converter$1;
                        private final ObjectRef mergedSchema$1;

                        public final void apply(Footer footer) {
                            StructType schema = ParquetFileFormat$.MODULE$.readSchemaFromFooter(footer, this.converter$1);
                            try {
                                this.mergedSchema$1.elem = ((StructType)this.mergedSchema$1.elem).merge(schema);
                                return;
                            }
                            catch (SparkException sparkException) {
                                throw new SparkException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed merging schema of file ", ":\\n", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{footer.getFile(), schema.treeString()})), (Throwable)sparkException);
                            }
                        }
                        {
                            this.converter$1 = converter$1;
                            this.mergedSchema$1 = mergedSchema$1;
                        }
                    });
                    iterator3 = package$.MODULE$.Iterator().single((Object)((StructType)mergedSchema.elem));
                }
                return iterator3;
            }
            {
                this.assumeBinaryIsString$1 = assumeBinaryIsString$1;
                this.assumeInt96IsTimestamp$1 = assumeInt96IsTimestamp$1;
                this.writeLegacyParquetFormat$1 = writeLegacyParquetFormat$1;
                this.serializedConf$1 = serializedConf$1;
            }
        }), x$18 = qual$1.mapPartitions$default$2(), ClassTag$.MODULE$.apply(StructType.class)).collect();
        if (Predef$.MODULE$.refArrayOps((Object[])partiallyMergedSchemas).isEmpty()) {
            none$ = None$.MODULE$;
        } else {
            ObjectRef finalSchema = new ObjectRef((Object)((StructType)Predef$.MODULE$.refArrayOps((Object[])partiallyMergedSchemas).head()));
            Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])partiallyMergedSchemas).tail()).foreach((Function1)new Serializable(finalSchema){
                public static final long serialVersionUID = 0L;
                private final ObjectRef finalSchema$1;

                public final void apply(StructType schema) {
                    try {
                        this.finalSchema$1.elem = ((StructType)this.finalSchema$1.elem).merge(schema);
                        return;
                    }
                    catch (SparkException sparkException) {
                        throw new SparkException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed merging schema:\\n", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{schema.treeString()})), (Throwable)sparkException);
                    }
                }
                {
                    this.finalSchema$1 = finalSchema$1;
                }
            });
            none$ = new Some((Object)((StructType)finalSchema.elem));
        }
        return none$;
    }

    public StructType readSchemaFromFooter(Footer footer, ParquetSchemaConverter converter) {
        FileMetaData fileMetaData = footer.getParquetMetadata().getFileMetaData();
        return (StructType)((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(fileMetaData.getKeyValueMetaData()).asScala()).toMap(Predef$.MODULE$.conforms()).get((Object)ParquetReadSupport$.MODULE$.SPARK_METADATA_KEY()).flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Option<StructType> apply(String schemaString2) {
                return ParquetFileFormat$.MODULE$.org$apache$spark$sql$execution$datasources$parquet$ParquetFileFormat$$deserializeSchemaString(schemaString2);
            }
        }).getOrElse((Function0)new Serializable(converter, fileMetaData){
            public static final long serialVersionUID = 0L;
            private final ParquetSchemaConverter converter$2;
            private final FileMetaData fileMetaData$1;

            public final StructType apply() {
                return this.converter$2.convert(this.fileMetaData$1.getSchema());
            }
            {
                this.converter$2 = converter$2;
                this.fileMetaData$1 = fileMetaData$1;
            }
        });
    }

    public Option<StructType> org$apache$spark$sql$execution$datasources$parquet$ParquetFileFormat$$deserializeSchemaString(String schemaString2) {
        return Try$.MODULE$.apply((Function0)new Serializable(schemaString2){
            public static final long serialVersionUID = 0L;
            private final String schemaString$1;

            public final StructType apply() {
                return (StructType)DataType$.MODULE$.fromJson(this.schemaString$1);
            }
            {
                this.schemaString$1 = schemaString$1;
            }
        }).recover((PartialFunction)new Serializable(schemaString2){
            public static final long serialVersionUID = 0L;
            private final String schemaString$1;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x3, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x3;
                if (A1 != null) {
                    ParquetFileFormat$.MODULE$.logInfo((Function0<String>)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Serialized Spark schema in Parquet key-value metadata is not in JSON format, "})).s((Seq)Nil$.MODULE$)).append((Object)"falling back to the deprecated DataType.fromCaseClassString parser.").toString();
                        }
                    });
                    object = (StructType)LegacyTypeStringParser$.MODULE$.parse(this.schemaString$1);
                } else {
                    object = function1.apply(x3);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Throwable x3) {
                Throwable throwable = x3;
                boolean bl = throwable != null;
                return bl;
            }
            {
                this.schemaString$1 = schemaString$1;
            }
        }).recoverWith((PartialFunction)new Serializable(schemaString2){
            public static final long serialVersionUID = 0L;
            public final String schemaString$1;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x4, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x4;
                if (A1 != null) {
                    A1 A12 = A1;
                    ParquetFileFormat$.MODULE$.logWarning((Function0<String>)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun$org$apache$spark$sql$execution$datasources$parquet$ParquetFileFormat$$deserializeSchemaString$2 $outer;

                        public final String apply() {
                            return new StringBuilder().append((Object)"Failed to parse and ignored serialized Spark schema in ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Parquet key-value metadata:\\n\\t", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.schemaString$1}))).toString();
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                        }
                    }, A12);
                    object = new Failure(A12);
                } else {
                    object = function1.apply(x4);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Throwable x4) {
                Throwable throwable = x4;
                boolean bl = throwable != null;
                return bl;
            }
            {
                this.schemaString$1 = schemaString$1;
            }
        }).toOption();
    }

    public java.util.logging.Logger apacheParquetLogger() {
        return this.apacheParquetLogger;
    }

    public java.util.logging.Logger parquetLogger() {
        return this.parquetLogger;
    }

    public void redirectParquetLogsViaSLF4J() {
    }

    private Object readResolve() {
        return MODULE$;
    }

    public final StructType org$apache$spark$sql$execution$datasources$parquet$ParquetFileFormat$$parseParquetSchema$1(MessageType schema, SparkSession sparkSession$1) {
        ParquetSchemaConverter converter = new ParquetSchemaConverter(sparkSession$1.sessionState().conf().isParquetBinaryAsString(), sparkSession$1.sessionState().conf().isParquetBinaryAsString(), sparkSession$1.sessionState().conf().writeLegacyParquetFormat());
        return converter.convert(schema);
    }

    public final String org$apache$spark$sql$execution$datasources$parquet$ParquetFileFormat$$schemaConflictMessage$1(StructType metastoreSchema$1, StructType parquetSchema$1) {
        return new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Converting Hive Metastore Parquet, but detected conflicting schemas. Metastore schema:\n         |", "\n         |\n         |Parquet schema:\n         |", "\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{metastoreSchema$1.prettyJson(), parquetSchema$1.prettyJson()})))).stripMargin();
    }

    private final void redirect$1(java.util.logging.Logger logger) {
        Predef$.MODULE$.refArrayOps((Object[])logger.getHandlers()).foreach((Function1)new Serializable(logger){
            public static final long serialVersionUID = 0L;
            private final java.util.logging.Logger logger$1;

            public final void apply(Handler x$1) {
                this.logger$1.removeHandler(x$1);
            }
            {
                this.logger$1 = logger$1;
            }
        });
        logger.setUseParentHandlers(false);
        logger.addHandler((Handler)new SLF4JBridgeHandler());
    }

    private final void liftedTree1$1() {
        try {
            Class.forName("parquet.Log");
            this.redirect$1(java.util.logging.Logger.getLogger("parquet"));
        }
        catch (Throwable throwable) {}
    }

    private ParquetFileFormat$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
        this.apacheParquetLogger = java.util.logging.Logger.getLogger(Log.class.getPackage().getName());
        this.parquetLogger = java.util.logging.Logger.getLogger("parquet");
        Class.forName(Log.class.getName());
        this.redirect$1(java.util.logging.Logger.getLogger(Log.class.getPackage().getName()));
        this.liftedTree1$1();
        this.redirectParquetLogsViaSLF4J = BoxedUnit.UNIT;
    }
}

