/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.jdbc;

import java.util.Properties;
import org.apache.spark.Partition;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCPartition;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCPartitioningInfo;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCRelation;
import org.slf4j.Logger;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple4;
import scala.collection.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class JDBCRelation$
implements Logging,
Serializable {
    public static final JDBCRelation$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new JDBCRelation$();
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public Partition[] columnPartition(JDBCPartitioningInfo partitioning) {
        long l;
        long upperBound;
        if (partitioning == null || partitioning.numPartitions() <= 1 || partitioning.lowerBound() == partitioning.upperBound()) {
            Partition[] partitionArray = new Partition[1];
            partitionArray[0] = new JDBCPartition(null, 0);
            return (Partition[])((Object[])partitionArray);
        }
        long lowerBound = partitioning.lowerBound();
        Predef$.MODULE$.require(lowerBound <= (upperBound = partitioning.upperBound()), (Function0)new Serializable(lowerBound, upperBound){
            public static final long serialVersionUID = 0L;
            private final long lowerBound$1;
            private final long upperBound$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Operation not allowed: the lower bound of partitioning column is larger than the upper ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"bound. Lower bound: ", "; Upper bound: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.lowerBound$1), BoxesRunTime.boxToLong((long)this.upperBound$1)}))).toString();
            }
            {
                this.lowerBound$1 = lowerBound$1;
                this.upperBound$1 = upperBound$1;
            }
        });
        if (upperBound - lowerBound >= (long)partitioning.numPartitions()) {
            l = partitioning.numPartitions();
        } else {
            this.logWarning((Function0<String>)new Serializable(partitioning, lowerBound, upperBound){
                public static final long serialVersionUID = 0L;
                private final JDBCPartitioningInfo partitioning$1;
                private final long lowerBound$1;
                private final long upperBound$1;

                public final String apply() {
                    return new StringBuilder().append((Object)"The number of partitions is reduced because the specified number of partitions is less than the difference between upper bound and lower bound. ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Updated number of partitions: ", "; Input number of "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)(this.upperBound$1 - this.lowerBound$1))}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"partitions: ", "; Lower bound: ", "; "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.partitioning$1.numPartitions()), BoxesRunTime.boxToLong((long)this.lowerBound$1)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Upper bound: ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.upperBound$1)}))).toString();
                }
                {
                    this.partitioning$1 = partitioning$1;
                    this.lowerBound$1 = lowerBound$1;
                    this.upperBound$1 = upperBound$1;
                }
            });
            l = upperBound - lowerBound;
        }
        long numPartitions = l;
        long stride = upperBound / numPartitions - lowerBound / numPartitions;
        String column = partitioning.column();
        int i = 0;
        long currentValue = lowerBound;
        ArrayBuffer ans = new ArrayBuffer();
        while ((long)i < numPartitions) {
            String uBound;
            String lBound = i != 0 ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " >= ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{column, BoxesRunTime.boxToLong((long)currentValue)})) : null;
            String string = (long)i != numPartitions - 1L ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " < ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{column, BoxesRunTime.boxToLong((long)(currentValue += stride))})) : (uBound = null);
            String whereClause = uBound == null ? lBound : (lBound == null ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " or ", " is null"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{uBound, column})) : new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " AND ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{lBound, uBound})));
            ans.$plus$eq((Object)new JDBCPartition(whereClause, i));
            ++i;
        }
        return (Partition[])ans.toArray(ClassTag$.MODULE$.apply(Partition.class));
    }

    public JDBCRelation apply(String url, String table, Partition[] parts, Properties properties, SparkSession sparkSession) {
        return new JDBCRelation(url, table, parts, properties, sparkSession);
    }

    public Option<Tuple4<String, String, Partition[], Properties>> unapply(JDBCRelation x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple4((Object)x$0.url(), (Object)x$0.table(), (Object)x$0.parts(), (Object)x$0.properties()));
    }

    public Properties apply$default$4() {
        return new Properties();
    }

    public Properties $lessinit$greater$default$4() {
        return new Properties();
    }

    private Object readResolve() {
        return MODULE$;
    }

    private JDBCRelation$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
    }
}

