/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.command;

import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType$;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.execution.command.DropTableCommand$;
import org.apache.spark.sql.execution.command.RunnableCommand;
import org.apache.spark.sql.execution.command.RunnableCommand$class;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005-e\u0001B\u0001\u0003\u0001>\u0011\u0001\u0003\u0012:paR\u000b'\r\\3D_6l\u0017M\u001c3\u000b\u0005\r!\u0011aB2p[6\fg\u000e\u001a\u0006\u0003\u000b\u0019\t\u0011\"\u001a=fGV$\u0018n\u001c8\u000b\u0005\u001dA\u0011aA:rY*\u0011\u0011BC\u0001\u0006gB\f'o\u001b\u0006\u0003\u00171\ta!\u00199bG\",'\"A\u0007\u0002\u0007=\u0014xm\u0001\u0001\u0014\u000b\u0001\u0001\"D\b\u0013\u0011\u0005EAR\"\u0001\n\u000b\u0005M!\u0012a\u00027pO&\u001c\u0017\r\u001c\u0006\u0003+Y\tQ\u0001\u001d7b]NT!a\u0006\u0004\u0002\u0011\r\fG/\u00197zgRL!!\u0007\n\u0003\u00171{w-[2bYBc\u0017M\u001c\t\u00037qi\u0011AA\u0005\u0003;\t\u0011qBU;o]\u0006\u0014G.Z\"p[6\fg\u000e\u001a\t\u0003?\tj\u0011\u0001\t\u0006\u0002C\u0005)1oY1mC&\u00111\u0005\t\u0002\b!J|G-^2u!\tyR%\u0003\u0002'A\ta1+\u001a:jC2L'0\u00192mK\"A\u0001\u0006\u0001BK\u0002\u0013\u0005\u0011&A\u0005uC\ndWMT1nKV\t!\u0006\u0005\u0002,Y5\ta#\u0003\u0002.-\tyA+\u00192mK&#WM\u001c;jM&,'\u000f\u0003\u00050\u0001\tE\t\u0015!\u0003+\u0003)!\u0018M\u00197f\u001d\u0006lW\r\t\u0005\tc\u0001\u0011)\u001a!C\u0001e\u0005A\u0011NZ#ySN$8/F\u00014!\tyB'\u0003\u00026A\t9!i\\8mK\u0006t\u0007\u0002C\u001c\u0001\u0005#\u0005\u000b\u0011B\u001a\u0002\u0013%4W\t_5tiN\u0004\u0003\u0002C\u001d\u0001\u0005+\u0007I\u0011\u0001\u001a\u0002\r%\u001ch+[3x\u0011!Y\u0004A!E!\u0002\u0013\u0019\u0014aB5t-&,w\u000f\t\u0005\u0006{\u0001!\tAP\u0001\u0007y%t\u0017\u000e\u001e \u0015\t}\u0002\u0015I\u0011\t\u00037\u0001AQ\u0001\u000b\u001fA\u0002)BQ!\r\u001fA\u0002MBQ!\u000f\u001fA\u0002MBQ\u0001\u0012\u0001\u0005B\u0015\u000b1A];o)\t1e\u000bE\u0002H\u001fJs!\u0001S'\u000f\u0005%cU\"\u0001&\u000b\u0005-s\u0011A\u0002\u001fs_>$h(C\u0001\"\u0013\tq\u0005%A\u0004qC\u000e\\\u0017mZ3\n\u0005A\u000b&aA*fc*\u0011a\n\t\t\u0003'Rk\u0011AB\u0005\u0003+\u001a\u00111AU8x\u0011\u001596\t1\u0001Y\u00031\u0019\b/\u0019:l'\u0016\u001c8/[8o!\t\u0019\u0016,\u0003\u0002[\r\ta1\u000b]1sWN+7o]5p]\"9A\fAA\u0001\n\u0003i\u0016\u0001B2paf$Ba\u00100`A\"9\u0001f\u0017I\u0001\u0002\u0004Q\u0003bB\u0019\\!\u0003\u0005\ra\r\u0005\bsm\u0003\n\u00111\u00014\u0011\u001d\u0011\u0007!%A\u0005\u0002\r\fabY8qs\u0012\"WMZ1vYR$\u0013'F\u0001eU\tQSmK\u0001g!\t9G.D\u0001i\u0015\tI'.A\u0005v]\u000eDWmY6fI*\u00111\u000eI\u0001\u000bC:tw\u000e^1uS>t\u0017BA7i\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0005\b_\u0002\t\n\u0011\"\u0001q\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII*\u0012!\u001d\u0016\u0003g\u0015Dqa\u001d\u0001\u0012\u0002\u0013\u0005\u0001/\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001a\t\u000fU\u0004\u0011\u0011!C!m\u0006i\u0001O]8ek\u000e$\bK]3gSb,\u0012a\u001e\t\u0003qvl\u0011!\u001f\u0006\u0003un\fA\u0001\\1oO*\tA0\u0001\u0003kCZ\f\u0017B\u0001@z\u0005\u0019\u0019FO]5oO\"I\u0011\u0011\u0001\u0001\u0002\u0002\u0013\u0005\u00111A\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003\u000b\u00012aHA\u0004\u0013\r\tI\u0001\t\u0002\u0004\u0013:$\b\"CA\u0007\u0001\u0005\u0005I\u0011AA\b\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!!\u0005\u0002\u0018A\u0019q$a\u0005\n\u0007\u0005U\u0001EA\u0002B]fD!\"!\u0007\u0002\f\u0005\u0005\t\u0019AA\u0003\u0003\rAH%\r\u0005\n\u0003;\u0001\u0011\u0011!C!\u0003?\tq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003C\u0001b!a\t\u0002*\u0005EQBAA\u0013\u0015\r\t9\u0003I\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA\u0016\u0003K\u0011\u0001\"\u0013;fe\u0006$xN\u001d\u0005\n\u0003_\u0001\u0011\u0011!C\u0001\u0003c\t\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0004g\u0005M\u0002BCA\r\u0003[\t\t\u00111\u0001\u0002\u0012!I\u0011q\u0007\u0001\u0002\u0002\u0013\u0005\u0013\u0011H\u0001\u0007KF,\u0018\r\\:\u0015\u0007M\nY\u0004\u0003\u0006\u0002\u001a\u0005U\u0012\u0011!a\u0001\u0003#9\u0011\"a\u0010\u0003\u0003\u0003E\t!!\u0011\u0002!\u0011\u0013x\u000e\u001d+bE2,7i\\7nC:$\u0007cA\u000e\u0002D\u0019A\u0011AAA\u0001\u0012\u0003\t)eE\u0003\u0002D\u0005\u001dC\u0005\u0005\u0005\u0002J\u0005=#fM\u001a@\u001b\t\tYEC\u0002\u0002N\u0001\nqA];oi&lW-\u0003\u0003\u0002R\u0005-#!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8og!9Q(a\u0011\u0005\u0002\u0005UCCAA!\u0011)\tI&a\u0011\u0002\u0002\u0013\u0015\u00131L\u0001\ti>\u001cFO]5oOR\tq\u000f\u0003\u0006\u0002`\u0005\r\u0013\u0011!CA\u0003C\nQ!\u00199qYf$raPA2\u0003K\n9\u0007\u0003\u0004)\u0003;\u0002\rA\u000b\u0005\u0007c\u0005u\u0003\u0019A\u001a\t\re\ni\u00061\u00014\u0011)\tY'a\u0011\u0002\u0002\u0013\u0005\u0015QN\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\ty'a\u001f\u0011\u000b}\t\t(!\u001e\n\u0007\u0005M\u0004E\u0001\u0004PaRLwN\u001c\t\u0007?\u0005]$fM\u001a\n\u0007\u0005e\u0004E\u0001\u0004UkBdWm\r\u0005\n\u0003{\nI'!AA\u0002}\n1\u0001\u001f\u00131\u0011)\t\t)a\u0011\u0002\u0002\u0013%\u00111Q\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0002\u0006B\u0019\u00010a\"\n\u0007\u0005%\u0015P\u0001\u0004PE*,7\r\u001e")
public class DropTableCommand
extends LogicalPlan
implements RunnableCommand,
Serializable {
    private final TableIdentifier tableName;
    private final boolean ifExists;
    private final boolean isView;

    public static Function1<Tuple3<TableIdentifier, Object, Object>, DropTableCommand> tupled() {
        return DropTableCommand$.MODULE$.tupled();
    }

    public static Function1<TableIdentifier, Function1<Object, Function1<Object, DropTableCommand>>> curried() {
        return DropTableCommand$.MODULE$.curried();
    }

    @Override
    public Seq<Attribute> output() {
        return RunnableCommand$class.output(this);
    }

    @Override
    public Seq<LogicalPlan> children() {
        return RunnableCommand$class.children(this);
    }

    public TableIdentifier tableName() {
        return this.tableName;
    }

    public boolean ifExists() {
        return this.ifExists;
    }

    public boolean isView() {
        return this.isView;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Seq<Row> run(SparkSession sparkSession) {
        SessionCatalog catalog = sparkSession.sessionState().catalog();
        if (!catalog.tableExists(this.tableName())) {
            if (this.ifExists()) return (Seq)Seq$.MODULE$.empty();
            String objectName = this.isView() ? "View" : "Table";
            throw new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " to drop '", "' does not exist"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{objectName, this.tableName()})), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        } else {
            Boolean bl;
            catalog.getTableMetadataOption(this.tableName()).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ DropTableCommand $outer;

                public final void apply(CatalogTable x$6) {
                    CatalogTableType catalogTableType = x$6.tableType();
                    CatalogTableType catalogTableType2 = CatalogTableType$.MODULE$.VIEW();
                    CatalogTableType catalogTableType3 = catalogTableType;
                    if (!(catalogTableType2 != null ? !catalogTableType2.equals(catalogTableType3) : catalogTableType3 != null) && !this.$outer.isView()) {
                        throw new AnalysisException("Cannot drop a view with DROP TABLE. Please use DROP VIEW instead", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
                    }
                    CatalogTableType catalogTableType4 = catalogTableType;
                    CatalogTableType catalogTableType5 = CatalogTableType$.MODULE$.VIEW();
                    if ((catalogTableType4 == null ? catalogTableType5 != null : !catalogTableType4.equals(catalogTableType5)) && this.$outer.isView()) {
                        throw new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot drop a table with DROP VIEW. Please use DROP TABLE instead"})).s((Seq)Nil$.MODULE$), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
                    }
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
            try {
                bl = BoxesRunTime.boxToBoolean((boolean)sparkSession.sharedState().cacheManager().uncacheQuery(sparkSession.table(this.tableName().quotedString()), sparkSession.sharedState().cacheManager().uncacheQuery$default$2()));
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (option.isEmpty()) {
                    throw throwable;
                }
                Throwable e = (Throwable)option.get();
                this.log().warn(e.toString(), e);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                bl = boxedUnit;
            }
            catalog.refreshTable(this.tableName());
            catalog.dropTable(this.tableName(), this.ifExists());
        }
        return (Seq)Seq$.MODULE$.empty();
    }

    public DropTableCommand copy(TableIdentifier tableName, boolean ifExists, boolean isView) {
        return new DropTableCommand(tableName, ifExists, isView);
    }

    public TableIdentifier copy$default$1() {
        return this.tableName();
    }

    public boolean copy$default$2() {
        return this.ifExists();
    }

    public boolean copy$default$3() {
        return this.isView();
    }

    public String productPrefix() {
        return "DropTableCommand";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 2: {
                object = BoxesRunTime.boxToBoolean((boolean)this.isView());
                break;
            }
            case 1: {
                object = BoxesRunTime.boxToBoolean((boolean)this.ifExists());
                break;
            }
            case 0: {
                object = this.tableName();
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof DropTableCommand;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof DropTableCommand)) return false;
        boolean bl = true;
        if (!bl) return false;
        DropTableCommand dropTableCommand = (DropTableCommand)x$1;
        TableIdentifier tableIdentifier = this.tableName();
        TableIdentifier tableIdentifier2 = dropTableCommand.tableName();
        if (tableIdentifier == null) {
            if (tableIdentifier2 != null) {
                return false;
            }
        } else if (!tableIdentifier.equals(tableIdentifier2)) return false;
        if (this.ifExists() != dropTableCommand.ifExists()) return false;
        if (this.isView() != dropTableCommand.isView()) return false;
        if (!dropTableCommand.canEqual(this)) return false;
        return true;
    }

    public DropTableCommand(TableIdentifier tableName, boolean ifExists, boolean isView) {
        this.tableName = tableName;
        this.ifExists = ifExists;
        this.isView = isView;
        RunnableCommand$class.$init$(this);
    }
}

