/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.evaluation;

import java.io.Serializable;
import org.apache.spark.internal.Logging;
import org.apache.spark.ml.stat.SummarizerBuffer;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.stat.Statistics$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005b\u0001\u0002\t\u0012\u0001qA\u0001\"\u000b\u0001\u0003\u0002\u0003\u0006IA\u000b\u0005\ty\u0001\u0011\t\u0011)A\u0005{!)\u0001\t\u0001C\u0001\u0003\")\u0001\t\u0001C\u0001'\"1\u0001\t\u0001C\u0001'uC\u0001b\u001d\u0001\t\u0006\u0004%I\u0001\u001e\u0005\t{\u0002A)\u0019!C\u0005}\"I\u0011Q\u0001\u0001\t\u0006\u0004%IA \u0005\n\u0003\u000f\u0001\u0001R1A\u0005\nyD\u0011\"!\u0003\u0001\u0011\u000b\u0007I\u0011\u0002@\t\r\u0005-\u0001\u0001\"\u0001\u007f\u0011\u0019\ty\u0001\u0001C\u0001}\"1\u00111\u0003\u0001\u0005\u0002yDa!a\u0006\u0001\t\u0003q\bBBA\u000e\u0001\u0011\u0005aPA\tSK\u001e\u0014Xm]:j_:lU\r\u001e:jGNT!AE\n\u0002\u0015\u00154\u0018\r\\;bi&|gN\u0003\u0002\u0015+\u0005)Q\u000e\u001c7jE*\u0011acF\u0001\u0006gB\f'o\u001b\u0006\u00031e\ta!\u00199bG\",'\"\u0001\u000e\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001i2\u0005\u0005\u0002\u001fC5\tqDC\u0001!\u0003\u0015\u00198-\u00197b\u0013\t\u0011sD\u0001\u0004B]f\u0014VM\u001a\t\u0003I\u001dj\u0011!\n\u0006\u0003MU\t\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0003Q\u0015\u0012q\u0001T8hO&tw-A\rqe\u0016$\u0017n\u0019;j_:\fe\u000eZ(cg\u0016\u0014h/\u0019;j_:\u001c\bGA\u00164!\ras&M\u0007\u0002[)\u0011a&F\u0001\u0004e\u0012$\u0017B\u0001\u0019.\u0005\r\u0011F\t\u0012\t\u0003eMb\u0001\u0001B\u00055\u0003\u0005\u0005\t\u0011!B\u0001k\t\u0019q\fJ\u0019\u0012\u0005YJ\u0004C\u0001\u00108\u0013\tAtDA\u0004O_RD\u0017N\\4\u0011\u0005yQ\u0014BA\u001e \u0005\u001d\u0001&o\u001c3vGR\fQ\u0002\u001e5s_V<\u0007n\u0014:jO&t\u0007C\u0001\u0010?\u0013\tytDA\u0004C_>dW-\u00198\u0002\rqJg.\u001b;?)\r\u0011E)\u0013\t\u0003\u0007\u0002i\u0011!\u0005\u0005\u0006S\r\u0001\r!\u0012\u0019\u0003\r\"\u00032\u0001L\u0018H!\t\u0011\u0004\nB\u00055\t\u0006\u0005\t\u0011!B\u0001k!)Ah\u0001a\u0001{!\u001a1aS)\u0011\u00051{U\"A'\u000b\u00059+\u0012AC1o]>$\u0018\r^5p]&\u0011\u0001+\u0014\u0002\u0006'&t7-Z\u0011\u0002%\u0006)!G\f\u0019/aQ\u0011!\t\u0016\u0005\u0006S\u0011\u0001\r!\u0016\u0019\u0003-b\u00032\u0001L\u0018X!\t\u0011\u0004\fB\u0005Z)\u0006\u0005\t\u0011!B\u0001k\t\u0019q\f\n\u001a)\u0007\u0011Y5,I\u0001]\u0003\u0015\tdF\r\u00181)\t\u0011e\fC\u0003*\u000b\u0001\u0007q\f\u0005\u0002aa:\u0011\u0011-\u001c\b\u0003E.t!a\u00196\u000f\u0005\u0011LgBA3i\u001b\u00051'BA4\u001c\u0003\u0019a$o\\8u}%\t!$\u0003\u0002\u00193%\u0011acF\u0005\u0003YV\t1a]9m\u0013\tqw.A\u0004qC\u000e\\\u0017mZ3\u000b\u00051,\u0012BA9s\u0005%!\u0015\r^1Ge\u0006lWM\u0003\u0002o_\u000691/^7nCJLX#A;\u0011\u0005Y\\X\"A<\u000b\u0005aL\u0018\u0001B:uCRT!A_\u000b\u0002\u00055d\u0017B\u0001?x\u0005A\u0019V/\\7be&TXM\u001d\"vM\u001a,'/A\u0002T'f,\u0012a \t\u0004=\u0005\u0005\u0011bAA\u0002?\t1Ai\\;cY\u0016\fQaU*feJ\fQaU*u_R\fQaU*sK\u001e\f\u0011#\u001a=qY\u0006Lg.\u001a3WCJL\u0017M\\2fQ\rY1jW\u0001\u0012[\u0016\fg.\u00112t_2,H/Z#se>\u0014\bf\u0001\u0007L7\u0006\u0001R.Z1o'F,\u0018M]3e\u000bJ\u0014xN\u001d\u0015\u0004\u001b-[\u0016\u0001\u0006:p_RlU-\u00198TcV\f'/\u001a3FeJ|'\u000fK\u0002\u000f\u0017n\u000b!A\u001d\u001a)\u0007=Y5\fK\u0002\u0001\u0017n\u0003")
public class RegressionMetrics
implements Logging {
    private SummarizerBuffer summary;
    private double SSy;
    private double SSerr;
    private double SStot;
    private double SSreg;
    private final RDD<? extends Product> predictionAndObservations;
    private final boolean throughOrigin;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile byte bitmap$0;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private SummarizerBuffer summary$lzycompute() {
        RegressionMetrics regressionMetrics = this;
        synchronized (regressionMetrics) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                RDD weightedVectors = this.predictionAndObservations.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    Product product = x0$1;
                    if (product instanceof Tuple3) {
                        Tuple3 tuple3 = (Tuple3)product;
                        Object prediction = tuple3._1();
                        Object observation = tuple3._2();
                        Object weight = tuple3._3();
                        if (prediction instanceof Double) {
                            double d = BoxesRunTime.unboxToDouble((Object)prediction);
                            if (observation instanceof Double) {
                                double d2 = BoxesRunTime.unboxToDouble((Object)observation);
                                if (weight instanceof Double) {
                                    double d3 = BoxesRunTime.unboxToDouble((Object)weight);
                                    return new Tuple2((Object)Vectors$.MODULE$.dense(d2, (Seq<Object>)Predef$.MODULE$.wrapDoubleArray(new double[]{d2 - d, d})), (Object)BoxesRunTime.boxToDouble((double)d3));
                                }
                            }
                        }
                    }
                    if (!(product instanceof Tuple2)) throw new MatchError((Object)product);
                    Tuple2 tuple2 = (Tuple2)product;
                    Object prediction = tuple2._1();
                    Object observation = tuple2._2();
                    if (!(prediction instanceof Double)) throw new MatchError((Object)product);
                    double d = BoxesRunTime.unboxToDouble((Object)prediction);
                    if (!(observation instanceof Double)) throw new MatchError((Object)product);
                    double d4 = BoxesRunTime.unboxToDouble((Object)observation);
                    return new Tuple2((Object)Vectors$.MODULE$.dense(d4, (Seq<Object>)Predef$.MODULE$.wrapDoubleArray(new double[]{d4 - d, d})), (Object)BoxesRunTime.boxToDouble((double)1.0));
                }, ClassTag$.MODULE$.apply(Tuple2.class));
                this.summary = Statistics$.MODULE$.colStats((RDD<Tuple2<Vector, Object>>)weightedVectors, (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"mean", "normL1", "normL2", "variance"}))));
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.summary;
    }

    private SummarizerBuffer summary() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.summary$lzycompute() : this.summary;
    }

    private double SSy$lzycompute() {
        RegressionMetrics regressionMetrics = this;
        synchronized (regressionMetrics) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.SSy = package$.MODULE$.pow(this.summary().normL2().apply(0), 2.0);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.SSy;
    }

    private double SSy() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.SSy$lzycompute() : this.SSy;
    }

    private double SSerr$lzycompute() {
        RegressionMetrics regressionMetrics = this;
        synchronized (regressionMetrics) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.SSerr = package$.MODULE$.pow(this.summary().normL2().apply(1), 2.0);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.SSerr;
    }

    private double SSerr() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.SSerr$lzycompute() : this.SSerr;
    }

    private double SStot$lzycompute() {
        RegressionMetrics regressionMetrics = this;
        synchronized (regressionMetrics) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.SStot = this.summary().variance().apply(0) * (this.summary().weightSum() - 1.0);
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.SStot;
    }

    private double SStot() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.SStot$lzycompute() : this.SStot;
    }

    private double SSreg$lzycompute() {
        RegressionMetrics regressionMetrics = this;
        synchronized (regressionMetrics) {
            if ((byte)(this.bitmap$0 & 0x10) == 0) {
                this.SSreg = package$.MODULE$.pow(this.summary().normL2().apply(2), 2.0) + package$.MODULE$.pow(this.summary().mean().apply(0), 2.0) * this.summary().weightSum() - (double)2 * this.summary().mean().apply(0) * this.summary().mean().apply(2) * this.summary().weightSum();
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
            }
        }
        return this.SSreg;
    }

    private double SSreg() {
        return (byte)(this.bitmap$0 & 0x10) == 0 ? this.SSreg$lzycompute() : this.SSreg;
    }

    public double explainedVariance() {
        return this.SSreg() / this.summary().weightSum();
    }

    public double meanAbsoluteError() {
        return this.summary().normL1().apply(1) / this.summary().weightSum();
    }

    public double meanSquaredError() {
        return this.SSerr() / this.summary().weightSum();
    }

    public double rootMeanSquaredError() {
        return package$.MODULE$.sqrt(this.meanSquaredError());
    }

    public double r2() {
        return this.throughOrigin ? 1.0 - this.SSerr() / this.SSy() : 1.0 - this.SSerr() / this.SStot();
    }

    public RegressionMetrics(RDD<? extends Product> predictionAndObservations, boolean throughOrigin) {
        this.predictionAndObservations = predictionAndObservations;
        this.throughOrigin = throughOrigin;
        Logging.$init$((Logging)this);
    }

    public RegressionMetrics(RDD<? extends Product> predictionAndObservations) {
        this(predictionAndObservations, false);
    }

    public RegressionMetrics(Dataset<Row> predictionAndObservations) {
        this((RDD<? extends Product>)predictionAndObservations.rdd().map((Function1)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Tuple3<Object, Object, Object> apply(Row x0$1) {
                Some some;
                Row row = x0$1;
                Some some2 = Row$.MODULE$.unapplySeq(row);
                if (!some2.isEmpty() && some2.get() != null && ((SeqLike)some2.get()).lengthCompare(3) == 0) {
                    Object prediction = ((SeqLike)some2.get()).apply(0);
                    Object label = ((SeqLike)some2.get()).apply(1);
                    Object weight = ((SeqLike)some2.get()).apply(2);
                    if (prediction instanceof Double) {
                        double d = BoxesRunTime.unboxToDouble((Object)prediction);
                        if (label instanceof Double) {
                            double d2 = BoxesRunTime.unboxToDouble((Object)label);
                            if (weight instanceof Double) {
                                double d3 = BoxesRunTime.unboxToDouble((Object)weight);
                                return new Tuple3((Object)BoxesRunTime.boxToDouble((double)d), (Object)BoxesRunTime.boxToDouble((double)d2), (Object)BoxesRunTime.boxToDouble((double)d3));
                            }
                        }
                    }
                }
                if ((some = Row$.MODULE$.unapplySeq(row)).isEmpty()) throw new IllegalArgumentException(new StringBuilder(28).append("Expected Row of tuples, got ").append(row).toString());
                if (some.get() == null) throw new IllegalArgumentException(new StringBuilder(28).append("Expected Row of tuples, got ").append(row).toString());
                if (((SeqLike)some.get()).lengthCompare(2) != 0) throw new IllegalArgumentException(new StringBuilder(28).append("Expected Row of tuples, got ").append(row).toString());
                Object prediction = ((SeqLike)some.get()).apply(0);
                Object label = ((SeqLike)some.get()).apply(1);
                if (!(prediction instanceof Double)) throw new IllegalArgumentException(new StringBuilder(28).append("Expected Row of tuples, got ").append(row).toString());
                double d = BoxesRunTime.unboxToDouble((Object)prediction);
                if (!(label instanceof Double)) throw new IllegalArgumentException(new StringBuilder(28).append("Expected Row of tuples, got ").append(row).toString());
                double d4 = BoxesRunTime.unboxToDouble((Object)label);
                return new Tuple3((Object)BoxesRunTime.boxToDouble((double)d), (Object)BoxesRunTime.boxToDouble((double)d4), (Object)BoxesRunTime.boxToDouble((double)1.0));
            }
        }, ClassTag$.MODULE$.apply(Tuple3.class)));
    }
}

