/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.clustering;

import java.io.Serializable;
import java.util.Random;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.internal.Logging;
import org.apache.spark.ml.util.Instrumentation;
import org.apache.spark.mllib.clustering.BisectingKMeans$;
import org.apache.spark.mllib.clustering.BisectingKMeansModel;
import org.apache.spark.mllib.clustering.ClusteringTreeNode;
import org.apache.spark.mllib.clustering.DistanceMeasure;
import org.apache.spark.mllib.clustering.DistanceMeasure$;
import org.apache.spark.mllib.clustering.VectorWithNorm;
import org.apache.spark.mllib.linalg.BLAS$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.util.MLUtils$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Seq$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\r5h\u0001B2e\u0001=D\u0001\u0002 \u0001\u0003\u0002\u0004%I! \u0005\u000b\u0003\u0007\u0001!\u00111A\u0005\n\u0005\u0015\u0001\"CA\t\u0001\t\u0005\t\u0015)\u0003\u007f\u0011%\t\u0019\u0002\u0001BA\u0002\u0013%Q\u0010\u0003\u0006\u0002\u0016\u0001\u0011\t\u0019!C\u0005\u0003/A\u0011\"a\u0007\u0001\u0005\u0003\u0005\u000b\u0015\u0002@\t\u0015\u0005u\u0001A!a\u0001\n\u0013\ty\u0002\u0003\u0006\u0002(\u0001\u0011\t\u0019!C\u0005\u0003SA!\"!\f\u0001\u0005\u0003\u0005\u000b\u0015BA\u0011\u0011)\ty\u0003\u0001BA\u0002\u0013%\u0011\u0011\u0007\u0005\u000b\u0003s\u0001!\u00111A\u0005\n\u0005m\u0002BCA \u0001\t\u0005\t\u0015)\u0003\u00024!Q\u0011\u0011\t\u0001\u0003\u0002\u0004%I!a\u0011\t\u0015\u0005m\u0003A!a\u0001\n\u0013\ti\u0006\u0003\u0006\u0002b\u0001\u0011\t\u0011)Q\u0005\u0003\u000bBq!a\u0019\u0001\t\u0013\t)\u0007C\u0004\u0002d\u0001!\t!!\u001e\t\u000f\u0005%\u0005\u0001\"\u0001\u0002\f\"1\u00111\u0013\u0001\u0005\u0002uDq!a&\u0001\t\u0003\tI\n\u0003\u0004\u0002 \u0002!\t! \u0005\b\u0003G\u0003A\u0011AAS\u0011\u001d\tY\u000b\u0001C\u0001\u0003?Aq!a,\u0001\t\u0003\t\t\fC\u0004\u00028\u0002!\t!!\r\t\u000f\u0005m\u0006\u0001\"\u0001\u0002D!9\u00111\u0019\u0001\u0005\u0002\u0005\u0015\u0007\u0002CAf\u0001\u0011\u0005\u0001.!4\t\u0011\t-\u0001\u0001\"\u0001i\u0005\u001bAq!a3\u0001\t\u0003\u0011Y\u0002C\u0004\u0002L\u0002!\tA!\t\b\u000f\teB\r#\u0003\u0003<\u001911\r\u001aE\u0005\u0005{Aq!a\u0019\"\t\u0003\u0011)\u0005C\u0005\u0003H\u0005\u0012\r\u0011\"\u0003\u00022!A!\u0011J\u0011!\u0002\u0013\t\u0019\u0004C\u0005\u0003L\u0005\u0012\r\u0011\"\u0003\u00022!A!QJ\u0011!\u0002\u0013\t\u0019\u0004C\u0005\u0003P\u0005\u0012\r\u0011\"\u0003\u0002 !A!\u0011K\u0011!\u0002\u0013\t\t\u0003C\u0004\u0003T\u0005\"IA!\u0016\t\u000f\tm\u0013\u0005\"\u0003\u0003^!9!\u0011M\u0011\u0005\n\t\r\u0004b\u0002B4C\u0011%!\u0011\u000e\u0004\u0007\u0007[\tCaa\f\t\u0013\rmQF!b\u0001\n\u0003i\b\"CB\u0019[\t\u0005\t\u0015!\u0003\u007f\u0011)\t\t%\fBC\u0002\u0013\u000511\u0007\u0005\u000b\u0003Cj#\u0011!Q\u0001\n\r\u001d\u0002bBA2[\u0011\u00051Q\u0007\u0005\n\u0007{i\u0003\u0019!C\u0005\u0003cA\u0011ba\u0010.\u0001\u0004%Ia!\u0011\t\u0011\r\u0015S\u0006)Q\u0005\u0003gA\u0011Ba!.\u0001\u0004%I!a\b\t\u0013\r\u001dS\u00061A\u0005\n\r%\u0003\u0002\u0003BC[\u0001\u0006K!!\t\t\u0013\r5SF1A\u0005\n\r=\u0003\u0002CB)[\u0001\u0006I!!:\t\u0013\rMS\u00061A\u0005\n\u0005}\u0001\"CB+[\u0001\u0007I\u0011BB,\u0011!\u0019Y&\fQ!\n\u0005\u0005\u0002bBB/[\u0011\u00051q\f\u0005\b\u0007OjC\u0011AB5\u0011\u001d\u0019y'\fC\u0001\u0007cBqaa\u001d\"\t\u0013\u0019)\bC\u0004\u0004\f\u0006\"Ia!$\t\u000f\r\r\u0016\u0005\"\u0003\u0004&\u001a1!QO\u0011E\u0005oB!Ba E\u0005+\u0007I\u0011AA\u0019\u0011)\u0011\t\t\u0012B\tB\u0003%\u00111\u0007\u0005\u000b\u0005\u0007#%Q3A\u0005\u0002\u0005}\u0001B\u0003BC\t\nE\t\u0015!\u0003\u0002\"!Q!q\u0011#\u0003\u0016\u0004%\tA!#\t\u0015\tEEI!E!\u0002\u0013\u0011Y\t\u0003\u0006\u0003\u0014\u0012\u0013)\u001a!C\u0001\u0003?A!B!&E\u0005#\u0005\u000b\u0011BA\u0011\u0011\u001d\t\u0019\u0007\u0012C\u0001\u0005/C\u0011B!)E\u0003\u0003%\tAa)\t\u0013\t5F)%A\u0005\u0002\t=\u0006\"\u0003Bb\tF\u0005I\u0011\u0001Bc\u0011%\u0011I\rRI\u0001\n\u0003\u0011Y\rC\u0005\u0003P\u0012\u000b\n\u0011\"\u0001\u0003F\"I!\u0011\u001b#\u0002\u0002\u0013\u0005#1\u001b\u0005\t\u0005C$\u0015\u0011!C\u0001{\"I!1\u001d#\u0002\u0002\u0013\u0005!Q\u001d\u0005\n\u0005_$\u0015\u0011!C!\u0005cD\u0011Ba@E\u0003\u0003%\ta!\u0001\t\u0013\r-A)!A\u0005B\r5\u0001\"CB\b\t\u0006\u0005I\u0011IB\t\u0011%\u0019\u0019\u0002RA\u0001\n\u0003\u001a)bB\u0005\u00044\u0006\n\t\u0011#\u0003\u00046\u001aI!QO\u0011\u0002\u0002#%1q\u0017\u0005\b\u0003GbF\u0011ABc\u0011%\u0019y\u0001XA\u0001\n\u000b\u001a\t\u0002C\u0005\u0004Hr\u000b\t\u0011\"!\u0004J\"I11\u001b/\u0002\u0002\u0013\u00055Q\u001b\u0005\n\u0007Gd\u0016\u0011!C\u0005\u0007KD\u0011ba9\"\u0003\u0003%Ia!:\u0003\u001f\tK7/Z2uS:<7*T3b]NT!!\u001a4\u0002\u0015\rdWo\u001d;fe&twM\u0003\u0002hQ\u0006)Q\u000e\u001c7jE*\u0011\u0011N[\u0001\u0006gB\f'o\u001b\u0006\u0003W2\fa!\u00199bG\",'\"A7\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001\u0001h\u000f\u0005\u0002ri6\t!OC\u0001t\u0003\u0015\u00198-\u00197b\u0013\t)(O\u0001\u0004B]f\u0014VM\u001a\t\u0003ojl\u0011\u0001\u001f\u0006\u0003s\"\f\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0003wb\u0014q\u0001T8hO&tw-A\u0001l+\u0005q\bCA9\u0000\u0013\r\t\tA\u001d\u0002\u0004\u0013:$\u0018!B6`I\u0015\fH\u0003BA\u0004\u0003\u001b\u00012!]A\u0005\u0013\r\tYA\u001d\u0002\u0005+:LG\u000f\u0003\u0005\u0002\u0010\t\t\t\u00111\u0001\u007f\u0003\rAH%M\u0001\u0003W\u0002\nQ\"\\1y\u0013R,'/\u0019;j_:\u001c\u0018!E7bq&#XM]1uS>t7o\u0018\u0013fcR!\u0011qAA\r\u0011!\ty!BA\u0001\u0002\u0004q\u0018AD7bq&#XM]1uS>t7\u000fI\u0001\u0018[&tG)\u001b<jg&\u0014G.Z\"mkN$XM]*ju\u0016,\"!!\t\u0011\u0007E\f\u0019#C\u0002\u0002&I\u0014a\u0001R8vE2,\u0017aG7j]\u0012Kg/[:jE2,7\t\\;ti\u0016\u00148+\u001b>f?\u0012*\u0017\u000f\u0006\u0003\u0002\b\u0005-\u0002\"CA\b\u0011\u0005\u0005\t\u0019AA\u0011\u0003ai\u0017N\u001c#jm&\u001c\u0018N\u00197f\u00072,8\u000f^3s'&TX\rI\u0001\u0005g\u0016,G-\u0006\u0002\u00024A\u0019\u0011/!\u000e\n\u0007\u0005]\"O\u0001\u0003M_:<\u0017\u0001C:fK\u0012|F%Z9\u0015\t\u0005\u001d\u0011Q\b\u0005\n\u0003\u001fY\u0011\u0011!a\u0001\u0003g\tQa]3fI\u0002\nq\u0002Z5ti\u0006t7-Z'fCN,(/Z\u000b\u0003\u0003\u000b\u0002B!a\u0012\u0002V9!\u0011\u0011JA)!\r\tYE]\u0007\u0003\u0003\u001bR1!a\u0014o\u0003\u0019a$o\\8u}%\u0019\u00111\u000b:\u0002\rA\u0013X\rZ3g\u0013\u0011\t9&!\u0017\u0003\rM#(/\u001b8h\u0015\r\t\u0019F]\u0001\u0014I&\u001cH/\u00198dK6+\u0017m];sK~#S-\u001d\u000b\u0005\u0003\u000f\ty\u0006C\u0005\u0002\u00109\t\t\u00111\u0001\u0002F\u0005\u0001B-[:uC:\u001cW-T3bgV\u0014X\rI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0019\u0005\u001d\u00141NA7\u0003_\n\t(a\u001d\u0011\u0007\u0005%\u0004!D\u0001e\u0011\u0015a\b\u00031\u0001\u007f\u0011\u0019\t\u0019\u0002\u0005a\u0001}\"9\u0011Q\u0004\tA\u0002\u0005\u0005\u0002bBA\u0018!\u0001\u0007\u00111\u0007\u0005\b\u0003\u0003\u0002\u0002\u0019AA#)\t\t9\u0007K\u0003\u0012\u0003s\n)\t\u0005\u0003\u0002|\u0005\u0005UBAA?\u0015\r\ty\b[\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAB\u0003{\u0012QaU5oG\u0016\f#!a\"\u0002\u000bErcG\f\u0019\u0002\tM,Go\u0013\u000b\u0005\u0003\u001b\u000by)D\u0001\u0001\u0011\u0015a(\u00031\u0001\u007fQ\u0015\u0011\u0012\u0011PAC\u0003\u00119W\r^&)\u000bM\tI(!\"\u0002!M,G/T1y\u0013R,'/\u0019;j_:\u001cH\u0003BAG\u00037Ca!a\u0005\u0015\u0001\u0004q\b&\u0002\u000b\u0002z\u0005\u0015\u0015\u0001E4fi6\u000b\u00070\u0013;fe\u0006$\u0018n\u001c8tQ\u0015)\u0012\u0011PAC\u0003i\u0019X\r^'j]\u0012Kg/[:jE2,7\t\\;ti\u0016\u00148+\u001b>f)\u0011\ti)a*\t\u000f\u0005ua\u00031\u0001\u0002\"!*a#!\u001f\u0002\u0006\u0006Qr-\u001a;NS:$\u0015N^5tS\ndWm\u00117vgR,'oU5{K\"*q#!\u001f\u0002\u0006\u000691/\u001a;TK\u0016$G\u0003BAG\u0003gCq!a\f\u0019\u0001\u0004\t\u0019\u0004K\u0003\u0019\u0003s\n))A\u0004hKR\u001cV-\u001a3)\u000be\tI(!\"\u0002%\u001d,G\u000fR5ti\u0006t7-Z'fCN,(/\u001a\u0015\u00065\u0005e\u0014qX\u0011\u0003\u0003\u0003\fQA\r\u00185]A\n!c]3u\t&\u001cH/\u00198dK6+\u0017m];sKR!\u0011QRAd\u0011\u001d\t\te\u0007a\u0001\u0003\u000bBSaGA=\u0003\u007f\u000b1A];o)\u0019\ty-!6\u0002rB!\u0011\u0011NAi\u0013\r\t\u0019\u000e\u001a\u0002\u0015\u0005&\u001cXm\u0019;j]\u001e\\U*Z1og6{G-\u001a7\t\u000f\u0005]G\u00041\u0001\u0002Z\u0006)\u0011N\u001c9viB1\u00111\\Aq\u0003Kl!!!8\u000b\u0007\u0005}\u0007.A\u0002sI\u0012LA!a9\u0002^\n\u0019!\u000b\u0012#\u0011\t\u0005\u001d\u0018Q^\u0007\u0003\u0003ST1!a;g\u0003\u0019a\u0017N\\1mO&!\u0011q^Au\u0005\u00191Vm\u0019;pe\"9\u00111\u001f\u000fA\u0002\u0005U\u0018!B5ogR\u0014\b#B9\u0002x\u0006m\u0018bAA}e\n1q\n\u001d;j_:\u0004B!!@\u0003\b5\u0011\u0011q \u0006\u0005\u0005\u0003\u0011\u0019!\u0001\u0003vi&d'b\u0001B\u0003Q\u0006\u0011Q\u000e\\\u0005\u0005\u0005\u0013\tyPA\bJ]N$(/^7f]R\fG/[8o\u00035\u0011XO\\,ji\"<V-[4iiR1\u0011q\u001aB\b\u00053Aq!a6\u001e\u0001\u0004\u0011\t\u0002\u0005\u0004\u0002\\\u0006\u0005(1\u0003\t\bc\nU\u0011Q]A\u0011\u0013\r\u00119B\u001d\u0002\u0007)V\u0004H.\u001a\u001a\t\u000f\u0005MX\u00041\u0001\u0002vR!\u0011q\u001aB\u000f\u0011\u001d\t9N\ba\u0001\u00033DSAHA=\u0003\u000b#B!a4\u0003$!9!QE\u0010A\u0002\t\u001d\u0012\u0001\u00023bi\u0006\u0004bA!\u000b\u00034\u0005\u0015XB\u0001B\u0016\u0015\u0011\u0011iCa\f\u0002\t)\fg/\u0019\u0006\u0004\u0005cA\u0017aA1qS&!!Q\u0007B\u0016\u0005\u001dQ\u0015M^1S\t\u0012CS\u0001AA=\u0003\u000b\u000bqBQ5tK\u000e$\u0018N\\4L\u001b\u0016\fgn\u001d\t\u0004\u0003S\n3\u0003B\u0011q\u0005\u007f\u00012!\u001dB!\u0013\r\u0011\u0019E\u001d\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u000b\u0003\u0005w\t!BU(P)~Ke\nR#Y\u0003-\u0011vj\u0014+`\u0013:#U\t\u0017\u0011\u000275\u000b\u0005l\u0018#J-&\u001b\u0016J\u0011'F?\u000ecUk\u0015+F%~Ke\nR#Y\u0003qi\u0015\tW0E\u0013ZK5+\u0013\"M\u000b~\u001bE*V*U\u000bJ{\u0016J\u0014#F1\u0002\n1\u0002T#W\u000b2{F*S'J)\u0006aA*\u0012,F\u0019~c\u0015*T%UA\u0005qA.\u001a4u\u0007\"LG\u000eZ%oI\u0016DH\u0003BA\u001a\u0005/BqA!\u0017*\u0001\u0004\t\u0019$A\u0003j]\u0012,\u00070A\bsS\u001eDGo\u00115jY\u0012Le\u000eZ3y)\u0011\t\u0019Da\u0018\t\u000f\te#\u00061\u0001\u00024\u0005Y\u0001/\u0019:f]RLe\u000eZ3y)\u0011\t\u0019D!\u001a\t\u000f\te3\u00061\u0001\u00024\u0005I1/^7nCJL'0\u001a\u000b\t\u0005W\u001aIb!\b\u0004&AA\u0011q\tB7\u0003g\u0011\t(\u0003\u0003\u0003p\u0005e#aA'baB\u0019!1\u000f#\u000e\u0003\u0005\u0012ab\u00117vgR,'oU;n[\u0006\u0014\u0018p\u0005\u0004Ea\ne$q\b\t\u0004c\nm\u0014b\u0001B?e\n9\u0001K]8ek\u000e$\u0018\u0001B:ju\u0016\fQa]5{K\u0002\n\u0011b^3jO\"$8+^7\u0002\u0015],\u0017n\u001a5u'Vl\u0007%\u0001\u0004dK:$XM]\u000b\u0003\u0005\u0017\u0003B!!\u001b\u0003\u000e&\u0019!q\u00123\u0003\u001dY+7\r^8s/&$\bNT8s[\u000691-\u001a8uKJ\u0004\u0013\u0001B2pgR\fQaY8ti\u0002\"\"B!\u001d\u0003\u001a\nm%Q\u0014BP\u0011\u001d\u0011y(\u0014a\u0001\u0003gAqAa!N\u0001\u0004\t\t\u0003C\u0004\u0003\b6\u0003\rAa#\t\u000f\tMU\n1\u0001\u0002\"\u0005!1m\u001c9z))\u0011\tH!*\u0003(\n%&1\u0016\u0005\n\u0005\u007fr\u0005\u0013!a\u0001\u0003gA\u0011Ba!O!\u0003\u0005\r!!\t\t\u0013\t\u001de\n%AA\u0002\t-\u0005\"\u0003BJ\u001dB\u0005\t\u0019AA\u0011\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"A!-+\t\u0005M\"1W\u0016\u0003\u0005k\u0003BAa.\u0003@6\u0011!\u0011\u0018\u0006\u0005\u0005w\u0013i,A\u0005v]\u000eDWmY6fI*\u0019\u0011q\u0010:\n\t\t\u0005'\u0011\u0018\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u000b\u0003\u0005\u000fTC!!\t\u00034\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u001aTC\u0001BgU\u0011\u0011YIa-\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%i\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"A!6\u0011\t\t]'q\\\u0007\u0003\u00053TAAa7\u0003^\u0006!A.\u00198h\u0015\t\u0011i#\u0003\u0003\u0002X\te\u0017\u0001\u00049s_\u0012,8\r^!sSRL\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0005O\u0014i\u000fE\u0002r\u0005SL1Aa;s\u0005\r\te.\u001f\u0005\t\u0003\u001f)\u0016\u0011!a\u0001}\u0006y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0003tB1!Q\u001fB~\u0005Ol!Aa>\u000b\u0007\te(/\u0001\u0006d_2dWm\u0019;j_:LAA!@\u0003x\nA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\u0019\u0019a!\u0003\u0011\u0007E\u001c)!C\u0002\u0004\bI\u0014qAQ8pY\u0016\fg\u000eC\u0005\u0002\u0010]\u000b\t\u00111\u0001\u0003h\u0006A\u0001.Y:i\u0007>$W\rF\u0001\u007f\u0003!!xn\u0015;sS:<GC\u0001Bk\u0003\u0019)\u0017/^1mgR!11AB\f\u0011%\tyAWA\u0001\u0002\u0004\u00119\u000f\u0003\u0004\u0004\u001c1\u0002\rA`\u0001\u0002I\"91q\u0004\u0017A\u0002\r\u0005\u0012aC1tg&<g.\\3oiN\u0004b!a7\u0002b\u000e\r\u0002cB9\u0003\u0016\u0005M\"1\u0012\u0005\b\u0003\u0003b\u0003\u0019AB\u0014!\u0011\tIg!\u000b\n\u0007\r-BMA\bESN$\u0018M\\2f\u001b\u0016\f7/\u001e:f\u0005a\u0019E.^:uKJ\u001cV/\\7bef\fum\u001a:fO\u0006$xN]\n\u0005[A\u0014y$\u0001\u0002eAU\u00111q\u0005\u000b\u0007\u0007o\u0019Ida\u000f\u0011\u0007\tMT\u0006\u0003\u0004\u0004\u001cI\u0002\rA \u0005\b\u0003\u0003\u0012\u0004\u0019AB\u0014\u0003\u0005q\u0017!\u00028`I\u0015\fH\u0003BA\u0004\u0007\u0007B\u0011\"a\u00045\u0003\u0003\u0005\r!a\r\u0002\u00059\u0004\u0013!D<fS\u001eDGoU;n?\u0012*\u0017\u000f\u0006\u0003\u0002\b\r-\u0003\"CA\bo\u0005\u0005\t\u0019AA\u0011\u0003\r\u0019X/\\\u000b\u0003\u0003K\fAa];nA\u0005)1/^7Tc\u0006I1/^7Tc~#S-\u001d\u000b\u0005\u0003\u000f\u0019I\u0006C\u0005\u0002\u0010q\n\t\u00111\u0001\u0002\"\u000511/^7Tc\u0002\n1!\u00193e)\u0011\u0019\tga\u0019\u000e\u00035Bqa!\u001a?\u0001\u0004\u0011Y)A\u0001w\u0003\u0015iWM]4f)\u0011\u0019\tga\u001b\t\u000f\r5t\b1\u0001\u00048\u0005)q\u000e\u001e5fe\u000691/^7nCJLXC\u0001B9\u0003-\u0019\b\u000f\\5u\u0007\u0016tG/\u001a:\u0015\u0011\r]4\u0011PB>\u0007\u0013\u0003r!\u001dB\u000b\u0005\u0017\u0013Y\tC\u0004\u0003\b\u0006\u0003\rAa#\t\u000f\ru\u0014\t1\u0001\u0004\u0000\u00051!/\u00198e_6\u0004Ba!!\u0004\u00066\u001111\u0011\u0006\u0005\u0005\u0003\u0011i.\u0003\u0003\u0004\b\u000e\r%A\u0002*b]\u0012|W\u000eC\u0004\u0002B\u0005\u0003\raa\n\u0002#U\u0004H-\u0019;f\u0003N\u001c\u0018n\u001a8nK:$8\u000f\u0006\u0006\u0004\"\r=5\u0011SBN\u0007CCqaa\bC\u0001\u0004\u0019\t\u0003C\u0004\u0004\u0014\n\u0003\ra!&\u0002!\u0011Lg/[:jE2,\u0017J\u001c3jG\u0016\u001c\bCBA$\u0007/\u000b\u0019$\u0003\u0003\u0004\u001a\u0006e#aA*fi\"91Q\u0014\"A\u0002\r}\u0015!\u00058fo\u000ecWo\u001d;fe\u000e+g\u000e^3sgBA\u0011q\tB7\u0003g\u0011Y\tC\u0004\u0002B\t\u0003\raa\n\u0002\u0013\t,\u0018\u000e\u001c3Ue\u0016,GCBBT\u0007[\u001b\t\f\u0005\u0003\u0002j\r%\u0016bABVI\n\u00112\t\\;ti\u0016\u0014\u0018N\\4Ue\u0016,gj\u001c3f\u0011\u001d\u0019yk\u0011a\u0001\u0005W\n\u0001b\u00197vgR,'o\u001d\u0005\b\u0003\u0003\u001a\u0005\u0019AB\u0014\u00039\u0019E.^:uKJ\u001cV/\\7bef\u00042Aa\u001d]'\u0015a6\u0011\u0018B !9\u0019Yl!1\u00024\u0005\u0005\"1RA\u0011\u0005cj!a!0\u000b\u0007\r}&/A\u0004sk:$\u0018.\\3\n\t\r\r7Q\u0018\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:$DCAB[\u0003\u0015\t\u0007\u000f\u001d7z))\u0011\tha3\u0004N\u000e=7\u0011\u001b\u0005\b\u0005\u007fz\u0006\u0019AA\u001a\u0011\u001d\u0011\u0019i\u0018a\u0001\u0003CAqAa\"`\u0001\u0004\u0011Y\tC\u0004\u0003\u0014~\u0003\r!!\t\u0002\u000fUt\u0017\r\u001d9msR!1q[Bp!\u0015\t\u0018q_Bm!-\t81\\A\u001a\u0003C\u0011Y)!\t\n\u0007\ru'O\u0001\u0004UkBdW\r\u000e\u0005\n\u0007C\u0004\u0017\u0011!a\u0001\u0005c\n1\u0001\u001f\u00131\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\r\u001d\b\u0003\u0002Bl\u0007SLAaa;\u0003Z\n1qJ\u00196fGR\u0004")
public class BisectingKMeans
implements Logging {
    private int k;
    private int maxIterations;
    private double minDivisibleClusterSize;
    private long seed;
    private String distanceMeasure;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private int k() {
        return this.k;
    }

    private void k_$eq(int x$1) {
        this.k = x$1;
    }

    private int maxIterations() {
        return this.maxIterations;
    }

    private void maxIterations_$eq(int x$1) {
        this.maxIterations = x$1;
    }

    private double minDivisibleClusterSize() {
        return this.minDivisibleClusterSize;
    }

    private void minDivisibleClusterSize_$eq(double x$1) {
        this.minDivisibleClusterSize = x$1;
    }

    private long seed() {
        return this.seed;
    }

    private void seed_$eq(long x$1) {
        this.seed = x$1;
    }

    private String distanceMeasure() {
        return this.distanceMeasure;
    }

    private void distanceMeasure_$eq(String x$1) {
        this.distanceMeasure = x$1;
    }

    public BisectingKMeans setK(int k) {
        Predef$.MODULE$.require(k > 0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("k must be positive but got ").append(k).append(".").toString());
        this.k_$eq(k);
        return this;
    }

    public int getK() {
        return this.k();
    }

    public BisectingKMeans setMaxIterations(int maxIterations) {
        Predef$.MODULE$.require(maxIterations > 0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(40).append("maxIterations must be positive but got ").append(maxIterations).append(".").toString());
        this.maxIterations_$eq(maxIterations);
        return this;
    }

    public int getMaxIterations() {
        return this.maxIterations();
    }

    public BisectingKMeans setMinDivisibleClusterSize(double minDivisibleClusterSize) {
        Predef$.MODULE$.require(minDivisibleClusterSize > 0.0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(50).append("minDivisibleClusterSize must be positive but got ").append(minDivisibleClusterSize).append(".").toString());
        this.minDivisibleClusterSize_$eq(minDivisibleClusterSize);
        return this;
    }

    public double getMinDivisibleClusterSize() {
        return this.minDivisibleClusterSize();
    }

    public BisectingKMeans setSeed(long seed) {
        this.seed_$eq(seed);
        return this;
    }

    public long getSeed() {
        return this.seed();
    }

    public String getDistanceMeasure() {
        return this.distanceMeasure();
    }

    public BisectingKMeans setDistanceMeasure(String distanceMeasure) {
        DistanceMeasure$.MODULE$.validateDistanceMeasure(distanceMeasure);
        this.distanceMeasure_$eq(distanceMeasure);
        return this;
    }

    public BisectingKMeansModel run(RDD<Vector> input, Option<Instrumentation> instr) {
        RDD instances = input.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Vector vector = x0$1;
            Tuple2 tuple2 = new Tuple2((Object)vector, (Object)BoxesRunTime.boxToDouble((double)1.0));
            return tuple2;
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        return this.runWithWeight((RDD<Tuple2<Vector, Object>>)instances, (Option<Instrumentation>)None$.MODULE$);
    }

    public BisectingKMeansModel runWithWeight(RDD<Tuple2<Vector, Object>> input, Option<Instrumentation> instr) {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        int d2 = BoxesRunTime.unboxToInt((Object)input.map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)BisectingKMeans.$anonfun$runWithWeight$1(x$1)), ClassTag$.MODULE$.Int()).first());
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(20).append("Feature dimension: ").append(d2).append(".").toString());
        DistanceMeasure dMeasure = DistanceMeasure$.MODULE$.decodeFromString(this.distanceMeasure());
        RDD norms = input.map((Function1 & Serializable & scala.Serializable)d -> BoxesRunTime.boxToDouble((double)Vectors$.MODULE$.norm((Vector)d._1(), 2.0)), ClassTag$.MODULE$.Double());
        RDD vectors = input.zip(norms, ClassTag$.MODULE$.Double()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            double norm;
            Tuple2 tuple2;
            block3: {
                Tuple2 tuple22;
                block2: {
                    tuple22 = x0$1;
                    if (tuple22 == null) break block2;
                    tuple2 = (Tuple2)tuple22._1();
                    norm = tuple22._2$mcD$sp();
                    if (tuple2 != null) break block3;
                }
                throw new MatchError((Object)tuple22);
            }
            Vector x = (Vector)tuple2._1();
            double weight = tuple2._2$mcD$sp();
            VectorWithNorm vectorWithNorm = new VectorWithNorm(x, norm, weight);
            return vectorWithNorm;
        }, ClassTag$.MODULE$.apply(VectorWithNorm.class));
        StorageLevel storageLevel = input.getStorageLevel();
        StorageLevel storageLevel2 = StorageLevel$.MODULE$.NONE();
        Object object = !(storageLevel != null ? !storageLevel.equals(storageLevel2) : storageLevel2 != null) ? vectors.persist(StorageLevel$.MODULE$.MEMORY_AND_DISK()) : BoxedUnit.UNIT;
        ObjectRef assignments = ObjectRef.create((Object)vectors.map((Function1 & Serializable & scala.Serializable)v -> new Tuple2((Object)BoxesRunTime.boxToLong((long)BisectingKMeans$.MODULE$.org$apache$spark$mllib$clustering$BisectingKMeans$$ROOT_INDEX()), v), ClassTag$.MODULE$.apply(Tuple2.class)));
        ObjectRef activeClusters = ObjectRef.create(BisectingKMeans$.MODULE$.org$apache$spark$mllib$clustering$BisectingKMeans$$summarize(d2, (RDD<Tuple2<Object, VectorWithNorm>>)((RDD)assignments.elem), dMeasure));
        instr.foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            x$2.logNumExamples(BoxesRunTime.unboxToLong((Object)((TraversableOnce)((Map)activeClusters.elem).values().map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToLong((long)x$3.size()), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)));
            return BoxedUnit.UNIT;
        });
        instr.foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
            x$4.logSumOfWeights(BoxesRunTime.unboxToDouble((Object)((TraversableOnce)((Map)activeClusters.elem).values().map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToDouble((double)x$5.weightSum()), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)));
            return BoxedUnit.UNIT;
        });
        ClusterSummary rootSummary = (ClusterSummary)((Map)activeClusters.elem).apply((Object)BoxesRunTime.boxToLong((long)BisectingKMeans$.MODULE$.org$apache$spark$mllib$clustering$BisectingKMeans$$ROOT_INDEX()));
        long n = rootSummary.size();
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(19).append("Number of points: ").append(n).append(".").toString());
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(15).append("Initial cost: ").append(rootSummary.cost()).append(".").toString());
        long minSize = this.minDivisibleClusterSize() >= 1.0 ? (long)scala.math.package$.MODULE$.ceil(this.minDivisibleClusterSize()) : (long)scala.math.package$.MODULE$.ceil(this.minDivisibleClusterSize() * (double)n);
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(56).append("The minimum number of points of a divisible cluster is ").append(minSize).append(".").toString());
        scala.collection.mutable.Seq inactiveClusters = (scala.collection.mutable.Seq)Seq$.MODULE$.empty();
        Random random = new Random(this.seed());
        int numLeafClustersNeeded = this.k() - 1;
        IntRef level = IntRef.create((int)1);
        RDD preIndices = null;
        RDD indices = null;
        while (((Map)activeClusters.elem).nonEmpty() && numLeafClustersNeeded > 0 && (double)level.elem < BisectingKMeans$.MODULE$.org$apache$spark$mllib$clustering$BisectingKMeans$$LEVEL_LIMIT()) {
            Map divisibleClusters = (Map)((Map)activeClusters.elem).filter((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)BisectingKMeans.$anonfun$runWithWeight$13(minSize, x0$2)));
            if (divisibleClusters.size() > numLeafClustersNeeded) {
                divisibleClusters = ((TraversableOnce)((IterableLike)divisibleClusters.toSeq().sortBy((Function1 & Serializable & scala.Serializable)x0$3 -> BoxesRunTime.boxToLong((long)BisectingKMeans.$anonfun$runWithWeight$14(x0$3)), (Ordering)Ordering.Long$.MODULE$)).take(numLeafClustersNeeded)).toMap(Predef$.MODULE$.$conforms());
            }
            if (divisibleClusters.nonEmpty()) {
                BoxedUnit boxedUnit3;
                Set divisibleIndices = divisibleClusters.keys().toSet();
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("Dividing ").append(divisibleIndices.size()).append(" clusters on level ").append(level$1.elem).append(".").toString());
                ObjectRef newClusterCenters = ObjectRef.create((Object)((Map)((TraversableLike)divisibleClusters.flatMap((Function1 & Serializable & scala.Serializable)x0$4 -> {
                    Tuple2 tuple2;
                    long index;
                    Tuple2 tuple22 = x0$4;
                    if (tuple22 != null) {
                        index = tuple22._1$mcJ$sp();
                        ClusterSummary summary = (ClusterSummary)tuple22._2();
                        Tuple2<VectorWithNorm, VectorWithNorm> tuple23 = BisectingKMeans$.MODULE$.org$apache$spark$mllib$clustering$BisectingKMeans$$splitCenter(summary.center(), random, dMeasure);
                        if (tuple23 == null) {
                            throw new MatchError(tuple23);
                        }
                        VectorWithNorm left = (VectorWithNorm)tuple23._1();
                        VectorWithNorm right = (VectorWithNorm)tuple23._2();
                        tuple2 = new Tuple2((Object)left, (Object)right);
                    } else {
                        throw new MatchError((Object)tuple22);
                    }
                    Tuple2 tuple24 = tuple2;
                    VectorWithNorm left = (VectorWithNorm)tuple24._1();
                    VectorWithNorm right = (VectorWithNorm)tuple24._2();
                    Iterator iterator = package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToLong((long)BisectingKMeans$.MODULE$.org$apache$spark$mllib$clustering$BisectingKMeans$$leftChildIndex(index)), (Object)left), new Tuple2((Object)BoxesRunTime.boxToLong((long)BisectingKMeans$.MODULE$.org$apache$spark$mllib$clustering$BisectingKMeans$$rightChildIndex(index)), (Object)right)}));
                    return iterator;
                }, Map$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x -> (Tuple2)Predef$.MODULE$.identity(x), Map$.MODULE$.canBuildFrom())));
                ObjectRef newClusters = ObjectRef.create(null);
                ObjectRef newAssignments = ObjectRef.create(null);
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.maxIterations()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)iter -> {
                    newAssignments$1.elem = BisectingKMeans$.MODULE$.org$apache$spark$mllib$clustering$BisectingKMeans$$updateAssignments((RDD<Tuple2<Object, VectorWithNorm>>)((RDD)assignments$1.elem), (Set<Object>)divisibleIndices, (Map<Object, VectorWithNorm>)((Map)newClusterCenters$1.elem), dMeasure).filter((Function1 & Serializable & scala.Serializable)x0$5 -> BoxesRunTime.boxToBoolean((boolean)BisectingKMeans.$anonfun$runWithWeight$19(divisibleIndices, x0$5)));
                    newClusters$1.elem = BisectingKMeans$.MODULE$.org$apache$spark$mllib$clustering$BisectingKMeans$$summarize(d2, (RDD<Tuple2<Object, VectorWithNorm>>)((RDD)newAssignments$1.elem), dMeasure);
                    newClusterCenters$1.elem = (Map)((Map)newClusters$1.elem).mapValues((Function1 & Serializable & scala.Serializable)x$7 -> x$7.center()).map((Function1 & Serializable & scala.Serializable)x -> (Tuple2)Predef$.MODULE$.identity(x), Map$.MODULE$.canBuildFrom());
                });
                if (preIndices != null) {
                    RDD qual$1 = preIndices;
                    boolean x$12 = qual$1.unpersist$default$1();
                    boxedUnit3 = qual$1.unpersist(x$12);
                } else {
                    boxedUnit3 = BoxedUnit.UNIT;
                }
                preIndices = indices;
                indices = RDD$.MODULE$.rddToPairRDDFunctions(BisectingKMeans$.MODULE$.org$apache$spark$mllib$clustering$BisectingKMeans$$updateAssignments((RDD<Tuple2<Object, VectorWithNorm>>)((RDD)assignments.elem), (Set<Object>)divisibleIndices, (Map<Object, VectorWithNorm>)((Map)newClusterCenters.elem), dMeasure), ClassTag$.MODULE$.Long(), ClassTag$.MODULE$.apply(VectorWithNorm.class), (Ordering)Ordering.Long$.MODULE$).keys().persist(StorageLevel$.MODULE$.MEMORY_AND_DISK());
                assignments.elem = indices.zip(vectors, ClassTag$.MODULE$.apply(VectorWithNorm.class));
                inactiveClusters = (scala.collection.mutable.Seq)inactiveClusters.$plus$plus((GenTraversableOnce)((Map)activeClusters.elem), Seq$.MODULE$.canBuildFrom());
                activeClusters.elem = (Map)newClusters.elem;
                numLeafClustersNeeded -= divisibleClusters.size();
            } else {
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(67).append("None active and divisible clusters left on level ").append(level$1.elem).append(". Stop iterations.").toString());
                inactiveClusters = (scala.collection.mutable.Seq)inactiveClusters.$plus$plus((GenTraversableOnce)((Map)activeClusters.elem), Seq$.MODULE$.canBuildFrom());
                activeClusters.elem = Predef$.MODULE$.Map().empty();
            }
            ++level.elem;
        }
        if (preIndices != null) {
            RDD qual$2 = preIndices;
            boolean x$22 = qual$2.unpersist$default$1();
            boxedUnit2 = qual$2.unpersist(x$22);
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        if (indices != null) {
            RDD qual$3 = indices;
            boolean x$3 = qual$3.unpersist$default$1();
            boxedUnit = qual$3.unpersist(x$3);
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        vectors.unpersist(vectors.unpersist$default$1());
        Map clusters = ((Map)activeClusters.elem).$plus$plus((GenTraversableOnce)inactiveClusters);
        ClusteringTreeNode root = BisectingKMeans$.MODULE$.org$apache$spark$mllib$clustering$BisectingKMeans$$buildTree((Map<Object, ClusterSummary>)clusters, dMeasure);
        double totalCost = BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])root.leafNodes())).map((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToDouble((double)x$8.cost()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())))).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
        return new BisectingKMeansModel(root, this.distanceMeasure(), totalCost);
    }

    public BisectingKMeansModel run(RDD<Vector> input) {
        return this.run(input, (Option<Instrumentation>)None$.MODULE$);
    }

    public BisectingKMeansModel run(JavaRDD<Vector> data) {
        return this.run((RDD<Vector>)data.rdd());
    }

    public static final /* synthetic */ int $anonfun$runWithWeight$1(Tuple2 x$1) {
        return ((Vector)x$1._1()).size();
    }

    public static final /* synthetic */ boolean $anonfun$runWithWeight$13(long minSize$1, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        ClusterSummary summary = (ClusterSummary)tuple2._2();
        boolean bl = summary.size() >= minSize$1 && summary.cost() > MLUtils$.MODULE$.EPSILON() * (double)summary.size();
        return bl;
    }

    public static final /* synthetic */ long $anonfun$runWithWeight$14(Tuple2 x0$3) {
        Tuple2 tuple2 = x0$3;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        ClusterSummary summary = (ClusterSummary)tuple2._2();
        long l = -summary.size();
        return l;
    }

    public static final /* synthetic */ boolean $anonfun$runWithWeight$19(Set divisibleIndices$1, Tuple2 x0$5) {
        Tuple2 tuple2 = x0$5;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        long index = tuple2._1$mcJ$sp();
        boolean bl = divisibleIndices$1.contains((Object)BoxesRunTime.boxToLong((long)BisectingKMeans$.MODULE$.org$apache$spark$mllib$clustering$BisectingKMeans$$parentIndex(index)));
        return bl;
    }

    private BisectingKMeans(int k, int maxIterations, double minDivisibleClusterSize, long seed, String distanceMeasure) {
        this.k = k;
        this.maxIterations = maxIterations;
        this.minDivisibleClusterSize = minDivisibleClusterSize;
        this.seed = seed;
        this.distanceMeasure = distanceMeasure;
        Logging.$init$((Logging)this);
    }

    public BisectingKMeans() {
        this(4, 20, 1.0, Statics.anyHash((Object)BisectingKMeans.class.getName()), DistanceMeasure$.MODULE$.EUCLIDEAN());
    }

    public static class ClusterSummary
    implements Product,
    scala.Serializable {
        private final long size;
        private final double weightSum;
        private final VectorWithNorm center;
        private final double cost;

        public long size() {
            return this.size;
        }

        public double weightSum() {
            return this.weightSum;
        }

        public VectorWithNorm center() {
            return this.center;
        }

        public double cost() {
            return this.cost;
        }

        public ClusterSummary copy(long size, double weightSum, VectorWithNorm center, double cost) {
            return new ClusterSummary(size, weightSum, center, cost);
        }

        public long copy$default$1() {
            return this.size();
        }

        public double copy$default$2() {
            return this.weightSum();
        }

        public VectorWithNorm copy$default$3() {
            return this.center();
        }

        public double copy$default$4() {
            return this.cost();
        }

        public String productPrefix() {
            return "ClusterSummary";
        }

        public int productArity() {
            return 4;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = BoxesRunTime.boxToLong((long)this.size());
                    break;
                }
                case 1: {
                    object = BoxesRunTime.boxToDouble((double)this.weightSum());
                    break;
                }
                case 2: {
                    object = this.center();
                    break;
                }
                case 3: {
                    object = BoxesRunTime.boxToDouble((double)this.cost());
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof ClusterSummary;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.size()));
            n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.weightSum()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.center()));
            n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.cost()));
            return Statics.finalizeHash((int)n, (int)4);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof ClusterSummary)) return false;
            boolean bl = true;
            if (!bl) return false;
            ClusterSummary clusterSummary = (ClusterSummary)x$1;
            if (this.size() != clusterSummary.size()) return false;
            if (this.weightSum() != clusterSummary.weightSum()) return false;
            VectorWithNorm vectorWithNorm = this.center();
            VectorWithNorm vectorWithNorm2 = clusterSummary.center();
            if (vectorWithNorm == null) {
                if (vectorWithNorm2 != null) {
                    return false;
                }
            } else if (!vectorWithNorm.equals(vectorWithNorm2)) return false;
            if (this.cost() != clusterSummary.cost()) return false;
            if (!clusterSummary.canEqual(this)) return false;
            return true;
        }

        public ClusterSummary(long size, double weightSum, VectorWithNorm center, double cost) {
            this.size = size;
            this.weightSum = weightSum;
            this.center = center;
            this.cost = cost;
            Product.$init$((Product)this);
        }
    }

    public static class ClusterSummaryAggregator
    implements scala.Serializable {
        private final int d;
        private final DistanceMeasure distanceMeasure;
        private long n;
        private double weightSum;
        private final Vector sum;
        private double sumSq;

        public int d() {
            return this.d;
        }

        public DistanceMeasure distanceMeasure() {
            return this.distanceMeasure;
        }

        private long n() {
            return this.n;
        }

        private void n_$eq(long x$1) {
            this.n = x$1;
        }

        private double weightSum() {
            return this.weightSum;
        }

        private void weightSum_$eq(double x$1) {
            this.weightSum = x$1;
        }

        private Vector sum() {
            return this.sum;
        }

        private double sumSq() {
            return this.sumSq;
        }

        private void sumSq_$eq(double x$1) {
            this.sumSq = x$1;
        }

        public ClusterSummaryAggregator add(VectorWithNorm v) {
            this.n_$eq(this.n() + 1L);
            this.weightSum_$eq(this.weightSum() + v.weight());
            this.sumSq_$eq(this.sumSq() + v.norm() * v.norm() * v.weight());
            this.distanceMeasure().updateClusterSum(v, this.sum());
            return this;
        }

        public ClusterSummaryAggregator merge(ClusterSummaryAggregator other) {
            this.n_$eq(this.n() + other.n());
            this.weightSum_$eq(this.weightSum() + other.weightSum());
            this.sumSq_$eq(this.sumSq() + other.sumSq());
            BLAS$.MODULE$.axpy(1.0, other.sum(), this.sum());
            return this;
        }

        public ClusterSummary summary() {
            VectorWithNorm center = this.distanceMeasure().centroid(this.sum().copy(), this.weightSum());
            double cost = this.distanceMeasure().clusterCost(center, new VectorWithNorm(this.sum()), this.weightSum(), this.sumSq());
            return new ClusterSummary(this.n(), this.weightSum(), center, cost);
        }

        public ClusterSummaryAggregator(int d, DistanceMeasure distanceMeasure) {
            this.d = d;
            this.distanceMeasure = distanceMeasure;
            this.n = 0L;
            this.weightSum = 0.0;
            this.sum = Vectors$.MODULE$.zeros(d);
            this.sumSq = 0.0;
        }
    }
}

