/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.regression;

import java.io.IOException;
import java.io.Serializable;
import org.apache.spark.ml.feature.LabeledPoint;
import org.apache.spark.ml.linalg.Matrix;
import org.apache.spark.ml.param.BooleanParam;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.LongParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.ParamPair;
import org.apache.spark.ml.param.shared.HasFitIntercept;
import org.apache.spark.ml.param.shared.HasMaxIter;
import org.apache.spark.ml.param.shared.HasRegParam;
import org.apache.spark.ml.param.shared.HasSeed;
import org.apache.spark.ml.param.shared.HasSolver;
import org.apache.spark.ml.param.shared.HasStepSize;
import org.apache.spark.ml.param.shared.HasTol;
import org.apache.spark.ml.regression.FMRegressionModel;
import org.apache.spark.ml.regression.FMRegressor$;
import org.apache.spark.ml.regression.FMRegressorParams;
import org.apache.spark.ml.regression.FactorizationMachines;
import org.apache.spark.ml.regression.FactorizationMachines$;
import org.apache.spark.ml.regression.FactorizationMachinesParams;
import org.apache.spark.ml.regression.Regressor;
import org.apache.spark.ml.util.DefaultParamsWritable;
import org.apache.spark.ml.util.Identifiable$;
import org.apache.spark.ml.util.Instrumentation$;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.ml.util.MetadataUtils$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.VectorImplicits$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005g\u0001B\f\u0019\u0001\rB\u0001\u0002\u0012\u0001\u0003\u0006\u0004%\t%\u0012\u0005\t9\u0002\u0011\t\u0011)A\u0005\r\")a\f\u0001C\u0001?\")a\f\u0001C\u0001G\")Q\r\u0001C\u0001M\")q\u000e\u0001C\u0001a\")a\u000f\u0001C\u0001o\")!\u0010\u0001C\u0001w\"9\u00111\u0001\u0001\u0005\u0002\u0005\u0015\u0001bBA\u0006\u0001\u0011\u0005\u0011Q\u0002\u0005\b\u0003'\u0001A\u0011AA\u000b\u0011\u001d\tY\u0002\u0001C\u0001\u0003;Aq!a\t\u0001\t\u0003\t)\u0003C\u0004\u0002,\u0001!\t!!\f\t\u000f\u0005M\u0002\u0001\"\u0001\u00026!9\u0011\u0011\t\u0001\u0005R\u0005\r\u0003bBA7\u0001\u0011\u0005\u0013qN\u0004\b\u0003\u000bC\u0002\u0012AAD\r\u00199\u0002\u0004#\u0001\u0002\n\"1al\u0005C\u0001\u0003;Cq!a(\u0014\t\u0003\n\t\u000bC\u0005\u0002*N\t\t\u0011\"\u0003\u0002,\nYa)\u0014*fOJ,7o]8s\u0015\tI\"$\u0001\u0006sK\u001e\u0014Xm]:j_:T!a\u0007\u000f\u0002\u00055d'BA\u000f\u001f\u0003\u0015\u0019\b/\u0019:l\u0015\ty\u0002%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002C\u0005\u0019qN]4\u0004\u0001M1\u0001\u0001\n\u001a6qy\u0002R!\n\u0014)]=j\u0011\u0001G\u0005\u0003Oa\u0011\u0011BU3he\u0016\u001c8o\u001c:\u0011\u0005%bS\"\u0001\u0016\u000b\u0005-R\u0012A\u00027j]\u0006dw-\u0003\u0002.U\t1a+Z2u_J\u0004\"!\n\u0001\u0011\u0005\u0015\u0002\u0014BA\u0019\u0019\u0005E1UJU3he\u0016\u001c8/[8o\u001b>$W\r\u001c\t\u0003KMJ!\u0001\u000e\r\u0003+\u0019\u000b7\r^8sSj\fG/[8o\u001b\u0006\u001c\u0007.\u001b8fgB\u0011QEN\u0005\u0003oa\u0011\u0011CR'SK\u001e\u0014Xm]:peB\u000b'/Y7t!\tID(D\u0001;\u0015\tY$$\u0001\u0003vi&d\u0017BA\u001f;\u0005U!UMZ1vYR\u0004\u0016M]1ng^\u0013\u0018\u000e^1cY\u0016\u0004\"a\u0010\"\u000e\u0003\u0001S!!\u0011\u000f\u0002\u0011%tG/\u001a:oC2L!a\u0011!\u0003\u000f1{wmZ5oO\u0006\u0019Q/\u001b3\u0016\u0003\u0019\u0003\"a\u0012)\u000f\u0005!s\u0005CA%M\u001b\u0005Q%BA&#\u0003\u0019a$o\\8u})\tQ*A\u0003tG\u0006d\u0017-\u0003\u0002P\u0019\u00061\u0001K]3eK\u001aL!!\u0015*\u0003\rM#(/\u001b8h\u0015\tyE\nK\u0002\u0002)j\u0003\"!\u0016-\u000e\u0003YS!a\u0016\u000f\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002Z-\n)1+\u001b8dK\u0006\n1,A\u00034]Ar\u0003'\u0001\u0003vS\u0012\u0004\u0003f\u0001\u0002U5\u00061A(\u001b8jiz\"\"A\f1\t\u000b\u0011\u001b\u0001\u0019\u0001$)\u0007\u0001$&\fK\u0002\u0004)j#\u0012A\f\u0015\u0004\tQS\u0016!D:fi\u001a\u000b7\r^8s'&TX\r\u0006\u0002hQ6\t\u0001\u0001C\u0003j\u000b\u0001\u0007!.A\u0003wC2,X\r\u0005\u0002lY6\tA*\u0003\u0002n\u0019\n\u0019\u0011J\u001c;)\u0007\u0015!&,A\btKR4\u0015\u000e^%oi\u0016\u00148-\u001a9u)\t9\u0017\u000fC\u0003j\r\u0001\u0007!\u000f\u0005\u0002lg&\u0011A\u000f\u0014\u0002\b\u0005>|G.Z1oQ\r1AKW\u0001\rg\u0016$h)\u001b;MS:,\u0017M\u001d\u000b\u0003ObDQ![\u0004A\u0002ID3a\u0002+[\u0003-\u0019X\r\u001e*fOB\u000b'/Y7\u0015\u0005\u001dd\b\"B5\t\u0001\u0004i\bCA6\u007f\u0013\tyHJ\u0001\u0004E_V\u0014G.\u001a\u0015\u0004\u0011QS\u0016\u0001F:fi6Kg.\u001b\"bi\u000eDgI]1di&|g\u000eF\u0002h\u0003\u000fAQ![\u0005A\u0002uD3!\u0003+[\u0003)\u0019X\r^%oSR\u001cF\u000f\u001a\u000b\u0004O\u0006=\u0001\"B5\u000b\u0001\u0004i\bf\u0001\u0006U5\u0006Q1/\u001a;NCbLE/\u001a:\u0015\u0007\u001d\f9\u0002C\u0003j\u0017\u0001\u0007!\u000eK\u0002\f)j\u000b1b]3u'R,\u0007oU5{KR\u0019q-a\b\t\u000b%d\u0001\u0019A?)\u00071!&,\u0001\u0004tKR$v\u000e\u001c\u000b\u0004O\u0006\u001d\u0002\"B5\u000e\u0001\u0004i\bfA\u0007U5\u0006I1/\u001a;T_24XM\u001d\u000b\u0004O\u0006=\u0002\"B5\u000f\u0001\u00041\u0005f\u0001\bU5\u000691/\u001a;TK\u0016$GcA4\u00028!1\u0011n\u0004a\u0001\u0003s\u00012a[A\u001e\u0013\r\ti\u0004\u0014\u0002\u0005\u0019>tw\rK\u0002\u0010)j\u000bQ\u0001\u001e:bS:$2aLA#\u0011\u001d\t9\u0005\u0005a\u0001\u0003\u0013\nq\u0001Z1uCN,G\u000f\r\u0003\u0002L\u0005m\u0003CBA'\u0003'\n9&\u0004\u0002\u0002P)\u0019\u0011\u0011\u000b\u000f\u0002\u0007M\fH.\u0003\u0003\u0002V\u0005=#a\u0002#bi\u0006\u001cX\r\u001e\t\u0005\u00033\nY\u0006\u0004\u0001\u0005\u0019\u0005u\u0013QIA\u0001\u0002\u0003\u0015\t!a\u0018\u0003\u0007}#\u0013'\u0005\u0003\u0002b\u0005\u001d\u0004cA6\u0002d%\u0019\u0011Q\r'\u0003\u000f9{G\u000f[5oOB\u00191.!\u001b\n\u0007\u0005-DJA\u0002B]f\fAaY8qsR\u0019a&!\u001d\t\u000f\u0005M\u0014\u00031\u0001\u0002v\u0005)Q\r\u001f;sCB!\u0011qOA?\u001b\t\tIHC\u0002\u0002|i\tQ\u0001]1sC6LA!a \u0002z\tA\u0001+\u0019:b[6\u000b\u0007\u000fK\u0002\u0012)jC3\u0001\u0001+[\u0003-1UJU3he\u0016\u001c8o\u001c:\u0011\u0005\u0015\u001a2cB\n\u0002\f\u0006E\u0015q\u0013\t\u0004W\u00065\u0015bAAH\u0019\n1\u0011I\\=SK\u001a\u0004B!OAJ]%\u0019\u0011Q\u0013\u001e\u0003+\u0011+g-Y;miB\u000b'/Y7t%\u0016\fG-\u00192mKB\u00191.!'\n\u0007\u0005mEJ\u0001\u0007TKJL\u0017\r\\5{C\ndW\r\u0006\u0002\u0002\b\u0006!An\\1e)\rq\u00131\u0015\u0005\u0007\u0003K+\u0002\u0019\u0001$\u0002\tA\fG\u000f\u001b\u0015\u0004+QS\u0016a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"!!,\u0011\t\u0005=\u0016\u0011X\u0007\u0003\u0003cSA!a-\u00026\u0006!A.\u00198h\u0015\t\t9,\u0001\u0003kCZ\f\u0017\u0002BA^\u0003c\u0013aa\u00142kK\u000e$\bfA\nU5\"\u001a!\u0003\u0016.")
public class FMRegressor
extends Regressor<org.apache.spark.ml.linalg.Vector, FMRegressor, FMRegressionModel>
implements FactorizationMachines,
FMRegressorParams,
DefaultParamsWritable {
    private final String uid;
    private final IntParam factorSize;
    private final BooleanParam fitLinear;
    private final DoubleParam miniBatchFraction;
    private final DoubleParam initStd;
    private final Param<String> solver;
    private final DoubleParam regParam;
    private final BooleanParam fitIntercept;
    private final LongParam seed;
    private final DoubleParam tol;
    private final DoubleParam stepSize;
    private final IntParam maxIter;

    public static FMRegressor load(String string) {
        return FMRegressor$.MODULE$.load(string);
    }

    public static MLReader<FMRegressor> read() {
        return FMRegressor$.MODULE$.read();
    }

    @Override
    public MLWriter write() {
        return DefaultParamsWritable.write$(this);
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable.save$(this, path);
    }

    @Override
    public Vector initCoefficients(int numFeatures) {
        return FactorizationMachines.initCoefficients$(this, numFeatures);
    }

    @Override
    public org.apache.spark.ml.linalg.Vector trainImpl(RDD<Tuple2<Object, Vector>> data, int numFeatures, String loss) {
        return FactorizationMachines.trainImpl$(this, data, numFeatures, loss);
    }

    @Override
    public final int getFactorSize() {
        return FactorizationMachinesParams.getFactorSize$(this);
    }

    @Override
    public final boolean getFitLinear() {
        return FactorizationMachinesParams.getFitLinear$(this);
    }

    @Override
    public final double getMiniBatchFraction() {
        return FactorizationMachinesParams.getMiniBatchFraction$(this);
    }

    @Override
    public final double getInitStd() {
        return FactorizationMachinesParams.getInitStd$(this);
    }

    @Override
    public final double getRegParam() {
        return HasRegParam.getRegParam$(this);
    }

    @Override
    public final boolean getFitIntercept() {
        return HasFitIntercept.getFitIntercept$(this);
    }

    @Override
    public final long getSeed() {
        return HasSeed.getSeed$(this);
    }

    @Override
    public final String getSolver() {
        return HasSolver.getSolver$(this);
    }

    @Override
    public final double getTol() {
        return HasTol.getTol$(this);
    }

    @Override
    public final double getStepSize() {
        return HasStepSize.getStepSize$(this);
    }

    @Override
    public final int getMaxIter() {
        return HasMaxIter.getMaxIter$(this);
    }

    @Override
    public final IntParam factorSize() {
        return this.factorSize;
    }

    @Override
    public final BooleanParam fitLinear() {
        return this.fitLinear;
    }

    @Override
    public final DoubleParam miniBatchFraction() {
        return this.miniBatchFraction;
    }

    @Override
    public final DoubleParam initStd() {
        return this.initStd;
    }

    @Override
    public final Param<String> solver() {
        return this.solver;
    }

    @Override
    public final void org$apache$spark$ml$regression$FactorizationMachinesParams$_setter_$factorSize_$eq(IntParam x$1) {
        this.factorSize = x$1;
    }

    @Override
    public final void org$apache$spark$ml$regression$FactorizationMachinesParams$_setter_$fitLinear_$eq(BooleanParam x$1) {
        this.fitLinear = x$1;
    }

    @Override
    public final void org$apache$spark$ml$regression$FactorizationMachinesParams$_setter_$miniBatchFraction_$eq(DoubleParam x$1) {
        this.miniBatchFraction = x$1;
    }

    @Override
    public final void org$apache$spark$ml$regression$FactorizationMachinesParams$_setter_$initStd_$eq(DoubleParam x$1) {
        this.initStd = x$1;
    }

    @Override
    public final void org$apache$spark$ml$regression$FactorizationMachinesParams$_setter_$solver_$eq(Param<String> x$1) {
        this.solver = x$1;
    }

    @Override
    public final DoubleParam regParam() {
        return this.regParam;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasRegParam$_setter_$regParam_$eq(DoubleParam x$1) {
        this.regParam = x$1;
    }

    @Override
    public final BooleanParam fitIntercept() {
        return this.fitIntercept;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasFitIntercept$_setter_$fitIntercept_$eq(BooleanParam x$1) {
        this.fitIntercept = x$1;
    }

    @Override
    public final LongParam seed() {
        return this.seed;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasSeed$_setter_$seed_$eq(LongParam x$1) {
        this.seed = x$1;
    }

    @Override
    public void org$apache$spark$ml$param$shared$HasSolver$_setter_$solver_$eq(Param<String> x$1) {
    }

    @Override
    public final DoubleParam tol() {
        return this.tol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasTol$_setter_$tol_$eq(DoubleParam x$1) {
        this.tol = x$1;
    }

    @Override
    public DoubleParam stepSize() {
        return this.stepSize;
    }

    @Override
    public void org$apache$spark$ml$param$shared$HasStepSize$_setter_$stepSize_$eq(DoubleParam x$1) {
        this.stepSize = x$1;
    }

    @Override
    public final IntParam maxIter() {
        return this.maxIter;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasMaxIter$_setter_$maxIter_$eq(IntParam x$1) {
        this.maxIter = x$1;
    }

    @Override
    public String uid() {
        return this.uid;
    }

    public FMRegressor setFactorSize(int value) {
        return (FMRegressor)this.set(this.factorSize(), BoxesRunTime.boxToInteger((int)value));
    }

    public FMRegressor setFitIntercept(boolean value) {
        return (FMRegressor)this.set(this.fitIntercept(), BoxesRunTime.boxToBoolean((boolean)value));
    }

    public FMRegressor setFitLinear(boolean value) {
        return (FMRegressor)this.set(this.fitLinear(), BoxesRunTime.boxToBoolean((boolean)value));
    }

    public FMRegressor setRegParam(double value) {
        return (FMRegressor)this.set(this.regParam(), BoxesRunTime.boxToDouble((double)value));
    }

    public FMRegressor setMiniBatchFraction(double value) {
        return (FMRegressor)this.set(this.miniBatchFraction(), BoxesRunTime.boxToDouble((double)value));
    }

    public FMRegressor setInitStd(double value) {
        return (FMRegressor)this.set(this.initStd(), BoxesRunTime.boxToDouble((double)value));
    }

    public FMRegressor setMaxIter(int value) {
        return (FMRegressor)this.set(this.maxIter(), BoxesRunTime.boxToInteger((int)value));
    }

    public FMRegressor setStepSize(double value) {
        return (FMRegressor)this.set(this.stepSize(), BoxesRunTime.boxToDouble((double)value));
    }

    public FMRegressor setTol(double value) {
        return (FMRegressor)this.set(this.tol(), BoxesRunTime.boxToDouble((double)value));
    }

    public FMRegressor setSolver(String value) {
        return (FMRegressor)this.set(this.solver(), value);
    }

    public FMRegressor setSeed(long value) {
        return (FMRegressor)this.set(this.seed(), BoxesRunTime.boxToLong((long)value));
    }

    @Override
    public FMRegressionModel train(Dataset<?> dataset) {
        return (FMRegressionModel)Instrumentation$.MODULE$.instrumented((Function1 & Serializable & scala.Serializable)instr -> {
            instr.logPipelineStage(this);
            instr.logDataset(dataset);
            instr.logParams(this, (Seq<Param<?>>)Predef$.MODULE$.wrapRefArray((Object[])new Param[]{this.factorSize(), this.fitIntercept(), this.fitLinear(), this.regParam(), this.miniBatchFraction(), this.initStd(), this.maxIter(), this.stepSize(), this.tol(), this.solver()}));
            int numFeatures = MetadataUtils$.MODULE$.getNumFeatures(dataset, this.$(this.featuresCol()));
            instr.logNumFeatures(numFeatures);
            StorageLevel storageLevel = dataset.storageLevel();
            StorageLevel storageLevel2 = StorageLevel$.MODULE$.NONE();
            boolean handlePersistence = !(storageLevel != null ? !storageLevel.equals(storageLevel2) : storageLevel2 != null);
            RDD<LabeledPoint> labeledPoint = this.extractLabeledPoints(dataset);
            RDD data = labeledPoint.map((Function1 & Serializable & scala.Serializable)x -> new Tuple2((Object)BoxesRunTime.boxToDouble((double)x.label()), (Object)VectorImplicits$.MODULE$.mlVectorToMLlibVector(x.features())), ClassTag$.MODULE$.apply(Tuple2.class));
            Object object = handlePersistence ? data.persist(StorageLevel$.MODULE$.MEMORY_AND_DISK()) : BoxedUnit.UNIT;
            org.apache.spark.ml.linalg.Vector coefficients = this.trainImpl((RDD<Tuple2<Object, Vector>>)data, numFeatures, FactorizationMachines$.MODULE$.SquaredError());
            Tuple3<Object, org.apache.spark.ml.linalg.Vector, Matrix> tuple3 = FactorizationMachines$.MODULE$.splitCoefficients(coefficients, numFeatures, BoxesRunTime.unboxToInt((Object)this.$(this.factorSize())), BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept())), BoxesRunTime.unboxToBoolean((Object)this.$(this.fitLinear())));
            if (tuple3 == null) {
                throw new MatchError(tuple3);
            }
            double intercept = BoxesRunTime.unboxToDouble((Object)tuple3._1());
            org.apache.spark.ml.linalg.Vector linear = (org.apache.spark.ml.linalg.Vector)tuple3._2();
            Matrix factors = (Matrix)tuple3._3();
            Tuple3 tuple32 = new Tuple3((Object)BoxesRunTime.boxToDouble((double)intercept), (Object)linear, (Object)factors);
            Tuple3 tuple33 = tuple32;
            double intercept2 = BoxesRunTime.unboxToDouble((Object)tuple33._1());
            org.apache.spark.ml.linalg.Vector linear2 = (org.apache.spark.ml.linalg.Vector)tuple33._2();
            Matrix factors2 = (Matrix)tuple33._3();
            Object object2 = handlePersistence ? data.unpersist(data.unpersist$default$1()) : BoxedUnit.UNIT;
            return this.copyValues(new FMRegressionModel(this.uid(), intercept2, linear2, factors2), this.copyValues$default$2());
        });
    }

    @Override
    public FMRegressor copy(ParamMap extra) {
        return (FMRegressor)this.defaultCopy(extra);
    }

    public FMRegressor(String uid) {
        this.uid = uid;
        HasMaxIter.$init$(this);
        HasStepSize.$init$(this);
        HasTol.$init$(this);
        HasSolver.$init$(this);
        HasSeed.$init$(this);
        HasFitIntercept.$init$(this);
        HasRegParam.$init$(this);
        FactorizationMachinesParams.$init$(this);
        FactorizationMachines.$init$(this);
        MLWritable.$init$(this);
        DefaultParamsWritable.$init$(this);
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.factorSize().$minus$greater(BoxesRunTime.boxToInteger((int)8))}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.fitIntercept().$minus$greater(BoxesRunTime.boxToBoolean((boolean)true))}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.fitLinear().$minus$greater(BoxesRunTime.boxToBoolean((boolean)true))}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.regParam().$minus$greater(BoxesRunTime.boxToDouble((double)0.0))}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.miniBatchFraction().$minus$greater(BoxesRunTime.boxToDouble((double)1.0))}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.initStd().$minus$greater(BoxesRunTime.boxToDouble((double)0.01))}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.maxIter().$minus$greater(BoxesRunTime.boxToInteger((int)100))}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.stepSize().$minus$greater(BoxesRunTime.boxToDouble((double)1.0))}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.tol().$minus$greater(BoxesRunTime.boxToDouble((double)1.0E-6))}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.solver().$minus$greater(FactorizationMachines$.MODULE$.AdamW())}));
    }

    public FMRegressor() {
        this(Identifiable$.MODULE$.randomUID("fmr"));
    }
}

