/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.evaluation;

import java.io.IOException;
import java.io.Serializable;
import org.apache.spark.annotation.Experimental;
import org.apache.spark.ml.evaluation.Evaluator;
import org.apache.spark.ml.evaluation.RankingEvaluator$;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.ParamPair;
import org.apache.spark.ml.param.ParamValidators$;
import org.apache.spark.ml.param.shared.HasLabelCol;
import org.apache.spark.ml.param.shared.HasPredictionCol;
import org.apache.spark.ml.util.DefaultParamsWritable;
import org.apache.spark.ml.util.Identifiable;
import org.apache.spark.ml.util.Identifiable$;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.ml.util.SchemaUtils$;
import org.apache.spark.mllib.evaluation.RankingMetrics;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.StructType;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Experimental
@ScalaSignature(bytes="\u0006\u0001\u0005\u0005g\u0001\u0002\u000e\u001c\u0001\u0019B\u0001\u0002\u0010\u0001\u0003\u0006\u0004%\t%\u0010\u0005\t)\u0002\u0011\t\u0011)A\u0005}!)a\u000b\u0001C\u0001/\")a\u000b\u0001C\u00019\"9a\f\u0001b\u0001\n\u000by\u0006BB3\u0001A\u00035\u0001\rC\u0003h\u0001\u0011\u0005Q\bC\u0003j\u0001\u0011\u0005!\u000eC\u0004p\u0001\t\u0007IQ\u00019\t\rU\u0004\u0001\u0015!\u0004r\u0011\u00159\b\u0001\"\u0001y\u0011\u0015q\b\u0001\"\u0001\u0000\u0011\u001d\t)\u0001\u0001C\u0001\u0003\u000fAq!!\u0004\u0001\t\u0003\ty\u0001C\u0004\u0002\u0016\u0001!\t%a\u0006\t\u000f\u0005%\u0003\u0001\"\u0011\u0002L!9\u0011Q\u000b\u0001\u0005B\u0005]\u0003bBA3\u0001\u0011\u0005\u0013qM\u0004\b\u0003kZ\u0002\u0012AA<\r\u0019Q2\u0004#\u0001\u0002z!1a\u000b\u0006C\u0001\u0003\u001bC\u0011\"a$\u0015\u0005\u0004%I!!%\t\u0011\u0005\u001dF\u0003)A\u0005\u0003'Cq!!+\u0015\t\u0003\nY\u000bC\u0005\u00024R\t\t\u0011\"\u0003\u00026\n\u0001\"+\u00198lS:<WI^1mk\u0006$xN\u001d\u0006\u00039u\t!\"\u001a<bYV\fG/[8o\u0015\tqr$\u0001\u0002nY*\u0011\u0001%I\u0001\u0006gB\f'o\u001b\u0006\u0003E\r\na!\u00199bG\",'\"\u0001\u0013\u0002\u0007=\u0014xm\u0001\u0001\u0014\u000b\u000193f\r\u001c\u0011\u0005!JS\"A\u000e\n\u0005)Z\"!C#wC2,\u0018\r^8s!\ta\u0013'D\u0001.\u0015\tqs&\u0001\u0004tQ\u0006\u0014X\r\u001a\u0006\u0003au\tQ\u0001]1sC6L!AM\u0017\u0003!!\u000b7\u000f\u0015:fI&\u001cG/[8o\u0007>d\u0007C\u0001\u00175\u0013\t)TFA\u0006ICNd\u0015MY3m\u0007>d\u0007CA\u001c;\u001b\u0005A$BA\u001d\u001e\u0003\u0011)H/\u001b7\n\u0005mB$!\u0006#fM\u0006,H\u000e\u001e)be\u0006l7o\u0016:ji\u0006\u0014G.Z\u0001\u0004k&$W#\u0001 \u0011\u0005}BeB\u0001!G!\t\tE)D\u0001C\u0015\t\u0019U%\u0001\u0004=e>|GO\u0010\u0006\u0002\u000b\u0006)1oY1mC&\u0011q\tR\u0001\u0007!J,G-\u001a4\n\u0005%S%AB*ue&twM\u0003\u0002H\t\"\u001a\u0011\u0001\u0014*\u0011\u00055\u0003V\"\u0001(\u000b\u0005={\u0012AC1o]>$\u0018\r^5p]&\u0011\u0011K\u0014\u0002\u0006'&t7-Z\u0011\u0002'\u0006)1G\f\u0019/a\u0005!Q/\u001b3!Q\r\u0011AJU\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005aK\u0006C\u0001\u0015\u0001\u0011\u0015a4\u00011\u0001?Q\rIFJ\u0015\u0015\u0004\u00071\u0013F#\u0001-)\u0007\u0011a%+\u0001\u0006nKR\u0014\u0018n\u0019(b[\u0016,\u0012\u0001\u0019\t\u0004C\ntT\"A\u0018\n\u0005\r|#!\u0002)be\u0006l\u0007fA\u0003M%\u0006YQ.\u001a;sS\u000et\u0015-\\3!Q\r1AJU\u0001\u000eO\u0016$X*\u001a;sS\u000et\u0015-\\3)\u0007\u001da%+A\u0007tKRlU\r\u001e:jG:\u000bW.\u001a\u000b\u0003W2l\u0011\u0001\u0001\u0005\u0006[\"\u0001\rAP\u0001\u0006m\u0006dW/\u001a\u0015\u0004\u00111\u0013\u0016!A6\u0016\u0003E\u0004\"!\u0019:\n\u0005M|#\u0001C%oiB\u000b'/Y7)\u0007%a%+\u0001\u0002lA!\u001a!\u0002\u0014*\u0002\t\u001d,GoS\u000b\u0002sB\u0011!p_\u0007\u0002\t&\u0011A\u0010\u0012\u0002\u0004\u0013:$\bfA\u0006M%\u0006!1/\u001a;L)\rY\u0017\u0011\u0001\u0005\u0006[2\u0001\r!\u001f\u0015\u0004\u00191\u0013\u0016\u0001E:fiB\u0013X\rZ5di&|gnQ8m)\rY\u0017\u0011\u0002\u0005\u0006[6\u0001\rA\u0010\u0015\u0004\u001b1\u0013\u0016aC:fi2\u000b'-\u001a7D_2$2a[A\t\u0011\u0015ig\u00021\u0001?Q\rqAJU\u0001\tKZ\fG.^1uKR!\u0011\u0011DA\u0010!\rQ\u00181D\u0005\u0004\u0003;!%A\u0002#pk\ndW\rC\u0004\u0002\"=\u0001\r!a\t\u0002\u000f\u0011\fG/Y:fiB\"\u0011QEA\u001b!\u0019\t9#!\f\u000225\u0011\u0011\u0011\u0006\u0006\u0004\u0003Wy\u0012aA:rY&!\u0011qFA\u0015\u0005\u001d!\u0015\r^1tKR\u0004B!a\r\u000261\u0001A\u0001DA\u001c\u0003?\t\t\u0011!A\u0003\u0002\u0005e\"aA0%cE!\u00111HA!!\rQ\u0018QH\u0005\u0004\u0003\u007f!%a\u0002(pi\"Lgn\u001a\t\u0004u\u0006\r\u0013bAA#\t\n\u0019\u0011I\\=)\u0007=a%+\u0001\bjg2\u000b'oZ3s\u0005\u0016$H/\u001a:\u0016\u0005\u00055\u0003c\u0001>\u0002P%\u0019\u0011\u0011\u000b#\u0003\u000f\t{w\u000e\\3b]\"\u001a\u0001\u0003\u0014*\u0002\t\r|\u0007/\u001f\u000b\u00041\u0006e\u0003bBA.#\u0001\u0007\u0011QL\u0001\u0006Kb$(/\u0019\t\u0004C\u0006}\u0013bAA1_\tA\u0001+\u0019:b[6\u000b\u0007\u000fK\u0002\u0012\u0019J\u000b\u0001\u0002^8TiJLgn\u001a\u000b\u0002}!\u001a!\u0003\u0014*)\u0007\u0001a%\u000bK\u0002\u0001\u0003_\u00022!TA9\u0013\r\t\u0019H\u0014\u0002\r\u000bb\u0004XM]5nK:$\u0018\r\\\u0001\u0011%\u0006t7.\u001b8h\u000bZ\fG.^1u_J\u0004\"\u0001\u000b\u000b\u0014\u000fQ\tY(!!\u0002\bB\u0019!0! \n\u0007\u0005}DI\u0001\u0004B]f\u0014VM\u001a\t\u0005o\u0005\r\u0005,C\u0002\u0002\u0006b\u0012Q\u0003R3gCVdG\u000fU1sC6\u001c(+Z1eC\ndW\rE\u0002{\u0003\u0013K1!a#E\u00051\u0019VM]5bY&T\u0018M\u00197f)\t\t9(\u0001\u000btkB\u0004xN\u001d;fI6+GO]5d\u001d\u0006lWm]\u000b\u0003\u0003'\u0003RA_AK\u00033K1!a&E\u0005\u0015\t%O]1z!\u0011\tY*!*\u000e\u0005\u0005u%\u0002BAP\u0003C\u000bA\u0001\\1oO*\u0011\u00111U\u0001\u0005U\u00064\u0018-C\u0002J\u0003;\u000bQc];qa>\u0014H/\u001a3NKR\u0014\u0018n\u0019(b[\u0016\u001c\b%\u0001\u0003m_\u0006$Gc\u0001-\u0002.\"1\u0011q\u0016\rA\u0002y\nA\u0001]1uQ\"\u001a\u0001\u0004\u0014*\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0003o\u0003B!a'\u0002:&!\u00111XAO\u0005\u0019y%M[3di\"\u001aA\u0003\u0014*)\u0007Ma%\u000b")
public class RankingEvaluator
extends Evaluator
implements HasPredictionCol,
HasLabelCol,
DefaultParamsWritable {
    private final String uid;
    private final Param<String> metricName;
    private final IntParam k;
    private final Param<String> labelCol;
    private final Param<String> predictionCol;

    public static RankingEvaluator load(String string) {
        return RankingEvaluator$.MODULE$.load(string);
    }

    public static MLReader<RankingEvaluator> read() {
        return RankingEvaluator$.MODULE$.read();
    }

    @Override
    public MLWriter write() {
        return DefaultParamsWritable.write$(this);
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable.save$(this, path);
    }

    @Override
    public final String getLabelCol() {
        return HasLabelCol.getLabelCol$(this);
    }

    @Override
    public final String getPredictionCol() {
        return HasPredictionCol.getPredictionCol$(this);
    }

    @Override
    public final Param<String> labelCol() {
        return this.labelCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasLabelCol$_setter_$labelCol_$eq(Param<String> x$1) {
        this.labelCol = x$1;
    }

    @Override
    public final Param<String> predictionCol() {
        return this.predictionCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasPredictionCol$_setter_$predictionCol_$eq(Param<String> x$1) {
        this.predictionCol = x$1;
    }

    @Override
    public String uid() {
        return this.uid;
    }

    public final Param<String> metricName() {
        return this.metricName;
    }

    public String getMetricName() {
        return this.$(this.metricName());
    }

    public RankingEvaluator setMetricName(String value) {
        return (RankingEvaluator)this.set(this.metricName(), value);
    }

    public final IntParam k() {
        return this.k;
    }

    public int getK() {
        return BoxesRunTime.unboxToInt((Object)this.$(this.k()));
    }

    public RankingEvaluator setK(int value) {
        return (RankingEvaluator)this.set(this.k(), BoxesRunTime.boxToInteger((int)value));
    }

    public RankingEvaluator setPredictionCol(String value) {
        return (RankingEvaluator)this.set(this.predictionCol(), value);
    }

    public RankingEvaluator setLabelCol(String value) {
        return (RankingEvaluator)this.set(this.labelCol(), value);
    }

    @Override
    public double evaluate(Dataset<?> dataset) {
        double d;
        StructType schema = dataset.schema();
        SchemaUtils$.MODULE$.checkColumnTypes(schema, this.$(this.predictionCol()), (Seq<DataType>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ArrayType[]{new ArrayType((DataType)DoubleType$.MODULE$, false), new ArrayType((DataType)DoubleType$.MODULE$, true)}))), SchemaUtils$.MODULE$.checkColumnTypes$default$4());
        SchemaUtils$.MODULE$.checkColumnTypes(schema, this.$(this.labelCol()), (Seq<DataType>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ArrayType[]{new ArrayType((DataType)DoubleType$.MODULE$, false), new ArrayType((DataType)DoubleType$.MODULE$, true)}))), SchemaUtils$.MODULE$.checkColumnTypes$default$4());
        RDD predictionAndLabels = dataset.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.predictionCol())), functions$.MODULE$.col(this.$(this.labelCol()))})).rdd().map((Function1 & Serializable & scala.Serializable)row -> new Tuple2(row.getSeq(0).toArray(ClassTag$.MODULE$.Double()), row.getSeq(1).toArray(ClassTag$.MODULE$.Double())), ClassTag$.MODULE$.apply(Tuple2.class));
        RankingMetrics metrics = new RankingMetrics((RDD<Tuple2<Object, Object>>)predictionAndLabels, ClassTag$.MODULE$.Double());
        String string = this.$(this.metricName());
        if ("meanAveragePrecision".equals(string)) {
            d = metrics.meanAveragePrecision();
        } else if ("meanAveragePrecisionAtK".equals(string)) {
            d = metrics.meanAveragePrecisionAt(BoxesRunTime.unboxToInt((Object)this.$(this.k())));
        } else if ("precisionAtK".equals(string)) {
            d = metrics.precisionAt(BoxesRunTime.unboxToInt((Object)this.$(this.k())));
        } else if ("ndcgAtK".equals(string)) {
            d = metrics.ndcgAt(BoxesRunTime.unboxToInt((Object)this.$(this.k())));
        } else if ("recallAtK".equals(string)) {
            d = metrics.recallAt(BoxesRunTime.unboxToInt((Object)this.$(this.k())));
        } else {
            throw new MatchError((Object)string);
        }
        return d;
    }

    @Override
    public boolean isLargerBetter() {
        return true;
    }

    @Override
    public RankingEvaluator copy(ParamMap extra) {
        return (RankingEvaluator)this.defaultCopy(extra);
    }

    @Override
    public String toString() {
        return new StringBuilder(39).append("RankingEvaluator: uid=").append(this.uid()).append(", metricName=").append((Object)this.$(this.metricName())).append(", k=").append(this.$(this.k())).toString();
    }

    public RankingEvaluator(String uid) {
        this.uid = uid;
        HasPredictionCol.$init$(this);
        HasLabelCol.$init$(this);
        MLWritable.$init$(this);
        DefaultParamsWritable.$init$(this);
        Function1 allowedParams = ParamValidators$.MODULE$.inArray(RankingEvaluator$.MODULE$.org$apache$spark$ml$evaluation$RankingEvaluator$$supportedMetricNames());
        this.metricName = new Param(this, "metricName", new StringBuilder(26).append("metric name in evaluation ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])RankingEvaluator$.MODULE$.org$apache$spark$ml$evaluation$RankingEvaluator$$supportedMetricNames())).mkString("(", "|", ")")).toString(), allowedParams);
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.metricName().$minus$greater("meanAveragePrecision")}));
        this.k = new IntParam((Identifiable)this, "k", new StringBuilder(74).append("The ranking position value used in ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])RankingEvaluator$.MODULE$.org$apache$spark$ml$evaluation$RankingEvaluator$$supportedMetricNames())).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.endsWith("AtK"))))).mkString("(", "|", ")")).append("  ").append("Must be > 0. The default value is 10.").toString(), (Function1<Object, Object>)ParamValidators$.MODULE$.gt(0.0));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.k().$minus$greater(BoxesRunTime.boxToInteger((int)10))}));
    }

    public RankingEvaluator() {
        this(Identifiable$.MODULE$.randomUID("rankEval"));
    }
}

