/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.evaluation;

import java.io.IOException;
import java.io.Serializable;
import org.apache.spark.annotation.Experimental;
import org.apache.spark.ml.evaluation.Evaluator;
import org.apache.spark.ml.evaluation.MultilabelClassificationEvaluator$;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.ParamPair;
import org.apache.spark.ml.param.ParamValidators$;
import org.apache.spark.ml.param.shared.HasLabelCol;
import org.apache.spark.ml.param.shared.HasPredictionCol;
import org.apache.spark.ml.util.DefaultParamsWritable;
import org.apache.spark.ml.util.Identifiable;
import org.apache.spark.ml.util.Identifiable$;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.ml.util.SchemaUtils$;
import org.apache.spark.mllib.evaluation.MultilabelMetrics;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.StructType;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Experimental
@ScalaSignature(bytes="\u0006\u0001\u0005Uf\u0001\u0002\u000e\u001c\u0001\u0019B\u0001\u0002\u0010\u0001\u0003\u0006\u0004%\t%\u0010\u0005\t)\u0002\u0011\t\u0011)A\u0005}!)a\u000b\u0001C\u0001/\")a\u000b\u0001C\u00019\"9a\f\u0001b\u0001\n\u000by\u0006BB3\u0001A\u00035\u0001\rC\u0003h\u0001\u0011\u0005Q\bC\u0003j\u0001\u0011\u0005!\u000eC\u0004p\u0001\t\u0007IQ\u00019\t\rU\u0004\u0001\u0015!\u0004r\u0011\u00159\b\u0001\"\u0001y\u0011\u0015q\b\u0001\"\u0001\u0000\u0011\u001d\t\u0019\u0001\u0001C\u0001\u0003\u000bAq!a\u0003\u0001\t\u0003\ti\u0001C\u0004\u0002\u0014\u0001!\t%!\u0006\t\u000f\u0005\u0005\u0003\u0001\"\u0011\u0002D!9\u0011Q\n\u0001\u0005B\u0005=\u0003bBA/\u0001\u0011\u0005\u0013qL\u0004\b\u0003[Z\u0002\u0012AA8\r\u0019Q2\u0004#\u0001\u0002r!1a\u000b\u0006C\u0001\u0003\u000bC\u0011\"a\"\u0015\u0005\u0004%I!!#\t\u0011\u0005EE\u0003)A\u0005\u0003\u0017Cq!a%\u0015\t\u0003\n)\nC\u0005\u0002\u001eR\t\t\u0011\"\u0003\u0002 \n\tS*\u001e7uS2\f'-\u001a7DY\u0006\u001c8/\u001b4jG\u0006$\u0018n\u001c8Fm\u0006dW/\u0019;pe*\u0011A$H\u0001\u000bKZ\fG.^1uS>t'B\u0001\u0010 \u0003\tiGN\u0003\u0002!C\u0005)1\u000f]1sW*\u0011!eI\u0001\u0007CB\f7\r[3\u000b\u0003\u0011\n1a\u001c:h\u0007\u0001\u0019R\u0001A\u0014,gY\u0002\"\u0001K\u0015\u000e\u0003mI!AK\u000e\u0003\u0013\u00153\u0018\r\\;bi>\u0014\bC\u0001\u00172\u001b\u0005i#B\u0001\u00180\u0003\u0019\u0019\b.\u0019:fI*\u0011\u0001'H\u0001\u0006a\u0006\u0014\u0018-\\\u0005\u0003e5\u0012\u0001\u0003S1t!J,G-[2uS>t7i\u001c7\u0011\u00051\"\u0014BA\u001b.\u0005-A\u0015m\u001d'bE\u0016d7i\u001c7\u0011\u0005]RT\"\u0001\u001d\u000b\u0005ej\u0012\u0001B;uS2L!a\u000f\u001d\u0003+\u0011+g-Y;miB\u000b'/Y7t/JLG/\u00192mK\u0006\u0019Q/\u001b3\u0016\u0003y\u0002\"a\u0010%\u000f\u0005\u00013\u0005CA!E\u001b\u0005\u0011%BA\"&\u0003\u0019a$o\\8u})\tQ)A\u0003tG\u0006d\u0017-\u0003\u0002H\t\u00061\u0001K]3eK\u001aL!!\u0013&\u0003\rM#(/\u001b8h\u0015\t9E\tK\u0002\u0002\u0019J\u0003\"!\u0014)\u000e\u00039S!aT\u0010\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002R\u001d\n)1+\u001b8dK\u0006\n1+A\u00034]Ar\u0003'\u0001\u0003vS\u0012\u0004\u0003f\u0001\u0002M%\u00061A(\u001b8jiz\"\"\u0001W-\u0011\u0005!\u0002\u0001\"\u0002\u001f\u0004\u0001\u0004q\u0004fA-M%\"\u001a1\u0001\u0014*\u0015\u0003aC3\u0001\u0002'S\u0003)iW\r\u001e:jG:\u000bW.Z\u000b\u0002AB\u0019\u0011M\u0019 \u000e\u0003=J!aY\u0018\u0003\u000bA\u000b'/Y7)\u0007\u0015a%+A\u0006nKR\u0014\u0018n\u0019(b[\u0016\u0004\u0003f\u0001\u0004M%\u0006iq-\u001a;NKR\u0014\u0018n\u0019(b[\u0016D3a\u0002'S\u00035\u0019X\r^'fiJL7MT1nKR\u00111\u000e\\\u0007\u0002\u0001!)Q\u000e\u0003a\u0001}\u0005)a/\u00197vK\"\u001a\u0001\u0002\u0014*\u0002\u00175,GO]5d\u0019\u0006\u0014W\r\\\u000b\u0002cB\u0011\u0011M]\u0005\u0003g>\u00121\u0002R8vE2,\u0007+\u0019:b[\"\u001a\u0011\u0002\u0014*\u0002\u00195,GO]5d\u0019\u0006\u0014W\r\u001c\u0011)\u0007)a%+\u0001\bhKRlU\r\u001e:jG2\u000b'-\u001a7\u0016\u0003e\u0004\"A_>\u000e\u0003\u0011K!\u0001 #\u0003\r\u0011{WO\u00197fQ\rYAJU\u0001\u000fg\u0016$X*\u001a;sS\u000ed\u0015MY3m)\rY\u0017\u0011\u0001\u0005\u0006[2\u0001\r!_\u0001\u0011g\u0016$\bK]3eS\u000e$\u0018n\u001c8D_2$2a[A\u0004\u0011\u0015iW\u00021\u0001?Q\riAJU\u0001\fg\u0016$H*\u00192fY\u000e{G\u000eF\u0002l\u0003\u001fAQ!\u001c\bA\u0002yB3A\u0004'S\u0003!)g/\u00197vCR,GcA=\u0002\u0018!9\u0011\u0011D\bA\u0002\u0005m\u0011a\u00023bi\u0006\u001cX\r\u001e\u0019\u0005\u0003;\ti\u0003\u0005\u0004\u0002 \u0005\u0015\u0012\u0011F\u0007\u0003\u0003CQ1!a\t \u0003\r\u0019\u0018\u000f\\\u0005\u0005\u0003O\t\tCA\u0004ECR\f7/\u001a;\u0011\t\u0005-\u0012Q\u0006\u0007\u0001\t1\ty#a\u0006\u0002\u0002\u0003\u0005)\u0011AA\u0019\u0005\ryF%M\t\u0005\u0003g\tI\u0004E\u0002{\u0003kI1!a\u000eE\u0005\u001dqu\u000e\u001e5j]\u001e\u00042A_A\u001e\u0013\r\ti\u0004\u0012\u0002\u0004\u0003:L\bfA\bM%\u0006q\u0011n\u001d'be\u001e,'OQ3ui\u0016\u0014XCAA#!\rQ\u0018qI\u0005\u0004\u0003\u0013\"%a\u0002\"p_2,\u0017M\u001c\u0015\u0004!1\u0013\u0016\u0001B2paf$2\u0001WA)\u0011\u001d\t\u0019&\u0005a\u0001\u0003+\nQ!\u001a=ue\u0006\u00042!YA,\u0013\r\tIf\f\u0002\t!\u0006\u0014\u0018-\\'ba\"\u001a\u0011\u0003\u0014*\u0002\u0011Q|7\u000b\u001e:j]\u001e$\u0012A\u0010\u0015\u0004%1\u0013\u0006f\u0001\u0001\u0002fA\u0019Q*a\u001a\n\u0007\u0005%dJ\u0001\u0007FqB,'/[7f]R\fG\u000eK\u0002\u0001\u0019J\u000b\u0011%T;mi&d\u0017MY3m\u00072\f7o]5gS\u000e\fG/[8o\u000bZ\fG.^1u_J\u0004\"\u0001\u000b\u000b\u0014\u000fQ\t\u0019(!\u001f\u0002\u0000A\u0019!0!\u001e\n\u0007\u0005]DI\u0001\u0004B]f\u0014VM\u001a\t\u0005o\u0005m\u0004,C\u0002\u0002~a\u0012Q\u0003R3gCVdG\u000fU1sC6\u001c(+Z1eC\ndW\rE\u0002{\u0003\u0003K1!a!E\u00051\u0019VM]5bY&T\u0018M\u00197f)\t\ty'\u0001\u000btkB\u0004xN\u001d;fI6+GO]5d\u001d\u0006lWm]\u000b\u0003\u0003\u0017\u0003BA_AG}%\u0019\u0011q\u0012#\u0003\u000b\u0005\u0013(/Y=\u0002+M,\b\u000f]8si\u0016$W*\u001a;sS\u000et\u0015-\\3tA\u0005!An\\1e)\rA\u0016q\u0013\u0005\u0007\u00033C\u0002\u0019\u0001 \u0002\tA\fG\u000f\u001b\u0015\u000411\u0013\u0016a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"!!)\u0011\t\u0005\r\u0016QV\u0007\u0003\u0003KSA!a*\u0002*\u0006!A.\u00198h\u0015\t\tY+\u0001\u0003kCZ\f\u0017\u0002BAX\u0003K\u0013aa\u00142kK\u000e$\bf\u0001\u000bM%\"\u001a1\u0003\u0014*")
public class MultilabelClassificationEvaluator
extends Evaluator
implements HasPredictionCol,
HasLabelCol,
DefaultParamsWritable {
    private final String uid;
    private final Param<String> metricName;
    private final DoubleParam metricLabel;
    private final Param<String> labelCol;
    private final Param<String> predictionCol;

    public static MultilabelClassificationEvaluator load(String string) {
        return MultilabelClassificationEvaluator$.MODULE$.load(string);
    }

    public static MLReader<MultilabelClassificationEvaluator> read() {
        return MultilabelClassificationEvaluator$.MODULE$.read();
    }

    @Override
    public MLWriter write() {
        return DefaultParamsWritable.write$(this);
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable.save$(this, path);
    }

    @Override
    public final String getLabelCol() {
        return HasLabelCol.getLabelCol$(this);
    }

    @Override
    public final String getPredictionCol() {
        return HasPredictionCol.getPredictionCol$(this);
    }

    @Override
    public final Param<String> labelCol() {
        return this.labelCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasLabelCol$_setter_$labelCol_$eq(Param<String> x$1) {
        this.labelCol = x$1;
    }

    @Override
    public final Param<String> predictionCol() {
        return this.predictionCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasPredictionCol$_setter_$predictionCol_$eq(Param<String> x$1) {
        this.predictionCol = x$1;
    }

    @Override
    public String uid() {
        return this.uid;
    }

    public final Param<String> metricName() {
        return this.metricName;
    }

    public String getMetricName() {
        return this.$(this.metricName());
    }

    public MultilabelClassificationEvaluator setMetricName(String value) {
        return (MultilabelClassificationEvaluator)this.set(this.metricName(), value);
    }

    public final DoubleParam metricLabel() {
        return this.metricLabel;
    }

    public double getMetricLabel() {
        return BoxesRunTime.unboxToDouble((Object)this.$(this.metricLabel()));
    }

    public MultilabelClassificationEvaluator setMetricLabel(double value) {
        return (MultilabelClassificationEvaluator)this.set(this.metricLabel(), BoxesRunTime.boxToDouble((double)value));
    }

    public MultilabelClassificationEvaluator setPredictionCol(String value) {
        return (MultilabelClassificationEvaluator)this.set(this.predictionCol(), value);
    }

    public MultilabelClassificationEvaluator setLabelCol(String value) {
        return (MultilabelClassificationEvaluator)this.set(this.labelCol(), value);
    }

    @Override
    public double evaluate(Dataset<?> dataset) {
        double d;
        StructType schema = dataset.schema();
        SchemaUtils$.MODULE$.checkColumnTypes(schema, this.$(this.predictionCol()), (Seq<DataType>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ArrayType[]{new ArrayType((DataType)DoubleType$.MODULE$, false), new ArrayType((DataType)DoubleType$.MODULE$, true)}))), SchemaUtils$.MODULE$.checkColumnTypes$default$4());
        SchemaUtils$.MODULE$.checkColumnTypes(schema, this.$(this.labelCol()), (Seq<DataType>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ArrayType[]{new ArrayType((DataType)DoubleType$.MODULE$, false), new ArrayType((DataType)DoubleType$.MODULE$, true)}))), SchemaUtils$.MODULE$.checkColumnTypes$default$4());
        RDD predictionAndLabels = dataset.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.predictionCol())), functions$.MODULE$.col(this.$(this.labelCol()))})).rdd().map((Function1 & Serializable & scala.Serializable)row -> new Tuple2(row.getSeq(0).toArray(ClassTag$.MODULE$.Double()), row.getSeq(1).toArray(ClassTag$.MODULE$.Double())), ClassTag$.MODULE$.apply(Tuple2.class));
        MultilabelMetrics metrics = new MultilabelMetrics((RDD<Tuple2<double[], double[]>>)predictionAndLabels);
        String string = this.$(this.metricName());
        if ("subsetAccuracy".equals(string)) {
            d = metrics.subsetAccuracy();
        } else if ("accuracy".equals(string)) {
            d = metrics.accuracy();
        } else if ("hammingLoss".equals(string)) {
            d = metrics.hammingLoss();
        } else if ("precision".equals(string)) {
            d = metrics.precision();
        } else if ("recall".equals(string)) {
            d = metrics.recall();
        } else if ("f1Measure".equals(string)) {
            d = metrics.f1Measure();
        } else if ("precisionByLabel".equals(string)) {
            d = metrics.precision(BoxesRunTime.unboxToDouble((Object)this.$(this.metricLabel())));
        } else if ("recallByLabel".equals(string)) {
            d = metrics.recall(BoxesRunTime.unboxToDouble((Object)this.$(this.metricLabel())));
        } else if ("f1MeasureByLabel".equals(string)) {
            d = metrics.f1Measure(BoxesRunTime.unboxToDouble((Object)this.$(this.metricLabel())));
        } else if ("microPrecision".equals(string)) {
            d = metrics.microPrecision();
        } else if ("microRecall".equals(string)) {
            d = metrics.microRecall();
        } else if ("microF1Measure".equals(string)) {
            d = metrics.microF1Measure();
        } else {
            throw new MatchError((Object)string);
        }
        return d;
    }

    @Override
    public boolean isLargerBetter() {
        String string = this.$(this.metricName());
        boolean bl = !"hammingLoss".equals(string);
        return bl;
    }

    @Override
    public MultilabelClassificationEvaluator copy(ParamMap extra) {
        return (MultilabelClassificationEvaluator)this.defaultCopy(extra);
    }

    @Override
    public String toString() {
        return new StringBuilder(66).append("MultilabelClassificationEvaluator: uid=").append(this.uid()).append(", metricName=").append((Object)this.$(this.metricName())).append(", ").append("metricLabel=").append(this.$(this.metricLabel())).toString();
    }

    public MultilabelClassificationEvaluator(String uid) {
        this.uid = uid;
        HasPredictionCol.$init$(this);
        HasLabelCol.$init$(this);
        MLWritable.$init$(this);
        DefaultParamsWritable.$init$(this);
        Function1 allowedParams = ParamValidators$.MODULE$.inArray(MultilabelClassificationEvaluator$.MODULE$.org$apache$spark$ml$evaluation$MultilabelClassificationEvaluator$$supportedMetricNames());
        this.metricName = new Param(this, "metricName", new StringBuilder(26).append("metric name in evaluation ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])MultilabelClassificationEvaluator$.MODULE$.org$apache$spark$ml$evaluation$MultilabelClassificationEvaluator$$supportedMetricNames())).mkString("(", "|", ")")).toString(), allowedParams);
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.metricName().$minus$greater("f1Measure")}));
        this.metricLabel = new DoubleParam((Identifiable)this, "metricLabel", new StringBuilder(82).append("The class whose metric will be computed in ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])MultilabelClassificationEvaluator$.MODULE$.org$apache$spark$ml$evaluation$MultilabelClassificationEvaluator$$supportedMetricNames())).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.endsWith("ByLabel"))))).mkString("(", "|", ")")).append(". ").append("Must be >= 0. The default value is 0.").toString(), (Function1<Object, Object>)ParamValidators$.MODULE$.gtEq(0.0));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.metricLabel().$minus$greater(BoxesRunTime.boxToDouble((double)0.0))}));
    }

    public MultilabelClassificationEvaluator() {
        this(Identifiable$.MODULE$.randomUID("mlcEval"));
    }
}

