/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.classification;

import java.io.IOException;
import java.io.Serializable;
import org.apache.hadoop.fs.Path;
import org.apache.spark.ml.classification.NaiveBayes$;
import org.apache.spark.ml.classification.NaiveBayesModel$;
import org.apache.spark.ml.classification.NaiveBayesModel$NaiveBayesModelWriter$;
import org.apache.spark.ml.classification.NaiveBayesModel$NaiveBayesModelWriter$Data$;
import org.apache.spark.ml.classification.NaiveBayesParams;
import org.apache.spark.ml.classification.ProbabilisticClassificationModel;
import org.apache.spark.ml.linalg.BLAS$;
import org.apache.spark.ml.linalg.DenseVector;
import org.apache.spark.ml.linalg.Matrices$;
import org.apache.spark.ml.linalg.Matrix;
import org.apache.spark.ml.linalg.SparseVector;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.shared.HasWeightCol;
import org.apache.spark.ml.util.DefaultParamsReader;
import org.apache.spark.ml.util.DefaultParamsReader$;
import org.apache.spark.ml.util.DefaultParamsWriter$;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.mllib.util.MLUtils$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.util.VersionUtils$;
import org.json4s.DefaultFormats$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\r-b\u0001B%K\u0001UC\u0001B\u001b\u0001\u0003\u0006\u0004%\te\u001b\u0005\n\u0003\u000b\u0001!\u0011!Q\u0001\n1D!\"!\u0003\u0001\u0005\u000b\u0007I\u0011AA\u0006\u0011%\t\u0019\u0002\u0001B\u0001B\u0003%!\f\u0003\u0006\u0002\u0018\u0001\u0011)\u0019!C\u0001\u00033A!\"a\t\u0001\u0005\u0003\u0005\u000b\u0011BA\u000e\u0011)\t9\u0003\u0001BC\u0002\u0013\u0005\u0011\u0011\u0004\u0005\u000b\u0003_\u0001!\u0011!Q\u0001\n\u0005m\u0001\u0002CA\u001a\u0001\u0011\u0005A*!\u000e\t\u0015\u0005\u001d\u0003\u00011A\u0005\u00029\u000bI\u0005\u0003\u0006\u0002Z\u0001\u0001\r\u0011\"\u0001O\u00037B\u0001\"a\u001a\u0001A\u0003&\u00111\n\u0005\t\u0003S\u0002A\u0011\u0001(\u0002l!a\u00111\u000f\u0001\u0011\u0002#\u001d\r\u0015\"\u0003\u0002v!Q\u00111\u0011\u0001\t\u0006\u0004%I!!\u0007\t\u0015\u00055\u0005\u0001#b\u0001\n\u0013\ty\t\u0003\u0006\u0002\u0014\u0002A)\u0019!C\u0005\u0003\u0013B\u0011\"a&\u0001\u0005\u0004%\t%!'\t\u0011\u0005\u001d\u0006\u0001)A\u0005\u00037C\u0011\"a+\u0001\u0005\u0004%\t%!'\t\u0011\u0005=\u0006\u0001)A\u0005\u00037Cq!a-\u0001\t\u0013\t)\fC\u0004\u0002<\u0002!I!!0\t\u000f\u0005\u0005\u0007\u0001\"\u0003\u0002D\"9\u0011q\u0019\u0001\u0005\n\u0005%\u0007BCAg\u0001!\u0015\r\u0011\"\u0003\u0002P\"9\u0011\u0011\u001c\u0001\u0005B\u0005m\u0007bBAq\u0001\u0011E\u00131\u001d\u0005\b\u0003S\u0004A\u0011IAv\u0011\u001d\ty\u0010\u0001C!\u0005\u0003AqA!\u0002\u0001\t\u0003\u00129aB\u0004\u0003\u0014)C\tA!\u0006\u0007\r%S\u0005\u0012\u0001B\f\u0011\u001d\t\u0019$\tC\u0001\u0005WAqA!\f\"\t\u0003\u0012y\u0003C\u0004\u0003:\u0005\"\tEa\u000f\u0007\u000f\t\r\u0013\u0005A\u0011\u0003F!I!qI\u0013\u0003\u0002\u0003\u0006I\u0001\u0019\u0005\b\u0003g)C\u0011\u0001B%\r\u0019\u0011\t&\n#\u0003T!Q\u0011\u0011\u0002\u0015\u0003\u0016\u0004%\t!a\u0003\t\u0013\u0005M\u0001F!E!\u0002\u0013Q\u0006BCA\fQ\tU\r\u0011\"\u0001\u0002\u001a!Q\u00111\u0005\u0015\u0003\u0012\u0003\u0006I!a\u0007\t\u0015\u0005\u001d\u0002F!f\u0001\n\u0003\tI\u0002\u0003\u0006\u00020!\u0012\t\u0012)A\u0005\u00037Aq!a\r)\t\u0003\u0011Y\u0006C\u0005\u0002j\"\n\t\u0011\"\u0001\u0003h!I!q\u000e\u0015\u0012\u0002\u0013\u0005!\u0011\u000f\u0005\n\u0005\u000bC\u0013\u0013!C\u0001\u0005\u000fC\u0011Ba#)#\u0003%\tAa\"\t\u0013\t5\u0005&!A\u0005B\t=\u0005\"\u0003BPQ\u0005\u0005I\u0011AAM\u0011%\u0011\t\u000bKA\u0001\n\u0003\u0011\u0019\u000bC\u0005\u0003.\"\n\t\u0011\"\u0011\u00030\"I!Q\u0018\u0015\u0002\u0002\u0013\u0005!q\u0018\u0005\n\u0005\u0013D\u0013\u0011!C!\u0005\u0017D\u0011\"a@)\u0003\u0003%\tE!4\t\u0013\t=\u0007&!A\u0005B\tEw!\u0003BkK\u0005\u0005\t\u0012\u0002Bl\r%\u0011\t&JA\u0001\u0012\u0013\u0011I\u000eC\u0004\u00024u\"\tAa:\t\u0013\u0005}X(!A\u0005F\t5\u0007\"\u0003Bu{\u0005\u0005I\u0011\u0011Bv\u0011%\u0011\u00190PA\u0001\n\u0003\u0013)\u0010C\u0004\u0004\b\u0015\"\tf!\u0003\u0007\r\r5\u0011\u0005BB\b\u0011\u001d\t\u0019d\u0011C\u0001\u0007#A\u0011b!\u0006D\u0005\u0004%IAa$\t\u0011\r]1\t)A\u0005\u0005#CqA!\u000fD\t\u0003\u001aI\u0002C\u0005\u0004\u001e\u0005\n\t\u0011\"\u0003\u0004 \tya*Y5wK\n\u000b\u00170Z:N_\u0012,GN\u0003\u0002L\u0019\u0006q1\r\\1tg&4\u0017nY1uS>t'BA'O\u0003\tiGN\u0003\u0002P!\u0006)1\u000f]1sW*\u0011\u0011KU\u0001\u0007CB\f7\r[3\u000b\u0003M\u000b1a\u001c:h\u0007\u0001\u0019B\u0001\u0001,bIB!q\u000b\u0017.a\u001b\u0005Q\u0015BA-K\u0005\u0001\u0002&o\u001c2bE&d\u0017n\u001d;jG\u000ec\u0017m]:jM&\u001c\u0017\r^5p]6{G-\u001a7\u0011\u0005msV\"\u0001/\u000b\u0005uc\u0015A\u00027j]\u0006dw-\u0003\u0002`9\n1a+Z2u_J\u0004\"a\u0016\u0001\u0011\u0005]\u0013\u0017BA2K\u0005Aq\u0015-\u001b<f\u0005\u0006LXm\u001d)be\u0006l7\u000f\u0005\u0002fQ6\taM\u0003\u0002h\u0019\u0006!Q\u000f^5m\u0013\tIgM\u0001\u0006N\u0019^\u0013\u0018\u000e^1cY\u0016\f1!^5e+\u0005a\u0007CA7w\u001d\tqG\u000f\u0005\u0002pe6\t\u0001O\u0003\u0002r)\u00061AH]8pizR\u0011a]\u0001\u0006g\u000e\fG.Y\u0005\u0003kJ\fa\u0001\u0015:fI\u00164\u0017BA<y\u0005\u0019\u0019FO]5oO*\u0011QO\u001d\u0015\u0005\u0003i\f\t\u0001\u0005\u0002|}6\tAP\u0003\u0002~\u001d\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u0005}d(!B*j]\u000e,\u0017EAA\u0002\u0003\u0015\td&\u000e\u00181\u0003\u0011)\u0018\u000e\u001a\u0011)\t\tQ\u0018\u0011A\u0001\u0003a&,\u0012A\u0017\u0015\u0005\u0007i\fy!\t\u0002\u0002\u0012\u0005)!G\f\u0019/a\u0005\u0019\u0001/\u001b\u0011)\t\u0011Q\u0018qB\u0001\u0006i\",G/Y\u000b\u0003\u00037\u00012aWA\u000f\u0013\r\ty\u0002\u0018\u0002\u0007\u001b\u0006$(/\u001b=)\t\u0015Q\u0018qB\u0001\u0007i\",G/\u0019\u0011)\t\u0019Q\u0018qB\u0001\u0006g&<W.\u0019\u0015\u0005\u000fi\fY#\t\u0002\u0002.\u0005)1G\f\u0019/a\u000511/[4nC\u0002BC\u0001\u0003>\u0002,\u00051A(\u001b8jiz\"\u0012\u0002YA\u001c\u0003w\ty$a\u0011\t\u000b)L\u0001\u0019\u00017)\u000b\u0005]\"0!\u0001\t\r\u0005%\u0011\u00021\u0001[Q\u0015\tYD_A\b\u0011\u001d\t9\"\u0003a\u0001\u00037AS!a\u0010{\u0003\u001fAq!a\n\n\u0001\u0004\tY\u0002K\u0003\u0002Di\fY#A\u0005pY\u0012d\u0015MY3mgV\u0011\u00111\n\t\u0007\u0003\u001b\ny%a\u0015\u000e\u0003IL1!!\u0015s\u0005\u0015\t%O]1z!\u0011\ti%!\u0016\n\u0007\u0005]#O\u0001\u0004E_V\u0014G.Z\u0001\u000e_2$G*\u00192fYN|F%Z9\u0015\t\u0005u\u00131\r\t\u0005\u0003\u001b\ny&C\u0002\u0002bI\u0014A!\u00168ji\"I\u0011QM\u0006\u0002\u0002\u0003\u0007\u00111J\u0001\u0004q\u0012\n\u0014AC8mI2\u000b'-\u001a7tA\u0005a1/\u001a;PY\u0012d\u0015MY3mgR!\u0011QNA8\u001b\u0005\u0001\u0001bBA9\u001b\u0001\u0007\u00111J\u0001\u0007Y\u0006\u0014W\r\\:\u0002\u0007a$\u0003(\u0006\u0002\u0002xAA\u0011QJA=\u00037\ti(C\u0002\u0002|I\u0014a\u0001V;qY\u0016\u0014\u0004cA.\u0002\u0000%\u0019\u0011\u0011\u0011/\u0003\u0017\u0011+gn]3WK\u000e$xN]\u0001\u0013i\",G/Y'j]V\u001ch*Z4UQ\u0016$\u0018\rK\u0002\u0010\u0003\u000f\u0003B!!\u0014\u0002\n&\u0019\u00111\u0012:\u0003\u0013Q\u0014\u0018M\\:jK:$\u0018a\u00049j\u001b&tWo\u001d+iKR\f7+^7\u0016\u0005\u0005u\u0004f\u0001\t\u0002\b\u0006IAn\\4WCJ\u001cV/\u001c\u0015\u0004#\u0005\u001d\u0015a\u00038v[\u001a+\u0017\r^;sKN,\"!a'\u0011\t\u00055\u0013QT\u0005\u0004\u0003?\u0013(aA%oi\"\"!C_ARC\t\t)+A\u00032]Yr\u0003'\u0001\u0007ok64U-\u0019;ve\u0016\u001c\b\u0005\u000b\u0003\u0014u\u0006\r\u0016A\u00038v[\u000ec\u0017m]:fg\"\"AC_A\u0001\u0003-qW/\\\"mCN\u001cXm\u001d\u0011)\tUQ\u0018\u0011A\u0001\u0017[VdG/\u001b8p[&\fGnQ1mGVd\u0017\r^5p]R!\u0011QPA\\\u0011\u0019\tIL\u0006a\u00015\u0006Aa-Z1ukJ,7/A\u000bd_6\u0004H.Z7f]R\u001c\u0015\r\\2vY\u0006$\u0018n\u001c8\u0015\u0007i\u000by\f\u0003\u0004\u0002:^\u0001\rAW\u0001\u0015E\u0016\u0014hn\\;mY&\u001c\u0015\r\\2vY\u0006$\u0018n\u001c8\u0015\t\u0005u\u0014Q\u0019\u0005\u0007\u0003sC\u0002\u0019\u0001.\u0002'\u001d\fWo]:jC:\u001c\u0015\r\\2vY\u0006$\u0018n\u001c8\u0015\u0007i\u000bY\r\u0003\u0004\u0002:f\u0001\rAW\u0001\u000faJ,G-[2u%\u0006<h)\u001e8d+\t\t\t\u000e\u0005\u0004\u0002N\u0005M'LW\u0005\u0004\u0003+\u0014(!\u0003$v]\u000e$\u0018n\u001c82Q\rQ\u0012qQ\u0001\u000baJ,G-[2u%\u0006<Hc\u0001.\u0002^\"1\u0011\u0011X\u000eA\u0002iCCa\u0007>\u0002,\u00051\"/Y<3aJ|'-\u00192jY&$\u00180\u00138QY\u0006\u001cW\rF\u0002[\u0003KDa!a:\u001d\u0001\u0004Q\u0016!\u0004:boB\u0013X\rZ5di&|g.\u0001\u0003d_BLHc\u00011\u0002n\"9\u0011q^\u000fA\u0002\u0005E\u0018!B3yiJ\f\u0007\u0003BAz\u0003sl!!!>\u000b\u0007\u0005]H*A\u0003qCJ\fW.\u0003\u0003\u0002|\u0006U(\u0001\u0003)be\u0006lW*\u00199)\tuQ\u0018\u0011A\u0001\ti>\u001cFO]5oOR\tA\u000e\u000b\u0003\u001fu\u0006\u0005\u0011!B<sSR,WC\u0001B\u0005!\r)'1B\u0005\u0004\u0005\u001b1'\u0001C'M/JLG/\u001a:)\t}Q\u00181\u0015\u0015\u0005\u0001i\f\t!A\bOC&4XMQ1zKNlu\u000eZ3m!\t9\u0016eE\u0004\"\u00053\u0011yB!\n\u0011\t\u00055#1D\u0005\u0004\u0005;\u0011(AB!osJ+g\r\u0005\u0003f\u0005C\u0001\u0017b\u0001B\u0012M\nQQ\n\u0014*fC\u0012\f'\r\\3\u0011\t\u00055#qE\u0005\u0004\u0005S\u0011(\u0001D*fe&\fG.\u001b>bE2,GC\u0001B\u000b\u0003\u0011\u0011X-\u00193\u0016\u0005\tE\u0002\u0003B3\u00034\u0001L1A!\u000eg\u0005!iEJU3bI\u0016\u0014\b\u0006B\u0012{\u0003G\u000bA\u0001\\8bIR\u0019\u0001M!\u0010\t\r\t}B\u00051\u0001m\u0003\u0011\u0001\u0018\r\u001e5)\t\u0011R\u00181\u0015\u0002\u0016\u001d\u0006Lg/\u001a\"bs\u0016\u001cXj\u001c3fY^\u0013\u0018\u000e^3s'\r)#\u0011B\u0001\tS:\u001cH/\u00198dKR!!1\nB(!\r\u0011i%J\u0007\u0002C!1!qI\u0014A\u0002\u0001\u0014A\u0001R1uCN9\u0001F!\u0007\u0003V\t\u0015\u0002\u0003BA'\u0005/J1A!\u0017s\u0005\u001d\u0001&o\u001c3vGR$\u0002B!\u0018\u0003b\t\r$Q\r\t\u0004\u0005?BS\"A\u0013\t\r\u0005%q\u00061\u0001[\u0011\u001d\t9b\fa\u0001\u00037Aq!a\n0\u0001\u0004\tY\u0002\u0006\u0005\u0003^\t%$1\u000eB7\u0011!\tI\u0001\rI\u0001\u0002\u0004Q\u0006\"CA\faA\u0005\t\u0019AA\u000e\u0011%\t9\u0003\rI\u0001\u0002\u0004\tY\"\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\tM$f\u0001.\u0003v-\u0012!q\u000f\t\u0005\u0005s\u0012\t)\u0004\u0002\u0003|)!!Q\u0010B@\u0003%)hn\u00195fG.,GM\u0003\u0002~e&!!1\u0011B>\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\u0011II\u000b\u0003\u0002\u001c\tU\u0014AD2paf$C-\u001a4bk2$HeM\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\tE\u0005\u0003\u0002BJ\u0005;k!A!&\u000b\t\t]%\u0011T\u0001\u0005Y\u0006twM\u0003\u0002\u0003\u001c\u0006!!.\u0019<b\u0013\r9(QS\u0001\raJ|G-^2u\u0003JLG/_\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\u0011)Ka+\u0011\t\u00055#qU\u0005\u0004\u0005S\u0013(aA!os\"I\u0011Q\r\u001c\u0002\u0002\u0003\u0007\u00111T\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011!\u0011\u0017\t\u0007\u0005g\u0013IL!*\u000e\u0005\tU&b\u0001B\\e\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\tm&Q\u0017\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0003B\n\u001d\u0007\u0003BA'\u0005\u0007L1A!2s\u0005\u001d\u0011un\u001c7fC:D\u0011\"!\u001a9\u0003\u0003\u0005\rA!*\u0002\u0011!\f7\u000f[\"pI\u0016$\"!a'\u0015\u0005\tE\u0015AB3rk\u0006d7\u000f\u0006\u0003\u0003B\nM\u0007\"CA3w\u0005\u0005\t\u0019\u0001BS\u0003\u0011!\u0015\r^1\u0011\u0007\t}ShE\u0003>\u00057\u0014)\u0003E\u0006\u0003^\n\r(,a\u0007\u0002\u001c\tuSB\u0001Bp\u0015\r\u0011\tO]\u0001\beVtG/[7f\u0013\u0011\u0011)Oa8\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t7\u0007\u0006\u0002\u0003X\u0006)\u0011\r\u001d9msRA!Q\fBw\u0005_\u0014\t\u0010\u0003\u0004\u0002\n\u0001\u0003\rA\u0017\u0005\b\u0003/\u0001\u0005\u0019AA\u000e\u0011\u001d\t9\u0003\u0011a\u0001\u00037\tq!\u001e8baBd\u0017\u0010\u0006\u0003\u0003x\u000e\r\u0001CBA'\u0005s\u0014i0C\u0002\u0003|J\u0014aa\u00149uS>t\u0007#CA'\u0005\u007fT\u00161DA\u000e\u0013\r\u0019\tA\u001d\u0002\u0007)V\u0004H.Z\u001a\t\u0013\r\u0015\u0011)!AA\u0002\tu\u0013a\u0001=%a\u0005A1/\u0019<f\u00136\u0004H\u000e\u0006\u0003\u0002^\r-\u0001B\u0002B \u0005\u0002\u0007ANA\u000bOC&4XMQ1zKNlu\u000eZ3m%\u0016\fG-\u001a:\u0014\u0007\r\u0013\t\u0004\u0006\u0002\u0004\u0014A\u0019!QJ\"\u0002\u0013\rd\u0017m]:OC6,\u0017AC2mCN\u001ch*Y7fAQ\u0019\u0001ma\u0007\t\r\t}r\t1\u0001m\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\r\u0005\u0002\u0003\u0002BJ\u0007GIAa!\n\u0003\u0016\n1qJ\u00196fGRDC!\t>\u0002$\"\"\u0001E_AR\u0001")
public class NaiveBayesModel
extends ProbabilisticClassificationModel<Vector, NaiveBayesModel>
implements NaiveBayesParams,
MLWritable {
    private Tuple2<Matrix, DenseVector> x$8;
    private transient Matrix thetaMinusNegTheta;
    private transient DenseVector piMinusThetaSum;
    private transient double[] logVarSum;
    private transient Function1<Vector, Vector> predictRawFunc;
    private final String uid;
    private final Vector pi;
    private final Matrix theta;
    private final Matrix sigma;
    private double[] oldLabels;
    private final int numFeatures;
    private final int numClasses;
    private final DoubleParam smoothing;
    private final Param<String> modelType;
    private final Param<String> weightCol;
    private volatile transient byte bitmap$trans$0;
    private volatile boolean bitmap$0;

    public static NaiveBayesModel load(String string) {
        return NaiveBayesModel$.MODULE$.load(string);
    }

    public static MLReader<NaiveBayesModel> read() {
        return NaiveBayesModel$.MODULE$.read();
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable.save$(this, path);
    }

    @Override
    public final double getSmoothing() {
        return NaiveBayesParams.getSmoothing$(this);
    }

    @Override
    public final String getModelType() {
        return NaiveBayesParams.getModelType$(this);
    }

    @Override
    public final String getWeightCol() {
        return HasWeightCol.getWeightCol$(this);
    }

    @Override
    public final DoubleParam smoothing() {
        return this.smoothing;
    }

    @Override
    public final Param<String> modelType() {
        return this.modelType;
    }

    @Override
    public final void org$apache$spark$ml$classification$NaiveBayesParams$_setter_$smoothing_$eq(DoubleParam x$1) {
        this.smoothing = x$1;
    }

    @Override
    public final void org$apache$spark$ml$classification$NaiveBayesParams$_setter_$modelType_$eq(Param<String> x$1) {
        this.modelType = x$1;
    }

    @Override
    public final Param<String> weightCol() {
        return this.weightCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasWeightCol$_setter_$weightCol_$eq(Param<String> x$1) {
        this.weightCol = x$1;
    }

    @Override
    public String uid() {
        return this.uid;
    }

    public Vector pi() {
        return this.pi;
    }

    public Matrix theta() {
        return this.theta;
    }

    public Matrix sigma() {
        return this.sigma;
    }

    public double[] oldLabels() {
        return this.oldLabels;
    }

    public void oldLabels_$eq(double[] x$1) {
        this.oldLabels = x$1;
    }

    public NaiveBayesModel setOldLabels(double[] labels) {
        this.oldLabels_$eq(labels);
        return this;
    }

    private Tuple2<Matrix, DenseVector> x$8$lzycompute() {
        NaiveBayesModel naiveBayesModel = this;
        synchronized (naiveBayesModel) {
            if (!this.bitmap$0) {
                String string = this.$(this.modelType());
                String string2 = NaiveBayes$.MODULE$.Bernoulli();
                String string3 = string;
                if (string2 != null ? !string2.equals(string3) : string3 != null) {
                    throw new IllegalArgumentException(new StringBuilder(109).append("Invalid modelType: ").append((Object)this.$(this.modelType())).append(". ").append("Variables thetaMinusNegTheta and negThetaSum should only be precomputed in Bernoulli NB.").toString());
                }
                Matrix thetaMinusNegTheta = this.theta().map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)value -> value - scala.math.package$.MODULE$.log1p(-scala.math.package$.MODULE$.exp(value)));
                Matrix negTheta = this.theta().map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)value -> scala.math.package$.MODULE$.log1p(-scala.math.package$.MODULE$.exp(value)));
                DenseVector ones = new DenseVector((double[])Array$.MODULE$.fill(this.theta().numCols(), (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 1.0, ClassTag$.MODULE$.Double()));
                DenseVector piMinusThetaSum = this.pi().toDense().copy();
                BLAS$.MODULE$.gemv(1.0, negTheta, (Vector)ones, 1.0, piMinusThetaSum);
                Tuple2 tuple2 = new Tuple2((Object)thetaMinusNegTheta, (Object)piMinusThetaSum);
                Tuple2 tuple22 = tuple2;
                if (tuple22 == null) {
                    throw new MatchError((Object)tuple22);
                }
                Matrix thetaMinusNegTheta2 = (Matrix)tuple22._1();
                DenseVector piMinusThetaSum2 = (DenseVector)tuple22._2();
                Tuple2 tuple23 = new Tuple2((Object)thetaMinusNegTheta2, (Object)piMinusThetaSum2);
                this.x$8 = tuple23;
                this.bitmap$0 = true;
            }
        }
        return this.x$8;
    }

    private /* synthetic */ Tuple2 x$8() {
        return !this.bitmap$0 ? this.x$8$lzycompute() : this.x$8;
    }

    private Matrix thetaMinusNegTheta$lzycompute() {
        NaiveBayesModel naiveBayesModel = this;
        synchronized (naiveBayesModel) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.thetaMinusNegTheta = (Matrix)this.x$8()._1();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.thetaMinusNegTheta;
    }

    private Matrix thetaMinusNegTheta() {
        return (byte)(this.bitmap$trans$0 & 1) == 0 ? this.thetaMinusNegTheta$lzycompute() : this.thetaMinusNegTheta;
    }

    private DenseVector piMinusThetaSum$lzycompute() {
        NaiveBayesModel naiveBayesModel = this;
        synchronized (naiveBayesModel) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.piMinusThetaSum = (DenseVector)this.x$8()._2();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.piMinusThetaSum;
    }

    private DenseVector piMinusThetaSum() {
        return (byte)(this.bitmap$trans$0 & 2) == 0 ? this.piMinusThetaSum$lzycompute() : this.piMinusThetaSum;
    }

    private double[] logVarSum$lzycompute() {
        NaiveBayesModel naiveBayesModel = this;
        synchronized (naiveBayesModel) {
            if ((byte)(this.bitmap$trans$0 & 4) == 0) {
                String string = this.$(this.modelType());
                String string2 = NaiveBayes$.MODULE$.Gaussian();
                String string3 = string;
                if (string2 != null ? !string2.equals(string3) : string3 != null) {
                    throw new IllegalArgumentException(new StringBuilder(83).append("Invalid modelType: ").append((Object)this.$(this.modelType())).append(". ").append("Variables logVarSum should only be precomputed in Gaussian NB.").toString());
                }
                double[] dArray = (double[])Array$.MODULE$.tabulate(this.numClasses(), (Function1)(JFunction1.mcDI.sp & Serializable & scala.Serializable)i -> BoxesRunTime.unboxToDouble((Object)package$.MODULE$.Iterator().range(0, this.numFeatures()).map((Function1)(JFunction1.mcDI.sp & Serializable & scala.Serializable)j -> scala.math.package$.MODULE$.log(this.sigma().apply(i, j))).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)), ClassTag$.MODULE$.Double());
                this.logVarSum = dArray;
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 4);
            }
        }
        return this.logVarSum;
    }

    private double[] logVarSum() {
        return (byte)(this.bitmap$trans$0 & 4) == 0 ? this.logVarSum$lzycompute() : this.logVarSum;
    }

    @Override
    public int numFeatures() {
        return this.numFeatures;
    }

    @Override
    public int numClasses() {
        return this.numClasses;
    }

    /*
     * WARNING - void declaration
     */
    private DenseVector multinomialCalculation(Vector features) {
        void var2_2;
        NaiveBayes$.MODULE$.requireNonnegativeValues(features);
        DenseVector prob = this.pi().toDense().copy();
        BLAS$.MODULE$.gemv(1.0, this.theta(), features, 1.0, prob);
        return var2_2;
    }

    private Vector complementCalculation(Vector features) {
        int j;
        NaiveBayes$.MODULE$.requireNonnegativeValues(features);
        double[] probArray = this.theta().multiply(features).toArray();
        double max = BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(probArray)).max((Ordering)Ordering.Double$.MODULE$));
        double sumExp = 0.0;
        for (j = 0; j < probArray.length; ++j) {
            sumExp += scala.math.package$.MODULE$.exp(probArray[j] - max);
        }
        double logSumExp = scala.math.package$.MODULE$.log(sumExp) + max;
        for (j = 0; j < probArray.length; ++j) {
            probArray[j] = probArray[j] - logSumExp;
        }
        return Vectors$.MODULE$.dense(probArray);
    }

    /*
     * WARNING - void declaration
     */
    private DenseVector bernoulliCalculation(Vector features) {
        void var2_2;
        NaiveBayes$.MODULE$.requireZeroOneBernoulliValues(features);
        DenseVector prob = this.piMinusThetaSum().copy();
        BLAS$.MODULE$.gemv(1.0, this.thetaMinusNegTheta(), features, 1.0, prob);
        return var2_2;
    }

    private Vector gaussianCalculation(Vector features) {
        double[] prob = (double[])Array$.MODULE$.ofDim(this.numClasses(), ClassTag$.MODULE$.Double());
        for (int i = 0; i < this.numClasses(); ++i) {
            double s = 0.0;
            for (int j = 0; j < this.numFeatures(); ++j) {
                double d = features.apply(j) - this.theta().apply(i, j);
                s += d * d / this.sigma().apply(i, j);
            }
            prob[i] = this.pi().apply(i) - (s + this.logVarSum()[i]) / (double)2;
        }
        return Vectors$.MODULE$.dense(prob);
    }

    private Function1<Vector, Vector> predictRawFunc$lzycompute() {
        NaiveBayesModel naiveBayesModel = this;
        synchronized (naiveBayesModel) {
            if ((byte)(this.bitmap$trans$0 & 8) == 0) {
                Function1 & Serializable & scala.Serializable intersect;
                String string = this.$(this.modelType());
                String string2 = NaiveBayes$.MODULE$.Multinomial();
                String string3 = string;
                if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                    intersect = (Function1 & Serializable & scala.Serializable)features -> this.multinomialCalculation((Vector)features);
                } else {
                    String string4 = NaiveBayes$.MODULE$.Complement();
                    String string5 = string;
                    if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                        intersect = (Function1 & Serializable & scala.Serializable)features -> this.complementCalculation((Vector)features);
                    } else {
                        String string6 = NaiveBayes$.MODULE$.Bernoulli();
                        String string7 = string;
                        if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                            intersect = (Function1 & Serializable & scala.Serializable)features -> this.bernoulliCalculation((Vector)features);
                        } else {
                            String string8 = NaiveBayes$.MODULE$.Gaussian();
                            String string9 = string;
                            if (!(string8 != null ? !string8.equals(string9) : string9 != null)) {
                                intersect = (Function1 & Serializable & scala.Serializable)features -> this.gaussianCalculation((Vector)features);
                            } else {
                                throw new MatchError((Object)string);
                            }
                        }
                    }
                }
                this.predictRawFunc = intersect;
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 8);
            }
        }
        return this.predictRawFunc;
    }

    private Function1<Vector, Vector> predictRawFunc() {
        return (byte)(this.bitmap$trans$0 & 8) == 0 ? this.predictRawFunc$lzycompute() : this.predictRawFunc;
    }

    @Override
    public Vector predictRaw(Vector features) {
        return (Vector)this.predictRawFunc().apply((Object)features);
    }

    @Override
    public Vector raw2probabilityInPlace(Vector rawPrediction) {
        DenseVector denseVector;
        Vector vector = rawPrediction;
        if (vector instanceof DenseVector) {
            int i;
            denseVector = (DenseVector)vector;
            int size = denseVector.size();
            double maxLog = BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(denseVector.values())).max((Ordering)Ordering.Double$.MODULE$));
            for (i = 0; i < size; ++i) {
                denseVector.values()[i] = scala.math.package$.MODULE$.exp(denseVector.values()[i] - maxLog);
            }
            double probSum = BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(denseVector.values())).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
            for (i = 0; i < size; ++i) {
                denseVector.values()[i] = denseVector.values()[i] / probSum;
            }
        } else {
            if (vector instanceof SparseVector) {
                throw new RuntimeException("Unexpected error in NaiveBayesModel: raw2probabilityInPlace encountered SparseVector");
            }
            throw new MatchError((Object)vector);
        }
        DenseVector denseVector2 = denseVector;
        return denseVector2;
    }

    @Override
    public NaiveBayesModel copy(ParamMap extra) {
        return (NaiveBayesModel)this.copyValues(new NaiveBayesModel(this.uid(), this.pi(), this.theta(), this.sigma()).setParent(this.parent()), extra);
    }

    @Override
    public String toString() {
        return new StringBuilder(60).append("NaiveBayesModel: uid=").append(this.uid()).append(", modelType=").append((Object)this.$(this.modelType())).append(", numClasses=").append(this.numClasses()).append(", ").append("numFeatures=").append(this.numFeatures()).toString();
    }

    @Override
    public MLWriter write() {
        return new NaiveBayesModelWriter(this);
    }

    public NaiveBayesModel(String uid, Vector pi, Matrix theta, Matrix sigma) {
        this.uid = uid;
        this.pi = pi;
        this.theta = theta;
        this.sigma = sigma;
        HasWeightCol.$init$(this);
        NaiveBayesParams.$init$(this);
        MLWritable.$init$(this);
        this.oldLabels = null;
        this.numFeatures = theta.numCols();
        this.numClasses = pi.size();
    }

    public static class NaiveBayesModelReader
    extends MLReader<NaiveBayesModel> {
        private final String className = NaiveBayesModel.class.getName();

        private String className() {
            return this.className;
        }

        @Override
        public NaiveBayesModel load(String path) {
            NaiveBayesModel naiveBayesModel;
            DefaultParamsReader.Metadata metadata;
            block10: {
                Matrix matrix;
                Vector vector;
                Object sigma;
                block12: {
                    Row row;
                    block11: {
                        Dataset<Row> vecConverted;
                        block7: {
                            Vector vector2;
                            Object theta;
                            block9: {
                                Row row2;
                                block8: {
                                    DefaultFormats$ format = DefaultFormats$.MODULE$;
                                    metadata = DefaultParamsReader$.MODULE$.loadMetadata(path, this.sc(), this.className());
                                    Tuple2 tuple2 = VersionUtils$.MODULE$.majorMinorVersion(metadata.sparkVersion());
                                    if (tuple2 == null) {
                                        throw new MatchError((Object)tuple2);
                                    }
                                    int major = tuple2._1$mcI$sp();
                                    int minor = tuple2._2$mcI$sp();
                                    Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(major, minor);
                                    Tuple2.mcII.sp sp3 = sp2;
                                    int major2 = sp3._1$mcI$sp();
                                    int minor2 = sp3._2$mcI$sp();
                                    String dataPath = new Path(path, "data").toString();
                                    Dataset data = this.sparkSession().read().parquet(dataPath);
                                    vecConverted = MLUtils$.MODULE$.convertVectorColumnsToML(data, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"pi"}));
                                    if (major2 >= 3) break block7;
                                    row2 = (Row)MLUtils$.MODULE$.convertMatrixColumnsToML(vecConverted, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"theta"})).select("pi", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"theta"})).head();
                                    Some some = Row$.MODULE$.unapplySeq(row2);
                                    if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(2) != 0) break block8;
                                    Object pi = ((SeqLike)some.get()).apply(0);
                                    theta = ((SeqLike)some.get()).apply(1);
                                    if (!(pi instanceof Vector)) break block8;
                                    vector2 = (Vector)pi;
                                    if (theta instanceof Matrix) break block9;
                                }
                                throw new MatchError((Object)row2);
                            }
                            Matrix matrix2 = (Matrix)theta;
                            Tuple2 tuple2 = new Tuple2((Object)vector2, (Object)matrix2);
                            Tuple2 tuple22 = tuple2;
                            Vector pi = (Vector)tuple22._1();
                            Matrix theta2 = (Matrix)tuple22._2();
                            naiveBayesModel = new NaiveBayesModel(metadata.uid(), pi, theta2, Matrices$.MODULE$.zeros(0, 0));
                            break block10;
                        }
                        row = (Row)MLUtils$.MODULE$.convertMatrixColumnsToML(vecConverted, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"theta", "sigma"})).select("pi", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"theta", "sigma"})).head();
                        Some some = Row$.MODULE$.unapplySeq(row);
                        if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(3) != 0) break block11;
                        Object pi = ((SeqLike)some.get()).apply(0);
                        Object theta = ((SeqLike)some.get()).apply(1);
                        sigma = ((SeqLike)some.get()).apply(2);
                        if (!(pi instanceof Vector)) break block11;
                        vector = (Vector)pi;
                        if (!(theta instanceof Matrix)) break block11;
                        matrix = (Matrix)theta;
                        if (sigma instanceof Matrix) break block12;
                    }
                    throw new MatchError((Object)row);
                }
                Matrix matrix3 = (Matrix)sigma;
                Tuple3 tuple3 = new Tuple3((Object)vector, (Object)matrix, (Object)matrix3);
                Tuple3 tuple32 = tuple3;
                Vector pi = (Vector)tuple32._1();
                Matrix theta = (Matrix)tuple32._2();
                Matrix sigma2 = (Matrix)tuple32._3();
                naiveBayesModel = new NaiveBayesModel(metadata.uid(), pi, theta, sigma2);
            }
            NaiveBayesModel model = naiveBayesModel;
            metadata.getAndSetParams(model, metadata.getAndSetParams$default$2());
            return model;
        }
    }

    public static class NaiveBayesModelWriter
    extends MLWriter {
        private volatile NaiveBayesModel$NaiveBayesModelWriter$Data$ Data$module;
        private final NaiveBayesModel instance;

        private NaiveBayesModel$NaiveBayesModelWriter$Data$ Data() {
            if (this.Data$module == null) {
                this.Data$lzycompute$1();
            }
            return this.Data$module;
        }

        @Override
        public void saveImpl(String path) {
            boolean bl;
            DefaultParamsWriter$.MODULE$.saveMetadata(this.instance, path, this.sc(), DefaultParamsWriter$.MODULE$.saveMetadata$default$4(), DefaultParamsWriter$.MODULE$.saveMetadata$default$5());
            String dataPath = new Path(path, "data").toString();
            String string = this.instance.getModelType();
            String string2 = NaiveBayes$.MODULE$.Multinomial();
            String string3 = string;
            if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                bl = true;
            } else {
                String string4 = NaiveBayes$.MODULE$.Bernoulli();
                String string5 = string;
                if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                    bl = true;
                } else {
                    String string6 = NaiveBayes$.MODULE$.Complement();
                    String string7 = string;
                    bl = !(string6 != null ? !string6.equals(string7) : string7 != null);
                }
            }
            if (bl) {
                Predef$.MODULE$.require(this.instance.sigma().numRows() == 0 && this.instance.sigma().numCols() == 0);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                String string8 = NaiveBayes$.MODULE$.Gaussian();
                String string9 = string;
                if (!(string8 != null ? !string8.equals(string9) : string9 != null)) {
                    Predef$.MODULE$.require(this.instance.sigma().numRows() != 0 && this.instance.sigma().numCols() != 0);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    throw new MatchError((Object)string);
                }
            }
            Data data = new Data(this, this.instance.pi(), this.instance.theta(), this.instance.sigma());
            JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(NaiveBayesModelWriter.class.getClassLoader());
            public final class Org_apache_spark_ml_classification_NaiveBayesModel$NaiveBayesModelWriter$$typecreator1$2
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType((Symbols.SymbolApi)$m.staticClass("org.apache.spark.ml.classification.NaiveBayesModel.NaiveBayesModelWriter")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType((Symbols.SymbolApi)$m.staticClass("org.apache.spark.ml.classification.NaiveBayesModel.NaiveBayesModelWriter"), "Data"), (List)Nil$.MODULE$);
                }

                public Org_apache_spark_ml_classification_NaiveBayesModel$NaiveBayesModelWriter$$typecreator1$2(NaiveBayesModelWriter $outer) {
                }
            }
            this.sparkSession().createDataFrame((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Data[]{data})), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_classification_NaiveBayesModel$NaiveBayesModelWriter$$typecreator1$2(null))).repartition(1).write().parquet(dataPath);
        }

        private final void Data$lzycompute$1() {
            NaiveBayesModelWriter naiveBayesModelWriter = this;
            synchronized (naiveBayesModelWriter) {
                if (this.Data$module == null) {
                    this.Data$module = new NaiveBayesModel$NaiveBayesModelWriter$Data$(this);
                }
            }
        }

        public NaiveBayesModelWriter(NaiveBayesModel instance) {
            this.instance = instance;
        }

        public class Data
        implements Product,
        scala.Serializable {
            private final Vector pi;
            private final Matrix theta;
            private final Matrix sigma;
            public final /* synthetic */ NaiveBayesModelWriter $outer;

            public Vector pi() {
                return this.pi;
            }

            public Matrix theta() {
                return this.theta;
            }

            public Matrix sigma() {
                return this.sigma;
            }

            public Data copy(Vector pi, Matrix theta, Matrix sigma) {
                return new Data(this.org$apache$spark$ml$classification$NaiveBayesModel$NaiveBayesModelWriter$Data$$$outer(), pi, theta, sigma);
            }

            public Vector copy$default$1() {
                return this.pi();
            }

            public Matrix copy$default$2() {
                return this.theta();
            }

            public Matrix copy$default$3() {
                return this.sigma();
            }

            public String productPrefix() {
                return "Data";
            }

            public int productArity() {
                return 3;
            }

            public Object productElement(int x$1) {
                Vector vector;
                int n = x$1;
                switch (n) {
                    case 0: {
                        vector = this.pi();
                        break;
                    }
                    case 1: {
                        vector = this.theta();
                        break;
                    }
                    case 2: {
                        vector = this.sigma();
                        break;
                    }
                    default: {
                        throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                    }
                }
                return vector;
            }

            public Iterator<Object> productIterator() {
                return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
            }

            public boolean canEqual(Object x$1) {
                return x$1 instanceof Data;
            }

            public int hashCode() {
                return ScalaRunTime$.MODULE$._hashCode((Product)this);
            }

            public String toString() {
                return ScalaRunTime$.MODULE$._toString((Product)this);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean equals(Object x$1) {
                if (this == x$1) return true;
                Object object = x$1;
                if (!(object instanceof Data)) return false;
                if (((Data)object).org$apache$spark$ml$classification$NaiveBayesModel$NaiveBayesModelWriter$Data$$$outer() != this.org$apache$spark$ml$classification$NaiveBayesModel$NaiveBayesModelWriter$Data$$$outer()) return false;
                boolean bl = true;
                if (!bl) return false;
                Data data = (Data)x$1;
                Vector vector = this.pi();
                Vector vector2 = data.pi();
                if (vector == null) {
                    if (vector2 != null) {
                        return false;
                    }
                } else if (!vector.equals(vector2)) return false;
                Matrix matrix = this.theta();
                Matrix matrix2 = data.theta();
                if (matrix == null) {
                    if (matrix2 != null) {
                        return false;
                    }
                } else if (!matrix.equals(matrix2)) return false;
                Matrix matrix3 = this.sigma();
                Matrix matrix4 = data.sigma();
                if (matrix3 == null) {
                    if (matrix4 != null) {
                        return false;
                    }
                } else if (!matrix3.equals(matrix4)) return false;
                if (!data.canEqual(this)) return false;
                return true;
            }

            public /* synthetic */ NaiveBayesModelWriter org$apache$spark$ml$classification$NaiveBayesModel$NaiveBayesModelWriter$Data$$$outer() {
                return this.$outer;
            }

            public Data(NaiveBayesModelWriter $outer, Vector pi, Matrix theta, Matrix sigma) {
                this.pi = pi;
                this.theta = theta;
                this.sigma = sigma;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                Product.$init$((Product)this);
            }
        }
    }
}

