/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.classification;

import breeze.linalg.DenseVector;
import breeze.linalg.DenseVector$;
import breeze.math.MutableEnumeratedCoordinateField;
import breeze.math.MutableInnerProductModule;
import breeze.optimize.CachedDiffFunction;
import breeze.optimize.FirstOrderMinimizer;
import breeze.optimize.LBFGS;
import breeze.optimize.LBFGSB;
import breeze.optimize.LBFGSB$;
import breeze.optimize.OWLQN;
import breeze.optimize.StochasticDiffFunction;
import java.io.IOException;
import java.io.Serializable;
import java.util.Locale;
import org.apache.spark.SparkException;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.ml.classification.BinaryLogisticRegressionTrainingSummaryImpl;
import org.apache.spark.ml.classification.LogisticRegression$;
import org.apache.spark.ml.classification.LogisticRegressionModel;
import org.apache.spark.ml.classification.LogisticRegressionParams;
import org.apache.spark.ml.classification.LogisticRegressionSummaryImpl;
import org.apache.spark.ml.classification.LogisticRegressionTrainingSummary;
import org.apache.spark.ml.classification.LogisticRegressionTrainingSummaryImpl;
import org.apache.spark.ml.classification.MultiClassSummarizer;
import org.apache.spark.ml.classification.ProbabilisticClassifier;
import org.apache.spark.ml.classification.ProbabilisticClassifierParams;
import org.apache.spark.ml.feature.Instance;
import org.apache.spark.ml.linalg.DenseMatrix;
import org.apache.spark.ml.linalg.Matrices$;
import org.apache.spark.ml.linalg.Matrix;
import org.apache.spark.ml.linalg.SparseMatrix;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.optim.aggregator.LogisticAggregator;
import org.apache.spark.ml.optim.loss.DifferentiableRegularization;
import org.apache.spark.ml.optim.loss.L2Regularization;
import org.apache.spark.ml.optim.loss.RDDLossFunction;
import org.apache.spark.ml.param.BooleanParam;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.ParamPair;
import org.apache.spark.ml.param.shared.HasAggregationDepth;
import org.apache.spark.ml.param.shared.HasElasticNetParam;
import org.apache.spark.ml.param.shared.HasFitIntercept;
import org.apache.spark.ml.param.shared.HasMaxIter;
import org.apache.spark.ml.param.shared.HasRegParam;
import org.apache.spark.ml.param.shared.HasStandardization;
import org.apache.spark.ml.param.shared.HasThreshold;
import org.apache.spark.ml.param.shared.HasTol;
import org.apache.spark.ml.param.shared.HasWeightCol;
import org.apache.spark.ml.stat.Summarizer$;
import org.apache.spark.ml.stat.SummarizerBuffer;
import org.apache.spark.ml.util.DefaultParamsWritable;
import org.apache.spark.ml.util.Identifiable$;
import org.apache.spark.ml.util.Instrumentation$;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.ml.util.MetadataUtils$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenIterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.ArrayBuilder;
import scala.collection.mutable.ArrayBuilder$;
import scala.collection.mutable.ArrayOps;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.runtime.java8.JFunction2;

@ScalaSignature(bytes="\u0006\u0001\t%d\u0001B\u0013'\u0001EB\u0001b\u0014\u0001\u0003\u0006\u0004%\t\u0005\u0015\u0005\tO\u0002\u0011\t\u0011)A\u0005#\")\u0011\u000e\u0001C\u0001U\")\u0011\u000e\u0001C\u0001a\")!\u000f\u0001C\u0001g\")A\u0010\u0001C\u0001{\"9\u0011\u0011\u0001\u0001\u0005\u0002\u0005\r\u0001bBA\b\u0001\u0011\u0005\u0011\u0011\u0003\u0005\b\u0003/\u0001A\u0011AA\r\u0011\u001d\t)\u0003\u0001C\u0001\u0003OAq!!\r\u0001\t\u0003\t\u0019\u0004C\u0004\u0002>\u0001!\t%a\u0010\t\u000f\u0005\u0015\u0003\u0001\"\u0011\u0002H!9\u00111\n\u0001\u0005\u0002\u00055\u0003bBA,\u0001\u0011\u0005\u0013\u0011\f\u0005\b\u0003K\u0002A\u0011IA4\u0011\u001d\tY\u0007\u0001C\u0001\u0003[Bq!a\u001d\u0001\t\u0003\t)\bC\u0004\u0002\u0006\u0002!\t!a\"\t\u000f\u00055\u0005\u0001\"\u0001\u0002\u0010\"9\u0011Q\u0013\u0001\u0005\u0002\u0005]\u0005bBAO\u0001\u0011%\u0011q\u0014\u0005\n\u0003_\u0003\u0001\u0019!C\u0005\u0003cC\u0011\"!/\u0001\u0001\u0004%I!a/\t\u0011\u0005\u0005\u0007\u0001)Q\u0005\u0003gC\u0001\"a1\u0001\t\u0003Q\u0013Q\u0019\u0005\t\u0003\u0017\u0004A\u0011\u000b\u0016\u0002N\"A\u00111\u001a\u0001\u0005\u0012)\n9\u0010C\u0004\u0003\n\u0001!\tEa\u0003\b\u000f\t\u0005b\u0005#\u0001\u0003$\u00191QE\nE\u0001\u0005KAa![\u0010\u0005\u0002\te\u0002b\u0002B\u001e?\u0011\u0005#Q\b\u0005\u000b\u0005\u000bz\"\u0019!C\u0001M\t\u001d\u0003\u0002\u0003B-?\u0001\u0006IA!\u0013\t\u0013\tms$!A\u0005\n\tu#A\u0005'pO&\u001cH/[2SK\u001e\u0014Xm]:j_:T!a\n\u0015\u0002\u001d\rd\u0017m]:jM&\u001c\u0017\r^5p]*\u0011\u0011FK\u0001\u0003[2T!a\u000b\u0017\u0002\u000bM\u0004\u0018M]6\u000b\u00055r\u0013AB1qC\u000eDWMC\u00010\u0003\ry'oZ\u0002\u0001'\u0015\u0001!\u0007Q\"J!\u0015\u0019DG\u000e\u001f>\u001b\u00051\u0013BA\u001b'\u0005]\u0001&o\u001c2bE&d\u0017n\u001d;jG\u000ec\u0017m]:jM&,'\u000f\u0005\u00028u5\t\u0001H\u0003\u0002:Q\u00051A.\u001b8bY\u001eL!a\u000f\u001d\u0003\rY+7\r^8s!\t\u0019\u0004\u0001\u0005\u00024}%\u0011qH\n\u0002\u0018\u0019><\u0017n\u001d;jGJ+wM]3tg&|g.T8eK2\u0004\"aM!\n\u0005\t3#\u0001\u0007'pO&\u001cH/[2SK\u001e\u0014Xm]:j_:\u0004\u0016M]1ngB\u0011AiR\u0007\u0002\u000b*\u0011a\tK\u0001\u0005kRLG.\u0003\u0002I\u000b\n)B)\u001a4bk2$\b+\u0019:b[N<&/\u001b;bE2,\u0007C\u0001&N\u001b\u0005Y%B\u0001'+\u0003!Ig\u000e^3s]\u0006d\u0017B\u0001(L\u0005\u001daunZ4j]\u001e\f1!^5e+\u0005\t\u0006C\u0001*\\\u001d\t\u0019\u0016\f\u0005\u0002U/6\tQK\u0003\u0002Wa\u00051AH]8pizR\u0011\u0001W\u0001\u0006g\u000e\fG.Y\u0005\u00035^\u000ba\u0001\u0015:fI\u00164\u0017B\u0001/^\u0005\u0019\u0019FO]5oO*\u0011!l\u0016\u0015\u0004\u0003}+\u0007C\u00011d\u001b\u0005\t'B\u00012+\u0003)\tgN\\8uCRLwN\\\u0005\u0003I\u0006\u0014QaU5oG\u0016\f\u0013AZ\u0001\u0006c9\"d\u0006M\u0001\u0005k&$\u0007\u0005K\u0002\u0003?\u0016\fa\u0001P5oSRtDC\u0001\u001fl\u0011\u0015y5\u00011\u0001RQ\rYw,\u001a\u0015\u0004\u0007}s\u0017%A8\u0002\u000bEr#G\f\u0019\u0015\u0003qB3\u0001B0f\u0003-\u0019X\r\u001e*fOB\u000b'/Y7\u0015\u0005Q,X\"\u0001\u0001\t\u000bY,\u0001\u0019A<\u0002\u000bY\fG.^3\u0011\u0005aLX\"A,\n\u0005i<&A\u0002#pk\ndW\rK\u0002\u0006?:\f!c]3u\u000b2\f7\u000f^5d\u001d\u0016$\b+\u0019:b[R\u0011AO \u0005\u0006m\u001a\u0001\ra\u001e\u0015\u0004\r}+\u0017AC:fi6\u000b\u00070\u0013;feR\u0019A/!\u0002\t\rY<\u0001\u0019AA\u0004!\rA\u0018\u0011B\u0005\u0004\u0003\u00179&aA%oi\"\u001aqa\u00188\u0002\rM,G\u000fV8m)\r!\u00181\u0003\u0005\u0006m\"\u0001\ra\u001e\u0015\u0004\u0011}+\u0017aD:fi\u001aKG/\u00138uKJ\u001cW\r\u001d;\u0015\u0007Q\fY\u0002\u0003\u0004w\u0013\u0001\u0007\u0011Q\u0004\t\u0004q\u0006}\u0011bAA\u0011/\n9!i\\8mK\u0006t\u0007fA\u0005`K\u0006I1/\u001a;GC6LG.\u001f\u000b\u0004i\u0006%\u0002\"\u0002<\u000b\u0001\u0004\t\u0006\u0006\u0002\u0006`\u0003[\t#!a\f\u0002\u000bIr\u0013G\f\u0019\u0002%M,Go\u0015;b]\u0012\f'\u000fZ5{CRLwN\u001c\u000b\u0004i\u0006U\u0002B\u0002<\f\u0001\u0004\ti\u0002\u000b\u0003\f?\u0006e\u0012EAA\u001e\u0003\u0015\td&\u000e\u00181\u00031\u0019X\r\u001e+ie\u0016\u001c\bn\u001c7e)\r!\u0018\u0011\t\u0005\u0006m2\u0001\ra\u001e\u0015\u0005\u0019}\u000bI$\u0001\u0007hKR$\u0006N]3tQ>dG-F\u0001xQ\u0011iq,!\u000f\u0002\u0019M,GoV3jO\"$8i\u001c7\u0015\u0007Q\fy\u0005C\u0003w\u001d\u0001\u0007\u0011\u000b\u000b\u0003\u000f?\u0006M\u0013EAA+\u0003\u0015\tdF\u000e\u00181\u00035\u0019X\r\u001e+ie\u0016\u001c\bn\u001c7egR\u0019A/a\u0017\t\rY|\u0001\u0019AA/!\u0011A\u0018qL<\n\u0007\u0005\u0005tKA\u0003BeJ\f\u0017\u0010\u000b\u0003\u0010?\u0006e\u0012!D4fiRC'/Z:i_2$7/\u0006\u0002\u0002^!\"\u0001cXA\u001d\u0003M\u0019X\r^!hOJ,w-\u0019;j_:$U\r\u001d;i)\r!\u0018q\u000e\u0005\u0007mF\u0001\r!a\u0002)\tEy\u0016QF\u0001\u001dg\u0016$Hj\\<fe\n{WO\u001c3t\u001f:\u001cu.\u001a4gS\u000eLWM\u001c;t)\r!\u0018q\u000f\u0005\u0007mJ\u0001\r!!\u001f\u0011\u0007]\nY(C\u0002\u0002~a\u0012a!T1ue&D\b\u0006\u0002\n`\u0003\u0003\u000b#!a!\u0002\u000bIr#G\f\u0019\u00029M,G/\u00169qKJ\u0014u.\u001e8eg>s7i\\3gM&\u001c\u0017.\u001a8ugR\u0019A/!#\t\rY\u001c\u0002\u0019AA=Q\u0011\u0019r,!!\u00025M,G\u000fT8xKJ\u0014u.\u001e8eg>s\u0017J\u001c;fe\u000e,\u0007\u000f^:\u0015\u0007Q\f\t\nC\u0003w)\u0001\u0007a\u0007\u000b\u0003\u0015?\u0006\u0005\u0015AG:fiV\u0003\b/\u001a:C_VtGm](o\u0013:$XM]2faR\u001cHc\u0001;\u0002\u001a\")a/\u0006a\u0001m!\"QcXAA\u00035\n7o]3si\n{WO\u001c3D_:\u001cHO]1j]\u0016$w\n\u001d;j[&T\u0018\r^5p]B\u000b'/Y7t-\u0006d\u0017\u000e\u001a\u000b\u0007\u0003C\u000b9+a+\u0011\u0007a\f\u0019+C\u0002\u0002&^\u0013A!\u00168ji\"9\u0011\u0011\u0016\fA\u0002\u0005\u001d\u0011A\u00058v[\u000e{WM\u001a4jG&,g\u000e^*fiNDq!!,\u0017\u0001\u0004\t9!A\u0006ok64U-\u0019;ve\u0016\u001c\u0018aD8qi&s\u0017\u000e^5bY6{G-\u001a7\u0016\u0005\u0005M\u0006\u0003\u0002=\u00026vJ1!a.X\u0005\u0019y\u0005\u000f^5p]\u0006\u0019r\u000e\u001d;J]&$\u0018.\u00197N_\u0012,Gn\u0018\u0013fcR!\u0011\u0011UA_\u0011%\ty\fGA\u0001\u0002\u0004\t\u0019,A\u0002yIE\n\u0001c\u001c9u\u0013:LG/[1m\u001b>$W\r\u001c\u0011\u0002\u001fM,G/\u00138ji&\fG.T8eK2$2\u0001^Ad\u0011\u0019\tIM\u0007a\u0001{\u0005)Qn\u001c3fY\u0006)AO]1j]R\u0019Q(a4\t\u000f\u0005E7\u00041\u0001\u0002T\u00069A-\u0019;bg\u0016$\b\u0007BAk\u0003K\u0004b!a6\u0002^\u0006\u0005XBAAm\u0015\r\tYNK\u0001\u0004gFd\u0017\u0002BAp\u00033\u0014q\u0001R1uCN,G\u000f\u0005\u0003\u0002d\u0006\u0015H\u0002\u0001\u0003\r\u0003O\fy-!A\u0001\u0002\u000b\u0005\u0011\u0011\u001e\u0002\u0004?\u0012\n\u0014\u0003BAv\u0003c\u00042\u0001_Aw\u0013\r\tyo\u0016\u0002\b\u001d>$\b.\u001b8h!\rA\u00181_\u0005\u0004\u0003k<&aA!osR)Q(!?\u0003\u0006!9\u0011\u0011\u001b\u000fA\u0002\u0005m\b\u0007BA\u007f\u0005\u0003\u0001b!a6\u0002^\u0006}\b\u0003BAr\u0005\u0003!ABa\u0001\u0002z\u0006\u0005\t\u0011!B\u0001\u0003S\u00141a\u0018\u00133\u0011\u001d\u00119\u0001\ba\u0001\u0003;\t\u0011\u0003[1oI2,\u0007+\u001a:tSN$XM\\2f\u0003\u0011\u0019w\u000e]=\u0015\u0007q\u0012i\u0001C\u0004\u0003\u0010u\u0001\rA!\u0005\u0002\u000b\u0015DHO]1\u0011\t\tM!\u0011D\u0007\u0003\u0005+Q1Aa\u0006)\u0003\u0015\u0001\u0018M]1n\u0013\u0011\u0011YB!\u0006\u0003\u0011A\u000b'/Y7NCBD3!H0fQ\r\u0001qL\\\u0001\u0013\u0019><\u0017n\u001d;jGJ+wM]3tg&|g\u000e\u0005\u00024?M9qDa\n\u0003.\tM\u0002c\u0001=\u0003*%\u0019!1F,\u0003\r\u0005s\u0017PU3g!\u0011!%q\u0006\u001f\n\u0007\tERIA\u000bEK\u001a\fW\u000f\u001c;QCJ\fWn\u001d*fC\u0012\f'\r\\3\u0011\u0007a\u0014)$C\u0002\u00038]\u0013AbU3sS\u0006d\u0017N_1cY\u0016$\"Aa\t\u0002\t1|\u0017\r\u001a\u000b\u0004y\t}\u0002B\u0002B!C\u0001\u0007\u0011+\u0001\u0003qCRD\u0007\u0006B\u0011`\u0003'\nAc];qa>\u0014H/\u001a3GC6LG.\u001f(b[\u0016\u001cXC\u0001B%!\u0015A\u0018q\fB&!\u0011\u0011iEa\u0016\u000e\u0005\t=#\u0002\u0002B)\u0005'\nA\u0001\\1oO*\u0011!QK\u0001\u0005U\u00064\u0018-C\u0002]\u0005\u001f\nQc];qa>\u0014H/\u001a3GC6LG.\u001f(b[\u0016\u001c\b%A\u0006sK\u0006$'+Z:pYZ,GC\u0001B0!\u0011\u0011iE!\u0019\n\t\t\r$q\n\u0002\u0007\u001f\nTWm\u0019;)\t}y\u00161\u000b\u0015\u0005=}\u000b\u0019\u0006")
public class LogisticRegression
extends ProbabilisticClassifier<Vector, LogisticRegression, LogisticRegressionModel>
implements LogisticRegressionParams,
DefaultParamsWritable {
    private final String uid;
    private Option<LogisticRegressionModel> optInitialModel;
    private final Param<String> family;
    private final Param<Matrix> lowerBoundsOnCoefficients;
    private final Param<Matrix> upperBoundsOnCoefficients;
    private final Param<Vector> lowerBoundsOnIntercepts;
    private final Param<Vector> upperBoundsOnIntercepts;
    private final IntParam aggregationDepth;
    private final DoubleParam threshold;
    private final Param<String> weightCol;
    private final BooleanParam standardization;
    private final DoubleParam tol;
    private final BooleanParam fitIntercept;
    private final IntParam maxIter;
    private final DoubleParam elasticNetParam;
    private final DoubleParam regParam;

    public static LogisticRegression load(String string) {
        return LogisticRegression$.MODULE$.load(string);
    }

    public static MLReader<LogisticRegression> read() {
        return LogisticRegression$.MODULE$.read();
    }

    @Override
    public MLWriter write() {
        return DefaultParamsWritable.write$(this);
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable.save$(this, path);
    }

    @Override
    public /* synthetic */ StructType org$apache$spark$ml$classification$LogisticRegressionParams$$super$validateAndTransformSchema(StructType schema, boolean fitting, DataType featuresDataType) {
        return ProbabilisticClassifierParams.validateAndTransformSchema$(this, schema, fitting, featuresDataType);
    }

    @Override
    public String getFamily() {
        return LogisticRegressionParams.getFamily$(this);
    }

    @Override
    public void checkThresholdConsistency() {
        LogisticRegressionParams.checkThresholdConsistency$(this);
    }

    @Override
    public Matrix getLowerBoundsOnCoefficients() {
        return LogisticRegressionParams.getLowerBoundsOnCoefficients$(this);
    }

    @Override
    public Matrix getUpperBoundsOnCoefficients() {
        return LogisticRegressionParams.getUpperBoundsOnCoefficients$(this);
    }

    @Override
    public Vector getLowerBoundsOnIntercepts() {
        return LogisticRegressionParams.getLowerBoundsOnIntercepts$(this);
    }

    @Override
    public Vector getUpperBoundsOnIntercepts() {
        return LogisticRegressionParams.getUpperBoundsOnIntercepts$(this);
    }

    @Override
    public boolean usingBoundConstrainedOptimization() {
        return LogisticRegressionParams.usingBoundConstrainedOptimization$(this);
    }

    @Override
    public StructType validateAndTransformSchema(StructType schema, boolean fitting, DataType featuresDataType) {
        return LogisticRegressionParams.validateAndTransformSchema$(this, schema, fitting, featuresDataType);
    }

    @Override
    public final int getAggregationDepth() {
        return HasAggregationDepth.getAggregationDepth$(this);
    }

    @Override
    public final String getWeightCol() {
        return HasWeightCol.getWeightCol$(this);
    }

    @Override
    public final boolean getStandardization() {
        return HasStandardization.getStandardization$(this);
    }

    @Override
    public final double getTol() {
        return HasTol.getTol$(this);
    }

    @Override
    public final boolean getFitIntercept() {
        return HasFitIntercept.getFitIntercept$(this);
    }

    @Override
    public final int getMaxIter() {
        return HasMaxIter.getMaxIter$(this);
    }

    @Override
    public final double getElasticNetParam() {
        return HasElasticNetParam.getElasticNetParam$(this);
    }

    @Override
    public final double getRegParam() {
        return HasRegParam.getRegParam$(this);
    }

    @Override
    public final Param<String> family() {
        return this.family;
    }

    @Override
    public Param<Matrix> lowerBoundsOnCoefficients() {
        return this.lowerBoundsOnCoefficients;
    }

    @Override
    public Param<Matrix> upperBoundsOnCoefficients() {
        return this.upperBoundsOnCoefficients;
    }

    @Override
    public Param<Vector> lowerBoundsOnIntercepts() {
        return this.lowerBoundsOnIntercepts;
    }

    @Override
    public Param<Vector> upperBoundsOnIntercepts() {
        return this.upperBoundsOnIntercepts;
    }

    @Override
    public final void org$apache$spark$ml$classification$LogisticRegressionParams$_setter_$family_$eq(Param<String> x$1) {
        this.family = x$1;
    }

    @Override
    public void org$apache$spark$ml$classification$LogisticRegressionParams$_setter_$lowerBoundsOnCoefficients_$eq(Param<Matrix> x$1) {
        this.lowerBoundsOnCoefficients = x$1;
    }

    @Override
    public void org$apache$spark$ml$classification$LogisticRegressionParams$_setter_$upperBoundsOnCoefficients_$eq(Param<Matrix> x$1) {
        this.upperBoundsOnCoefficients = x$1;
    }

    @Override
    public void org$apache$spark$ml$classification$LogisticRegressionParams$_setter_$lowerBoundsOnIntercepts_$eq(Param<Vector> x$1) {
        this.lowerBoundsOnIntercepts = x$1;
    }

    @Override
    public void org$apache$spark$ml$classification$LogisticRegressionParams$_setter_$upperBoundsOnIntercepts_$eq(Param<Vector> x$1) {
        this.upperBoundsOnIntercepts = x$1;
    }

    @Override
    public final IntParam aggregationDepth() {
        return this.aggregationDepth;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasAggregationDepth$_setter_$aggregationDepth_$eq(IntParam x$1) {
        this.aggregationDepth = x$1;
    }

    @Override
    public DoubleParam threshold() {
        return this.threshold;
    }

    @Override
    public void org$apache$spark$ml$param$shared$HasThreshold$_setter_$threshold_$eq(DoubleParam x$1) {
        this.threshold = x$1;
    }

    @Override
    public final Param<String> weightCol() {
        return this.weightCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasWeightCol$_setter_$weightCol_$eq(Param<String> x$1) {
        this.weightCol = x$1;
    }

    @Override
    public final BooleanParam standardization() {
        return this.standardization;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasStandardization$_setter_$standardization_$eq(BooleanParam x$1) {
        this.standardization = x$1;
    }

    @Override
    public final DoubleParam tol() {
        return this.tol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasTol$_setter_$tol_$eq(DoubleParam x$1) {
        this.tol = x$1;
    }

    @Override
    public final BooleanParam fitIntercept() {
        return this.fitIntercept;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasFitIntercept$_setter_$fitIntercept_$eq(BooleanParam x$1) {
        this.fitIntercept = x$1;
    }

    @Override
    public final IntParam maxIter() {
        return this.maxIter;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasMaxIter$_setter_$maxIter_$eq(IntParam x$1) {
        this.maxIter = x$1;
    }

    @Override
    public final DoubleParam elasticNetParam() {
        return this.elasticNetParam;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasElasticNetParam$_setter_$elasticNetParam_$eq(DoubleParam x$1) {
        this.elasticNetParam = x$1;
    }

    @Override
    public final DoubleParam regParam() {
        return this.regParam;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasRegParam$_setter_$regParam_$eq(DoubleParam x$1) {
        this.regParam = x$1;
    }

    @Override
    public String uid() {
        return this.uid;
    }

    public LogisticRegression setRegParam(double value) {
        return (LogisticRegression)this.set(this.regParam(), BoxesRunTime.boxToDouble((double)value));
    }

    public LogisticRegression setElasticNetParam(double value) {
        return (LogisticRegression)this.set(this.elasticNetParam(), BoxesRunTime.boxToDouble((double)value));
    }

    public LogisticRegression setMaxIter(int value) {
        return (LogisticRegression)this.set(this.maxIter(), BoxesRunTime.boxToInteger((int)value));
    }

    public LogisticRegression setTol(double value) {
        return (LogisticRegression)this.set(this.tol(), BoxesRunTime.boxToDouble((double)value));
    }

    public LogisticRegression setFitIntercept(boolean value) {
        return (LogisticRegression)this.set(this.fitIntercept(), BoxesRunTime.boxToBoolean((boolean)value));
    }

    public LogisticRegression setFamily(String value) {
        return (LogisticRegression)this.set(this.family(), value);
    }

    public LogisticRegression setStandardization(boolean value) {
        return (LogisticRegression)this.set(this.standardization(), BoxesRunTime.boxToBoolean((boolean)value));
    }

    @Override
    public LogisticRegression setThreshold(double value) {
        return (LogisticRegression)LogisticRegressionParams.setThreshold$(this, value);
    }

    @Override
    public double getThreshold() {
        return LogisticRegressionParams.getThreshold$(this);
    }

    public LogisticRegression setWeightCol(String value) {
        return (LogisticRegression)this.set(this.weightCol(), value);
    }

    @Override
    public LogisticRegression setThresholds(double[] value) {
        return (LogisticRegression)LogisticRegressionParams.setThresholds$(this, value);
    }

    @Override
    public double[] getThresholds() {
        return LogisticRegressionParams.getThresholds$(this);
    }

    public LogisticRegression setAggregationDepth(int value) {
        return (LogisticRegression)this.set(this.aggregationDepth(), BoxesRunTime.boxToInteger((int)value));
    }

    public LogisticRegression setLowerBoundsOnCoefficients(Matrix value) {
        return (LogisticRegression)this.set(this.lowerBoundsOnCoefficients(), value);
    }

    public LogisticRegression setUpperBoundsOnCoefficients(Matrix value) {
        return (LogisticRegression)this.set(this.upperBoundsOnCoefficients(), value);
    }

    public LogisticRegression setLowerBoundsOnIntercepts(Vector value) {
        return (LogisticRegression)this.set(this.lowerBoundsOnIntercepts(), value);
    }

    public LogisticRegression setUpperBoundsOnIntercepts(Vector value) {
        return (LogisticRegression)this.set(this.upperBoundsOnIntercepts(), value);
    }

    private void assertBoundConstrainedOptimizationParamsValid(int numCoefficientSets, int numFeatures) {
        block5: {
            if (this.isSet(this.lowerBoundsOnCoefficients())) {
                Predef$.MODULE$.require(this.$(this.lowerBoundsOnCoefficients()).numRows() == numCoefficientSets && this.$(this.lowerBoundsOnCoefficients()).numCols() == numFeatures, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(199).append("The shape of LowerBoundsOnCoefficients must be compatible with (1, number of features) for binomial regression, or (number of classes, number of features) for multinomial regression, but found: ").append("(").append(this.getLowerBoundsOnCoefficients().numRows()).append(", ").append(this.getLowerBoundsOnCoefficients().numCols()).append(").").toString());
            }
            if (this.isSet(this.upperBoundsOnCoefficients())) {
                Predef$.MODULE$.require(this.$(this.upperBoundsOnCoefficients()).numRows() == numCoefficientSets && this.$(this.upperBoundsOnCoefficients()).numCols() == numFeatures, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(199).append("The shape of upperBoundsOnCoefficients must be compatible with (1, number of features) for binomial regression, or (number of classes, number of features) for multinomial regression, but found: ").append("(").append(this.getUpperBoundsOnCoefficients().numRows()).append(", ").append(this.getUpperBoundsOnCoefficients().numCols()).append(").").toString());
            }
            if (this.isSet(this.lowerBoundsOnIntercepts())) {
                Predef$.MODULE$.require(this.$(this.lowerBoundsOnIntercepts()).size() == numCoefficientSets, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(145).append("The size of lowerBoundsOnIntercepts must be equal to 1 for binomial regression, or the number of ").append("classes for multinomial regression, but found: ").append(this.getLowerBoundsOnIntercepts().size()).append(".").toString());
            }
            if (this.isSet(this.upperBoundsOnIntercepts())) {
                Predef$.MODULE$.require(this.$(this.upperBoundsOnIntercepts()).size() == numCoefficientSets, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(145).append("The size of upperBoundsOnIntercepts must be equal to 1 for binomial regression, or the number of ").append("classes for multinomial regression, but found: ").append(this.getUpperBoundsOnIntercepts().size()).append(".").toString());
            }
            if (this.isSet(this.lowerBoundsOnCoefficients()) && this.isSet(this.upperBoundsOnCoefficients())) {
                Predef$.MODULE$.require(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(this.$(this.lowerBoundsOnCoefficients()).toArray())).zip((GenIterable)Predef$.MODULE$.wrapDoubleArray(this.$(this.upperBoundsOnCoefficients()).toArray()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).forall((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)LogisticRegression.$anonfun$assertBoundConstrainedOptimizationParamsValid$5(x))), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(162).append("LowerBoundsOnCoefficients should always be less than or equal to upperBoundsOnCoefficients, but found: ").append("lowerBoundsOnCoefficients = ").append(this.getLowerBoundsOnCoefficients()).append(", ").append("upperBoundsOnCoefficients = ").append(this.getUpperBoundsOnCoefficients()).append(".").toString());
            }
            if (!this.isSet(this.lowerBoundsOnIntercepts()) || !this.isSet(this.upperBoundsOnIntercepts())) break block5;
            Predef$.MODULE$.require(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(this.$(this.lowerBoundsOnIntercepts()).toArray())).zip((GenIterable)Predef$.MODULE$.wrapDoubleArray(this.$(this.upperBoundsOnIntercepts()).toArray()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).forall((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)LogisticRegression.$anonfun$assertBoundConstrainedOptimizationParamsValid$7(x))), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(154).append("LowerBoundsOnIntercepts should always be less than or equal to upperBoundsOnIntercepts, but found: ").append("lowerBoundsOnIntercepts = ").append(this.getLowerBoundsOnIntercepts()).append(", ").append("upperBoundsOnIntercepts = ").append(this.getUpperBoundsOnIntercepts()).append(".").toString());
        }
    }

    private Option<LogisticRegressionModel> optInitialModel() {
        return this.optInitialModel;
    }

    private void optInitialModel_$eq(Option<LogisticRegressionModel> x$1) {
        this.optInitialModel = x$1;
    }

    public LogisticRegression setInitialModel(LogisticRegressionModel model) {
        this.optInitialModel_$eq((Option<LogisticRegressionModel>)new Some((Object)model));
        return this;
    }

    @Override
    public LogisticRegressionModel train(Dataset<?> dataset) {
        StorageLevel storageLevel = dataset.storageLevel();
        StorageLevel storageLevel2 = StorageLevel$.MODULE$.NONE();
        boolean handlePersistence = !(storageLevel != null ? !storageLevel.equals(storageLevel2) : storageLevel2 != null);
        return this.train(dataset, handlePersistence);
    }

    public LogisticRegressionModel train(Dataset<?> dataset, boolean handlePersistence) {
        return (LogisticRegressionModel)Instrumentation$.MODULE$.instrumented((Function1 & Serializable & scala.Serializable)instr -> {
            Tuple3 tuple3;
            Tuple3 tuple32;
            boolean isConstantLabel;
            int numCoefficientSets;
            boolean bl;
            int n;
            RDD<Instance> instances = this.extractInstances(dataset);
            Object object = handlePersistence ? instances.persist(StorageLevel$.MODULE$.MEMORY_AND_DISK()) : BoxedUnit.UNIT;
            instr.logPipelineStage(this);
            instr.logDataset(dataset);
            instr.logParams(this, (Seq<Param<?>>)Predef$.MODULE$.wrapRefArray((Object[])new Param[]{this.labelCol(), this.weightCol(), this.featuresCol(), this.predictionCol(), this.rawPredictionCol(), this.probabilityCol(), this.regParam(), this.elasticNetParam(), this.standardization(), this.threshold(), this.maxIter(), this.tol(), this.fitIntercept()}));
            Tuple2 tuple2 = (Tuple2)instances.treeAggregate((Object)new Tuple2((Object)Summarizer$.MODULE$.createSummarizerBuffer((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"mean", "std", "count"})), (Object)new MultiClassSummarizer()), (Function2 & Serializable & scala.Serializable)(c, instance) -> new Tuple2((Object)((SummarizerBuffer)c._1()).add(instance.features(), instance.weight()), (Object)((MultiClassSummarizer)c._2()).add(instance.label(), instance.weight())), (Function2 & Serializable & scala.Serializable)(c1, c2) -> new Tuple2((Object)((SummarizerBuffer)c1._1()).merge((SummarizerBuffer)c2._1()), (Object)((MultiClassSummarizer)c1._2()).merge((MultiClassSummarizer)c2._2())), BoxesRunTime.unboxToInt((Object)this.$(this.aggregationDepth())), ClassTag$.MODULE$.apply(Tuple2.class));
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            SummarizerBuffer summarizer = (SummarizerBuffer)tuple2._1();
            MultiClassSummarizer labelSummarizer = (MultiClassSummarizer)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)summarizer, (Object)labelSummarizer);
            Tuple2 tuple23 = tuple22;
            SummarizerBuffer summarizer2 = (SummarizerBuffer)tuple23._1();
            MultiClassSummarizer labelSummarizer2 = (MultiClassSummarizer)tuple23._2();
            instr.logNumExamples(summarizer2.count());
            instr.logNamedValue("lowestLabelWeight", new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(labelSummarizer2.histogram())).min((Ordering)Ordering.Double$.MODULE$).toString());
            instr.logNamedValue("highestLabelWeight", new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(labelSummarizer2.histogram())).max((Ordering)Ordering.Double$.MODULE$).toString());
            instr.logSumOfWeights(summarizer2.weightSum());
            double[] histogram = labelSummarizer2.histogram();
            long numInvalid = labelSummarizer2.countInvalid();
            int numFeatures = summarizer2.mean().size();
            int numFeaturesPlusIntercept = this.getFitIntercept() ? numFeatures + 1 : numFeatures;
            Option<Object> option = MetadataUtils$.MODULE$.getNumClasses(dataset.schema().apply(this.$(this.labelCol())));
            if (option instanceof Some) {
                Some some = (Some)option;
                int n2 = BoxesRunTime.unboxToInt((Object)some.value());
                int n3 = n2;
                Predef$.MODULE$.require(n3 >= histogram.length, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(72).append("Specified number of classes ").append(n3).append(" was ").append("less than the number of unique labels ").append(histogram.length).append(".").toString());
                n = n3;
            } else if (None$.MODULE$.equals(option)) {
                n = histogram.length;
            } else {
                throw new MatchError(option);
            }
            int numClasses = n;
            String string = this.getFamily().toLowerCase(Locale.ROOT);
            if ("binomial".equals(string)) {
                Predef$.MODULE$.require(numClasses == 1 || numClasses == 2, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(64).append("Binomial family only supports 1 or 2 ").append("outcome classes but found ").append(numClasses).append(".").toString());
                bl = false;
            } else if ("multinomial".equals(string)) {
                bl = true;
            } else if ("auto".equals(string)) {
                bl = numClasses > 2;
            } else {
                throw new IllegalArgumentException(new StringBuilder(20).append("Unsupported family: ").append(string).toString());
            }
            boolean isMultinomial = bl;
            int n4 = numCoefficientSets = isMultinomial ? numClasses : 1;
            if (this.usingBoundConstrainedOptimization()) {
                this.assertBoundConstrainedOptimizationParamsValid(numCoefficientSets, numFeatures);
            }
            if (this.isDefined(this.thresholds())) {
                Predef$.MODULE$.require(this.$(this.thresholds()).length == numClasses, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(107).append(this.getClass().getSimpleName()).append(".train() called with non-matching numClasses and thresholds.length.").append(" numClasses=").append(numClasses).append(", but thresholds has length ").append(this.$(this.thresholds()).length).toString());
            }
            instr.logNumClasses(numClasses);
            instr.logNumFeatures(numFeatures);
            if (numInvalid != 0L) {
                String msg = new StringBuilder(66).append("Classification labels should be in [0 to ").append(numClasses - 1).append("]. ").append("Found ").append(numInvalid).append(" invalid labels.").toString();
                instr.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> msg);
                throw new SparkException(msg);
            }
            boolean bl2 = isConstantLabel = new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(histogram)).count((Function1)(JFunction1.mcZD.sp & Serializable & scala.Serializable)x$2 -> x$2 != 0.0) == 1;
            if (BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept())) && isConstantLabel && !this.usingBoundConstrainedOptimization()) {
                instr.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(111).append("All labels are the same value and fitIntercept=true, so the ").append("coefficients will be zeros. Training is not needed.").toString());
                int constantLabelIndex = Vectors$.MODULE$.dense(histogram).argmax();
                Matrix coefMatrix = new SparseMatrix(numCoefficientSets, numFeatures, new int[numCoefficientSets + 1], Array$.MODULE$.emptyIntArray(), Array$.MODULE$.emptyDoubleArray(), true).compressed();
                Vector interceptVec = isMultinomial ? Vectors$.MODULE$.sparse(numClasses, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcID.sp(constantLabelIndex, Double.POSITIVE_INFINITY)}))) : Vectors$.MODULE$.dense(numClasses == 2 ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]));
                tuple32 = new Tuple3((Object)coefMatrix, (Object)interceptVec, (Object)Array$.MODULE$.emptyDoubleArray());
            } else {
                boolean bl3;
                Object object2;
                Tuple2 tuple24;
                Tuple2 tuple25;
                None$ none$;
                if (!BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept())) && isConstantLabel) {
                    instr.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(119).append("All labels belong to a single class and fitIntercept=false. It's a ").append("dangerous ground, so the algorithm may not converge.").toString());
                }
                double[] featuresMean = summarizer2.mean().toArray();
                double[] featuresStd = summarizer2.std().toArray();
                if (!BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept())) && RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numFeatures).exists((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)i -> featuresStd[i] == 0.0 && featuresMean[i] != 0.0)) {
                    instr.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Fitting LogisticRegressionModel without intercept on dataset with constant nonzero column, Spark MLlib outputs zero coefficients for constant nonzero columns. This behavior is the same as R glmnet but different from LIBSVM.");
                }
                double regParamL1 = BoxesRunTime.unboxToDouble((Object)this.$(this.elasticNetParam())) * BoxesRunTime.unboxToDouble((Object)this.$(this.regParam()));
                double regParamL2 = (1.0 - BoxesRunTime.unboxToDouble((Object)this.$(this.elasticNetParam()))) * BoxesRunTime.unboxToDouble((Object)this.$(this.regParam()));
                Broadcast bcFeaturesStd = instances.context().broadcast((Object)featuresStd, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)));
                Function1 & Serializable & scala.Serializable getAggregatorFunc = (Function1 & Serializable & scala.Serializable)x$3 -> new LogisticAggregator((Broadcast<double[]>)bcFeaturesStd, numClasses, BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept())), isMultinomial, (Broadcast<Vector>)x$3);
                JFunction1.mcDI.sp & Serializable & scala.Serializable getFeaturesStd = (JFunction1.mcDI.sp & Serializable & scala.Serializable)j -> j >= 0 && j < numCoefficientSets * numFeatures ? featuresStd[j / numCoefficientSets] : 0.0;
                if (regParamL2 != 0.0) {
                    JFunction1.mcZI.sp & Serializable & scala.Serializable shouldApply = (JFunction1.mcZI.sp & Serializable & scala.Serializable)idx -> idx >= 0 && idx < numFeatures * numCoefficientSets;
                    none$ = new Some((Object)new L2Regularization(regParamL2, (Function1<Object, Object>)shouldApply, (Option<Function1<Object, Object>>)(BoxesRunTime.unboxToBoolean((Object)this.$(this.standardization())) ? None$.MODULE$ : new Some((Object)getFeaturesStd))));
                } else {
                    none$ = None$.MODULE$;
                }
                None$ regularization = none$;
                RDDLossFunction costFun = new RDDLossFunction(instances, getAggregatorFunc, (Option<DifferentiableRegularization<Vector>>)regularization, BoxesRunTime.unboxToInt((Object)this.$(this.aggregationDepth())), ClassTag$.MODULE$.apply(Instance.class), ClassTag$.MODULE$.apply(LogisticAggregator.class));
                int numCoeffsPlusIntercepts = numFeaturesPlusIntercept * numCoefficientSets;
                if (this.usingBoundConstrainedOptimization()) {
                    double[] lowerBounds = (double[])Array$.MODULE$.fill(numCoeffsPlusIntercepts, (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> Double.NEGATIVE_INFINITY, ClassTag$.MODULE$.Double());
                    double[] upperBounds = (double[])Array$.MODULE$.fill(numCoeffsPlusIntercepts, (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> Double.POSITIVE_INFINITY, ClassTag$.MODULE$.Double());
                    boolean isSetLowerBoundsOnCoefficients = this.isSet(this.lowerBoundsOnCoefficients());
                    boolean isSetUpperBoundsOnCoefficients = this.isSet(this.upperBoundsOnCoefficients());
                    boolean isSetLowerBoundsOnIntercepts = this.isSet(this.lowerBoundsOnIntercepts());
                    boolean isSetUpperBoundsOnIntercepts = this.isSet(this.upperBoundsOnIntercepts());
                    for (int i2 = 0; i2 < numCoeffsPlusIntercepts; ++i2) {
                        int coefficientSetIndex = i2 % numCoefficientSets;
                        int featureIndex2 = i2 / numCoefficientSets;
                        if (featureIndex2 < numFeatures) {
                            if (isSetLowerBoundsOnCoefficients) {
                                lowerBounds[i2] = this.$(this.lowerBoundsOnCoefficients()).apply(coefficientSetIndex, featureIndex2) * featuresStd[featureIndex2];
                            }
                            if (!isSetUpperBoundsOnCoefficients) continue;
                            upperBounds[i2] = this.$(this.upperBoundsOnCoefficients()).apply(coefficientSetIndex, featureIndex2) * featuresStd[featureIndex2];
                            continue;
                        }
                        if (isSetLowerBoundsOnIntercepts) {
                            lowerBounds[i2] = this.$(this.lowerBoundsOnIntercepts()).apply(coefficientSetIndex);
                        }
                        if (!isSetUpperBoundsOnIntercepts) continue;
                        upperBounds[i2] = this.$(this.upperBoundsOnIntercepts()).apply(coefficientSetIndex);
                    }
                    tuple25 = new Tuple2((Object)lowerBounds, (Object)upperBounds);
                } else {
                    tuple25 = tuple24 = new Tuple2(null, null);
                }
                if (tuple24 == null) {
                    throw new MatchError((Object)tuple24);
                }
                double[] lowerBounds = (double[])tuple24._1();
                double[] upperBounds = (double[])tuple24._2();
                Tuple2 tuple26 = new Tuple2((Object)lowerBounds, (Object)upperBounds);
                Tuple2 tuple27 = tuple26;
                double[] lowerBounds2 = (double[])tuple27._1();
                double[] upperBounds2 = (double[])tuple27._2();
                if (BoxesRunTime.unboxToDouble((Object)this.$(this.elasticNetParam())) == 0.0 || BoxesRunTime.unboxToDouble((Object)this.$(this.regParam())) == 0.0) {
                    object2 = lowerBounds2 != null && upperBounds2 != null ? new LBFGSB(DenseVector$.MODULE$.apply((Object)lowerBounds2), DenseVector$.MODULE$.apply((Object)upperBounds2), BoxesRunTime.unboxToInt((Object)this.$(this.maxIter())), 10, BoxesRunTime.unboxToDouble((Object)this.$(this.tol())), LBFGSB$.MODULE$.$lessinit$greater$default$6(), LBFGSB$.MODULE$.$lessinit$greater$default$7()) : new LBFGS(BoxesRunTime.unboxToInt((Object)this.$(this.maxIter())), 10, BoxesRunTime.unboxToDouble((Object)this.$(this.tol())), (MutableInnerProductModule)DenseVector$.MODULE$.space_Double());
                } else {
                    boolean standardizationParam = BoxesRunTime.unboxToBoolean((Object)this.$(this.standardization()));
                    object2 = new OWLQN(BoxesRunTime.unboxToInt((Object)this.$(this.maxIter())), 10, this.regParamL1Fun$1(numFeatures, numCoefficientSets, standardizationParam, regParamL1, featuresStd), BoxesRunTime.unboxToDouble((Object)this.$(this.tol())), (MutableEnumeratedCoordinateField)DenseVector$.MODULE$.space_Double());
                }
                LBFGS optimizer = object2;
                Matrix initialCoefWithInterceptMatrix = Matrices$.MODULE$.zeros(numCoefficientSets, numFeaturesPlusIntercept);
                Option<LogisticRegressionModel> option2 = this.optInitialModel();
                if (option2 instanceof Some) {
                    boolean modelIsValid;
                    Some some = (Some)option2;
                    LogisticRegressionModel _initialModel = (LogisticRegressionModel)some.value();
                    Matrix providedCoefs = _initialModel.coefficientMatrix();
                    boolean bl4 = modelIsValid = providedCoefs.numRows() == numCoefficientSets && providedCoefs.numCols() == numFeatures && _initialModel.interceptVector().size() == numCoefficientSets && _initialModel.getFitIntercept() == BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept()));
                    if (!modelIsValid) {
                        instr.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(94).append("Initial coefficients will be ignored! Its dimensions ").append("(").append(providedCoefs.numRows()).append(", ").append(providedCoefs.numCols()).append(") did not match the ").append("expected size (").append(numCoefficientSets).append(", ").append(numFeatures).append(")").toString());
                    }
                    bl3 = modelIsValid;
                } else if (None$.MODULE$.equals(option2)) {
                    bl3 = false;
                } else {
                    throw new MatchError(option2);
                }
                boolean initialModelIsValid = bl3;
                if (initialModelIsValid) {
                    Matrix providedCoef = ((LogisticRegressionModel)this.optInitialModel().get()).coefficientMatrix();
                    providedCoef.foreachActive((Function3 & Serializable & scala.Serializable)(classIndex, featureIndex, value) -> {
                        initialCoefWithInterceptMatrix.update(BoxesRunTime.unboxToInt((Object)classIndex), BoxesRunTime.unboxToInt((Object)featureIndex), BoxesRunTime.unboxToDouble((Object)value) * featuresStd[BoxesRunTime.unboxToInt((Object)featureIndex)]);
                        return BoxedUnit.UNIT;
                    });
                    if (BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept()))) {
                        ((LogisticRegressionModel)this.optInitialModel().get()).interceptVector().foreachNonZero((Function2)(JFunction2.mcVID.sp & Serializable & scala.Serializable)(classIndex, value) -> initialCoefWithInterceptMatrix.update(classIndex, numFeatures, value));
                    }
                } else if (BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept())) && isMultinomial) {
                    double[] rawIntercepts = (double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(histogram)).map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)x -> package$.MODULE$.log1p(x), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
                    double rawMean = BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(rawIntercepts)).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)) / (double)rawIntercepts.length;
                    new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(rawIntercepts)).indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> initialCoefWithInterceptMatrix.update(i, numFeatures, rawIntercepts[i] - rawMean));
                } else if (BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept()))) {
                    initialCoefWithInterceptMatrix.update(0, numFeatures, package$.MODULE$.log(histogram[1] / histogram[0]));
                }
                if (this.usingBoundConstrainedOptimization()) {
                    for (int i3 = 0; i3 < numCoeffsPlusIntercepts; ++i3) {
                        int coefficientSetIndex = i3 % numCoefficientSets;
                        int featureIndex3 = i3 / numCoefficientSets;
                        if (initialCoefWithInterceptMatrix.apply(coefficientSetIndex, featureIndex3) < lowerBounds2[i3]) {
                            initialCoefWithInterceptMatrix.update(coefficientSetIndex, featureIndex3, lowerBounds2[i3]);
                            continue;
                        }
                        if (!(initialCoefWithInterceptMatrix.apply(coefficientSetIndex, featureIndex3) > upperBounds2[i3])) continue;
                        initialCoefWithInterceptMatrix.update(coefficientSetIndex, featureIndex3, upperBounds2[i3]);
                    }
                }
                Iterator states = optimizer.iterations((StochasticDiffFunction)new CachedDiffFunction(costFun, DenseVector$.MODULE$.canCopyDenseVector(ClassTag$.MODULE$.Double())), (Object)new DenseVector.mcD.sp(initialCoefWithInterceptMatrix.toArray()));
                ArrayBuilder arrayBuilder = ArrayBuilder$.MODULE$.make(ClassTag$.MODULE$.Double());
                FirstOrderMinimizer.State state = null;
                while (states.hasNext()) {
                    state = (FirstOrderMinimizer.State)states.next();
                    arrayBuilder.$plus$eq((Object)BoxesRunTime.boxToDouble((double)state.adjustedValue()));
                }
                bcFeaturesStd.destroy();
                if (state == null) {
                    String msg = new StringBuilder(8).append(optimizer.getClass().getName()).append(" failed.").toString();
                    instr.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> msg);
                    throw new SparkException(msg);
                }
                double[] allCoefficients = (double[])((DenseVector)state.x()).toArray$mcD$sp(ClassTag$.MODULE$.Double()).clone();
                DenseMatrix allCoefMatrix = new DenseMatrix(numCoefficientSets, numFeaturesPlusIntercept, allCoefficients);
                DenseMatrix denseCoefficientMatrix = new DenseMatrix(numCoefficientSets, numFeatures, new double[numCoefficientSets * numFeatures], true);
                Vector interceptVec = BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept())) || !isMultinomial ? Vectors$.MODULE$.zeros(numCoefficientSets) : Vectors$.MODULE$.sparse(numCoefficientSets, (Seq)Seq$.MODULE$.empty());
                allCoefMatrix.foreachActive((Function3 & Serializable & scala.Serializable)(classIndex, featureIndex, value) -> {
                    LogisticRegression.$anonfun$train$25(this, numFeatures, featuresStd, denseCoefficientMatrix, interceptVec, BoxesRunTime.unboxToInt((Object)classIndex), BoxesRunTime.unboxToInt((Object)featureIndex), BoxesRunTime.unboxToDouble((Object)value));
                    return BoxedUnit.UNIT;
                });
                if (BoxesRunTime.unboxToDouble((Object)this.$(this.regParam())) == 0.0 && isMultinomial && !this.usingBoundConstrainedOptimization()) {
                    double[] centers = (double[])Array$.MODULE$.ofDim(numFeatures, ClassTag$.MODULE$.Double());
                    denseCoefficientMatrix.foreachActive((Function3 & Serializable & scala.Serializable)(x0$1, x1$1, x2$1) -> {
                        LogisticRegression.$anonfun$train$26(centers, BoxesRunTime.unboxToInt((Object)x0$1), BoxesRunTime.unboxToInt((Object)x1$1), BoxesRunTime.unboxToDouble((Object)x2$1));
                        return BoxedUnit.UNIT;
                    });
                    Predef$.MODULE$.wrapDoubleArray(centers).transform((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)x$5 -> x$5 / (double)numCoefficientSets);
                    denseCoefficientMatrix.foreachActive((Function3 & Serializable & scala.Serializable)(x0$2, x1$2, x2$2) -> {
                        LogisticRegression.$anonfun$train$28(denseCoefficientMatrix, centers, BoxesRunTime.unboxToInt((Object)x0$2), BoxesRunTime.unboxToInt((Object)x1$2), BoxesRunTime.unboxToDouble((Object)x2$2));
                        return BoxedUnit.UNIT;
                    });
                }
                if (BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept())) && isMultinomial && !this.usingBoundConstrainedOptimization()) {
                    double[] interceptArray = interceptVec.toArray();
                    double interceptMean = BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(interceptArray)).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)) / (double)interceptArray.length;
                    RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), interceptVec.size()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                        interceptArray$1[i] = interceptArray[i] - interceptMean;
                    });
                }
                tuple32 = tuple3 = new Tuple3((Object)denseCoefficientMatrix.compressed(), (Object)interceptVec.compressed(), arrayBuilder.result());
            }
            if (tuple3 == null) {
                throw new MatchError((Object)tuple3);
            }
            Matrix coefficientMatrix = (Matrix)tuple3._1();
            Vector interceptVector = (Vector)tuple3._2();
            double[] objectiveHistory = (double[])tuple3._3();
            Tuple3 tuple33 = new Tuple3((Object)coefficientMatrix, (Object)interceptVector, (Object)objectiveHistory);
            Tuple3 tuple34 = tuple33;
            Matrix coefficientMatrix2 = (Matrix)tuple34._1();
            Vector interceptVector2 = (Vector)tuple34._2();
            double[] objectiveHistory2 = (double[])tuple34._3();
            Object object3 = handlePersistence ? instances.unpersist(instances.unpersist$default$1()) : BoxedUnit.UNIT;
            LogisticRegressionModel model = this.copyValues(new LogisticRegressionModel(this.uid(), coefficientMatrix2, interceptVector2, numClasses, isMultinomial), this.copyValues$default$2());
            Tuple3<LogisticRegressionModel, String, String> tuple35 = model.findSummaryModel();
            if (tuple35 == null) {
                throw new MatchError(tuple35);
            }
            LogisticRegressionModel summaryModel = (LogisticRegressionModel)tuple35._1();
            String probabilityColName = (String)tuple35._2();
            String predictionColName = (String)tuple35._3();
            Tuple3 tuple36 = new Tuple3((Object)summaryModel, (Object)probabilityColName, (Object)predictionColName);
            Tuple3 tuple37 = tuple36;
            LogisticRegressionModel summaryModel2 = (LogisticRegressionModel)tuple37._1();
            String probabilityColName2 = (String)tuple37._2();
            String predictionColName2 = (String)tuple37._3();
            LogisticRegressionSummaryImpl logRegSummary = numClasses <= 2 ? new BinaryLogisticRegressionTrainingSummaryImpl(summaryModel2.transform(dataset), probabilityColName2, predictionColName2, this.$(this.labelCol()), this.$(this.featuresCol()), objectiveHistory2) : new LogisticRegressionTrainingSummaryImpl(summaryModel2.transform(dataset), probabilityColName2, predictionColName2, this.$(this.labelCol()), this.$(this.featuresCol()), objectiveHistory2);
            return (LogisticRegressionModel)model.setSummary((Option<LogisticRegressionTrainingSummary>)new Some((Object)logRegSummary));
        });
    }

    @Override
    public LogisticRegression copy(ParamMap extra) {
        return (LogisticRegression)this.defaultCopy(extra);
    }

    public static final /* synthetic */ boolean $anonfun$assertBoundConstrainedOptimizationParamsValid$5(Tuple2 x) {
        return x._1$mcD$sp() <= x._2$mcD$sp();
    }

    public static final /* synthetic */ boolean $anonfun$assertBoundConstrainedOptimizationParamsValid$7(Tuple2 x) {
        return x._1$mcD$sp() <= x._2$mcD$sp();
    }

    private final Function1 regParamL1Fun$1(int numFeatures$1, int numCoefficientSets$1, boolean standardizationParam$1, double regParamL1$1, double[] featuresStd$1) {
        return (JFunction1.mcDI.sp & Serializable & scala.Serializable)index -> {
            int featureIndex;
            boolean isIntercept;
            boolean bl = isIntercept = BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept())) && index >= numFeatures$1 * numCoefficientSets$1;
            return isIntercept ? 0.0 : (standardizationParam$1 ? regParamL1$1 : (featuresStd$1[featureIndex = index / numCoefficientSets$1] != 0.0 ? regParamL1$1 / featuresStd$1[featureIndex] : 0.0));
        };
    }

    public static final /* synthetic */ void $anonfun$train$25(LogisticRegression $this, int numFeatures$1, double[] featuresStd$1, DenseMatrix denseCoefficientMatrix$1, Vector interceptVec$1, int classIndex, int featureIndex, double value) {
        block1: {
            boolean isIntercept;
            boolean bl = isIntercept = BoxesRunTime.unboxToBoolean((Object)$this.$($this.fitIntercept())) && featureIndex == numFeatures$1;
            if (!isIntercept && featuresStd$1[featureIndex] != 0.0) {
                denseCoefficientMatrix$1.update(classIndex, featureIndex, value / featuresStd$1[featureIndex]);
            }
            if (!isIntercept) break block1;
            interceptVec$1.toArray()[classIndex] = value;
        }
    }

    public static final /* synthetic */ void $anonfun$train$26(double[] centers$1, int x0$1, int x1$1, double x2$1) {
        Tuple3 tuple3 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)x0$1), (Object)BoxesRunTime.boxToInteger((int)x1$1), (Object)BoxesRunTime.boxToDouble((double)x2$1));
        if (tuple3 == null) {
            throw new MatchError((Object)tuple3);
        }
        int j = BoxesRunTime.unboxToInt((Object)tuple3._2());
        double v = BoxesRunTime.unboxToDouble((Object)tuple3._3());
        centers$1[j] = centers$1[j] + v;
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$train$28(DenseMatrix denseCoefficientMatrix$1, double[] centers$1, int x0$2, int x1$2, double x2$2) {
        Tuple3 tuple3 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)x0$2), (Object)BoxesRunTime.boxToInteger((int)x1$2), (Object)BoxesRunTime.boxToDouble((double)x2$2));
        if (tuple3 == null) {
            throw new MatchError((Object)tuple3);
        }
        int i = BoxesRunTime.unboxToInt((Object)tuple3._1());
        int j = BoxesRunTime.unboxToInt((Object)tuple3._2());
        double v = BoxesRunTime.unboxToDouble((Object)tuple3._3());
        denseCoefficientMatrix$1.update(i, j, v - centers$1[j]);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public LogisticRegression(String uid) {
        this.uid = uid;
        HasRegParam.$init$(this);
        HasElasticNetParam.$init$(this);
        HasMaxIter.$init$(this);
        HasFitIntercept.$init$(this);
        HasTol.$init$(this);
        HasStandardization.$init$(this);
        HasWeightCol.$init$(this);
        HasThreshold.$init$(this);
        HasAggregationDepth.$init$(this);
        LogisticRegressionParams.$init$(this);
        MLWritable.$init$(this);
        DefaultParamsWritable.$init$(this);
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.regParam().$minus$greater(BoxesRunTime.boxToDouble((double)0.0))}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.elasticNetParam().$minus$greater(BoxesRunTime.boxToDouble((double)0.0))}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.maxIter().$minus$greater(BoxesRunTime.boxToInteger((int)100))}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.tol().$minus$greater(BoxesRunTime.boxToDouble((double)1.0E-6))}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.fitIntercept().$minus$greater(BoxesRunTime.boxToBoolean((boolean)true))}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.family().$minus$greater("auto")}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.standardization().$minus$greater(BoxesRunTime.boxToBoolean((boolean)true))}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.threshold().$minus$greater(BoxesRunTime.boxToDouble((double)0.5))}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.aggregationDepth().$minus$greater(BoxesRunTime.boxToInteger((int)2))}));
        this.optInitialModel = None$.MODULE$;
    }

    public LogisticRegression() {
        this(Identifiable$.MODULE$.randomUID("logreg"));
    }
}

