/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.classification;

import java.io.IOException;
import java.io.Serializable;
import org.apache.spark.ml.classification.FMClassificationModel;
import org.apache.spark.ml.classification.FMClassifier$;
import org.apache.spark.ml.classification.FMClassifierParams;
import org.apache.spark.ml.classification.ProbabilisticClassifier;
import org.apache.spark.ml.feature.LabeledPoint;
import org.apache.spark.ml.linalg.Matrix;
import org.apache.spark.ml.param.BooleanParam;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.LongParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.ParamPair;
import org.apache.spark.ml.param.shared.HasFitIntercept;
import org.apache.spark.ml.param.shared.HasMaxIter;
import org.apache.spark.ml.param.shared.HasRegParam;
import org.apache.spark.ml.param.shared.HasSeed;
import org.apache.spark.ml.param.shared.HasSolver;
import org.apache.spark.ml.param.shared.HasStepSize;
import org.apache.spark.ml.param.shared.HasTol;
import org.apache.spark.ml.regression.FactorizationMachines;
import org.apache.spark.ml.regression.FactorizationMachines$;
import org.apache.spark.ml.regression.FactorizationMachinesParams;
import org.apache.spark.ml.util.DefaultParamsWritable;
import org.apache.spark.ml.util.Identifiable$;
import org.apache.spark.ml.util.Instrumentation$;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.ml.util.MetadataUtils$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.VectorImplicits$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001dg\u0001B\f\u0019\u0001\rB\u0001b\u0012\u0001\u0003\u0006\u0004%\t\u0005\u0013\u0005\t?\u0002\u0011\t\u0011)A\u0005\u0013\")\u0011\r\u0001C\u0001E\")\u0011\r\u0001C\u0001M\")\u0001\u000e\u0001C\u0001S\")!\u000f\u0001C\u0001g\")\u0011\u0010\u0001C\u0001u\")Q\u0010\u0001C\u0001}\"9\u0011\u0011\u0002\u0001\u0005\u0002\u0005-\u0001bBA\t\u0001\u0011\u0005\u00111\u0003\u0005\b\u00033\u0001A\u0011AA\u000e\u0011\u001d\t\t\u0003\u0001C\u0001\u0003GAq!!\u000b\u0001\t\u0003\tY\u0003C\u0004\u00022\u0001!\t!a\r\t\u000f\u0005e\u0002\u0001\"\u0001\u0002<!9\u0011q\t\u0001\u0005R\u0005%\u0003bBA:\u0001\u0011\u0005\u0013QO\u0004\b\u0003\u0017C\u0002\u0012AAG\r\u00199\u0002\u0004#\u0001\u0002\u0010\"1\u0011m\u0005C\u0001\u0003GCq!!*\u0014\t\u0003\n9\u000bC\u0005\u00020N\t\t\u0011\"\u0003\u00022\naa)T\"mCN\u001c\u0018NZ5fe*\u0011\u0011DG\u0001\u000fG2\f7o]5gS\u000e\fG/[8o\u0015\tYB$\u0001\u0002nY*\u0011QDH\u0001\u0006gB\f'o\u001b\u0006\u0003?\u0001\na!\u00199bG\",'\"A\u0011\u0002\u0007=\u0014xm\u0001\u0001\u0014\r\u0001!#\u0007O\u001eB!\u0015)c\u0005\u000b\u00180\u001b\u0005A\u0012BA\u0014\u0019\u0005]\u0001&o\u001c2bE&d\u0017n\u001d;jG\u000ec\u0017m]:jM&,'\u000f\u0005\u0002*Y5\t!F\u0003\u0002,5\u00051A.\u001b8bY\u001eL!!\f\u0016\u0003\rY+7\r^8s!\t)\u0003\u0001\u0005\u0002&a%\u0011\u0011\u0007\u0007\u0002\u0016\r6\u001bE.Y:tS\u001aL7-\u0019;j_:lu\u000eZ3m!\t\u0019d'D\u00015\u0015\t)$$\u0001\u0006sK\u001e\u0014Xm]:j_:L!a\u000e\u001b\u0003+\u0019\u000b7\r^8sSj\fG/[8o\u001b\u0006\u001c\u0007.\u001b8fgB\u0011Q%O\u0005\u0003ua\u0011!CR'DY\u0006\u001c8/\u001b4jKJ\u0004\u0016M]1ngB\u0011AhP\u0007\u0002{)\u0011aHG\u0001\u0005kRLG.\u0003\u0002A{\t)B)\u001a4bk2$\b+\u0019:b[N<&/\u001b;bE2,\u0007C\u0001\"F\u001b\u0005\u0019%B\u0001#\u001d\u0003!Ig\u000e^3s]\u0006d\u0017B\u0001$D\u0005\u001daunZ4j]\u001e\f1!^5e+\u0005I\u0005C\u0001&T\u001d\tY\u0015\u000b\u0005\u0002M\u001f6\tQJ\u0003\u0002OE\u00051AH]8pizR\u0011\u0001U\u0001\u0006g\u000e\fG.Y\u0005\u0003%>\u000ba\u0001\u0015:fI\u00164\u0017B\u0001+V\u0005\u0019\u0019FO]5oO*\u0011!k\u0014\u0015\u0004\u0003]k\u0006C\u0001-\\\u001b\u0005I&B\u0001.\u001d\u0003)\tgN\\8uCRLwN\\\u0005\u00039f\u0013QaU5oG\u0016\f\u0013AX\u0001\u0006g9\u0002d\u0006M\u0001\u0005k&$\u0007\u0005K\u0002\u0003/v\u000ba\u0001P5oSRtDC\u0001\u0018d\u0011\u001595\u00011\u0001JQ\r\u0019w+\u0018\u0015\u0004\u0007]kF#\u0001\u0018)\u0007\u00119V,A\u0007tKR4\u0015m\u0019;peNK'0\u001a\u000b\u0003U.l\u0011\u0001\u0001\u0005\u0006Y\u0016\u0001\r!\\\u0001\u0006m\u0006dW/\u001a\t\u0003]>l\u0011aT\u0005\u0003a>\u00131!\u00138uQ\r)q+X\u0001\u0010g\u0016$h)\u001b;J]R,'oY3qiR\u0011!\u000e\u001e\u0005\u0006Y\u001a\u0001\r!\u001e\t\u0003]ZL!a^(\u0003\u000f\t{w\u000e\\3b]\"\u001aaaV/\u0002\u0019M,GOR5u\u0019&tW-\u0019:\u0015\u0005)\\\b\"\u00027\b\u0001\u0004)\bfA\u0004X;\u0006Y1/\u001a;SK\u001e\u0004\u0016M]1n)\tQw\u0010\u0003\u0004m\u0011\u0001\u0007\u0011\u0011\u0001\t\u0004]\u0006\r\u0011bAA\u0003\u001f\n1Ai\\;cY\u0016D3\u0001C,^\u0003Q\u0019X\r^'j]&\u0014\u0015\r^2i\rJ\f7\r^5p]R\u0019!.!\u0004\t\r1L\u0001\u0019AA\u0001Q\rIq+X\u0001\u000bg\u0016$\u0018J\\5u'R$Gc\u00016\u0002\u0016!1AN\u0003a\u0001\u0003\u0003A3AC,^\u0003)\u0019X\r^'bq&#XM\u001d\u000b\u0004U\u0006u\u0001\"\u00027\f\u0001\u0004i\u0007fA\u0006X;\u0006Y1/\u001a;Ti\u0016\u00048+\u001b>f)\rQ\u0017Q\u0005\u0005\u0007Y2\u0001\r!!\u0001)\u000719V,\u0001\u0004tKR$v\u000e\u001c\u000b\u0004U\u00065\u0002B\u00027\u000e\u0001\u0004\t\t\u0001K\u0002\u000e/v\u000b\u0011b]3u'>dg/\u001a:\u0015\u0007)\f)\u0004C\u0003m\u001d\u0001\u0007\u0011\nK\u0002\u000f/v\u000bqa]3u'\u0016,G\rF\u0002k\u0003{Aa\u0001\\\bA\u0002\u0005}\u0002c\u00018\u0002B%\u0019\u00111I(\u0003\t1{gn\u001a\u0015\u0004\u001f]k\u0016!\u0002;sC&tGcA\u0018\u0002L!9\u0011Q\n\tA\u0002\u0005=\u0013a\u00023bi\u0006\u001cX\r\u001e\u0019\u0005\u0003#\n\t\u0007\u0005\u0004\u0002T\u0005e\u0013QL\u0007\u0003\u0003+R1!a\u0016\u001d\u0003\r\u0019\u0018\u000f\\\u0005\u0005\u00037\n)FA\u0004ECR\f7/\u001a;\u0011\t\u0005}\u0013\u0011\r\u0007\u0001\t1\t\u0019'a\u0013\u0002\u0002\u0003\u0005)\u0011AA3\u0005\ryF%M\t\u0005\u0003O\ni\u0007E\u0002o\u0003SJ1!a\u001bP\u0005\u001dqu\u000e\u001e5j]\u001e\u00042A\\A8\u0013\r\t\th\u0014\u0002\u0004\u0003:L\u0018\u0001B2paf$2ALA<\u0011\u001d\tI(\u0005a\u0001\u0003w\nQ!\u001a=ue\u0006\u0004B!! \u0002\u00046\u0011\u0011q\u0010\u0006\u0004\u0003\u0003S\u0012!\u00029be\u0006l\u0017\u0002BAC\u0003\u007f\u0012\u0001\u0002U1sC6l\u0015\r\u001d\u0015\u0004#]k\u0006f\u0001\u0001X;\u0006aa)T\"mCN\u001c\u0018NZ5feB\u0011QeE\n\b'\u0005E\u0015qSAO!\rq\u00171S\u0005\u0004\u0003+{%AB!osJ+g\r\u0005\u0003=\u00033s\u0013bAAN{\t)B)\u001a4bk2$\b+\u0019:b[N\u0014V-\u00193bE2,\u0007c\u00018\u0002 &\u0019\u0011\u0011U(\u0003\u0019M+'/[1mSj\f'\r\\3\u0015\u0005\u00055\u0015\u0001\u00027pC\u0012$2ALAU\u0011\u0019\tY+\u0006a\u0001\u0013\u0006!\u0001/\u0019;iQ\r)r+X\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u00024B!\u0011QWA`\u001b\t\t9L\u0003\u0003\u0002:\u0006m\u0016\u0001\u00027b]\u001eT!!!0\u0002\t)\fg/Y\u0005\u0005\u0003\u0003\f9L\u0001\u0004PE*,7\r\u001e\u0015\u0004']k\u0006f\u0001\nX;\u0002")
public class FMClassifier
extends ProbabilisticClassifier<org.apache.spark.ml.linalg.Vector, FMClassifier, FMClassificationModel>
implements FactorizationMachines,
FMClassifierParams,
DefaultParamsWritable {
    private final String uid;
    private final IntParam factorSize;
    private final BooleanParam fitLinear;
    private final DoubleParam miniBatchFraction;
    private final DoubleParam initStd;
    private final Param<String> solver;
    private final DoubleParam regParam;
    private final BooleanParam fitIntercept;
    private final LongParam seed;
    private final DoubleParam tol;
    private final DoubleParam stepSize;
    private final IntParam maxIter;

    public static FMClassifier load(String string) {
        return FMClassifier$.MODULE$.load(string);
    }

    public static MLReader<FMClassifier> read() {
        return FMClassifier$.MODULE$.read();
    }

    @Override
    public MLWriter write() {
        return DefaultParamsWritable.write$(this);
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable.save$(this, path);
    }

    @Override
    public Vector initCoefficients(int numFeatures) {
        return FactorizationMachines.initCoefficients$(this, numFeatures);
    }

    @Override
    public org.apache.spark.ml.linalg.Vector trainImpl(RDD<Tuple2<Object, Vector>> data, int numFeatures, String loss) {
        return FactorizationMachines.trainImpl$(this, data, numFeatures, loss);
    }

    @Override
    public final int getFactorSize() {
        return FactorizationMachinesParams.getFactorSize$(this);
    }

    @Override
    public final boolean getFitLinear() {
        return FactorizationMachinesParams.getFitLinear$(this);
    }

    @Override
    public final double getMiniBatchFraction() {
        return FactorizationMachinesParams.getMiniBatchFraction$(this);
    }

    @Override
    public final double getInitStd() {
        return FactorizationMachinesParams.getInitStd$(this);
    }

    @Override
    public final double getRegParam() {
        return HasRegParam.getRegParam$(this);
    }

    @Override
    public final boolean getFitIntercept() {
        return HasFitIntercept.getFitIntercept$(this);
    }

    @Override
    public final long getSeed() {
        return HasSeed.getSeed$(this);
    }

    @Override
    public final String getSolver() {
        return HasSolver.getSolver$(this);
    }

    @Override
    public final double getTol() {
        return HasTol.getTol$(this);
    }

    @Override
    public final double getStepSize() {
        return HasStepSize.getStepSize$(this);
    }

    @Override
    public final int getMaxIter() {
        return HasMaxIter.getMaxIter$(this);
    }

    @Override
    public final IntParam factorSize() {
        return this.factorSize;
    }

    @Override
    public final BooleanParam fitLinear() {
        return this.fitLinear;
    }

    @Override
    public final DoubleParam miniBatchFraction() {
        return this.miniBatchFraction;
    }

    @Override
    public final DoubleParam initStd() {
        return this.initStd;
    }

    @Override
    public final Param<String> solver() {
        return this.solver;
    }

    @Override
    public final void org$apache$spark$ml$regression$FactorizationMachinesParams$_setter_$factorSize_$eq(IntParam x$1) {
        this.factorSize = x$1;
    }

    @Override
    public final void org$apache$spark$ml$regression$FactorizationMachinesParams$_setter_$fitLinear_$eq(BooleanParam x$1) {
        this.fitLinear = x$1;
    }

    @Override
    public final void org$apache$spark$ml$regression$FactorizationMachinesParams$_setter_$miniBatchFraction_$eq(DoubleParam x$1) {
        this.miniBatchFraction = x$1;
    }

    @Override
    public final void org$apache$spark$ml$regression$FactorizationMachinesParams$_setter_$initStd_$eq(DoubleParam x$1) {
        this.initStd = x$1;
    }

    @Override
    public final void org$apache$spark$ml$regression$FactorizationMachinesParams$_setter_$solver_$eq(Param<String> x$1) {
        this.solver = x$1;
    }

    @Override
    public final DoubleParam regParam() {
        return this.regParam;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasRegParam$_setter_$regParam_$eq(DoubleParam x$1) {
        this.regParam = x$1;
    }

    @Override
    public final BooleanParam fitIntercept() {
        return this.fitIntercept;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasFitIntercept$_setter_$fitIntercept_$eq(BooleanParam x$1) {
        this.fitIntercept = x$1;
    }

    @Override
    public final LongParam seed() {
        return this.seed;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasSeed$_setter_$seed_$eq(LongParam x$1) {
        this.seed = x$1;
    }

    @Override
    public void org$apache$spark$ml$param$shared$HasSolver$_setter_$solver_$eq(Param<String> x$1) {
    }

    @Override
    public final DoubleParam tol() {
        return this.tol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasTol$_setter_$tol_$eq(DoubleParam x$1) {
        this.tol = x$1;
    }

    @Override
    public DoubleParam stepSize() {
        return this.stepSize;
    }

    @Override
    public void org$apache$spark$ml$param$shared$HasStepSize$_setter_$stepSize_$eq(DoubleParam x$1) {
        this.stepSize = x$1;
    }

    @Override
    public final IntParam maxIter() {
        return this.maxIter;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasMaxIter$_setter_$maxIter_$eq(IntParam x$1) {
        this.maxIter = x$1;
    }

    @Override
    public String uid() {
        return this.uid;
    }

    public FMClassifier setFactorSize(int value) {
        return (FMClassifier)this.set(this.factorSize(), BoxesRunTime.boxToInteger((int)value));
    }

    public FMClassifier setFitIntercept(boolean value) {
        return (FMClassifier)this.set(this.fitIntercept(), BoxesRunTime.boxToBoolean((boolean)value));
    }

    public FMClassifier setFitLinear(boolean value) {
        return (FMClassifier)this.set(this.fitLinear(), BoxesRunTime.boxToBoolean((boolean)value));
    }

    public FMClassifier setRegParam(double value) {
        return (FMClassifier)this.set(this.regParam(), BoxesRunTime.boxToDouble((double)value));
    }

    public FMClassifier setMiniBatchFraction(double value) {
        return (FMClassifier)this.set(this.miniBatchFraction(), BoxesRunTime.boxToDouble((double)value));
    }

    public FMClassifier setInitStd(double value) {
        return (FMClassifier)this.set(this.initStd(), BoxesRunTime.boxToDouble((double)value));
    }

    public FMClassifier setMaxIter(int value) {
        return (FMClassifier)this.set(this.maxIter(), BoxesRunTime.boxToInteger((int)value));
    }

    public FMClassifier setStepSize(double value) {
        return (FMClassifier)this.set(this.stepSize(), BoxesRunTime.boxToDouble((double)value));
    }

    public FMClassifier setTol(double value) {
        return (FMClassifier)this.set(this.tol(), BoxesRunTime.boxToDouble((double)value));
    }

    public FMClassifier setSolver(String value) {
        return (FMClassifier)this.set(this.solver(), value);
    }

    public FMClassifier setSeed(long value) {
        return (FMClassifier)this.set(this.seed(), BoxesRunTime.boxToLong((long)value));
    }

    @Override
    public FMClassificationModel train(Dataset<?> dataset) {
        return (FMClassificationModel)Instrumentation$.MODULE$.instrumented((Function1 & Serializable & scala.Serializable)instr -> {
            int numClasses = 2;
            if (this.isDefined(this.thresholds())) {
                Predef$.MODULE$.require(this.$(this.thresholds()).length == numClasses, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(107).append(this.getClass().getSimpleName()).append(".train() called with non-matching numClasses and thresholds.length.").append(" numClasses=").append(numClasses).append(", but thresholds has length ").append(this.$(this.thresholds()).length).toString());
            }
            instr.logPipelineStage(this);
            instr.logDataset(dataset);
            instr.logParams(this, (Seq<Param<?>>)Predef$.MODULE$.wrapRefArray((Object[])new Param[]{this.factorSize(), this.fitIntercept(), this.fitLinear(), this.regParam(), this.miniBatchFraction(), this.initStd(), this.maxIter(), this.stepSize(), this.tol(), this.solver()}));
            instr.logNumClasses(numClasses);
            int numFeatures = MetadataUtils$.MODULE$.getNumFeatures(dataset, this.$(this.featuresCol()));
            instr.logNumFeatures(numFeatures);
            StorageLevel storageLevel = dataset.storageLevel();
            StorageLevel storageLevel2 = StorageLevel$.MODULE$.NONE();
            boolean handlePersistence = !(storageLevel != null ? !storageLevel.equals(storageLevel2) : storageLevel2 != null);
            RDD<LabeledPoint> labeledPoint = this.extractLabeledPoints(dataset, numClasses);
            RDD data = labeledPoint.map((Function1 & Serializable & scala.Serializable)x -> new Tuple2((Object)BoxesRunTime.boxToDouble((double)x.label()), (Object)VectorImplicits$.MODULE$.mlVectorToMLlibVector(x.features())), ClassTag$.MODULE$.apply(Tuple2.class));
            Object object = handlePersistence ? data.persist(StorageLevel$.MODULE$.MEMORY_AND_DISK()) : BoxedUnit.UNIT;
            org.apache.spark.ml.linalg.Vector coefficients = this.trainImpl((RDD<Tuple2<Object, Vector>>)data, numFeatures, FactorizationMachines$.MODULE$.LogisticLoss());
            Tuple3<Object, org.apache.spark.ml.linalg.Vector, Matrix> tuple3 = FactorizationMachines$.MODULE$.splitCoefficients(coefficients, numFeatures, BoxesRunTime.unboxToInt((Object)this.$(this.factorSize())), BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept())), BoxesRunTime.unboxToBoolean((Object)this.$(this.fitLinear())));
            if (tuple3 == null) {
                throw new MatchError(tuple3);
            }
            double intercept = BoxesRunTime.unboxToDouble((Object)tuple3._1());
            org.apache.spark.ml.linalg.Vector linear = (org.apache.spark.ml.linalg.Vector)tuple3._2();
            Matrix factors = (Matrix)tuple3._3();
            Tuple3 tuple32 = new Tuple3((Object)BoxesRunTime.boxToDouble((double)intercept), (Object)linear, (Object)factors);
            Tuple3 tuple33 = tuple32;
            double intercept2 = BoxesRunTime.unboxToDouble((Object)tuple33._1());
            org.apache.spark.ml.linalg.Vector linear2 = (org.apache.spark.ml.linalg.Vector)tuple33._2();
            Matrix factors2 = (Matrix)tuple33._3();
            Object object2 = handlePersistence ? data.unpersist(data.unpersist$default$1()) : BoxedUnit.UNIT;
            return this.copyValues(new FMClassificationModel(this.uid(), intercept2, linear2, factors2), this.copyValues$default$2());
        });
    }

    @Override
    public FMClassifier copy(ParamMap extra) {
        return (FMClassifier)this.defaultCopy(extra);
    }

    public FMClassifier(String uid) {
        this.uid = uid;
        HasMaxIter.$init$(this);
        HasStepSize.$init$(this);
        HasTol.$init$(this);
        HasSolver.$init$(this);
        HasSeed.$init$(this);
        HasFitIntercept.$init$(this);
        HasRegParam.$init$(this);
        FactorizationMachinesParams.$init$(this);
        FactorizationMachines.$init$(this);
        MLWritable.$init$(this);
        DefaultParamsWritable.$init$(this);
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.factorSize().$minus$greater(BoxesRunTime.boxToInteger((int)8))}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.fitIntercept().$minus$greater(BoxesRunTime.boxToBoolean((boolean)true))}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.fitLinear().$minus$greater(BoxesRunTime.boxToBoolean((boolean)true))}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.regParam().$minus$greater(BoxesRunTime.boxToDouble((double)0.0))}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.miniBatchFraction().$minus$greater(BoxesRunTime.boxToDouble((double)1.0))}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.initStd().$minus$greater(BoxesRunTime.boxToDouble((double)0.01))}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.maxIter().$minus$greater(BoxesRunTime.boxToInteger((int)100))}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.stepSize().$minus$greater(BoxesRunTime.boxToDouble((double)1.0))}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.tol().$minus$greater(BoxesRunTime.boxToDouble((double)1.0E-6))}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.solver().$minus$greater(FactorizationMachines$.MODULE$.AdamW())}));
    }

    public FMClassifier() {
        this(Identifiable$.MODULE$.randomUID("fmc"));
    }
}

