/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.sql.common.extractor;

import java.util.Collection;
import java.util.LinkedList;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.routine.RoutineBodySegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.routine.ValidStatementSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.assignment.AssignmentSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.combine.CombineSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.BetweenExpression;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.BinaryOperationExpression;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.ExistsSubqueryExpression;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.InExpression;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.ListExpression;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.subquery.SubqueryExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.AggregationProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.ColumnProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.ProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.ProjectionsSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.SubqueryProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.order.item.ColumnOrderByItemSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.order.item.OrderByItemSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.predicate.LockSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.OwnerAvailable;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.OwnerSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.DeleteMultiTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.JoinTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.SubqueryTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.TableNameSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.TableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.ddl.CreateTableStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.ddl.CreateViewStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.DeleteStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.InsertStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.SelectStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.UpdateStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.handler.ddl.CreateTableStatementHandler;
import org.apache.shardingsphere.sql.parser.sql.dialect.handler.dml.InsertStatementHandler;
import org.apache.shardingsphere.sql.parser.sql.dialect.handler.dml.SelectStatementHandler;

public final class TableExtractor {
    private final Collection<SimpleTableSegment> rewriteTables = new LinkedList<SimpleTableSegment>();
    private final Collection<TableSegment> tableContext = new LinkedList<TableSegment>();

    public void extractTablesFromSelect(SelectStatement selectStatement) {
        if (selectStatement.getCombine().isPresent()) {
            CombineSegment combineSegment = selectStatement.getCombine().get();
            this.extractTablesFromSelect(combineSegment.getLeft());
            this.extractTablesFromSelect(combineSegment.getRight());
        }
        if (null != selectStatement.getFrom() && !selectStatement.getCombine().isPresent()) {
            this.extractTablesFromTableSegment(selectStatement.getFrom());
        }
        if (selectStatement.getWhere().isPresent()) {
            this.extractTablesFromExpression(selectStatement.getWhere().get().getExpr());
        }
        if (null != selectStatement.getProjections()) {
            this.extractTablesFromProjections(selectStatement.getProjections());
        }
        if (selectStatement.getGroupBy().isPresent()) {
            this.extractTablesFromOrderByItems(selectStatement.getGroupBy().get().getGroupByItems());
        }
        if (selectStatement.getOrderBy().isPresent()) {
            this.extractTablesFromOrderByItems(selectStatement.getOrderBy().get().getOrderByItems());
        }
        Optional<LockSegment> lockSegment = SelectStatementHandler.getLockSegment(selectStatement);
        lockSegment.ifPresent(this::extractTablesFromLock);
    }

    private void extractTablesFromTableSegment(TableSegment tableSegment) {
        if (tableSegment instanceof SimpleTableSegment) {
            this.tableContext.add(tableSegment);
            this.rewriteTables.add((SimpleTableSegment)tableSegment);
        }
        if (tableSegment instanceof SubqueryTableSegment) {
            this.tableContext.add(tableSegment);
            TableExtractor tableExtractor = new TableExtractor();
            tableExtractor.extractTablesFromSelect(((SubqueryTableSegment)tableSegment).getSubquery().getSelect());
            this.rewriteTables.addAll(tableExtractor.rewriteTables);
        }
        if (tableSegment instanceof JoinTableSegment) {
            this.extractTablesFromJoinTableSegment((JoinTableSegment)tableSegment);
        }
        if (tableSegment instanceof DeleteMultiTableSegment) {
            DeleteMultiTableSegment deleteMultiTableSegment = (DeleteMultiTableSegment)tableSegment;
            this.rewriteTables.addAll(deleteMultiTableSegment.getActualDeleteTables());
            this.extractTablesFromTableSegment(deleteMultiTableSegment.getRelationTable());
        }
    }

    private void extractTablesFromJoinTableSegment(JoinTableSegment tableSegment) {
        this.extractTablesFromTableSegment(tableSegment.getLeft());
        this.extractTablesFromTableSegment(tableSegment.getRight());
        this.extractTablesFromExpression(tableSegment.getCondition());
    }

    private void extractTablesFromExpression(ExpressionSegment expressionSegment) {
        if (expressionSegment instanceof ColumnSegment && ((ColumnSegment)expressionSegment).getOwner().isPresent() && this.needRewrite(((ColumnSegment)expressionSegment).getOwner().get())) {
            OwnerSegment ownerSegment = ((ColumnSegment)expressionSegment).getOwner().get();
            this.rewriteTables.add(new SimpleTableSegment(new TableNameSegment(ownerSegment.getStartIndex(), ownerSegment.getStopIndex(), ownerSegment.getIdentifier())));
        }
        if (expressionSegment instanceof ListExpression) {
            for (ExpressionSegment each : ((ListExpression)expressionSegment).getItems()) {
                this.extractTablesFromExpression(each);
            }
        }
        if (expressionSegment instanceof ExistsSubqueryExpression) {
            this.extractTablesFromSelect(((ExistsSubqueryExpression)expressionSegment).getSubquery().getSelect());
        }
        if (expressionSegment instanceof BetweenExpression) {
            this.extractTablesFromExpression(((BetweenExpression)expressionSegment).getLeft());
            this.extractTablesFromExpression(((BetweenExpression)expressionSegment).getBetweenExpr());
            this.extractTablesFromExpression(((BetweenExpression)expressionSegment).getAndExpr());
        }
        if (expressionSegment instanceof InExpression) {
            this.extractTablesFromExpression(((InExpression)expressionSegment).getLeft());
            this.extractTablesFromExpression(((InExpression)expressionSegment).getRight());
        }
        if (expressionSegment instanceof SubqueryExpressionSegment) {
            this.extractTablesFromSelect(((SubqueryExpressionSegment)expressionSegment).getSubquery().getSelect());
        }
        if (expressionSegment instanceof BinaryOperationExpression) {
            this.extractTablesFromExpression(((BinaryOperationExpression)expressionSegment).getLeft());
            this.extractTablesFromExpression(((BinaryOperationExpression)expressionSegment).getRight());
        }
    }

    private void extractTablesFromProjections(ProjectionsSegment projections) {
        for (ProjectionSegment each : projections.getProjections()) {
            OwnerSegment ownerSegment;
            if (each instanceof SubqueryProjectionSegment) {
                this.extractTablesFromSelect(((SubqueryProjectionSegment)each).getSubquery().getSelect());
                continue;
            }
            if (each instanceof OwnerAvailable) {
                if (!((OwnerAvailable)((Object)each)).getOwner().isPresent() || !this.needRewrite(((OwnerAvailable)((Object)each)).getOwner().get())) continue;
                ownerSegment = ((OwnerAvailable)((Object)each)).getOwner().get();
                this.rewriteTables.add(this.createSimpleTableSegment(ownerSegment));
                continue;
            }
            if (each instanceof ColumnProjectionSegment) {
                if (!((ColumnProjectionSegment)each).getColumn().getOwner().isPresent() || !this.needRewrite(((ColumnProjectionSegment)each).getColumn().getOwner().get())) continue;
                ownerSegment = ((ColumnProjectionSegment)each).getColumn().getOwner().get();
                this.rewriteTables.add(this.createSimpleTableSegment(ownerSegment));
                continue;
            }
            if (!(each instanceof AggregationProjectionSegment)) continue;
            ((AggregationProjectionSegment)each).getParameters().forEach(this::extractTablesFromExpression);
        }
    }

    private SimpleTableSegment createSimpleTableSegment(OwnerSegment ownerSegment) {
        SimpleTableSegment result = new SimpleTableSegment(new TableNameSegment(ownerSegment.getStartIndex(), ownerSegment.getStopIndex(), ownerSegment.getIdentifier()));
        ownerSegment.getOwner().ifPresent(result::setOwner);
        return result;
    }

    private void extractTablesFromOrderByItems(Collection<OrderByItemSegment> orderByItems) {
        for (OrderByItemSegment each : orderByItems) {
            Optional<OwnerSegment> owner;
            if (!(each instanceof ColumnOrderByItemSegment) || !(owner = ((ColumnOrderByItemSegment)each).getColumn().getOwner()).isPresent() || !this.needRewrite(owner.get())) continue;
            this.rewriteTables.add(new SimpleTableSegment(new TableNameSegment(owner.get().getStartIndex(), owner.get().getStopIndex(), owner.get().getIdentifier())));
        }
    }

    private void extractTablesFromLock(LockSegment lockSegment) {
        this.rewriteTables.addAll(lockSegment.getTables());
    }

    public void extractTablesFromDelete(DeleteStatement deleteStatement) {
        this.extractTablesFromTableSegment(deleteStatement.getTable());
        if (deleteStatement.getWhere().isPresent()) {
            this.extractTablesFromExpression(deleteStatement.getWhere().get().getExpr());
        }
    }

    public void extractTablesFromInsert(InsertStatement insertStatement) {
        if (null != insertStatement.getTable()) {
            this.extractTablesFromTableSegment(insertStatement.getTable());
        }
        if (!insertStatement.getColumns().isEmpty()) {
            for (ColumnSegment each : insertStatement.getColumns()) {
                this.extractTablesFromExpression(each);
            }
        }
        InsertStatementHandler.getOnDuplicateKeyColumnsSegment(insertStatement).ifPresent(optional -> this.extractTablesFromAssignmentItems(optional.getColumns()));
        if (insertStatement.getInsertSelect().isPresent()) {
            this.extractTablesFromSelect(insertStatement.getInsertSelect().get().getSelect());
        }
    }

    private void extractTablesFromAssignmentItems(Collection<AssignmentSegment> assignmentItems) {
        assignmentItems.forEach(each -> this.extractTablesFromColumnSegments(each.getColumns()));
    }

    private void extractTablesFromColumnSegments(Collection<ColumnSegment> columnSegments) {
        columnSegments.forEach(each -> {
            if (each.getOwner().isPresent() && this.needRewrite(each.getOwner().get())) {
                OwnerSegment ownerSegment = each.getOwner().get();
                this.rewriteTables.add(new SimpleTableSegment(new TableNameSegment(ownerSegment.getStartIndex(), ownerSegment.getStopIndex(), ownerSegment.getIdentifier())));
            }
        });
    }

    public void extractTablesFromUpdate(UpdateStatement updateStatement) {
        this.extractTablesFromTableSegment(updateStatement.getTable());
        updateStatement.getSetAssignment().getAssignments().forEach(each -> this.extractTablesFromExpression(each.getColumns().get(0)));
        if (updateStatement.getWhere().isPresent()) {
            this.extractTablesFromExpression(updateStatement.getWhere().get().getExpr());
        }
    }

    public boolean needRewrite(OwnerSegment owner) {
        for (TableSegment each : this.tableContext) {
            if (!owner.getIdentifier().getValue().equalsIgnoreCase(each.getAlias().orElse(null))) continue;
            return false;
        }
        return true;
    }

    public Collection<SimpleTableSegment> extractExistTableFromRoutineBody(RoutineBodySegment routineBody) {
        LinkedList<SimpleTableSegment> result = new LinkedList<SimpleTableSegment>();
        for (ValidStatementSegment each : routineBody.getValidStatements()) {
            if (each.getAlterTable().isPresent()) {
                result.add(each.getAlterTable().get().getTable());
            }
            if (each.getDropTable().isPresent()) {
                result.addAll(each.getDropTable().get().getTables());
            }
            if (each.getTruncate().isPresent()) {
                result.addAll(each.getTruncate().get().getTables());
            }
            result.addAll(this.extractExistTableFromDMLStatement(each));
        }
        return result;
    }

    private Collection<SimpleTableSegment> extractExistTableFromDMLStatement(ValidStatementSegment validStatementSegment) {
        if (validStatementSegment.getInsert().isPresent()) {
            this.extractTablesFromInsert(validStatementSegment.getInsert().get());
        } else if (validStatementSegment.getReplace().isPresent()) {
            this.extractTablesFromInsert(validStatementSegment.getReplace().get());
        } else if (validStatementSegment.getUpdate().isPresent()) {
            this.extractTablesFromUpdate(validStatementSegment.getUpdate().get());
        } else if (validStatementSegment.getDelete().isPresent()) {
            this.extractTablesFromDelete(validStatementSegment.getDelete().get());
        } else if (validStatementSegment.getSelect().isPresent()) {
            this.extractTablesFromSelect(validStatementSegment.getSelect().get());
        }
        return this.rewriteTables;
    }

    public Collection<SimpleTableSegment> extractNotExistTableFromRoutineBody(RoutineBodySegment routineBody) {
        LinkedList<SimpleTableSegment> result = new LinkedList<SimpleTableSegment>();
        for (ValidStatementSegment each : routineBody.getValidStatements()) {
            Optional<CreateTableStatement> createTable = each.getCreateTable();
            if (!createTable.isPresent() || CreateTableStatementHandler.ifNotExists(createTable.get())) continue;
            result.add(createTable.get().getTable());
        }
        return result;
    }

    public void extractTablesFromSQLStatement(SQLStatement sqlStatement) {
        if (sqlStatement instanceof SelectStatement) {
            this.extractTablesFromSelect((SelectStatement)sqlStatement);
        } else if (sqlStatement instanceof InsertStatement) {
            this.extractTablesFromInsert((InsertStatement)sqlStatement);
        } else if (sqlStatement instanceof UpdateStatement) {
            this.extractTablesFromUpdate((UpdateStatement)sqlStatement);
        } else if (sqlStatement instanceof DeleteStatement) {
            this.extractTablesFromDelete((DeleteStatement)sqlStatement);
        }
    }

    public void extractTablesFromCreateViewStatement(CreateViewStatement createViewStatement) {
        this.tableContext.add(createViewStatement.getView());
        this.rewriteTables.add(createViewStatement.getView());
        this.extractTablesFromSelect(createViewStatement.getSelect());
    }

    @Generated
    public Collection<SimpleTableSegment> getRewriteTables() {
        return this.rewriteTables;
    }

    @Generated
    public Collection<TableSegment> getTableContext() {
        return this.tableContext;
    }
}

