/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.util.yaml.constructor;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import org.apache.shardingsphere.infra.util.spi.ShardingSphereServiceLoader;
import org.apache.shardingsphere.infra.util.yaml.constructor.ShardingSphereYamlConstruct;
import org.apache.shardingsphere.infra.util.yaml.shortcuts.ShardingSphereYamlShortcuts;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.TypeDescription;
import org.yaml.snakeyaml.constructor.Construct;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.nodes.Node;

public class ShardingSphereYamlConstructor
extends Constructor {
    private final Map<Class<?>, Construct> typeConstructs = new HashMap();
    private final Class<?> rootClass;

    public ShardingSphereYamlConstructor(Class<?> rootClass) {
        super(rootClass, new LoaderOptions(){
            {
                this.setCodePointLimit(Integer.MAX_VALUE);
            }
        });
        ShardingSphereServiceLoader.getServiceInstances(ShardingSphereYamlConstruct.class).forEach(each -> this.typeConstructs.put(each.getType(), (Construct)each));
        HashMap<String, Class> yamlShortcuts = new HashMap<String, Class>();
        ShardingSphereServiceLoader.getServiceInstances(ShardingSphereYamlShortcuts.class).stream().map(ShardingSphereYamlShortcuts::getYamlShortcuts).forEach(yamlShortcuts::putAll);
        yamlShortcuts.forEach((key, value) -> this.addTypeDescription(new TypeDescription(value, key)));
        this.rootClass = rootClass;
    }

    protected final Construct getConstructor(Node node) {
        return this.typeConstructs.getOrDefault(node.getType(), super.getConstructor(node));
    }

    protected Class<?> getClassForName(String className) throws ClassNotFoundException {
        Preconditions.checkArgument((boolean)className.equals(this.rootClass.getName()), (String)"Class `%s` is not accepted", (Object)className);
        return super.getClassForName(className);
    }
}

