/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.util.spi.type.typed;

import java.util.Optional;
import java.util.Properties;
import java.util.function.BiConsumer;
import lombok.Generated;
import org.apache.shardingsphere.infra.util.spi.ShardingSphereServiceLoader;
import org.apache.shardingsphere.infra.util.spi.exception.ServiceProviderNotFoundServerException;
import org.apache.shardingsphere.infra.util.spi.type.typed.TypedSPI;

public final class TypedSPILoader {
    public static <T extends TypedSPI> boolean contains(Class<T> spiClass, String type) {
        return ShardingSphereServiceLoader.getServiceInstances(spiClass).stream().anyMatch(each -> TypedSPILoader.matchesType(type, each));
    }

    public static <T extends TypedSPI> Optional<T> findService(Class<T> spiClass, String type) {
        return TypedSPILoader.findService(spiClass, type, new Properties());
    }

    public static <T extends TypedSPI> Optional<T> findService(Class<T> spiClass, String type, Properties props) {
        if (null == type) {
            return TypedSPILoader.findService(spiClass);
        }
        for (TypedSPI each : ShardingSphereServiceLoader.getServiceInstances(spiClass)) {
            if (!TypedSPILoader.matchesType(type, each)) continue;
            each.init(null == props ? new Properties() : TypedSPILoader.convertToStringTypedProperties(props));
            return Optional.of(each);
        }
        return TypedSPILoader.findService(spiClass);
    }

    private static <T extends TypedSPI> Optional<T> findService(Class<T> spiClass) {
        for (TypedSPI each : ShardingSphereServiceLoader.getServiceInstances(spiClass)) {
            if (!each.isDefault()) continue;
            each.init(new Properties());
            return Optional.of(each);
        }
        return Optional.empty();
    }

    private static boolean matchesType(String type, TypedSPI instance) {
        return instance.getType().equalsIgnoreCase(type) || instance.getTypeAliases().contains(type);
    }

    private static Properties convertToStringTypedProperties(Properties props) {
        if (props.isEmpty()) {
            return props;
        }
        Properties result = new Properties();
        props.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> result.setProperty(key.toString(), null == value ? null : value.toString())));
        return result;
    }

    public static <T extends TypedSPI> T getService(Class<T> spiClass, String type) {
        return TypedSPILoader.getService(spiClass, type, new Properties());
    }

    public static <T extends TypedSPI> T getService(Class<T> spiClass, String type, Properties props) {
        return (T)TypedSPILoader.findService(spiClass, type, props).orElseGet(() -> (TypedSPI)TypedSPILoader.findService(spiClass).orElseThrow(() -> new ServiceProviderNotFoundServerException(spiClass)));
    }

    @Generated
    private TypedSPILoader() {
    }
}

