/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.util.retry;

import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.Function;
import lombok.Generated;

public final class RetryExecutor {
    private final long timeoutMillis;
    private final long intervalMillis;
    private long expendMillis;

    public <T> boolean execute(Function<T, Boolean> function, T arg) {
        do {
            if (!function.apply(arg).booleanValue()) continue;
            return true;
        } while (!this.isTimeout());
        return false;
    }

    public <T, U> boolean execute(BiFunction<T, U, Boolean> function, T arg1, U arg2) {
        do {
            if (!function.apply(arg1, arg2).booleanValue()) continue;
            return true;
        } while (!this.isTimeout());
        return false;
    }

    private boolean isTimeout() {
        TimeUnit.MILLISECONDS.sleep(this.intervalMillis);
        if (-1L == this.timeoutMillis) {
            return false;
        }
        this.expendMillis += this.intervalMillis;
        return this.expendMillis > this.timeoutMillis;
    }

    @Generated
    public RetryExecutor(long timeoutMillis, long intervalMillis) {
        this.timeoutMillis = timeoutMillis;
        this.intervalMillis = intervalMillis;
    }
}

