/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.executor.sql.process.model;

import java.sql.Statement;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import lombok.Generated;
import org.apache.shardingsphere.infra.executor.kernel.model.ExecutionGroup;
import org.apache.shardingsphere.infra.executor.kernel.model.ExecutionGroupContext;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.SQLExecutionUnit;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutionUnit;
import org.apache.shardingsphere.infra.executor.sql.process.model.ExecuteProcessStatusEnum;
import org.apache.shardingsphere.infra.executor.sql.process.model.ExecuteProcessUnit;
import org.apache.shardingsphere.infra.metadata.user.Grantee;

public final class ExecuteProcessContext {
    private final String executionID;
    private final String databaseName;
    private final String username;
    private final String hostname;
    private String sql;
    private final Map<String, ExecuteProcessUnit> processUnits = new HashMap<String, ExecuteProcessUnit>();
    private final Collection<Statement> processStatements = new LinkedList<Statement>();
    private long startTimeMillis = System.currentTimeMillis();
    private ExecuteProcessStatusEnum processStatus;
    private final boolean proxyContext;

    public ExecuteProcessContext(String sql, ExecutionGroupContext<? extends SQLExecutionUnit> executionGroupContext, ExecuteProcessStatusEnum processStatus, boolean isProxyContext) {
        this.executionID = executionGroupContext.getReportContext().getExecutionID();
        this.sql = sql;
        this.databaseName = executionGroupContext.getReportContext().getDatabaseName();
        Grantee grantee = executionGroupContext.getReportContext().getGrantee();
        this.username = null != grantee ? grantee.getUsername() : null;
        this.hostname = null != grantee ? grantee.getHostname() : null;
        this.processStatus = processStatus;
        this.addProcessUnitsAndStatements(executionGroupContext, processStatus);
        this.proxyContext = isProxyContext;
    }

    private void addProcessUnitsAndStatements(ExecutionGroupContext<? extends SQLExecutionUnit> executionGroupContext, ExecuteProcessStatusEnum processStatus) {
        for (ExecutionGroup<? extends SQLExecutionUnit> each : executionGroupContext.getInputGroups()) {
            for (SQLExecutionUnit sQLExecutionUnit : each.getInputs()) {
                ExecuteProcessUnit processUnit = new ExecuteProcessUnit(sQLExecutionUnit.getExecutionUnit(), processStatus);
                this.processUnits.put(processUnit.getUnitID(), processUnit);
                if (!(sQLExecutionUnit instanceof JDBCExecutionUnit)) continue;
                this.processStatements.add(((JDBCExecutionUnit)sQLExecutionUnit).getStorageResource());
            }
        }
    }

    public void resetExecuteProcessContextToSleep() {
        this.sql = "";
        this.startTimeMillis = System.currentTimeMillis();
        this.processStatus = ExecuteProcessStatusEnum.SLEEP;
    }

    @Generated
    public String getExecutionID() {
        return this.executionID;
    }

    @Generated
    public String getDatabaseName() {
        return this.databaseName;
    }

    @Generated
    public String getUsername() {
        return this.username;
    }

    @Generated
    public String getHostname() {
        return this.hostname;
    }

    @Generated
    public String getSql() {
        return this.sql;
    }

    @Generated
    public Map<String, ExecuteProcessUnit> getProcessUnits() {
        return this.processUnits;
    }

    @Generated
    public Collection<Statement> getProcessStatements() {
        return this.processStatements;
    }

    @Generated
    public long getStartTimeMillis() {
        return this.startTimeMillis;
    }

    @Generated
    public ExecuteProcessStatusEnum getProcessStatus() {
        return this.processStatus;
    }

    @Generated
    public boolean isProxyContext() {
        return this.proxyContext;
    }
}

