/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.executor.sql.execute.result.query.impl.driver.jdbc.type.memory.loader.dialect;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.impl.driver.jdbc.type.memory.loader.AbstractQueryResultDataRowLoader;

public final class MySQLQueryResultDataRowLoader
extends AbstractQueryResultDataRowLoader {
    private static final String YEAR_DATA_TYPE = "YEAR";

    @Override
    protected Object getSmallintValue(ResultSet resultSet, int columnIndex) throws SQLException {
        return resultSet.getInt(columnIndex);
    }

    @Override
    protected Object getDateValue(ResultSet resultSet, int columnIndex) throws SQLException {
        if (MySQLQueryResultDataRowLoader.isYearDataType(resultSet.getMetaData().getColumnTypeName(columnIndex))) {
            Object result = resultSet.getObject(columnIndex);
            return resultSet.wasNull() ? null : result;
        }
        return resultSet.getDate(columnIndex);
    }

    private static boolean isYearDataType(String columnDataTypeName) {
        return YEAR_DATA_TYPE.equalsIgnoreCase(columnDataTypeName);
    }

    public String getType() {
        return "MySQL";
    }
}

