/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.binder.segment.table;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.TreeSet;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.segment.select.projection.impl.ColumnProjection;
import org.apache.shardingsphere.infra.binder.segment.select.subquery.SubqueryTableContext;
import org.apache.shardingsphere.infra.binder.segment.select.subquery.engine.SubqueryTableContextEngine;
import org.apache.shardingsphere.infra.binder.statement.dml.SelectStatementContext;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.database.type.dialect.OpenGaussDatabaseType;
import org.apache.shardingsphere.infra.database.type.dialect.PostgreSQLDatabaseType;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereSchema;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.OwnerSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.SubqueryTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.TableSegment;

public final class TablesContext {
    private final Collection<SimpleTableSegment> tables = new LinkedList<SimpleTableSegment>();
    private final Collection<String> tableNames = new HashSet<String>();
    private final Collection<String> schemaNames = new HashSet<String>();
    private final Collection<String> databaseNames = new HashSet<String>();
    private final Map<String, Collection<SubqueryTableContext>> subqueryTables = new HashMap<String, Collection<SubqueryTableContext>>();

    public TablesContext(SimpleTableSegment tableSegment, DatabaseType databaseType) {
        this(Collections.singletonList(tableSegment), databaseType);
    }

    public TablesContext(Collection<SimpleTableSegment> tableSegments, DatabaseType databaseType) {
        this(tableSegments, Collections.emptyMap(), databaseType);
    }

    public TablesContext(Collection<? extends TableSegment> tableSegments, Map<Integer, SelectStatementContext> subqueryContexts, DatabaseType databaseType) {
        if (tableSegments.isEmpty()) {
            return;
        }
        for (TableSegment tableSegment : tableSegments) {
            if (tableSegment instanceof SimpleTableSegment) {
                SimpleTableSegment simpleTableSegment = (SimpleTableSegment)tableSegment;
                this.tables.add(simpleTableSegment);
                this.tableNames.add(simpleTableSegment.getTableName().getIdentifier().getValue());
                simpleTableSegment.getOwner().ifPresent(optional -> this.schemaNames.add(optional.getIdentifier().getValue()));
                this.findDatabaseName(simpleTableSegment, databaseType).ifPresent(this.databaseNames::add);
            }
            if (!(tableSegment instanceof SubqueryTableSegment)) continue;
            this.subqueryTables.putAll(this.createSubqueryTables(subqueryContexts, (SubqueryTableSegment)tableSegment));
        }
    }

    private Optional<String> findDatabaseName(SimpleTableSegment tableSegment, DatabaseType databaseType) {
        Optional owner = databaseType instanceof PostgreSQLDatabaseType || databaseType instanceof OpenGaussDatabaseType ? tableSegment.getOwner().flatMap(OwnerSegment::getOwner) : tableSegment.getOwner();
        return owner.map(optional -> optional.getIdentifier().getValue());
    }

    private Map<String, Collection<SubqueryTableContext>> createSubqueryTables(Map<Integer, SelectStatementContext> subqueryContexts, SubqueryTableSegment subqueryTable) {
        SelectStatementContext subqueryContext = subqueryContexts.get(subqueryTable.getSubquery().getStartIndex());
        Collection<SubqueryTableContext> subqueryTableContexts = new SubqueryTableContextEngine().createSubqueryTableContexts(subqueryContext, subqueryTable.getAlias().orElse(null));
        HashMap<String, Collection<SubqueryTableContext>> result = new HashMap<String, Collection<SubqueryTableContext>>();
        for (SubqueryTableContext subQuery : subqueryTableContexts) {
            if (null == subQuery.getAlias()) continue;
            result.computeIfAbsent(subQuery.getAlias(), unused -> new LinkedList()).add(subQuery);
        }
        return result;
    }

    public Collection<String> getTableNames() {
        return this.tableNames;
    }

    public Map<String, String> findTableNamesByColumnSegment(Collection<ColumnSegment> columns, ShardingSphereSchema schema) {
        if (1 == this.tables.size()) {
            return this.findTableNameFromSingleTableByColumnSegment(columns);
        }
        TreeMap<String, String> result = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        Map<String, Collection<String>> ownerColumnNames = this.getOwnerColumnNamesByColumnSegment(columns);
        result.putAll(this.findTableNameFromSQL(ownerColumnNames));
        Collection<String> noOwnerColumnNames = this.getNoOwnerColumnNamesByColumnSegment(columns);
        result.putAll(this.findTableNameFromMetaData(noOwnerColumnNames, schema));
        result.putAll(this.findTableNameFromSubqueryByColumnSegment(columns, result));
        return result;
    }

    public Map<String, String> findTableNamesByColumnProjection(Collection<ColumnProjection> columns, ShardingSphereSchema schema) {
        if (1 == this.tables.size()) {
            return this.findTableNameFromSingleTableByColumnProjection(columns);
        }
        TreeMap<String, String> result = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        Map<String, Collection<String>> ownerColumnNames = this.getOwnerColumnNamesByColumnProjection(columns);
        result.putAll(this.findTableNameFromSQL(ownerColumnNames));
        Collection<String> noOwnerColumnNames = this.getNoOwnerColumnNamesByColumnProjection(columns);
        result.putAll(this.findTableNameFromMetaData(noOwnerColumnNames, schema));
        result.putAll(this.findTableNameFromSubqueryByColumnProjection(columns, result));
        return result;
    }

    private Map<String, String> findTableNameFromSubqueryByColumnSegment(Collection<ColumnSegment> columns, Map<String, String> ownerTableNames) {
        if (ownerTableNames.size() == columns.size() || this.subqueryTables.isEmpty()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>(columns.size(), 1.0f);
        for (ColumnSegment each : columns) {
            if (ownerTableNames.containsKey(each.getExpression())) continue;
            String owner = each.getOwner().map(optional -> optional.getIdentifier().getValue()).orElse("");
            Collection subqueryTableContexts = this.subqueryTables.getOrDefault(owner, Collections.emptyList());
            for (SubqueryTableContext subqueryTableContext : subqueryTableContexts) {
                if (!subqueryTableContext.getColumnNames().contains(each.getIdentifier().getValue())) continue;
                result.put(each.getExpression(), subqueryTableContext.getTableName());
            }
        }
        return result;
    }

    private Map<String, String> findTableNameFromSubqueryByColumnProjection(Collection<ColumnProjection> columns, Map<String, String> ownerTableNames) {
        if (ownerTableNames.size() == columns.size() || this.subqueryTables.isEmpty()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>(columns.size(), 1.0f);
        for (ColumnProjection each : columns) {
            if (ownerTableNames.containsKey(each.getExpression())) continue;
            Collection subqueryTableContexts = this.subqueryTables.getOrDefault(each.getOwner(), Collections.emptyList());
            for (SubqueryTableContext subqueryTableContext : subqueryTableContexts) {
                if (!subqueryTableContext.getColumnNames().contains(each.getName())) continue;
                result.put(each.getExpression(), subqueryTableContext.getTableName());
            }
        }
        return result;
    }

    private Map<String, String> findTableNameFromSingleTableByColumnSegment(Collection<ColumnSegment> columns) {
        String tableName = this.tables.iterator().next().getTableName().getIdentifier().getValue();
        TreeMap<String, String> result = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        for (ColumnSegment each : columns) {
            result.putIfAbsent(each.getExpression(), tableName);
        }
        return result;
    }

    private Map<String, String> findTableNameFromSingleTableByColumnProjection(Collection<ColumnProjection> columns) {
        String tableName = this.tables.iterator().next().getTableName().getIdentifier().getValue();
        TreeMap<String, String> result = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        for (ColumnProjection each : columns) {
            result.putIfAbsent(each.getExpression(), tableName);
        }
        return result;
    }

    private Map<String, Collection<String>> getOwnerColumnNamesByColumnSegment(Collection<ColumnSegment> columns) {
        TreeMap<String, Collection<String>> result = new TreeMap<String, Collection<String>>(String.CASE_INSENSITIVE_ORDER);
        for (ColumnSegment each : columns) {
            if (!each.getOwner().isPresent()) continue;
            result.computeIfAbsent(((OwnerSegment)each.getOwner().get()).getIdentifier().getValue(), unused -> new LinkedList()).add(each.getExpression());
        }
        return result;
    }

    private Map<String, Collection<String>> getOwnerColumnNamesByColumnProjection(Collection<ColumnProjection> columns) {
        TreeMap<String, Collection<String>> result = new TreeMap<String, Collection<String>>(String.CASE_INSENSITIVE_ORDER);
        for (ColumnProjection each : columns) {
            if (null == each.getOwner()) continue;
            result.computeIfAbsent(each.getOwner(), unused -> new LinkedList()).add(each.getExpression());
        }
        return result;
    }

    private Map<String, String> findTableNameFromSQL(Map<String, Collection<String>> ownerColumnNames) {
        if (ownerColumnNames.isEmpty()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        for (SimpleTableSegment each : this.tables) {
            Optional alias;
            String tableName = each.getTableName().getIdentifier().getValue();
            if (ownerColumnNames.containsKey(tableName)) {
                ownerColumnNames.get(tableName).forEach(column -> result.put((String)column, tableName));
            }
            if (!(alias = each.getAlias()).isPresent() || !ownerColumnNames.containsKey(alias.get())) continue;
            ownerColumnNames.get(alias.get()).forEach(column -> result.put((String)column, tableName));
        }
        return result;
    }

    private Map<String, String> findTableNameFromMetaData(Collection<String> noOwnerColumnNames, ShardingSphereSchema schema) {
        if (noOwnerColumnNames.isEmpty()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>(noOwnerColumnNames.size(), 1.0f);
        for (SimpleTableSegment each : this.tables) {
            String tableName = each.getTableName().getIdentifier().getValue();
            for (String columnName : schema.getAllColumnNames(tableName)) {
                if (!noOwnerColumnNames.contains(columnName)) continue;
                result.put(columnName, tableName);
            }
        }
        return result;
    }

    private Collection<String> getNoOwnerColumnNamesByColumnSegment(Collection<ColumnSegment> columns) {
        TreeSet<String> result = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        for (ColumnSegment each : columns) {
            if (each.getOwner().isPresent()) continue;
            result.add(each.getIdentifier().getValue());
        }
        return result;
    }

    private Collection<String> getNoOwnerColumnNamesByColumnProjection(Collection<ColumnProjection> columns) {
        TreeSet<String> result = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        for (ColumnProjection each : columns) {
            if (null != each.getOwner()) continue;
            result.add(each.getName());
        }
        return result;
    }

    public Optional<String> getDatabaseName() {
        Preconditions.checkState((this.databaseNames.size() <= 1 ? 1 : 0) != 0, (Object)"Can not support multiple different database.");
        return this.databaseNames.isEmpty() ? Optional.empty() : Optional.of(this.databaseNames.iterator().next());
    }

    public Optional<String> getSchemaName() {
        return this.schemaNames.isEmpty() ? Optional.empty() : Optional.of(this.schemaNames.iterator().next());
    }

    @Generated
    public Collection<SimpleTableSegment> getTables() {
        return this.tables;
    }

    @Generated
    public Collection<String> getSchemaNames() {
        return this.schemaNames;
    }

    @Generated
    public Collection<String> getDatabaseNames() {
        return this.databaseNames;
    }

    @Generated
    public Map<String, Collection<SubqueryTableContext>> getSubqueryTables() {
        return this.subqueryTables;
    }

    @Generated
    public String toString() {
        return "TablesContext(tables=" + this.getTables() + ", tableNames=" + this.getTableNames() + ", schemaNames=" + this.getSchemaNames() + ", databaseNames=" + this.getDatabaseNames() + ", subqueryTables=" + this.getSubqueryTables() + ")";
    }
}

