/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.tm.api.transaction;

import java.io.Serializable;
import org.apache.seata.common.util.StringUtils;

public class RollbackRule
implements Serializable {
    private final String exceptionName;

    public RollbackRule(String exceptionName) {
        if (StringUtils.isNullOrEmpty(exceptionName)) {
            throw new IllegalArgumentException("'exceptionName' cannot be null or empty");
        }
        this.exceptionName = exceptionName;
    }

    public RollbackRule(Class<?> clazz) {
        if (clazz == null) {
            throw new NullPointerException("'clazz' cannot be null");
        }
        if (!Throwable.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("Cannot construct rollback rule from [" + clazz.getName() + "]: it's not a Throwable");
        }
        this.exceptionName = clazz.getName();
    }

    public String getExceptionName() {
        return this.exceptionName;
    }

    public int getDepth(Throwable ex) {
        return this.getDepth(ex.getClass(), 0);
    }

    private int getDepth(Class<?> exceptionClass, int depth) {
        if (exceptionClass.getName().contains(this.exceptionName)) {
            return depth;
        }
        if (exceptionClass == Throwable.class) {
            return -1;
        }
        return this.getDepth(exceptionClass.getSuperclass(), depth + 1);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof RollbackRule)) {
            return false;
        }
        RollbackRule rhs = (RollbackRule)other;
        return this.exceptionName.equals(rhs.exceptionName);
    }

    public int hashCode() {
        return this.exceptionName.hashCode();
    }

    public String toString() {
        return "RollbackRule with pattern [" + this.exceptionName + "]";
    }
}

