/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.saga.engine.serializer.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.apache.seata.saga.engine.serializer.Serializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExceptionSerializer
implements Serializer<Exception, byte[]> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExceptionSerializer.class);

    public static byte[] serializeByObjectOutput(Object o) {
        byte[] result = null;
        if (o != null) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try (ObjectOutputStream oos = new ObjectOutputStream(baos);){
                oos.writeObject(o);
                oos.flush();
                result = baos.toByteArray();
            }
            catch (IOException e) {
                LOGGER.error("serializer failed: {}", o.getClass(), (Object)e);
                throw new RuntimeException("IO Create Error", e);
            }
        }
        return result;
    }

    public static <T> T deserializeByObjectInputStream(byte[] bytes, Class<T> valueType) {
        if (bytes == null) {
            return null;
        }
        Object result = ExceptionSerializer.deserializeByObjectInputStream(bytes);
        return valueType.cast(result);
    }

    public static Object deserializeByObjectInputStream(byte[] bytes) {
        Object result = null;
        if (bytes != null) {
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            try (ObjectInputStream ois = new ObjectInputStream(bais);){
                result = ois.readObject();
            }
            catch (IOException e) {
                LOGGER.error("deserialize failed:", (Throwable)e);
                throw new RuntimeException("IO Create Error", e);
            }
            catch (ClassNotFoundException e) {
                LOGGER.error("deserialize failed:", (Throwable)e);
                throw new RuntimeException("Cannot find specified class", e);
            }
        }
        return result;
    }

    @Override
    public byte[] serialize(Exception object) {
        return ExceptionSerializer.serializeByObjectOutput(object);
    }

    @Override
    public Exception deserialize(byte[] bytes) {
        return ExceptionSerializer.deserializeByObjectInputStream(bytes, Exception.class);
    }
}

