/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.rm.tcc.interceptor.parser;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.seata.common.util.ReflectionUtil;
import org.apache.seata.integration.tx.api.interceptor.handler.ProxyInvocationHandler;
import org.apache.seata.integration.tx.api.interceptor.parser.DefaultResourceRegisterParser;
import org.apache.seata.integration.tx.api.interceptor.parser.IfNeedEnhanceBean;
import org.apache.seata.integration.tx.api.interceptor.parser.InterfaceParser;
import org.apache.seata.integration.tx.api.interceptor.parser.NeedEnhanceEnum;
import org.apache.seata.integration.tx.api.remoting.parser.DefaultRemotingParser;
import org.apache.seata.rm.tcc.api.TwoPhaseBusinessAction;
import org.apache.seata.rm.tcc.interceptor.TccActionInterceptorHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TccActionInterceptorParser
implements InterfaceParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(TccActionInterceptorParser.class);

    @Override
    public ProxyInvocationHandler parserInterfaceToProxy(Object target, String objectName) {
        Set<String> methodsToProxy = this.tccProxyTargetMethod(target);
        if (methodsToProxy.isEmpty()) {
            return null;
        }
        DefaultResourceRegisterParser.get().registerResource(target, objectName);
        return new TccActionInterceptorHandler(target, methodsToProxy);
    }

    @Override
    public IfNeedEnhanceBean parseIfNeedEnhancement(Class<?> beanClass) {
        IfNeedEnhanceBean ifNeedEnhanceBean = new IfNeedEnhanceBean();
        if (DefaultRemotingParser.get().isService(beanClass)) {
            ifNeedEnhanceBean.setIfNeed(true);
            ifNeedEnhanceBean.setNeedEnhanceEnum(NeedEnhanceEnum.SERVICE_BEAN);
        }
        return ifNeedEnhanceBean;
    }

    private Set<String> tccProxyTargetMethod(Object target) {
        HashSet<String> methodsToProxy = new HashSet<String>();
        Class<?> tccServiceClazz = target.getClass();
        HashSet<Method> methods = new HashSet<Method>(Arrays.asList(tccServiceClazz.getMethods()));
        Set<Class<?>> interfaceClasses = ReflectionUtil.getInterfaces(tccServiceClazz);
        if (interfaceClasses != null) {
            for (Class<?> interClass : interfaceClasses) {
                methods.addAll(Arrays.asList(interClass.getMethods()));
            }
        }
        for (Method method : methods) {
            TwoPhaseBusinessAction twoPhaseBusinessAction = method.getAnnotation(TwoPhaseBusinessAction.class);
            if (twoPhaseBusinessAction == null) continue;
            methodsToProxy.add(method.getName());
        }
        if (methodsToProxy.isEmpty()) {
            return Collections.emptySet();
        }
        return methodsToProxy;
    }
}

