/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.rm.datasource.undo;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLIntegrityConstraintViolationException;
import java.sql.Statement;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.seata.common.Constants;
import org.apache.seata.common.util.CollectionUtils;
import org.apache.seata.common.util.SizeUtil;
import org.apache.seata.config.ConfigurationFactory;
import org.apache.seata.core.compressor.CompressorFactory;
import org.apache.seata.core.compressor.CompressorType;
import org.apache.seata.core.exception.BranchTransactionException;
import org.apache.seata.core.exception.TransactionException;
import org.apache.seata.core.exception.TransactionExceptionCode;
import org.apache.seata.rm.datasource.ConnectionContext;
import org.apache.seata.rm.datasource.ConnectionProxy;
import org.apache.seata.rm.datasource.DataSourceProxy;
import org.apache.seata.rm.datasource.sql.struct.TableMetaCacheFactory;
import org.apache.seata.rm.datasource.undo.AbstractUndoExecutor;
import org.apache.seata.rm.datasource.undo.BranchUndoLog;
import org.apache.seata.rm.datasource.undo.SQLUndoDirtyException;
import org.apache.seata.rm.datasource.undo.SQLUndoLog;
import org.apache.seata.rm.datasource.undo.UndoExecutorFactory;
import org.apache.seata.rm.datasource.undo.UndoLogManager;
import org.apache.seata.rm.datasource.undo.UndoLogParser;
import org.apache.seata.rm.datasource.undo.UndoLogParserFactory;
import org.apache.seata.sqlparser.struct.TableMeta;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractUndoLogManager
implements UndoLogManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractUndoLogManager.class);
    protected static final String UNDO_LOG_TABLE_NAME = ConfigurationFactory.getInstance().getConfig("client.undo.logTable", "undo_log");
    private static final String CHECK_UNDO_LOG_TABLE_EXIST_SQL = "SELECT 1 FROM " + UNDO_LOG_TABLE_NAME + " LIMIT 1";
    protected static final String SELECT_UNDO_LOG_SQL = "SELECT * FROM " + UNDO_LOG_TABLE_NAME + " WHERE " + "branch_id" + " = ? AND " + "xid" + " = ? FOR UPDATE";
    protected static final String DELETE_UNDO_LOG_SQL = "DELETE FROM " + UNDO_LOG_TABLE_NAME + " WHERE " + "branch_id" + " = ? AND " + "xid" + " = ?";
    protected static final boolean ROLLBACK_INFO_COMPRESS_ENABLE = ConfigurationFactory.getInstance().getBoolean("client.undo.compress.enable", true);
    protected static final CompressorType ROLLBACK_INFO_COMPRESS_TYPE = CompressorType.getByName(ConfigurationFactory.getInstance().getConfig("client.undo.compress.type", "zip"));
    protected static final long ROLLBACK_INFO_COMPRESS_THRESHOLD = SizeUtil.size2Long(ConfigurationFactory.getInstance().getConfig("client.undo.compress.threshold", "64k"));
    private static final ThreadLocal<String> SERIALIZER_LOCAL = new ThreadLocal();

    public static String getCurrentSerializer() {
        return SERIALIZER_LOCAL.get();
    }

    public static void setCurrentSerializer(String serializer) {
        SERIALIZER_LOCAL.set(serializer);
    }

    public static void removeCurrentSerializer() {
        SERIALIZER_LOCAL.remove();
    }

    @Override
    public void deleteUndoLog(String xid, long branchId, Connection conn) throws SQLException {
        try (PreparedStatement deletePST = conn.prepareStatement(DELETE_UNDO_LOG_SQL);){
            deletePST.setLong(1, branchId);
            deletePST.setString(2, xid);
            deletePST.executeUpdate();
        }
        catch (Exception e2) {
            SQLException e2;
            if (!(e2 instanceof SQLException)) {
                e2 = new SQLException(e2);
            }
            throw (SQLException)e2;
        }
    }

    @Override
    public void batchDeleteUndoLog(Set<String> xids, Set<Long> branchIds, Connection conn) throws SQLException {
        if (CollectionUtils.isEmpty(xids) || CollectionUtils.isEmpty(branchIds)) {
            return;
        }
        int xidSize = xids.size();
        int branchIdSize = branchIds.size();
        String batchDeleteSql = AbstractUndoLogManager.toBatchDeleteUndoLogSql(xidSize, branchIdSize);
        try (PreparedStatement deletePST = conn.prepareStatement(batchDeleteSql);){
            int paramsIndex = 1;
            for (Long branchId : branchIds) {
                deletePST.setLong(paramsIndex++, branchId);
            }
            for (String xid : xids) {
                deletePST.setString(paramsIndex++, xid);
            }
            int deleteRows = deletePST.executeUpdate();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("batch delete undo log size {}", (Object)deleteRows);
            }
        }
        catch (Exception e2) {
            SQLException e2;
            if (!(e2 instanceof SQLException)) {
                e2 = new SQLException(e2);
            }
            throw (SQLException)e2;
        }
    }

    protected static String toBatchDeleteUndoLogSql(int xidSize, int branchIdSize) {
        StringBuilder sqlBuilder = new StringBuilder(64);
        sqlBuilder.append("DELETE FROM ").append(UNDO_LOG_TABLE_NAME).append(" WHERE  ").append("branch_id").append(" IN ");
        AbstractUndoLogManager.appendInParam(branchIdSize, sqlBuilder);
        sqlBuilder.append(" AND ").append("xid").append(" IN ");
        AbstractUndoLogManager.appendInParam(xidSize, sqlBuilder);
        return sqlBuilder.toString();
    }

    protected static void appendInParam(int size, StringBuilder sqlBuilder) {
        sqlBuilder.append(" (");
        for (int i = 0; i < size; ++i) {
            sqlBuilder.append("?");
            if (i >= size - 1) continue;
            sqlBuilder.append(",");
        }
        sqlBuilder.append(") ");
    }

    protected static boolean canUndo(int state) {
        return state == State.Normal.getValue();
    }

    protected String buildContext(String serializer, CompressorType compressorType) {
        HashMap<String, String> map = new HashMap<String, String>(2, 1.01f);
        map.put("serializer", serializer);
        map.put("compressorType", compressorType.name());
        return CollectionUtils.encodeMap(map);
    }

    protected Map<String, String> parseContext(String data) {
        return CollectionUtils.decodeMap(data);
    }

    @Override
    public void flushUndoLogs(ConnectionProxy cp) throws SQLException {
        ConnectionContext connectionContext = cp.getContext();
        if (!connectionContext.hasUndoLog()) {
            return;
        }
        String xid = connectionContext.getXid();
        long branchId = connectionContext.getBranchId();
        BranchUndoLog branchUndoLog = new BranchUndoLog();
        branchUndoLog.setXid(xid);
        branchUndoLog.setBranchId(branchId);
        branchUndoLog.setSqlUndoLogs(connectionContext.getUndoItems());
        UndoLogParser parser = UndoLogParserFactory.getInstance();
        byte[] undoLogContent = parser.encode(branchUndoLog);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Flushing UNDO LOG: {}", (Object)new String(undoLogContent, Constants.DEFAULT_CHARSET));
        }
        CompressorType compressorType = CompressorType.NONE;
        if (this.needCompress(undoLogContent)) {
            compressorType = ROLLBACK_INFO_COMPRESS_TYPE;
            undoLogContent = CompressorFactory.getCompressor(compressorType.getCode()).compress(undoLogContent);
        }
        this.insertUndoLogWithNormal(xid, branchId, this.buildContext(parser.getName(), compressorType), undoLogContent, cp.getTargetConnection());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void undo(DataSourceProxy dataSourceProxy, String xid, long branchId) throws TransactionException {
        ConnectionProxy connectionProxy = null;
        Connection conn = null;
        ResultSet rs = null;
        Statement selectPST = null;
        boolean originalAutoCommit = true;
        while (true) {
            try {
                connectionProxy = dataSourceProxy.getConnection();
                conn = connectionProxy.getTargetConnection();
                originalAutoCommit = conn.getAutoCommit();
                if (originalAutoCommit) {
                    conn.setAutoCommit(false);
                }
                selectPST = conn.prepareStatement(this.buildSelectUndoSql());
                selectPST.setLong(1, branchId);
                selectPST.setString(2, xid);
                rs = selectPST.executeQuery();
                boolean exists = false;
                while (rs.next()) {
                    exists = true;
                    int state = rs.getInt("log_status");
                    if (!AbstractUndoLogManager.canUndo(state)) {
                        if (LOGGER.isInfoEnabled()) {
                            LOGGER.info("xid {} branch {}, ignore {} undo_log", new Object[]{xid, branchId, state});
                        }
                        return;
                    }
                    String contextString = rs.getString("context");
                    Map<String, String> context = this.parseContext(contextString);
                    byte[] rollbackInfo = this.getRollbackInfo(rs);
                    String serializer = context == null ? null : context.get("serializer");
                    UndoLogParser parser = serializer == null ? UndoLogParserFactory.getInstance() : UndoLogParserFactory.getInstance(serializer);
                    BranchUndoLog branchUndoLog = parser.decode(rollbackInfo);
                    try {
                        AbstractUndoLogManager.setCurrentSerializer(parser.getName());
                        List<SQLUndoLog> sqlUndoLogs = branchUndoLog.getSqlUndoLogs();
                        if (sqlUndoLogs.size() > 1) {
                            Collections.reverse(sqlUndoLogs);
                        }
                        for (SQLUndoLog sqlUndoLog : sqlUndoLogs) {
                            TableMeta tableMeta = TableMetaCacheFactory.getTableMetaCache(dataSourceProxy.getDbType()).getTableMeta(conn, sqlUndoLog.getTableName(), dataSourceProxy.getResourceId());
                            sqlUndoLog.setTableMeta(tableMeta);
                            AbstractUndoExecutor undoExecutor = UndoExecutorFactory.getUndoExecutor(dataSourceProxy.getDbType(), sqlUndoLog);
                            undoExecutor.executeOn(connectionProxy);
                        }
                    }
                    finally {
                        AbstractUndoLogManager.removeCurrentSerializer();
                    }
                }
                if (exists) {
                    this.deleteUndoLog(xid, branchId, conn);
                    conn.commit();
                    if (LOGGER.isInfoEnabled()) {
                        LOGGER.info("xid {} branch {}, undo_log deleted with {}", new Object[]{xid, branchId, State.GlobalFinished.name()});
                    }
                } else {
                    this.insertUndoLogWithGlobalFinished(xid, branchId, UndoLogParserFactory.getInstance(), conn);
                    conn.commit();
                    if (LOGGER.isInfoEnabled()) {
                        LOGGER.info("xid {} branch {}, undo_log added with {}", new Object[]{xid, branchId, State.GlobalFinished.name()});
                    }
                }
                return;
            }
            catch (SQLIntegrityConstraintViolationException e) {
                if (!LOGGER.isInfoEnabled()) continue;
                LOGGER.info("xid {} branch {}, undo_log inserted, retry rollback", (Object)xid, (Object)branchId);
                continue;
            }
            catch (Throwable e) {
                if (conn != null) {
                    try {
                        conn.rollback();
                    }
                    catch (SQLException rollbackEx) {
                        LOGGER.warn("Failed to close JDBC resource while undo ... ", (Throwable)rollbackEx);
                    }
                }
                if (e instanceof SQLUndoDirtyException) {
                    throw new BranchTransactionException(TransactionExceptionCode.BranchRollbackFailed_Unretriable, String.format("Branch session rollback failed because of dirty undo log, please delete the relevant undolog after manually calibrating the data. xid = %s branchId = %s", xid, branchId), e);
                }
                throw new BranchTransactionException(TransactionExceptionCode.BranchRollbackFailed_Retriable, String.format("Branch session rollback failed and try again later xid = %s branchId = %s %s", xid, branchId, e.getMessage()), e);
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (selectPST != null) {
                        selectPST.close();
                    }
                    if (conn == null) continue;
                    if (originalAutoCommit) {
                        conn.setAutoCommit(true);
                    }
                    connectionProxy.close();
                }
                catch (SQLException closeEx) {
                    LOGGER.warn("Failed to close JDBC resource while undo ... ", (Throwable)closeEx);
                }
                continue;
            }
            break;
        }
    }

    protected String buildSelectUndoSql() {
        return SELECT_UNDO_LOG_SQL;
    }

    protected abstract void insertUndoLogWithGlobalFinished(String var1, long var2, UndoLogParser var4, Connection var5) throws SQLException;

    protected abstract void insertUndoLogWithNormal(String var1, long var2, String var4, byte[] var5, Connection var6) throws SQLException;

    protected byte[] getRollbackInfo(ResultSet rs) throws SQLException {
        byte[] rollbackInfo = rs.getBytes("rollback_info");
        String rollbackInfoContext = rs.getString("context");
        Map<String, String> context = CollectionUtils.decodeMap(rollbackInfoContext);
        CompressorType compressorType = CompressorType.getByName(context.getOrDefault("compressorType", CompressorType.NONE.name()));
        return CompressorFactory.getCompressor(compressorType.getCode()).decompress(rollbackInfo);
    }

    protected boolean needCompress(byte[] undoLogContent) {
        return ROLLBACK_INFO_COMPRESS_ENABLE && (long)undoLogContent.length > ROLLBACK_INFO_COMPRESS_THRESHOLD;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean hasUndoLogTable(Connection conn) {
        String checkExistSql = this.getCheckUndoLogTableExistSql();
        try (PreparedStatement checkPst = conn.prepareStatement(checkExistSql);){
            checkPst.executeQuery();
            boolean bl = true;
            return bl;
        }
        catch (SQLException e) {
            return false;
        }
    }

    protected String getCheckUndoLogTableExistSql() {
        return CHECK_UNDO_LOG_TABLE_EXIST_SQL;
    }

    protected static enum State {
        Normal(0),
        GlobalFinished(1);

        private int value;

        private State(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

