/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.integration.tx.api.fence;

import java.lang.reflect.Method;
import java.util.Date;
import org.apache.seata.common.executor.Callback;
import org.apache.seata.integration.tx.api.fence.FenceHandler;

public class DefaultCommonFenceHandler
implements FenceHandler {
    private FenceHandler fenceHandler;

    public static DefaultCommonFenceHandler get() {
        return SingletonHolder.INSTANCE;
    }

    public void setFenceHandler(FenceHandler fenceHandler) {
        this.fenceHandler = fenceHandler;
    }

    private void check() {
        if (this.fenceHandler == null) {
            throw new RuntimeException("fenceHandler is null, need to set a fenceHandler implement");
        }
    }

    @Override
    public Object prepareFence(String xid, Long branchId, String actionName, Callback<Object> targetCallback) {
        this.check();
        return this.fenceHandler.prepareFence(xid, branchId, actionName, targetCallback);
    }

    @Override
    public boolean commitFence(Method commitMethod, Object targetTCCBean, String xid, Long branchId, Object[] args) {
        this.check();
        return this.fenceHandler.commitFence(commitMethod, targetTCCBean, xid, branchId, args);
    }

    @Override
    public boolean rollbackFence(Method rollbackMethod, Object targetTCCBean, String xid, Long branchId, Object[] args, String actionName) {
        this.check();
        return this.fenceHandler.rollbackFence(rollbackMethod, targetTCCBean, xid, branchId, args, actionName);
    }

    @Override
    public int deleteFenceByDate(Date datetime) {
        this.check();
        return this.fenceHandler.deleteFenceByDate(datetime);
    }

    private static class SingletonHolder {
        private static final DefaultCommonFenceHandler INSTANCE = new DefaultCommonFenceHandler();

        private SingletonHolder() {
        }
    }
}

