/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.config;

import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.seata.common.util.DurationUtil;
import org.apache.seata.common.util.StringUtils;
import org.apache.seata.config.Configuration;
import org.apache.seata.config.ConfigurationChangeEvent;
import org.apache.seata.config.ConfigurationChangeListener;

public class ConfigurationCache
implements ConfigurationChangeListener {
    private static final String PROXY_METHOD_PREFIX = "get";
    private static final String[] NOT_PROXY_METHOD_NAMES = new String[]{"getLatestConfig", "getConfigListeners"};
    private static final Map<String, ObjectWrapper> CONFIG_CACHE = new ConcurrentHashMap<String, ObjectWrapper>();
    private static final Set<String> DATA_ID_CACHED = new HashSet<String>();

    public static ConfigurationCache getInstance() {
        return ConfigurationCacheInstance.INSTANCE;
    }

    @Override
    public void onProcessEvent(ConfigurationChangeEvent event) {
        this.beforeEvent(event);
        this.onChangeEvent(event);
        this.afterEvent(event);
    }

    @Override
    public void onChangeEvent(ConfigurationChangeEvent event) {
        ObjectWrapper oldWrapper = CONFIG_CACHE.get(event.getDataId());
        if (StringUtils.isNotBlank(event.getNewValue())) {
            if (oldWrapper == null) {
                CONFIG_CACHE.put(event.getDataId(), new ObjectWrapper(event.getNewValue(), null));
            } else {
                Object newValue = new ObjectWrapper(event.getNewValue(), null).convertData(oldWrapper.getType());
                if (!Objects.equals(oldWrapper.getData(), newValue)) {
                    CONFIG_CACHE.put(event.getDataId(), new ObjectWrapper(newValue, oldWrapper.getType(), oldWrapper.getLastDefaultValue()));
                }
            }
        } else {
            CONFIG_CACHE.remove(event.getDataId(), oldWrapper);
        }
    }

    public Configuration proxy(Configuration originalConfiguration) throws Exception {
        return (Configuration)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{Configuration.class}, (proxy, method, args) -> {
            if (this.isProxyTargetMethod(method)) {
                String rawDataId = (String)args[0];
                ObjectWrapper wrapper = CONFIG_CACHE.get(rawDataId);
                ObjectWrapper.ConfigType type = ObjectWrapper.getTypeByName(method.getName().substring(PROXY_METHOD_PREFIX.length()));
                Object defaultValue = null;
                if (args.length > 1 && method.getParameterTypes()[1].getSimpleName().equalsIgnoreCase(type.name())) {
                    defaultValue = args[1];
                }
                if (null == wrapper || null != defaultValue && !Objects.equals(defaultValue, wrapper.lastDefaultValue)) {
                    Object result;
                    if (DATA_ID_CACHED.add(rawDataId)) {
                        originalConfiguration.addConfigListener(rawDataId, this);
                    }
                    if ((result = method.invoke((Object)originalConfiguration, args)) != null) {
                        wrapper = new ObjectWrapper(result, type, defaultValue);
                        CONFIG_CACHE.put(rawDataId, wrapper);
                    }
                }
                return wrapper == null ? null : wrapper.convertData(type);
            }
            return method.invoke((Object)originalConfiguration, args);
        });
    }

    private boolean isProxyTargetMethod(Method method) {
        String methodName = method.getName();
        if (!methodName.startsWith(PROXY_METHOD_PREFIX)) {
            return false;
        }
        for (String name : NOT_PROXY_METHOD_NAMES) {
            if (!methodName.equalsIgnoreCase(name)) continue;
            return false;
        }
        return true;
    }

    public static void clear() {
        CONFIG_CACHE.clear();
    }

    private static class ObjectWrapper {
        private final Object data;
        private final ConfigType type;
        private final Object lastDefaultValue;

        ObjectWrapper(Object data, ConfigType type) {
            this(data, type, null);
        }

        ObjectWrapper(Object data, ConfigType type, Object lastDefaultValue) {
            this.data = data;
            this.type = type;
            this.lastDefaultValue = lastDefaultValue;
        }

        public Object getData() {
            return this.data;
        }

        public ConfigType getType() {
            return this.type;
        }

        public Object getLastDefaultValue() {
            return this.lastDefaultValue;
        }

        public Object convertData(ConfigType aType) {
            if (this.data != null && Objects.equals((Object)this.type, (Object)aType)) {
                return this.data;
            }
            if (this.data != null) {
                if (ConfigType.INT.equals((Object)aType)) {
                    return Integer.parseInt(this.data.toString());
                }
                if (ConfigType.BOOLEAN.equals((Object)aType)) {
                    return Boolean.parseBoolean(this.data.toString());
                }
                if (ConfigType.DURATION.equals((Object)aType)) {
                    return DurationUtil.parse(this.data.toString());
                }
                if (ConfigType.LONG.equals((Object)aType)) {
                    return Long.parseLong(this.data.toString());
                }
                if (ConfigType.SHORT.equals((Object)aType)) {
                    return Short.parseShort(this.data.toString());
                }
                return String.valueOf(this.data);
            }
            return null;
        }

        public static boolean supportType(String type) {
            return ObjectWrapper.getTypeByName(type) != null;
        }

        public static ConfigType getTypeByName(String postfix) {
            return ConfigType.fromCode(postfix);
        }

        static enum ConfigType {
            INT("Int"),
            BOOLEAN("Boolean"),
            DURATION("Duration"),
            LONG("Long"),
            SHORT("Short"),
            STRING("Config");

            private static final Map<String, ConfigType> CODE_TO_VALUE;
            private String code;

            private ConfigType(String code) {
                this.code = code;
            }

            public String getCode() {
                return this.code;
            }

            public static ConfigType fromCode(String code) {
                ConfigType configType = CODE_TO_VALUE.get(code.toUpperCase());
                return configType == null ? STRING : configType;
            }

            public static ConfigType fromName(String name) {
                return ConfigType.valueOf(name);
            }

            static {
                CODE_TO_VALUE = new HashMap<String, ConfigType>();
                for (ConfigType configType : ConfigType.values()) {
                    CODE_TO_VALUE.put(configType.code.toUpperCase(), configType);
                }
            }
        }
    }

    private static class ConfigurationCacheInstance {
        private static final ConfigurationCache INSTANCE = new ConfigurationCache();

        private ConfigurationCacheInstance() {
        }
    }
}

