/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.common.metadata;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.seata.common.metadata.ClusterRole;
import org.apache.seata.common.metadata.MetadataResponse;
import org.apache.seata.common.metadata.Node;
import org.apache.seata.common.store.StoreMode;
import org.apache.seata.common.util.StringUtils;

public class Metadata {
    private final Map<String, Map<String, Node>> leaders = new ConcurrentHashMap<String, Map<String, Node>>();
    private final Map<String, Map<String, Long>> clusterTerm = new ConcurrentHashMap<String, Map<String, Long>>();
    private final Map<String, Map<String, List<Node>>> clusterNodes = new ConcurrentHashMap<String, Map<String, List<Node>>>();
    private StoreMode storeMode = StoreMode.FILE;

    public Node getLeader(String clusterName) {
        Map map = this.leaders.computeIfAbsent(clusterName, k -> new ConcurrentHashMap());
        ArrayList nodes = new ArrayList(map.values());
        return nodes.size() > 0 ? (Node)nodes.get(ThreadLocalRandom.current().nextInt(nodes.size())) : null;
    }

    public void setLeaderNode(String clusterName, Node node) {
        String group = node.getGroup();
        Map map = this.leaders.computeIfAbsent(clusterName, k -> new ConcurrentHashMap());
        map.put(group, node);
        this.leaders.put(clusterName, map);
    }

    public List<Node> getNodes(String clusterName, String group) {
        return (List)this.clusterNodes.computeIfAbsent(clusterName, k -> new ConcurrentHashMap()).get(group);
    }

    public List<Node> getNodes(String clusterName) {
        return this.clusterNodes.computeIfAbsent(clusterName, k -> new ConcurrentHashMap()).values().stream().flatMap(Collection::stream).collect(ArrayList::new, ArrayList::add, ArrayList::addAll);
    }

    public void setNodes(String clusterName, String group, List<Node> nodes) {
        this.clusterNodes.computeIfAbsent(clusterName, k -> new ConcurrentHashMap()).put(group, nodes);
    }

    public boolean containsGroup(String group) {
        return this.clusterNodes.containsKey(group);
    }

    public Set<String> groups(String clusterName) {
        return this.clusterNodes.computeIfAbsent(clusterName, k -> new ConcurrentHashMap()).keySet();
    }

    public StoreMode getStoreMode() {
        return this.storeMode;
    }

    public boolean isRaftMode() {
        return Objects.equals((Object)this.storeMode, (Object)StoreMode.RAFT);
    }

    public void setStoreMode(StoreMode storeMode) {
        this.storeMode = storeMode;
    }

    public Map<String, Long> getClusterTerm(String clusterName) {
        return this.clusterTerm.computeIfAbsent(clusterName, k -> new ConcurrentHashMap());
    }

    public void refreshMetadata(String clusterName, MetadataResponse metadataResponse) {
        ArrayList<Node> list = new ArrayList<Node>();
        for (Node node : metadataResponse.getNodes()) {
            if (node.getRole() == ClusterRole.LEADER) {
                this.setLeaderNode(clusterName, node);
            }
            list.add(node);
        }
        this.storeMode = StoreMode.get(metadataResponse.getStoreMode());
        if (!list.isEmpty()) {
            String group = ((Node)list.get(0)).getGroup();
            this.setNodes(clusterName, group, list);
            this.clusterTerm.computeIfAbsent(clusterName, k -> new ConcurrentHashMap()).put(group, metadataResponse.getTerm());
        }
    }

    public String toString() {
        return StringUtils.toString(this);
    }
}

