/*
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 *
 */

/*
 * This file is auto-generated by Qpid Gentools v.0.1 - do not modify.
 * Supported AMQP version:
 *   8-0
 */

package org.apache.qpid.framing;

import java.io.DataOutput;
import java.io.IOException;

import org.apache.qpid.QpidException;
import org.apache.qpid.codec.MarkableDataInput;

public class ConnectionRedirectBody extends AMQMethodBodyImpl implements EncodableAMQDataBlock, AMQMethodBody
{
    private final int _ownMethodId;

    public static final int CLASS_ID =  10;

    // Fields declared in specification
    private final AMQShortString _host; // [host]
    private final AMQShortString _knownHosts; // [knownHosts]

    // Constructor
    public ConnectionRedirectBody(MarkableDataInput buffer, ProtocolVersion protocolVersion) throws AMQFrameDecodingException, IOException
    {
        _ownMethodId = ProtocolVersion.v0_8.equals(protocolVersion) ? 50 : 42;
        _host = buffer.readAMQShortString();
        _knownHosts = buffer.readAMQShortString();
    }

    public ConnectionRedirectBody(ProtocolVersion protocolVersion, AMQShortString host, AMQShortString knownHosts)
    {
        _ownMethodId = ProtocolVersion.v0_8.equals(protocolVersion) ? 50 : 42;
        _host = host;
        _knownHosts = knownHosts;
    }

    public int getClazz()
    {
        return CLASS_ID;
    }

    public int getMethod()
    {
        return _ownMethodId;
    }

    public final AMQShortString getHost()
    {
        return _host;
    }
    public final AMQShortString getKnownHosts()
    {
        return _knownHosts;
    }

    protected int getBodySize()
    {
        int size = 0;
        size += getSizeOf( _host );
        size += getSizeOf( _knownHosts );
        return size;
    }

    public void writeMethodPayload(DataOutput buffer) throws IOException
    {
        writeAMQShortString( buffer, _host );
        writeAMQShortString( buffer, _knownHosts );
    }

    public boolean execute(MethodDispatcher dispatcher, int channelId) throws QpidException
	{
        return dispatcher.dispatchConnectionRedirect(this, channelId);
	}

    public String toString()
    {
        StringBuilder buf = new StringBuilder("[ConnectionRedirectBodyImpl: ");
        buf.append( "host=" );
        buf.append(  getHost() );
        buf.append( ", " );
        buf.append( "knownHosts=" );
        buf.append(  getKnownHosts() );
        buf.append("]");
        return buf.toString();
    }

    public static void process(final MarkableDataInput buffer, final ClientMethodProcessor dispatcher) throws IOException
    {
        AMQShortString host = buffer.readAMQShortString();
        AMQShortString knownHosts = buffer.readAMQShortString();
        if(!dispatcher.ignoreAllButCloseOk())
        {
            dispatcher.receiveConnectionRedirect(host, knownHosts);
        }
    }
}
