/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.pmd.exec;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.sourceforge.pmd.cpd.CPDReport;
import net.sourceforge.pmd.cpd.CPDReportRenderer;
import net.sourceforge.pmd.cpd.Match;
import net.sourceforge.pmd.cpd.XMLRenderer;
import org.apache.maven.plugins.pmd.ExcludeDuplicationsFromFile;
import org.apache.maven.plugins.pmd.exec.CpdExecutor;
import org.apache.maven.plugins.pmd.exec.CpdRequest;
import org.apache.maven.reporting.MavenReportException;
import org.codehaus.plexus.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CpdReportConsumer
implements Consumer<CPDReport> {
    private static final Logger LOG = LoggerFactory.getLogger(CpdReportConsumer.class);
    private final CpdRequest request;
    private final ExcludeDuplicationsFromFile excludeDuplicationsFromFile;

    CpdReportConsumer(CpdRequest request, ExcludeDuplicationsFromFile excludeDuplicationsFromFile) {
        this.request = request;
        this.excludeDuplicationsFromFile = excludeDuplicationsFromFile;
    }

    @Override
    public void accept(CPDReport report) {
        try {
            this.writeXmlReport(report);
            String format = this.request.getFormat();
            if (!"html".equals(format) && !"xml".equals(format)) {
                this.writeFormattedReport(report);
            }
        }
        catch (IOException | MavenReportException e) {
            throw new RuntimeException(e);
        }
    }

    private void writeXmlReport(CPDReport cpd) throws IOException {
        File targetFile = this.writeReport(cpd, (CPDReportRenderer)new XMLRenderer(this.request.getOutputEncoding()), "xml");
        if (this.request.isIncludeXmlInSite()) {
            File siteDir = new File(this.request.getReportOutputDirectory());
            if (!siteDir.exists() && !siteDir.mkdirs()) {
                throw new IOException("Couldn't create report output directory: " + siteDir);
            }
            FileUtils.copyFile((File)targetFile, (File)new File(siteDir, "cpd.xml"));
        }
    }

    private void writeFormattedReport(CPDReport cpd) throws IOException, MavenReportException {
        CPDReportRenderer r = CpdExecutor.createRenderer(this.request.getFormat(), this.request.getOutputEncoding());
        this.writeReport(cpd, r, this.request.getFormat());
    }

    private File writeReport(CPDReport cpd, CPDReportRenderer renderer, String extension) throws IOException {
        if (renderer == null) {
            return null;
        }
        File targetDir = new File(this.request.getTargetDirectory());
        if (!targetDir.exists() && !targetDir.mkdirs()) {
            throw new IOException("Couldn't create report output directory: " + targetDir);
        }
        File targetFile = new File(targetDir, "cpd." + extension);
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(targetFile), this.request.getOutputEncoding());){
            renderer.render(cpd.filterMatches(this.filterMatches()), (Writer)writer);
            ((Writer)writer).flush();
        }
        return targetFile;
    }

    private Predicate<Match> filterMatches() {
        return match -> {
            LOG.debug("Filtering duplications. Using {} configured exclusions.", (Object)this.excludeDuplicationsFromFile.countExclusions());
            if (this.excludeDuplicationsFromFile.isExcludedFromFailure((Match)match)) {
                LOG.debug("Excluded {} duplications.", match);
                return false;
            }
            return true;
        };
    }
}

