/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.install;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.install.AbstractInstallMojo;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.shared.transfer.artifact.install.ArtifactInstallerException;
import org.apache.maven.shared.transfer.project.NoFileAssignedException;
import org.apache.maven.shared.transfer.project.install.ProjectInstaller;
import org.apache.maven.shared.transfer.project.install.ProjectInstallerRequest;

@Mojo(name="install", defaultPhase=LifecyclePhase.INSTALL, threadSafe=true)
public class InstallMojo
extends AbstractInstallMojo {
    private static final AtomicInteger READYPROJECTSCOUTNER = new AtomicInteger();
    private static final List<ProjectInstallerRequest> INSTALLREQUESTS = Collections.synchronizedList(new ArrayList());
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(defaultValue="${reactorProjects}", required=true, readonly=true)
    private List<MavenProject> reactorProjects;
    @Parameter(defaultValue="false", property="installAtEnd")
    private boolean installAtEnd;
    @Parameter(property="maven.install.skip", defaultValue="false")
    private boolean skip;
    @Component
    private ProjectInstaller installer;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        boolean projectsReady;
        boolean addedInstallRequest = false;
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping artifact installation");
        } else {
            ProjectInstallerRequest projectInstallerRequest = new ProjectInstallerRequest().setProject(this.project);
            if (!this.installAtEnd) {
                this.installProject(this.session.getProjectBuildingRequest(), projectInstallerRequest);
            } else {
                INSTALLREQUESTS.add(projectInstallerRequest);
                addedInstallRequest = true;
            }
        }
        boolean bl = projectsReady = READYPROJECTSCOUTNER.incrementAndGet() == this.reactorProjects.size();
        if (projectsReady) {
            List<ProjectInstallerRequest> list = INSTALLREQUESTS;
            synchronized (list) {
                while (!INSTALLREQUESTS.isEmpty()) {
                    this.installProject(this.session.getProjectBuildingRequest(), INSTALLREQUESTS.remove(0));
                }
            }
        } else if (addedInstallRequest) {
            this.getLog().info((CharSequence)("Installing " + this.project.getGroupId() + ":" + this.project.getArtifactId() + ":" + this.project.getVersion() + " at end"));
        }
    }

    private void installProject(ProjectBuildingRequest pbr, ProjectInstallerRequest pir) throws MojoFailureException, MojoExecutionException {
        try {
            this.installer.install(this.session.getProjectBuildingRequest(), pir);
        }
        catch (IOException e) {
            throw new MojoFailureException("IOException", (Throwable)e);
        }
        catch (ArtifactInstallerException e) {
            throw new MojoExecutionException("ArtifactInstallerException", (Exception)((Object)e));
        }
        catch (NoFileAssignedException e) {
            throw new MojoExecutionException("NoFileAssignedException", (Exception)((Object)e));
        }
    }

    public void setSkip(boolean skip) {
        this.skip = skip;
    }
}

