/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.hadoop.realtime;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hudi.common.model.HoodieLogFile;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.hadoop.realtime.HoodieRealtimePath;
import org.apache.hudi.hadoop.realtime.HoodieVirtualKeyInfo;
import org.apache.hudi.hadoop.realtime.RealtimeSplit;

public class HoodieRealtimeFileSplit
extends FileSplit
implements RealtimeSplit {
    private List<HoodieLogFile> deltaLogFiles = new ArrayList<HoodieLogFile>();
    private String basePath;
    private String maxCommitTime;
    private boolean belongsToIncrementalQuery = false;
    private Option<HoodieVirtualKeyInfo> virtualKeyInfo = Option.empty();

    public HoodieRealtimeFileSplit() {
    }

    public HoodieRealtimeFileSplit(FileSplit baseSplit, HoodieRealtimePath path) throws IOException {
        this(baseSplit, path.getBasePath(), path.getDeltaLogFiles(), path.getMaxCommitTime(), path.getBelongsToIncrementalQuery(), path.getVirtualKeyInfo());
    }

    public HoodieRealtimeFileSplit(FileSplit baseSplit, String basePath, List<HoodieLogFile> deltaLogFiles, String maxCommitTime, boolean belongsToIncrementalQuery, Option<HoodieVirtualKeyInfo> virtualKeyInfo) throws IOException {
        super(baseSplit.getPath(), baseSplit.getStart(), baseSplit.getLength(), baseSplit.getLocations());
        this.deltaLogFiles = deltaLogFiles;
        this.basePath = basePath;
        this.maxCommitTime = maxCommitTime;
        this.belongsToIncrementalQuery = belongsToIncrementalQuery;
        this.virtualKeyInfo = virtualKeyInfo;
    }

    @Override
    public List<HoodieLogFile> getDeltaLogFiles() {
        return this.deltaLogFiles;
    }

    @Override
    public void setDeltaLogFiles(List<HoodieLogFile> deltaLogFiles) {
        this.deltaLogFiles = deltaLogFiles;
    }

    @Override
    public String getMaxCommitTime() {
        return this.maxCommitTime;
    }

    @Override
    public void setMaxCommitTime(String maxCommitTime) {
        this.maxCommitTime = maxCommitTime;
    }

    @Override
    public String getBasePath() {
        return this.basePath;
    }

    @Override
    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    @Override
    public void setVirtualKeyInfo(Option<HoodieVirtualKeyInfo> virtualKeyInfo) {
        this.virtualKeyInfo = virtualKeyInfo;
    }

    @Override
    public Option<HoodieVirtualKeyInfo> getVirtualKeyInfo() {
        return this.virtualKeyInfo;
    }

    @Override
    public boolean getBelongsToIncrementalQuery() {
        return this.belongsToIncrementalQuery;
    }

    @Override
    public void setBelongsToIncrementalQuery(boolean belongsToIncrementalPath) {
        this.belongsToIncrementalQuery = belongsToIncrementalPath;
    }

    public void write(DataOutput out) throws IOException {
        super.write(out);
        this.writeToOutput(out);
    }

    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        this.readFromInput(in);
    }

    public String toString() {
        return "HoodieRealtimeFileSplit{DataPath=" + this.getPath() + ", deltaLogPaths=" + this.getDeltaLogPaths() + ", maxCommitTime='" + this.maxCommitTime + '\'' + ", basePath='" + this.basePath + '\'' + '}';
    }
}

