/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.hilbert;

import com.github.davidmoten.guavamini.Preconditions;
import org.davidmoten.hilbert.Range;

final class Node
implements Comparable<Node> {
    final Range value;
    private Node next;
    private Node previous;
    private long distanceToPrevious;

    Node(Range value) {
        this.value = value;
    }

    Node next() {
        return this.next;
    }

    Node previous() {
        return this.previous;
    }

    Node setNext(Node next) {
        Preconditions.checkNotNull(next);
        Preconditions.checkArgument(next != this);
        this.next = next;
        next.distanceToPrevious = this.value.low() - next.value.high();
        next.previous = this;
        return this;
    }

    @Override
    public int compareTo(Node o) {
        if (this == o) {
            return 0;
        }
        if (this.next == null) {
            return -1;
        }
        long x = this.distanceToPrevious;
        long y = o.distanceToPrevious;
        if (x < y) {
            return -1;
        }
        if (x == y) {
            return Long.compare(this.value.low(), o.value.low());
        }
        return 1;
    }

    public String toString() {
        return "Node [value=" + this.value + ", next=" + this.next + ", previous=" + this.previous + "]";
    }

    void setDistanceToPrevious(long distance) {
        this.distanceToPrevious = distance;
    }

    void clearForGc() {
        this.next = null;
        this.previous = null;
    }
}

