/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.upgrade;

import java.util.HashMap;
import java.util.Map;
import org.apache.hudi.client.BaseHoodieWriteClient;
import org.apache.hudi.common.config.ConfigProperty;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieInstantTimeGenerator;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.util.FileIOUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieCompactionConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.metadata.HoodieTableMetadataUtil;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.compact.CompactionTriggerStrategy;
import org.apache.hudi.table.action.compact.strategy.UnBoundedCompactionStrategy;
import org.apache.hudi.table.upgrade.DowngradeHandler;
import org.apache.hudi.table.upgrade.SupportsUpgradeDowngrade;

public class SixToFiveDowngradeHandler
implements DowngradeHandler {
    @Override
    public Map<ConfigProperty, String> downgrade(HoodieWriteConfig config, HoodieEngineContext context, String instantTime, SupportsUpgradeDowngrade upgradeDowngradeHelper) {
        HoodieTable table = upgradeDowngradeHelper.getTable(config, context);
        HoodieTableMetadataUtil.deleteMetadataTable(config.getBasePath(), context);
        this.runCompaction(table, context, config, upgradeDowngradeHelper);
        SixToFiveDowngradeHandler.syncCompactionRequestedFileToAuxiliaryFolder(table);
        HoodieTableMetaClient metaClient = HoodieTableMetaClient.reload(table.getMetaClient());
        HashMap<ConfigProperty, String> updatedTableProps = new HashMap<ConfigProperty, String>();
        HoodieTableConfig tableConfig = metaClient.getTableConfig();
        Option.ofNullable(tableConfig.getString(HoodieTableConfig.TABLE_METADATA_PARTITIONS)).ifPresent(v -> updatedTableProps.put(HoodieTableConfig.TABLE_METADATA_PARTITIONS, (String)v));
        Option.ofNullable(tableConfig.getString(HoodieTableConfig.TABLE_METADATA_PARTITIONS_INFLIGHT)).ifPresent(v -> updatedTableProps.put(HoodieTableConfig.TABLE_METADATA_PARTITIONS_INFLIGHT, (String)v));
        return updatedTableProps;
    }

    private void runCompaction(HoodieTable table, HoodieEngineContext context, HoodieWriteConfig config, SupportsUpgradeDowngrade upgradeDowngradeHelper) {
        block15: {
            try {
                if (table.getMetaClient().getTableType() != HoodieTableType.MERGE_ON_READ) break block15;
                HoodieInstantTimeGenerator.setCommitTimeZone(table.getMetaClient().getTableConfig().getTimelineTimezone());
                HoodieWriteConfig compactionConfig = HoodieWriteConfig.newBuilder().withProps(config.getProps()).build();
                compactionConfig.setValue(HoodieCompactionConfig.INLINE_COMPACT.key(), "true");
                compactionConfig.setValue(HoodieCompactionConfig.INLINE_COMPACT_NUM_DELTA_COMMITS.key(), "1");
                compactionConfig.setValue(HoodieCompactionConfig.INLINE_COMPACT_TRIGGER_STRATEGY.key(), CompactionTriggerStrategy.NUM_COMMITS.name());
                compactionConfig.setValue(HoodieCompactionConfig.COMPACTION_STRATEGY.key(), UnBoundedCompactionStrategy.class.getName());
                compactionConfig.setValue(HoodieMetadataConfig.ENABLE.key(), "false");
                try (BaseHoodieWriteClient writeClient = upgradeDowngradeHelper.getWriteClient(compactionConfig, context);){
                    Option<String> compactionInstantOpt = writeClient.scheduleCompaction(Option.empty());
                    if (compactionInstantOpt.isPresent()) {
                        writeClient.compact(compactionInstantOpt.get());
                    }
                }
            }
            catch (Exception e) {
                throw new HoodieException(e);
            }
        }
    }

    private static void syncCompactionRequestedFileToAuxiliaryFolder(HoodieTable table) {
        HoodieTableMetaClient metaClient = table.getMetaClient();
        HoodieTimeline compactionTimeline = new HoodieActiveTimeline(metaClient, false).filterPendingCompactionTimeline().filter(instant -> instant.getState() == HoodieInstant.State.REQUESTED);
        compactionTimeline.getInstantsAsStream().forEach(instant -> {
            String fileName = instant.getFileName();
            FileIOUtils.copy(metaClient.getStorage(), new StoragePath(metaClient.getMetaPath(), fileName), new StoragePath(metaClient.getMetaAuxiliaryPath(), fileName));
        });
    }
}

