/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.format.mor;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.table.format.mor.MergeOnReadInputSplit;

public class MergeOnReadTableState
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final RowType rowType;
    private final RowType requiredRowType;
    private final String avroSchema;
    private final String requiredAvroSchema;
    private final List<MergeOnReadInputSplit> inputSplits;
    private final String[] pkFields;
    private final int operationPos;

    public MergeOnReadTableState(RowType rowType, RowType requiredRowType, String avroSchema, String requiredAvroSchema, List<MergeOnReadInputSplit> inputSplits, String[] pkFields) {
        this.rowType = rowType;
        this.requiredRowType = requiredRowType;
        this.avroSchema = avroSchema;
        this.requiredAvroSchema = requiredAvroSchema;
        this.inputSplits = inputSplits;
        this.pkFields = pkFields;
        this.operationPos = rowType.getFieldIndex(HoodieRecord.OPERATION_METADATA_FIELD);
    }

    public RowType getRowType() {
        return this.rowType;
    }

    public RowType getRequiredRowType() {
        return this.requiredRowType;
    }

    public String getAvroSchema() {
        return this.avroSchema;
    }

    public String getRequiredAvroSchema() {
        return this.requiredAvroSchema;
    }

    public List<MergeOnReadInputSplit> getInputSplits() {
        return this.inputSplits;
    }

    public int getOperationPos() {
        return this.operationPos;
    }

    public int[] getRequiredPositions() {
        List fieldNames = this.rowType.getFieldNames();
        return this.requiredRowType.getFieldNames().stream().map(fieldNames::indexOf).mapToInt(i -> i).toArray();
    }

    public int[] getPkOffsetsInRequired() {
        List fieldNames = this.requiredRowType.getFieldNames();
        return Arrays.stream(this.pkFields).map(fieldNames::indexOf).mapToInt(i -> i).toArray();
    }

    public LogicalType[] getPkTypes(int[] pkOffsets) {
        LogicalType[] requiredTypes = (LogicalType[])this.requiredRowType.getFields().stream().map(RowType.RowField::getType).toArray(LogicalType[]::new);
        return (LogicalType[])Arrays.stream(pkOffsets).mapToObj(offset -> requiredTypes[offset]).toArray(LogicalType[]::new);
    }
}

