/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.rollback;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hudi.avro.model.HoodieRollbackRequest;
import org.apache.hudi.client.utils.MetadataConversionUtils;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.FileSlice;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.model.HoodieWriteStat;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieRollbackException;
import org.apache.hudi.hadoop.fs.HadoopFSUtils;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.rollback.BaseRollbackPlanActionExecutor;
import org.apache.hudi.table.action.rollback.SerializablePathFilter;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListingBasedRollbackStrategy
implements BaseRollbackPlanActionExecutor.RollbackStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(ListingBasedRollbackStrategy.class);
    protected final HoodieTable<?, ?, ?, ?> table;
    protected final transient HoodieEngineContext context;
    protected final HoodieWriteConfig config;
    protected final String instantTime;
    protected final Boolean isRestore;

    public ListingBasedRollbackStrategy(HoodieTable<?, ?, ?, ?> table, HoodieEngineContext context, HoodieWriteConfig config, String instantTime, boolean isRestore) {
        this.table = table;
        this.context = context;
        this.config = config;
        this.instantTime = instantTime;
        this.isRestore = isRestore;
    }

    @Override
    public List<HoodieRollbackRequest> getRollbackRequests(HoodieInstant instantToRollback) {
        try {
            HoodieTableMetaClient metaClient = this.table.getMetaClient();
            List<String> partitionPaths = FSUtils.getAllPartitionPaths(this.context, this.table.getStorage(), this.table.getMetaClient().getBasePath(), false, false);
            int numPartitions = Math.max(Math.min(partitionPaths.size(), this.config.getRollbackParallelism()), 1);
            this.context.setJobStatus(this.getClass().getSimpleName(), "Creating Listing Rollback Plan: " + this.config.getTableName());
            HoodieTableType tableType = this.table.getMetaClient().getTableType();
            String baseFileExtension = this.getBaseFileExtension(metaClient);
            Option<HoodieCommitMetadata> commitMetadataOptional = MetadataConversionUtils.getHoodieCommitMetadata(metaClient, instantToRollback);
            Boolean isCommitMetadataCompleted = this.checkCommitMetadataCompleted(instantToRollback, commitMetadataOptional);
            AtomicBoolean isCompaction = new AtomicBoolean(false);
            if (commitMetadataOptional.isPresent()) {
                isCompaction.set(commitMetadataOptional.get().getOperationType() == WriteOperationType.COMPACT);
            }
            return this.context.flatMap(partitionPaths, partitionPath -> {
                ArrayList<HoodieRollbackRequest> hoodieRollbackRequests;
                block15: {
                    block16: {
                        FileStatus[] filesToDelete;
                        block14: {
                            hoodieRollbackRequests = new ArrayList<HoodieRollbackRequest>(partitionPaths.size());
                            filesToDelete = this.fetchFilesFromInstant(instantToRollback, (String)partitionPath, metaClient.getBasePath(), baseFileExtension, (FileSystem)metaClient.getStorage().getFileSystem(), commitMetadataOptional, isCommitMetadataCompleted, tableType);
                            if (HoodieTableType.COPY_ON_WRITE != tableType) break block14;
                            hoodieRollbackRequests.addAll(this.getHoodieRollbackRequests((String)partitionPath, filesToDelete));
                            break block15;
                        }
                        if (HoodieTableType.MERGE_ON_READ != tableType) break block16;
                        String commit = instantToRollback.getTimestamp();
                        HoodieActiveTimeline activeTimeline = this.table.getMetaClient().reloadActiveTimeline();
                        String action = instantToRollback.getAction();
                        if (isCompaction.get()) {
                            action = "compaction";
                        }
                        switch (action) {
                            case "commit": 
                            case "replacecommit": {
                                hoodieRollbackRequests.addAll(this.getHoodieRollbackRequests((String)partitionPath, filesToDelete));
                                break;
                            }
                            case "compaction": {
                                if (!this.isRestore.booleanValue()) {
                                    hoodieRollbackRequests.addAll(this.getHoodieRollbackRequests((String)partitionPath, this.listBaseFilesToBeDeleted(instantToRollback.getTimestamp(), baseFileExtension, (String)partitionPath, (FileSystem)metaClient.getStorage().getFileSystem())));
                                    break;
                                }
                                hoodieRollbackRequests.addAll(this.getHoodieRollbackRequests((String)partitionPath, filesToDelete));
                                break;
                            }
                            case "deltacommit": {
                                HoodieCommitMetadata commitMetadata = HoodieCommitMetadata.fromBytes(this.table.getMetaClient().getCommitsTimeline().getInstantDetails(instantToRollback).get(), HoodieCommitMetadata.class);
                                hoodieRollbackRequests.addAll(this.getHoodieRollbackRequests((String)partitionPath, filesToDelete));
                                if (commitMetadata.getPartitionToWriteStats().containsKey(partitionPath)) {
                                    hoodieRollbackRequests.addAll(ListingBasedRollbackStrategy.getRollbackRequestToAppend(partitionPath, instantToRollback, commitMetadata, this.table));
                                    break;
                                }
                                break block15;
                            }
                            default: {
                                throw new HoodieRollbackException("Unknown listing type, during rollback of " + instantToRollback);
                            }
                        }
                        break block15;
                    }
                    throw new HoodieRollbackException(String.format("Unsupported table type: %s, during listing rollback of %s", new Object[]{tableType, instantToRollback}));
                }
                return hoodieRollbackRequests.stream();
            }, numPartitions);
        }
        catch (Exception e) {
            LOG.error("Generating rollback requests failed for " + instantToRollback.getTimestamp(), (Throwable)e);
            throw new HoodieRollbackException("Generating rollback requests failed for " + instantToRollback.getTimestamp(), e);
        }
    }

    private String getBaseFileExtension(HoodieTableMetaClient metaClient) {
        return metaClient.getTableConfig().getBaseFileFormat().getFileExtension();
    }

    @NotNull
    private List<HoodieRollbackRequest> getHoodieRollbackRequests(String partitionPath, FileStatus[] filesToDeletedStatus) {
        return Arrays.stream(filesToDeletedStatus).map(fileStatus -> {
            String dataFileToBeDeleted = fileStatus.getPath().toString();
            return dataFileToBeDeleted.substring(dataFileToBeDeleted.indexOf(":") + 1);
        }).map(s -> new HoodieRollbackRequest(partitionPath, "", "", Collections.singletonList(s), Collections.emptyMap())).collect(Collectors.toList());
    }

    private FileStatus[] listBaseFilesToBeDeleted(String commit, String basefileExtension, String partitionPath, FileSystem fs) throws IOException {
        LOG.info("Collecting files to be cleaned/rolledback up for path " + partitionPath + " and commit " + commit);
        PathFilter filter = path -> {
            if (path.toString().contains(basefileExtension)) {
                String fileCommitTime = FSUtils.getCommitTime(path.getName());
                return commit.equals(fileCommitTime);
            }
            return false;
        };
        return fs.listStatus(HadoopFSUtils.constructAbsolutePathInHadoopPath(this.config.getBasePath(), partitionPath), filter);
    }

    private FileStatus[] fetchFilesFromInstant(HoodieInstant instantToRollback, String partitionPath, String basePath, String baseFileExtension, FileSystem fs, Option<HoodieCommitMetadata> commitMetadataOptional, Boolean isCommitMetadataCompleted, HoodieTableType tableType) throws IOException {
        if (isCommitMetadataCompleted.booleanValue() && tableType == HoodieTableType.COPY_ON_WRITE) {
            return this.fetchFilesFromCommitMetadata(instantToRollback, partitionPath, basePath, commitMetadataOptional.get(), baseFileExtension, fs);
        }
        return this.fetchFilesFromListFiles(instantToRollback, partitionPath, basePath, baseFileExtension, fs);
    }

    private FileStatus[] fetchFilesFromCommitMetadata(HoodieInstant instantToRollback, String partitionPath, String basePath, HoodieCommitMetadata commitMetadata, String baseFileExtension, FileSystem fs) throws IOException {
        SerializablePathFilter pathFilter = ListingBasedRollbackStrategy.getSerializablePathFilter(baseFileExtension, instantToRollback.getTimestamp());
        Path[] filePaths = ListingBasedRollbackStrategy.getFilesFromCommitMetadata(basePath, commitMetadata, partitionPath);
        return fs.listStatus((Path[])Arrays.stream(filePaths).filter(entry -> {
            try {
                return fs.exists(entry);
            }
            catch (Exception e) {
                LOG.error("Exists check failed for " + entry.toString(), (Throwable)e);
                return true;
            }
        }).toArray(Path[]::new), (PathFilter)pathFilter);
    }

    private FileStatus[] fetchFilesFromListFiles(HoodieInstant instantToRollback, String partitionPath, String basePath, String baseFileExtension, FileSystem fs) throws IOException {
        SerializablePathFilter pathFilter = ListingBasedRollbackStrategy.getSerializablePathFilter(baseFileExtension, instantToRollback.getTimestamp());
        Path[] filePaths = ListingBasedRollbackStrategy.listFilesToBeDeleted(basePath, partitionPath);
        return fs.listStatus(filePaths, (PathFilter)pathFilter);
    }

    private Boolean checkCommitMetadataCompleted(HoodieInstant instantToRollback, Option<HoodieCommitMetadata> commitMetadataOptional) {
        return commitMetadataOptional.isPresent() && instantToRollback.isCompleted() && !WriteOperationType.UNKNOWN.equals((Object)commitMetadataOptional.get().getOperationType());
    }

    private static Path[] listFilesToBeDeleted(String basePath, String partitionPath) {
        return new Path[]{HadoopFSUtils.constructAbsolutePathInHadoopPath(basePath, partitionPath)};
    }

    private static Path[] getFilesFromCommitMetadata(String basePath, HoodieCommitMetadata commitMetadata, String partitionPath) {
        List<String> fullPaths = commitMetadata.getFullPathsByPartitionPath(basePath, partitionPath);
        return (Path[])fullPaths.stream().map(Path::new).toArray(Path[]::new);
    }

    @NotNull
    private static SerializablePathFilter getSerializablePathFilter(String basefileExtension, String commit) {
        return path -> {
            if (path.toString().endsWith(basefileExtension)) {
                String fileCommitTime = FSUtils.getCommitTime(path.getName());
                return commit.equals(fileCommitTime);
            }
            if (HadoopFSUtils.isLogFile(path)) {
                String fileCommitTime = FSUtils.getBaseCommitTimeFromLogPath(HadoopFSUtils.convertToStoragePath(path));
                return commit.equals(fileCommitTime);
            }
            return false;
        };
    }

    public static List<HoodieRollbackRequest> getRollbackRequestToAppend(String partitionPath, HoodieInstant rollbackInstant, HoodieCommitMetadata commitMetadata, HoodieTable<?, ?, ?, ?> table) {
        ArrayList<HoodieRollbackRequest> hoodieRollbackRequests = new ArrayList<HoodieRollbackRequest>();
        ValidationUtils.checkArgument(rollbackInstant.getAction().equals("deltacommit"));
        Map latestFileSlices = table.getSliceView().getLatestFileSlicesBeforeOrOn(partitionPath, rollbackInstant.getTimestamp(), true).collect(Collectors.toMap(FileSlice::getFileId, Function.identity()));
        List hoodieWriteStats = commitMetadata.getPartitionToWriteStats().get(partitionPath).stream().filter(writeStat -> {
            boolean validForRollback;
            boolean bl = validForRollback = writeStat != null && !writeStat.getPrevCommit().equals("null") && writeStat.getPrevCommit() != null && latestFileSlices.containsKey(writeStat.getFileId());
            if (!validForRollback) {
                return false;
            }
            FileSlice latestFileSlice = (FileSlice)latestFileSlices.get(writeStat.getFileId());
            ValidationUtils.checkArgument(HoodieTimeline.compareTimestamps(latestFileSlice.getBaseInstantTime(), HoodieTimeline.LESSER_THAN_OR_EQUALS, rollbackInstant.getTimestamp()), "Log-file base-instant could not be less than the instant being rolled back");
            return HoodieTimeline.compareTimestamps(latestFileSlice.getBaseInstantTime(), HoodieTimeline.LESSER_THAN, rollbackInstant.getTimestamp());
        }).collect(Collectors.toList());
        for (HoodieWriteStat writeStat2 : hoodieWriteStats.stream().filter(hoodieWriteStat -> !StringUtils.isNullOrEmpty(hoodieWriteStat.getFileId())).collect(Collectors.toList())) {
            FileSlice latestFileSlice = (FileSlice)latestFileSlices.get(writeStat2.getFileId());
            String fileId = writeStat2.getFileId();
            String latestBaseInstant = latestFileSlice.getBaseInstantTime();
            Path fullLogFilePath = HadoopFSUtils.constructAbsolutePathInHadoopPath(table.getConfig().getBasePath(), writeStat2.getPath());
            Map<String, Long> logFilesWithBlocksToRollback = Collections.singletonMap(fullLogFilePath.toString(), writeStat2.getTotalWriteBytes() > 0L ? writeStat2.getTotalWriteBytes() : 1L);
            hoodieRollbackRequests.add(new HoodieRollbackRequest(partitionPath, fileId, latestBaseInstant, Collections.emptyList(), logFilesWithBlocksToRollback));
        }
        return hoodieRollbackRequests;
    }
}

