/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.commit;

import java.io.IOException;
import java.time.Duration;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.common.data.HoodieData;
import org.apache.hudi.common.data.HoodieListData;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieWriteStat;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.util.CommitUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieCommitException;
import org.apache.hudi.exception.HoodieUpsertException;
import org.apache.hudi.execution.FlinkLazyInsertIterable;
import org.apache.hudi.io.ExplicitWriteHandleFactory;
import org.apache.hudi.io.HoodieCreateHandle;
import org.apache.hudi.io.HoodieMergeHandle;
import org.apache.hudi.io.HoodieWriteHandle;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.HoodieWriteMetadata;
import org.apache.hudi.table.action.commit.BaseCommitActionExecutor;
import org.apache.hudi.table.action.commit.BucketType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseFlinkCommitActionExecutor<T>
extends BaseCommitActionExecutor<T, List<HoodieRecord<T>>, List<HoodieKey>, List<WriteStatus>, HoodieWriteMetadata> {
    private static final Logger LOG = LoggerFactory.getLogger(BaseFlinkCommitActionExecutor.class);
    protected HoodieWriteHandle<?, ?, ?, ?> writeHandle;

    public BaseFlinkCommitActionExecutor(HoodieEngineContext context, HoodieWriteHandle<?, ?, ?, ?> writeHandle, HoodieWriteConfig config, HoodieTable table, String instantTime, WriteOperationType operationType) {
        this(context, writeHandle, config, table, instantTime, operationType, Option.empty());
    }

    public BaseFlinkCommitActionExecutor(HoodieEngineContext context, HoodieWriteHandle<?, ?, ?, ?> writeHandle, HoodieWriteConfig config, HoodieTable table, String instantTime, WriteOperationType operationType, Option extraMetadata) {
        super(context, config, table, instantTime, operationType, extraMetadata);
        this.writeHandle = writeHandle;
    }

    @Override
    public HoodieWriteMetadata<List<WriteStatus>> execute(List<HoodieRecord<T>> inputRecords) {
        HoodieWriteMetadata<List<WriteStatus>> result = new HoodieWriteMetadata<List<WriteStatus>>();
        LinkedList<WriteStatus> writeStatuses = new LinkedList<WriteStatus>();
        HoodieRecord<T> record = inputRecords.get(0);
        String partitionPath = record.getPartitionPath();
        String fileId = record.getCurrentLocation().getFileId();
        BucketType bucketType = record.getCurrentLocation().getInstantTime().equals("I") ? BucketType.INSERT : BucketType.UPDATE;
        this.handleUpsertPartition(partitionPath, fileId, bucketType, inputRecords.iterator()).forEachRemaining(writeStatuses::addAll);
        this.setUpWriteMetadata(writeStatuses, result);
        return result;
    }

    protected void setUpWriteMetadata(List<WriteStatus> statuses, HoodieWriteMetadata<List<WriteStatus>> result) {
        result.setWriteStatuses(statuses);
        result.setIndexUpdateDuration(Duration.ZERO);
    }

    @Override
    protected String getCommitActionType() {
        return this.table.getMetaClient().getCommitActionType();
    }

    @Override
    protected void commit(Option<Map<String, String>> extraMetadata, HoodieWriteMetadata<List<WriteStatus>> result) {
        this.commit(extraMetadata, HoodieListData.eager(result.getWriteStatuses()), result, result.getWriteStatuses().stream().map(WriteStatus::getStat).collect(Collectors.toList()));
    }

    @Override
    protected void setCommitMetadata(HoodieWriteMetadata<List<WriteStatus>> result) {
        result.setCommitMetadata(Option.of(CommitUtils.buildMetadata(result.getWriteStatuses().stream().map(WriteStatus::getStat).collect(Collectors.toList()), result.getPartitionToReplaceFileIds(), this.extraMetadata, this.operationType, this.getSchemaToStoreInCommit(), this.getCommitActionType())));
    }

    protected void commit(Option<Map<String, String>> extraMetadata, HoodieData<WriteStatus> writeStatuses, HoodieWriteMetadata<List<WriteStatus>> result, List<HoodieWriteStat> writeStats) {
        String actionType = this.getCommitActionType();
        LOG.info("Committing " + this.instantTime + ", action Type " + actionType);
        result.setCommitted(true);
        result.setWriteStats(writeStats);
        this.finalizeWrite(this.instantTime, writeStats, result);
        try {
            LOG.info("Committing " + this.instantTime + ", action Type " + this.getCommitActionType());
            HoodieActiveTimeline activeTimeline = this.table.getActiveTimeline();
            HoodieCommitMetadata metadata = result.getCommitMetadata().get();
            this.writeTableMetadata(metadata, writeStatuses, actionType);
            activeTimeline.saveAsComplete(new HoodieInstant(true, this.getCommitActionType(), this.instantTime), Option.of(StringUtils.getUTF8Bytes(metadata.toJsonString())));
            LOG.info("Committed " + this.instantTime);
            result.setCommitMetadata(Option.of(metadata));
        }
        catch (IOException e) {
            throw new HoodieCommitException("Failed to complete commit " + this.config.getBasePath() + " at time " + this.instantTime, e);
        }
    }

    protected Iterator<List<WriteStatus>> handleUpsertPartition(String partitionPath, String fileIdHint, BucketType bucketType, Iterator recordItr) {
        try {
            if (this.writeHandle instanceof HoodieCreateHandle) {
                return this.handleInsert(fileIdHint, recordItr);
            }
            if (this.writeHandle instanceof HoodieMergeHandle) {
                return this.handleUpdate(partitionPath, fileIdHint, recordItr);
            }
            switch (bucketType) {
                case INSERT: {
                    return this.handleInsert(fileIdHint, recordItr);
                }
                case UPDATE: {
                    return this.handleUpdate(partitionPath, fileIdHint, recordItr);
                }
            }
            throw new AssertionError();
        }
        catch (Throwable t) {
            String msg = "Error upserting bucketType " + (Object)((Object)bucketType) + " for partition :" + partitionPath;
            LOG.error(msg, t);
            throw new HoodieUpsertException(msg, t);
        }
    }

    @Override
    public Iterator<List<WriteStatus>> handleUpdate(String partitionPath, String fileId, Iterator<HoodieRecord<T>> recordItr) throws IOException {
        if (!recordItr.hasNext()) {
            LOG.info("Empty partition with fileId => " + fileId);
            return Collections.singletonList(Collections.EMPTY_LIST).iterator();
        }
        HoodieMergeHandle upsertHandle = (HoodieMergeHandle)this.writeHandle;
        return this.handleUpdateInternal(upsertHandle, fileId);
    }

    protected Iterator<List<WriteStatus>> handleUpdateInternal(HoodieMergeHandle<?, ?, ?, ?> upsertHandle, String fileId) throws IOException {
        this.table.runMerge(upsertHandle, this.instantTime, fileId);
        return upsertHandle.getWriteStatusesAsIterator();
    }

    @Override
    public Iterator<List<WriteStatus>> handleInsert(String idPfx, Iterator<HoodieRecord<T>> recordItr) throws Exception {
        if (!recordItr.hasNext()) {
            LOG.info("Empty partition");
            return Collections.singletonList(Collections.EMPTY_LIST).iterator();
        }
        return new FlinkLazyInsertIterable<T>(recordItr, true, this.config, this.instantTime, this.table, idPfx, this.taskContextSupplier, new ExplicitWriteHandleFactory(this.writeHandle));
    }
}

