/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.sink.utils;

import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.hudi.exception.HoodieException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeWait {
    private static final Logger LOG = LoggerFactory.getLogger(TimeWait.class);
    private final long timeout;
    private final long interval;
    private final String action;
    private long waitingTime = 0L;

    private TimeWait(long timeout, long interval, String action) {
        this.timeout = timeout;
        this.interval = interval;
        this.action = action;
    }

    public static Builder builder() {
        return new Builder();
    }

    public void waitFor() {
        try {
            if (this.waitingTime > this.timeout) {
                throw new HoodieException("Timeout(" + this.waitingTime + "ms) while waiting for " + this.action);
            }
            TimeUnit.MILLISECONDS.sleep(this.interval);
            this.waitingTime += this.interval;
        }
        catch (InterruptedException e) {
            throw new HoodieException("Error while waiting for " + this.action, e);
        }
    }

    public static class Builder {
        private long timeout = 300000L;
        private long interval = 1000L;
        private String action;

        private Builder() {
        }

        public Builder timeout(long timeout) {
            if (timeout > 0L) {
                this.timeout = timeout;
            }
            return this;
        }

        public Builder interval(long interval) {
            this.interval = interval;
            return this;
        }

        public Builder action(String action) {
            this.action = action;
            return this;
        }

        public TimeWait build() {
            Objects.requireNonNull(this.action);
            return new TimeWait(this.timeout, this.interval, this.action);
        }
    }
}

