/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.secondary.index;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.TableSchemaResolver;
import org.apache.hudi.common.util.CollectionUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.exception.HoodieSecondaryIndexException;
import org.apache.hudi.org.apache.avro.Schema;
import org.apache.hudi.secondary.index.HoodieSecondaryIndex;
import org.apache.hudi.secondary.index.SecondaryIndexUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecondaryIndexManager {
    private static final Logger LOG = LoggerFactory.getLogger(SecondaryIndexManager.class);
    private static volatile SecondaryIndexManager _instance;

    private SecondaryIndexManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SecondaryIndexManager getInstance() {
        if (_instance != null) return _instance;
        Class<SecondaryIndexManager> clazz = SecondaryIndexManager.class;
        synchronized (SecondaryIndexManager.class) {
            if (_instance != null) return _instance;
            _instance = new SecondaryIndexManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return _instance;
        }
    }

    public void create(HoodieTableMetaClient metaClient, String indexName, String indexType, boolean ignoreIfExists, LinkedHashMap<String, Map<String, String>> columns, Map<String, String> options) {
        Schema avroSchema;
        Option<List<HoodieSecondaryIndex>> secondaryIndexes = SecondaryIndexUtils.getSecondaryIndexes(metaClient);
        Set<String> colNames = columns.keySet();
        try {
            avroSchema = new TableSchemaResolver(metaClient).getTableAvroSchema(false);
        }
        catch (Exception e) {
            throw new HoodieSecondaryIndexException("Failed to get table avro schema: " + metaClient.getTableConfig().getTableName());
        }
        for (String col : colNames) {
            if (avroSchema.getField(col) != null) continue;
            throw new HoodieSecondaryIndexException("Field not exists: " + col);
        }
        if (this.indexExists(secondaryIndexes, indexName, Option.of(indexType), Option.of(colNames))) {
            if (ignoreIfExists) {
                return;
            }
            throw new HoodieSecondaryIndexException("Secondary index already exists: " + indexName);
        }
        HoodieSecondaryIndex secondaryIndexToAdd = HoodieSecondaryIndex.builder().setIndexName(indexName).setIndexType(indexType).setColumns(columns).setOptions(options).build();
        List newSecondaryIndexes = secondaryIndexes.map(h -> {
            h.add(secondaryIndexToAdd);
            return h;
        }).orElseGet(() -> Collections.singletonList(secondaryIndexToAdd));
        newSecondaryIndexes.sort(new HoodieSecondaryIndex.HoodieIndexCompactor());
        Properties updatedProps = new Properties();
        updatedProps.put(HoodieTableConfig.SECONDARY_INDEXES_METADATA.key(), SecondaryIndexUtils.toJsonString(newSecondaryIndexes));
        HoodieTableConfig.update(metaClient.getStorage(), metaClient.getMetaPath(), updatedProps);
        LOG.info("Success to add secondary index metadata: {}", (Object)secondaryIndexToAdd);
    }

    public void drop(HoodieTableMetaClient metaClient, String indexName, boolean ignoreIfNotExists) {
        Option<List<HoodieSecondaryIndex>> secondaryIndexes = SecondaryIndexUtils.getSecondaryIndexes(metaClient);
        if (!this.indexExists(secondaryIndexes, indexName, Option.empty(), Option.empty())) {
            if (ignoreIfNotExists) {
                return;
            }
            throw new HoodieSecondaryIndexException("Secondary index not exists: " + indexName);
        }
        List secondaryIndexesToKeep = secondaryIndexes.get().stream().filter(i -> !i.getIndexName().equals(indexName)).sorted(new HoodieSecondaryIndex.HoodieIndexCompactor()).collect(Collectors.toList());
        if (CollectionUtils.nonEmpty(secondaryIndexesToKeep)) {
            Properties updatedProps = new Properties();
            updatedProps.put(HoodieTableConfig.SECONDARY_INDEXES_METADATA.key(), SecondaryIndexUtils.toJsonString(secondaryIndexesToKeep));
            HoodieTableConfig.update(metaClient.getStorage(), metaClient.getMetaPath(), updatedProps);
        } else {
            HoodieTableConfig.delete(metaClient.getStorage(), metaClient.getMetaPath(), CollectionUtils.createSet(HoodieTableConfig.SECONDARY_INDEXES_METADATA.key()));
        }
        LOG.info("Success to delete secondary index metadata: {}", (Object)indexName);
    }

    public Option<List<HoodieSecondaryIndex>> show(HoodieTableMetaClient metaClient) {
        return SecondaryIndexUtils.getSecondaryIndexes(metaClient);
    }

    public void refresh(HoodieTableMetaClient metaClient, String indexName) {
    }

    private boolean indexExists(Option<List<HoodieSecondaryIndex>> secondaryIndexes, String indexName, Option<String> indexType, Option<Set<String>> colNames) {
        return secondaryIndexes.map(indexes -> indexes.stream().anyMatch(index -> {
            if (index.getIndexName().equals(indexName)) {
                return true;
            }
            if (indexType.isPresent() && colNames.isPresent()) {
                return index.getIndexType().name().equalsIgnoreCase((String)indexType.get()) && CollectionUtils.diff(index.getColumns().keySet(), (Collection)colNames.get()).isEmpty();
            }
            return false;
        })).orElse(false);
    }
}

