/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.security.provider;

import java.io.IOException;
import java.net.InetAddress;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextInputCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.RealmCallback;
import javax.security.sasl.RealmChoiceCallback;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslClient;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hudi.org.apache.hadoop.hbase.security.SaslUtil;
import org.apache.hudi.org.apache.hadoop.hbase.security.SecurityInfo;
import org.apache.hudi.org.apache.hadoop.hbase.security.User;
import org.apache.hudi.org.apache.hadoop.hbase.security.provider.DigestSaslAuthenticationProvider;
import org.apache.hudi.org.apache.hadoop.hbase.security.provider.SaslClientAuthenticationProvider;
import org.apache.hudi.org.apache.hadoop.hbase.shaded.protobuf.generated.RPCProtos;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class DigestSaslClientAuthenticationProvider
extends DigestSaslAuthenticationProvider
implements SaslClientAuthenticationProvider {
    @Override
    public SaslClient createClient(Configuration conf, InetAddress serverAddr, SecurityInfo securityInfo, Token<? extends TokenIdentifier> token, boolean fallbackAllowed, Map<String, String> saslProps) throws IOException {
        return Sasl.createSaslClient(new String[]{this.getSaslAuthMethod().getSaslMechanism()}, null, null, "default", saslProps, new DigestSaslClientCallbackHandler(token));
    }

    @Override
    public RPCProtos.UserInformation getUserInfo(User user) {
        return null;
    }

    public static class DigestSaslClientCallbackHandler
    implements CallbackHandler {
        private static final Logger LOG = LoggerFactory.getLogger(DigestSaslClientCallbackHandler.class);
        private final String userName;
        private final char[] userPassword;

        public DigestSaslClientCallbackHandler(Token<? extends TokenIdentifier> token) {
            this.userName = SaslUtil.encodeIdentifier(token.getIdentifier());
            this.userPassword = SaslUtil.encodePassword(token.getPassword());
        }

        @Override
        public void handle(Callback[] callbacks) throws UnsupportedCallbackException {
            NameCallback nc = null;
            PasswordCallback pc = null;
            TextInputCallback rc = null;
            for (Callback callback : callbacks) {
                if (callback instanceof RealmChoiceCallback) continue;
                if (callback instanceof NameCallback) {
                    nc = (NameCallback)callback;
                    continue;
                }
                if (callback instanceof PasswordCallback) {
                    pc = (PasswordCallback)callback;
                    continue;
                }
                if (callback instanceof RealmCallback) {
                    rc = (RealmCallback)callback;
                    continue;
                }
                throw new UnsupportedCallbackException(callback, "Unrecognized SASL client callback");
            }
            if (nc != null) {
                LOG.debug("SASL client callback: setting username: {}", (Object)this.userName);
                nc.setName(this.userName);
            }
            if (pc != null) {
                LOG.debug("SASL client callback: setting userPassword");
                pc.setPassword(this.userPassword);
            }
            if (rc != null) {
                LOG.debug("SASL client callback: setting realm: {}", (Object)rc.getDefaultText());
                rc.setText(rc.getDefaultText());
            }
        }
    }
}

