/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.metrics;

import java.text.ParseException;
import java.time.Duration;
import java.time.Instant;
import org.apache.flink.metrics.MetricGroup;
import org.apache.hudi.common.table.timeline.HoodieInstantTimeGenerator;
import org.apache.hudi.metrics.HoodieFlinkMetrics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlinkStreamReadMetrics
extends HoodieFlinkMetrics {
    private static final Logger LOG = LoggerFactory.getLogger(FlinkStreamReadMetrics.class);
    private long issuedInstant;
    private long issuedInstantDelay;
    private long splitLatestCommit;
    private long splitLatestCommitDelay;

    public FlinkStreamReadMetrics(MetricGroup metricGroup) {
        super(metricGroup);
    }

    @Override
    public void registerMetrics() {
        this.metricGroup.gauge("issuedInstantDelay", () -> this.issuedInstantDelay);
        this.metricGroup.gauge("issuedInstant", () -> this.issuedInstant);
        this.metricGroup.gauge("splitLatestCommit", () -> this.splitLatestCommit);
        this.metricGroup.gauge("splitLatestCommitDelay", () -> this.splitLatestCommitDelay);
    }

    public void setIssuedInstant(String issuedInstant) {
        try {
            Instant instant = HoodieInstantTimeGenerator.parseDateFromInstantTime(issuedInstant).toInstant();
            this.issuedInstant = instant.getEpochSecond();
            this.issuedInstantDelay = Duration.between(instant, Instant.now()).getSeconds();
        }
        catch (ParseException e) {
            LOG.warn("Invalid input issued instant: " + issuedInstant);
        }
    }

    public void setSplitLatestCommit(String splitLatestCommit) {
        try {
            Instant instant = HoodieInstantTimeGenerator.parseDateFromInstantTime(splitLatestCommit).toInstant();
            this.splitLatestCommit = instant.getEpochSecond();
            this.splitLatestCommitDelay = Duration.between(instant, Instant.now()).getSeconds();
        }
        catch (ParseException e) {
            LOG.warn("Invalid input latest commit" + splitLatestCommit);
        }
    }
}

