/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io.hfile;

import org.apache.hudi.io.compress.CompressionCodec;
import org.apache.hudi.io.compress.HoodieDecompressor;
import org.apache.hudi.io.compress.HoodieDecompressorFactory;

public class HFileContext {
    private final CompressionCodec compressionCodec;
    private final HoodieDecompressor decompressor;

    private HFileContext(CompressionCodec compressionCodec) {
        this.compressionCodec = compressionCodec;
        this.decompressor = HoodieDecompressorFactory.getDecompressor(compressionCodec);
    }

    CompressionCodec getCompressionCodec() {
        return this.compressionCodec;
    }

    HoodieDecompressor getDecompressor() {
        return this.decompressor;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private CompressionCodec compressionCodec = CompressionCodec.NONE;

        public Builder compressionCodec(CompressionCodec compressionCodec) {
            this.compressionCodec = compressionCodec;
            return this;
        }

        public HFileContext build() {
            return new HFileContext(this.compressionCodec);
        }
    }
}

