/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.index.bucket;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.hudi.client.utils.LazyIterableIterator;
import org.apache.hudi.common.data.HoodieData;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordLocation;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.exception.HoodieIndexException;
import org.apache.hudi.index.HoodieIndexUtils;
import org.apache.hudi.index.bucket.BucketIdentifier;
import org.apache.hudi.index.bucket.HoodieBucketIndex;
import org.apache.hudi.table.HoodieTable;

public class HoodieSimpleBucketIndex
extends HoodieBucketIndex {
    public HoodieSimpleBucketIndex(HoodieWriteConfig config) {
        super(config);
    }

    public Map<Integer, HoodieRecordLocation> loadBucketIdToFileIdMappingForPartition(HoodieTable hoodieTable, String partition) {
        HashMap<Integer, HoodieRecordLocation> bucketIdToFileIdMapping = new HashMap<Integer, HoodieRecordLocation>();
        hoodieTable.getMetaClient().reloadActiveTimeline();
        HoodieIndexUtils.getLatestFileSlicesForPartition(partition, hoodieTable).forEach(fileSlice -> {
            String fileId = fileSlice.getFileId();
            String commitTime = fileSlice.getBaseInstantTime();
            int bucketId = BucketIdentifier.bucketIdFromFileId(fileId);
            if (bucketIdToFileIdMapping.containsKey(bucketId)) {
                throw new HoodieIOException("Find multiple files at partition path=" + partition + " belongs to the same bucket id = " + bucketId);
            }
            bucketIdToFileIdMapping.put(bucketId, new HoodieRecordLocation(commitTime, fileId));
        });
        return bucketIdToFileIdMapping;
    }

    public int getBucketID(HoodieKey key) {
        return BucketIdentifier.getBucketId(key, this.indexKeyFields, this.numBuckets);
    }

    @Override
    public boolean canIndexLogFiles() {
        return false;
    }

    @Override
    public <R> HoodieData<HoodieRecord<R>> tagLocation(HoodieData<HoodieRecord<R>> records, HoodieEngineContext context, final HoodieTable hoodieTable) throws HoodieIndexException {
        final HashMap partitionPathFileIDList = new HashMap();
        return records.mapPartitions(iterator2 -> new LazyIterableIterator<HoodieRecord<R>, HoodieRecord<R>>((Iterator)iterator2){

            @Override
            protected HoodieRecord<R> computeNext() {
                HoodieRecord record = (HoodieRecord)this.inputItr.next();
                int bucketId = HoodieSimpleBucketIndex.this.getBucketID(record.getKey());
                String partitionPath = record.getPartitionPath();
                if (!partitionPathFileIDList.containsKey(partitionPath)) {
                    partitionPathFileIDList.put(partitionPath, HoodieSimpleBucketIndex.this.loadBucketIdToFileIdMappingForPartition(hoodieTable, partitionPath));
                }
                HoodieRecordLocation loc = ((Map)partitionPathFileIDList.get(partitionPath)).getOrDefault(bucketId, null);
                return HoodieIndexUtils.tagAsNewRecordIfNeeded(record, Option.ofNullable(loc));
            }
        }, false);
    }
}

