/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.configuration;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.hudi.client.clustering.plan.strategy.FlinkSizeBasedClusteringPlanStrategy;
import org.apache.hudi.common.config.AdvancedConfig;
import org.apache.hudi.common.config.ConfigClassProperty;
import org.apache.hudi.common.config.ConfigGroups;
import org.apache.hudi.common.config.HoodieConfig;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.model.EventTimeAvroPayload;
import org.apache.hudi.common.model.HoodieAvroRecordMerger;
import org.apache.hudi.common.model.HoodieCleaningPolicy;
import org.apache.hudi.common.model.HoodieSyncTableStrategy;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.cdc.HoodieCDCSupplementalLoggingMode;
import org.apache.hudi.config.HoodieIndexConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.configuration.OptionsResolver;
import org.apache.hudi.hive.MultiPartKeysValueExtractor;
import org.apache.hudi.hive.ddl.HiveSyncMode;
import org.apache.hudi.index.HoodieIndex;
import org.apache.hudi.keygen.constant.KeyGeneratorOptions;
import org.apache.hudi.keygen.constant.KeyGeneratorType;
import org.apache.hudi.sink.overwrite.PartitionOverwriteMode;
import org.apache.hudi.table.action.cluster.ClusteringPlanPartitionFilterMode;

@ConfigClassProperty(name="Flink Options", groupName=ConfigGroups.Names.FLINK_SQL, description="Flink jobs using the SQL can be configured through the options in WITH clause. The actual datasource level configs are listed below.")
public class FlinkOptions
extends HoodieConfig {
    public static final ConfigOption<String> PATH = ConfigOptions.key((String)"path").stringType().noDefaultValue().withDescription("Base path for the target hoodie table.\nThe path would be created if it does not exist,\notherwise a Hoodie table expects to be initialized successfully");
    public static final ConfigOption<String> DATABASE_NAME = ConfigOptions.key((String)HoodieTableConfig.DATABASE_NAME.key()).stringType().noDefaultValue().withDescription("Database name to register to Hive metastore");
    public static final ConfigOption<String> TABLE_NAME = ConfigOptions.key((String)HoodieWriteConfig.TBL_NAME.key()).stringType().noDefaultValue().withDescription("Table name to register to Hive metastore");
    public static final String TABLE_TYPE_COPY_ON_WRITE = HoodieTableType.COPY_ON_WRITE.name();
    public static final String TABLE_TYPE_MERGE_ON_READ = HoodieTableType.MERGE_ON_READ.name();
    public static final ConfigOption<String> TABLE_TYPE = ConfigOptions.key((String)"table.type").stringType().defaultValue((Object)TABLE_TYPE_COPY_ON_WRITE).withFallbackKeys(new String[]{HoodieTableConfig.TYPE.key()}).withDescription("Type of table to write. COPY_ON_WRITE (or) MERGE_ON_READ");
    public static final String NO_PRE_COMBINE = "no_precombine";
    public static final ConfigOption<String> PRECOMBINE_FIELD = ConfigOptions.key((String)"precombine.field").stringType().defaultValue((Object)"ts").withFallbackKeys(new String[]{"write.precombine.field", HoodieWriteConfig.PRECOMBINE_FIELD_NAME.key()}).withDescription("Field used in preCombining before actual write. When two records have the same\nkey value, we will pick the one with the largest value for the precombine field,\ndetermined by Object.compareTo(..)");
    @AdvancedConfig
    public static final ConfigOption<String> PAYLOAD_CLASS_NAME = ConfigOptions.key((String)"payload.class").stringType().defaultValue((Object)EventTimeAvroPayload.class.getName()).withFallbackKeys(new String[]{"write.payload.class", HoodieWriteConfig.WRITE_PAYLOAD_CLASS_NAME.key()}).withDescription("Payload class used. Override this, if you like to roll your own merge logic, when upserting/inserting.\nThis will render any value set for the option in-effective");
    @AdvancedConfig
    public static final ConfigOption<String> RECORD_MERGER_IMPLS = ConfigOptions.key((String)"record.merger.impls").stringType().defaultValue((Object)HoodieAvroRecordMerger.class.getName()).withFallbackKeys(new String[]{HoodieWriteConfig.RECORD_MERGER_IMPLS.key()}).withDescription("List of HoodieMerger implementations constituting Hudi's merging strategy -- based on the engine used. These merger impls will filter by record.merger.strategy. Hudi will pick most efficient implementation to perform merging/combining of the records (during update, reading MOR table, etc)");
    @AdvancedConfig
    public static final ConfigOption<String> RECORD_MERGER_STRATEGY = ConfigOptions.key((String)"record.merger.strategy").stringType().defaultValue((Object)"eeb8d96f-b1e4-49fd-bbf8-28ac514178e5").withFallbackKeys(new String[]{HoodieWriteConfig.RECORD_MERGER_STRATEGY.key()}).withDescription("Id of merger strategy. Hudi will pick HoodieRecordMerger implementations in record.merger.impls which has the same merger strategy id");
    @AdvancedConfig
    public static final ConfigOption<String> PARTITION_DEFAULT_NAME = ConfigOptions.key((String)"partition.default_name").stringType().defaultValue((Object)"__HIVE_DEFAULT_PARTITION__").withDescription("The default partition name in case the dynamic partition column value is null/empty string");
    public static final ConfigOption<Boolean> CHANGELOG_ENABLED = ConfigOptions.key((String)"changelog.enabled").booleanType().defaultValue((Object)false).withDescription("Whether to keep all the intermediate changes, we try to keep all the changes of a record when enabled:\n1). The sink accept the UPDATE_BEFORE message;\n2). The source try to emit every changes of a record.\nThe semantics is best effort because the compaction job would finally merge all changes of a record into one.\n default false to have UPSERT semantics");
    public static final ConfigOption<Boolean> CDC_ENABLED = ConfigOptions.key((String)"cdc.enabled").booleanType().defaultValue((Object)false).withFallbackKeys(new String[]{HoodieTableConfig.CDC_ENABLED.key()}).withDescription("When enable, persist the change data if necessary, and can be queried as a CDC query mode");
    public static final ConfigOption<String> SUPPLEMENTAL_LOGGING_MODE = ConfigOptions.key((String)"cdc.supplemental.logging.mode").stringType().defaultValue((Object)HoodieCDCSupplementalLoggingMode.DATA_BEFORE_AFTER.name()).withFallbackKeys(new String[]{HoodieTableConfig.CDC_SUPPLEMENTAL_LOGGING_MODE.key()}).withDescription("Setting 'op_key_only' persists the 'op' and the record key only, setting 'data_before' persists the additional 'before' image, and setting 'data_before_after' persists the additional 'before' and 'after' images.");
    public static final ConfigOption<Boolean> METADATA_ENABLED = ConfigOptions.key((String)"metadata.enabled").booleanType().defaultValue((Object)false).withFallbackKeys(new String[]{HoodieMetadataConfig.ENABLE.key()}).withDescription("Enable the internal metadata table which serves table metadata like level file listings, default disabled");
    public static final ConfigOption<Integer> METADATA_COMPACTION_DELTA_COMMITS = ConfigOptions.key((String)"metadata.compaction.delta_commits").intType().defaultValue((Object)10).withDescription("Max delta commits for metadata table to trigger compaction, default 10");
    public static final ConfigOption<String> INDEX_TYPE = ConfigOptions.key((String)"index.type").stringType().defaultValue((Object)HoodieIndex.IndexType.FLINK_STATE.name()).withFallbackKeys(new String[]{HoodieIndexConfig.INDEX_TYPE.key()}).withDescription("Index type of Flink write job, default is using state backed index.");
    @AdvancedConfig
    public static final ConfigOption<Boolean> INDEX_BOOTSTRAP_ENABLED = ConfigOptions.key((String)"index.bootstrap.enabled").booleanType().defaultValue((Object)false).withDescription("Whether to bootstrap the index state from existing hoodie table, default false");
    @AdvancedConfig
    public static final ConfigOption<Double> INDEX_STATE_TTL = ConfigOptions.key((String)"index.state.ttl").doubleType().defaultValue((Object)0.0).withDescription("Index state ttl in days, default stores the index permanently");
    @AdvancedConfig
    public static final ConfigOption<Boolean> INDEX_GLOBAL_ENABLED = ConfigOptions.key((String)"index.global.enabled").booleanType().defaultValue((Object)true).withDescription("Whether to update index for the old partition path\nif same key record with different partition path came in, default true");
    @AdvancedConfig
    public static final ConfigOption<String> INDEX_PARTITION_REGEX = ConfigOptions.key((String)"index.partition.regex").stringType().defaultValue((Object)".*").withDescription("Whether to load partitions in state if partition path matching\uff0c default `*`");
    @AdvancedConfig
    public static final ConfigOption<Integer> READ_TASKS = ConfigOptions.key((String)"read.tasks").intType().noDefaultValue().withDescription("Parallelism of tasks that do actual read, default is the parallelism of the execution environment");
    @AdvancedConfig
    public static final ConfigOption<String> SOURCE_AVRO_SCHEMA_PATH = ConfigOptions.key((String)"source.avro-schema.path").stringType().noDefaultValue().withDescription("Source avro schema file path, the parsed schema is used for deserialization");
    @AdvancedConfig
    public static final ConfigOption<String> SOURCE_AVRO_SCHEMA = ConfigOptions.key((String)"source.avro-schema").stringType().noDefaultValue().withDescription("Source avro schema string, the parsed schema is used for deserialization");
    public static final String QUERY_TYPE_SNAPSHOT = "snapshot";
    public static final String QUERY_TYPE_READ_OPTIMIZED = "read_optimized";
    public static final String QUERY_TYPE_INCREMENTAL = "incremental";
    public static final ConfigOption<String> QUERY_TYPE = ConfigOptions.key((String)"hoodie.datasource.query.type").stringType().defaultValue((Object)"snapshot").withDescription("Decides how data files need to be read, in\n1) Snapshot mode (obtain latest view, based on row & columnar data);\n2) incremental mode (new data since an instantTime);\n3) Read Optimized mode (obtain latest view, based on columnar data)\n.Default: snapshot");
    public static final String REALTIME_SKIP_MERGE = "skip_merge";
    public static final String REALTIME_PAYLOAD_COMBINE = "payload_combine";
    @AdvancedConfig
    public static final ConfigOption<String> MERGE_TYPE = ConfigOptions.key((String)"hoodie.datasource.merge.type").stringType().defaultValue((Object)"payload_combine").withDescription("For Snapshot query on merge on read table. Use this key to define how the payloads are merged, in\n1) skip_merge: read the base file records plus the log file records;\n2) payload_combine: read the base file records first, for each record in base file, checks whether the key is in the\n   log file records(combines the two records with same key for base and log file records), then read the left log file records");
    @AdvancedConfig
    public static final ConfigOption<Boolean> READ_UTC_TIMEZONE = ConfigOptions.key((String)"read.utc-timezone").booleanType().defaultValue((Object)true).withDescription("Use UTC timezone or local timezone to the conversion between epoch time and LocalDateTime. Hive 0.x/1.x/2.x use local timezone. But Hive 3.x use UTC timezone, by default true");
    public static final ConfigOption<Boolean> READ_AS_STREAMING = ConfigOptions.key((String)"read.streaming.enabled").booleanType().defaultValue((Object)false).withDescription("Whether to read as streaming source, default false");
    @AdvancedConfig
    public static final ConfigOption<Integer> READ_STREAMING_CHECK_INTERVAL = ConfigOptions.key((String)"read.streaming.check-interval").intType().defaultValue((Object)60).withDescription("Check interval for streaming read of SECOND, default 1 minute");
    @AdvancedConfig
    public static final ConfigOption<Boolean> READ_STREAMING_SKIP_COMPACT = ConfigOptions.key((String)"read.streaming.skip_compaction").booleanType().defaultValue((Object)true).withDescription("Whether to skip compaction instants and avoid reading compacted base files for streaming read to improve read performance.\nThis option can be used to avoid reading duplicates when changelog mode is enabled, it is a solution to keep data integrity\n");
    @AdvancedConfig
    public static final ConfigOption<Boolean> READ_STREAMING_SKIP_CLUSTERING = ConfigOptions.key((String)"read.streaming.skip_clustering").booleanType().defaultValue((Object)true).withDescription("Whether to skip clustering instants to avoid reading base files of clustering operations for streaming read to improve read performance.");
    public static final String START_COMMIT_EARLIEST = "earliest";
    public static final ConfigOption<String> READ_START_COMMIT = ConfigOptions.key((String)"read.start-commit").stringType().noDefaultValue().withDescription("Start commit instant for reading, the commit time format should be 'yyyyMMddHHmmss', by default reading from the latest instant for streaming read");
    public static final ConfigOption<String> READ_END_COMMIT = ConfigOptions.key((String)"read.end-commit").stringType().noDefaultValue().withDescription("End commit instant for reading, the commit time format should be 'yyyyMMddHHmmss'");
    @AdvancedConfig
    public static final ConfigOption<Boolean> READ_DATA_SKIPPING_ENABLED = ConfigOptions.key((String)"read.data.skipping.enabled").booleanType().defaultValue((Object)false).withDescription("Enables data-skipping allowing queries to leverage indexes to reduce the search space byskipping over files");
    @AdvancedConfig
    public static final ConfigOption<Boolean> INSERT_CLUSTER = ConfigOptions.key((String)"write.insert.cluster").booleanType().defaultValue((Object)false).withDescription("Whether to merge small files for insert mode, if true, the write throughput will decrease because the read/write of existing small file, only valid for COW table, default false");
    public static final ConfigOption<String> OPERATION = ConfigOptions.key((String)"write.operation").stringType().defaultValue((Object)WriteOperationType.UPSERT.value()).withDescription("The write operation, that this write should do");
    @AdvancedConfig
    public static final ConfigOption<Boolean> PRE_COMBINE = ConfigOptions.key((String)"write.precombine").booleanType().defaultValue((Object)false).withDescription("Flag to indicate whether to drop duplicates before insert/upsert.\nBy default these cases will accept duplicates, to gain extra performance:\n1) insert operation;\n2) upsert for MOR table, the MOR table deduplicate on reading");
    @AdvancedConfig
    public static final ConfigOption<Integer> RETRY_TIMES = ConfigOptions.key((String)"write.retry.times").intType().defaultValue((Object)3).withDescription("Flag to indicate how many times streaming job should retry for a failed checkpoint batch.\nBy default 3");
    @AdvancedConfig
    public static final ConfigOption<Long> RETRY_INTERVAL_MS = ConfigOptions.key((String)"write.retry.interval.ms").longType().defaultValue((Object)2000L).withDescription("Flag to indicate how long (by millisecond) before a retry should issued for failed checkpoint batch.\nBy default 2000 and it will be doubled by every retry");
    @AdvancedConfig
    public static final ConfigOption<Boolean> IGNORE_FAILED = ConfigOptions.key((String)"write.ignore.failed").booleanType().defaultValue((Object)false).withDescription("Flag to indicate whether to ignore any non exception error (e.g. writestatus error). within a checkpoint batch. \nBy default false. Turning this on, could hide the write status errors while the flink checkpoint moves ahead. \nSo, would recommend users to use this with caution.");
    public static final ConfigOption<String> RECORD_KEY_FIELD = ConfigOptions.key((String)KeyGeneratorOptions.RECORDKEY_FIELD_NAME.key()).stringType().defaultValue((Object)"uuid").withDescription("Record key field. Value to be used as the `recordKey` component of `HoodieKey`.\nActual value will be obtained by invoking .toString() on the field value. Nested fields can be specified using the dot notation eg: `a.b.c`");
    @AdvancedConfig
    public static final ConfigOption<String> INDEX_KEY_FIELD = ConfigOptions.key((String)HoodieIndexConfig.BUCKET_INDEX_HASH_FIELD.key()).stringType().defaultValue((Object)"").withDescription("Index key field. Value to be used as hashing to find the bucket ID. Should be a subset of or equal to the recordKey fields.\nActual value will be obtained by invoking .toString() on the field value. Nested fields can be specified using the dot notation eg: `a.b.c`");
    @AdvancedConfig
    public static final ConfigOption<String> BUCKET_INDEX_ENGINE_TYPE = ConfigOptions.key((String)HoodieIndexConfig.BUCKET_INDEX_ENGINE_TYPE.key()).stringType().defaultValue((Object)"SIMPLE").withDescription("Type of bucket index engine. Available options: [SIMPLE | CONSISTENT_HASHING]");
    @AdvancedConfig
    public static final ConfigOption<Integer> BUCKET_INDEX_NUM_BUCKETS = ConfigOptions.key((String)HoodieIndexConfig.BUCKET_INDEX_NUM_BUCKETS.key()).intType().defaultValue((Object)4).withDescription("Hudi bucket number per partition. Only affected if using Hudi bucket index.");
    public static final ConfigOption<String> PARTITION_PATH_FIELD = ConfigOptions.key((String)KeyGeneratorOptions.PARTITIONPATH_FIELD_NAME.key()).stringType().defaultValue((Object)"").withDescription("Partition path field. Value to be used at the `partitionPath` component of `HoodieKey`.\nActual value obtained by invoking .toString(), default ''");
    @AdvancedConfig
    public static final ConfigOption<Boolean> URL_ENCODE_PARTITIONING = ConfigOptions.key((String)KeyGeneratorOptions.URL_ENCODE_PARTITIONING.key()).booleanType().defaultValue((Object)false).withDescription("Whether to encode the partition path url, default false");
    public static final ConfigOption<Boolean> HIVE_STYLE_PARTITIONING = ConfigOptions.key((String)KeyGeneratorOptions.HIVE_STYLE_PARTITIONING_ENABLE.key()).booleanType().defaultValue((Object)false).withDescription("Whether to use Hive style partitioning.\nIf set true, the names of partition folders follow <partition_column_name>=<partition_value> format.\nBy default false (the names of partition folders are only partition values)");
    @AdvancedConfig
    public static final ConfigOption<String> KEYGEN_CLASS_NAME = ConfigOptions.key((String)HoodieWriteConfig.KEYGENERATOR_CLASS_NAME.key()).stringType().noDefaultValue().withDescription("Key generator class, that implements will extract the key out of incoming record");
    @AdvancedConfig
    public static final ConfigOption<String> KEYGEN_TYPE = ConfigOptions.key((String)HoodieWriteConfig.KEYGENERATOR_TYPE.key()).stringType().defaultValue((Object)KeyGeneratorType.SIMPLE.name()).withDescription("Key generator type, that implements will extract the key out of incoming record. **Note** This is being actively worked on. Please use `hoodie.datasource.write.keygenerator.class` instead.");
    public static final String PARTITION_FORMAT_HOUR = "yyyyMMddHH";
    public static final String PARTITION_FORMAT_DAY = "yyyyMMdd";
    public static final String PARTITION_FORMAT_DASHED_DAY = "yyyy-MM-dd";
    @AdvancedConfig
    public static final ConfigOption<Boolean> WRITE_UTC_TIMEZONE = ConfigOptions.key((String)"write.utc-timezone").booleanType().defaultValue((Object)true).withDescription("Use UTC timezone or local timezone to the conversion between epoch time and LocalDateTime. Default value is utc timezone for forward compatibility.");
    @AdvancedConfig
    public static final ConfigOption<String> PARTITION_FORMAT = ConfigOptions.key((String)"write.partition.format").stringType().noDefaultValue().withDescription("Partition path format, only valid when 'write.datetime.partitioning' is true, default is:\n1) 'yyyyMMddHH' for timestamp(3) WITHOUT TIME ZONE, LONG, FLOAT, DOUBLE, DECIMAL;\n2) 'yyyyMMdd' for DATE and INT.");
    @AdvancedConfig
    public static final ConfigOption<Integer> INDEX_BOOTSTRAP_TASKS = ConfigOptions.key((String)"write.index_bootstrap.tasks").intType().noDefaultValue().withDescription("Parallelism of tasks that do index bootstrap, default same as the write task parallelism");
    @AdvancedConfig
    public static final ConfigOption<Integer> BUCKET_ASSIGN_TASKS = ConfigOptions.key((String)"write.bucket_assign.tasks").intType().noDefaultValue().withDescription("Parallelism of tasks that do bucket assign, default same as the write task parallelism");
    @AdvancedConfig
    public static final ConfigOption<Integer> WRITE_TASKS = ConfigOptions.key((String)"write.tasks").intType().noDefaultValue().withDescription("Parallelism of tasks that do actual write, default is the parallelism of the execution environment");
    @AdvancedConfig
    public static final ConfigOption<Double> WRITE_TASK_MAX_SIZE = ConfigOptions.key((String)"write.task.max.size").doubleType().defaultValue((Object)1024.0).withDescription("Maximum memory in MB for a write task, when the threshold hits,\nit flushes the max size data bucket to avoid OOM, default 1GB");
    @AdvancedConfig
    public static final ConfigOption<Long> WRITE_RATE_LIMIT = ConfigOptions.key((String)"write.rate.limit").longType().defaultValue((Object)0L).withDescription("Write record rate limit per second to prevent traffic jitter and improve stability, default 0 (no limit)");
    @AdvancedConfig
    public static final ConfigOption<Double> WRITE_BATCH_SIZE = ConfigOptions.key((String)"write.batch.size").doubleType().defaultValue((Object)256.0).withDescription("Batch buffer size in MB to flush data into the underneath filesystem, default 256MB");
    @AdvancedConfig
    public static final ConfigOption<Integer> WRITE_LOG_BLOCK_SIZE = ConfigOptions.key((String)"write.log_block.size").intType().defaultValue((Object)128).withDescription("Max log block size in MB for log file, default 128MB");
    @AdvancedConfig
    public static final ConfigOption<Long> WRITE_LOG_MAX_SIZE = ConfigOptions.key((String)"write.log.max.size").longType().defaultValue((Object)1024L).withDescription("Maximum size allowed in MB for a log file before it is rolled over to the next version, default 1GB");
    @AdvancedConfig
    public static final ConfigOption<Integer> WRITE_PARQUET_BLOCK_SIZE = ConfigOptions.key((String)"write.parquet.block.size").intType().defaultValue((Object)120).withDescription("Parquet RowGroup size. It's recommended to make this large enough that scan costs can be amortized by packing enough column values into a single row group.");
    public static final ConfigOption<Integer> WRITE_PARQUET_MAX_FILE_SIZE = ConfigOptions.key((String)"write.parquet.max.file.size").intType().defaultValue((Object)120).withDescription("Target size for parquet files produced by Hudi write phases. For DFS, this needs to be aligned with the underlying filesystem block size for optimal performance.");
    @AdvancedConfig
    public static final ConfigOption<Integer> WRITE_PARQUET_PAGE_SIZE = ConfigOptions.key((String)"write.parquet.page.size").intType().defaultValue((Object)1).withDescription("Parquet page size. Page is the unit of read within a parquet file. Within a block, pages are compressed separately.");
    @AdvancedConfig
    public static final ConfigOption<Integer> WRITE_MERGE_MAX_MEMORY = ConfigOptions.key((String)"write.merge.max_memory").intType().defaultValue((Object)100).withDescription("Max memory in MB for merge, default 100MB");
    @AdvancedConfig
    public static final ConfigOption<Long> WRITE_COMMIT_ACK_TIMEOUT = ConfigOptions.key((String)"write.commit.ack.timeout").longType().defaultValue((Object)-1L).withDescription("Timeout limit for a writer task after it finishes a checkpoint and\nwaits for the instant commit success, only for internal use");
    @AdvancedConfig
    public static final ConfigOption<Boolean> WRITE_BULK_INSERT_SHUFFLE_INPUT = ConfigOptions.key((String)"write.bulk_insert.shuffle_input").booleanType().defaultValue((Object)true).withDescription("Whether to shuffle the inputs by specific fields for bulk insert tasks, default true");
    @AdvancedConfig
    public static final ConfigOption<Boolean> WRITE_BULK_INSERT_SORT_INPUT = ConfigOptions.key((String)"write.bulk_insert.sort_input").booleanType().defaultValue((Object)true).withDescription("Whether to sort the inputs by specific fields for bulk insert tasks, default true");
    @AdvancedConfig
    public static final ConfigOption<Boolean> WRITE_BULK_INSERT_SORT_INPUT_BY_RECORD_KEY = ConfigOptions.key((String)"write.bulk_insert.sort_input.by_record_key").booleanType().defaultValue((Object)false).withDescription("Whether to sort the inputs by record keys for bulk insert tasks, default false");
    @AdvancedConfig
    public static final ConfigOption<Integer> WRITE_SORT_MEMORY = ConfigOptions.key((String)"write.sort.memory").intType().defaultValue((Object)128).withDescription("Sort memory in MB, default 128MB");
    @AdvancedConfig
    public static final ConfigOption<String> WRITE_PARTITION_OVERWRITE_MODE = ConfigOptions.key((String)"write.partition.overwrite.mode").stringType().defaultValue((Object)PartitionOverwriteMode.STATIC.name()).withDescription("When INSERT OVERWRITE a partitioned data source table, we currently support 2 modes: static and dynamic. Static mode deletes all the partitions that match the partition specification(e.g. PARTITION(a=1,b)) in the INSERT statement, before overwriting. Dynamic mode doesn't delete partitions ahead, and only overwrite those partitions that have data written into it at runtime. By default we use static mode to keep the same behavior of previous version.");
    @AdvancedConfig
    public static final ConfigOption<String> WRITE_CLIENT_ID = ConfigOptions.key((String)"write.client.id").stringType().defaultValue((Object)"").withDescription("Unique identifier used to distinguish different writer pipelines for concurrent mode");
    @AdvancedConfig
    public static final ConfigOption<Boolean> COMPACTION_SCHEDULE_ENABLED = ConfigOptions.key((String)"compaction.schedule.enabled").booleanType().defaultValue((Object)true).withDescription("Schedule the compaction plan, enabled by default for MOR");
    public static final ConfigOption<Boolean> COMPACTION_ASYNC_ENABLED = ConfigOptions.key((String)"compaction.async.enabled").booleanType().defaultValue((Object)true).withDescription("Async Compaction, enabled by default for MOR");
    @AdvancedConfig
    public static final ConfigOption<Integer> COMPACTION_TASKS = ConfigOptions.key((String)"compaction.tasks").intType().noDefaultValue().withDescription("Parallelism of tasks that do actual compaction, default same as the write task parallelism");
    public static final String NUM_COMMITS = "num_commits";
    public static final String TIME_ELAPSED = "time_elapsed";
    public static final String NUM_AND_TIME = "num_and_time";
    public static final String NUM_OR_TIME = "num_or_time";
    @AdvancedConfig
    public static final ConfigOption<String> COMPACTION_TRIGGER_STRATEGY = ConfigOptions.key((String)"compaction.trigger.strategy").stringType().defaultValue((Object)"num_commits").withDescription("Strategy to trigger compaction, options are 'num_commits': trigger compaction when there are at least N delta commits after last completed compaction;\n'num_commits_after_last_request': trigger compaction when there are at least N delta commits after last completed/requested compaction;\n'time_elapsed': trigger compaction when time elapsed > N seconds since last compaction;\n'num_and_time': trigger compaction when both NUM_COMMITS and TIME_ELAPSED are satisfied;\n'num_or_time': trigger compaction when NUM_COMMITS or TIME_ELAPSED is satisfied.\nDefault is 'num_commits'");
    public static final ConfigOption<Integer> COMPACTION_DELTA_COMMITS = ConfigOptions.key((String)"compaction.delta_commits").intType().defaultValue((Object)5).withDescription("Max delta commits needed to trigger compaction, default 5 commits");
    @AdvancedConfig
    public static final ConfigOption<Integer> COMPACTION_DELTA_SECONDS = ConfigOptions.key((String)"compaction.delta_seconds").intType().defaultValue((Object)3600).withDescription("Max delta seconds time needed to trigger compaction, default 1 hour");
    @AdvancedConfig
    public static final ConfigOption<Integer> COMPACTION_TIMEOUT_SECONDS = ConfigOptions.key((String)"compaction.timeout.seconds").intType().defaultValue((Object)1200).withDescription("Max timeout time in seconds for online compaction to rollback, default 20 minutes");
    @AdvancedConfig
    public static final ConfigOption<Integer> COMPACTION_MAX_MEMORY = ConfigOptions.key((String)"compaction.max_memory").intType().defaultValue((Object)100).withDescription("Max memory in MB for compaction spillable map, default 100MB");
    @AdvancedConfig
    public static final ConfigOption<Long> COMPACTION_TARGET_IO = ConfigOptions.key((String)"compaction.target_io").longType().defaultValue((Object)512000L).withDescription("Target IO in MB for per compaction (both read and write), default 500 GB");
    public static final ConfigOption<Boolean> CLEAN_ASYNC_ENABLED = ConfigOptions.key((String)"clean.async.enabled").booleanType().defaultValue((Object)true).withDescription("Whether to cleanup the old commits immediately on new commits, enabled by default");
    @AdvancedConfig
    public static final ConfigOption<String> CLEAN_POLICY = ConfigOptions.key((String)"clean.policy").stringType().defaultValue((Object)HoodieCleaningPolicy.KEEP_LATEST_COMMITS.name()).withDescription("Clean policy to manage the Hudi table. Available option: KEEP_LATEST_COMMITS, KEEP_LATEST_FILE_VERSIONS, KEEP_LATEST_BY_HOURS.Default is KEEP_LATEST_COMMITS.");
    public static final ConfigOption<Integer> CLEAN_RETAIN_COMMITS = ConfigOptions.key((String)"clean.retain_commits").intType().defaultValue((Object)30).withDescription("Number of commits to retain. So data will be retained for num_of_commits * time_between_commits (scheduled).\nThis also directly translates into how much you can incrementally pull on this table, default 30");
    @AdvancedConfig
    public static final ConfigOption<Integer> CLEAN_RETAIN_HOURS = ConfigOptions.key((String)"clean.retain_hours").intType().defaultValue((Object)24).withDescription("Number of hours for which commits need to be retained. This config provides a more flexible option ascompared to number of commits retained for cleaning service. Setting this property ensures all the files, but the latest in a file group, corresponding to commits with commit times older than the configured number of hours to be retained are cleaned.");
    @AdvancedConfig
    public static final ConfigOption<Integer> CLEAN_RETAIN_FILE_VERSIONS = ConfigOptions.key((String)"clean.retain_file_versions").intType().defaultValue((Object)5).withDescription("Number of file versions to retain. default 5");
    public static final ConfigOption<Integer> ARCHIVE_MAX_COMMITS = ConfigOptions.key((String)"archive.max_commits").intType().defaultValue((Object)50).withDescription("Max number of commits to keep before archiving older commits into a sequential log, default 50");
    public static final ConfigOption<Integer> ARCHIVE_MIN_COMMITS = ConfigOptions.key((String)"archive.min_commits").intType().defaultValue((Object)40).withDescription("Min number of commits to keep before archiving older commits into a sequential log, default 40");
    @AdvancedConfig
    public static final ConfigOption<Boolean> CLUSTERING_SCHEDULE_ENABLED = ConfigOptions.key((String)"clustering.schedule.enabled").booleanType().defaultValue((Object)false).withDescription("Schedule the cluster plan, default false");
    public static final ConfigOption<Boolean> CLUSTERING_ASYNC_ENABLED = ConfigOptions.key((String)"clustering.async.enabled").booleanType().defaultValue((Object)false).withDescription("Async Clustering, default false");
    @AdvancedConfig
    public static final ConfigOption<Integer> CLUSTERING_DELTA_COMMITS = ConfigOptions.key((String)"clustering.delta_commits").intType().defaultValue((Object)4).withDescription("Max delta commits needed to trigger clustering, default 4 commits");
    @AdvancedConfig
    public static final ConfigOption<Integer> CLUSTERING_TASKS = ConfigOptions.key((String)"clustering.tasks").intType().noDefaultValue().withDescription("Parallelism of tasks that do actual clustering, default same as the write task parallelism");
    @AdvancedConfig
    public static final ConfigOption<Integer> CLUSTERING_TARGET_PARTITIONS = ConfigOptions.key((String)"clustering.plan.strategy.daybased.lookback.partitions").intType().defaultValue((Object)2).withDescription("Number of partitions to list to create ClusteringPlan, default is 2");
    @AdvancedConfig
    public static final ConfigOption<Integer> CLUSTERING_PLAN_STRATEGY_SKIP_PARTITIONS_FROM_LATEST = ConfigOptions.key((String)"clustering.plan.strategy.daybased.skipfromlatest.partitions").intType().defaultValue((Object)0).withDescription("Number of partitions to skip from latest when choosing partitions to create ClusteringPlan");
    @AdvancedConfig
    public static final ConfigOption<String> CLUSTERING_PLAN_STRATEGY_CLUSTER_BEGIN_PARTITION = ConfigOptions.key((String)"clustering.plan.strategy.cluster.begin.partition").stringType().defaultValue((Object)"").withDescription("Begin partition used to filter partition (inclusive)");
    @AdvancedConfig
    public static final ConfigOption<String> CLUSTERING_PLAN_STRATEGY_CLUSTER_END_PARTITION = ConfigOptions.key((String)"clustering.plan.strategy.cluster.end.partition").stringType().defaultValue((Object)"").withDescription("End partition used to filter partition (inclusive)");
    @AdvancedConfig
    public static final ConfigOption<String> CLUSTERING_PLAN_STRATEGY_PARTITION_REGEX_PATTERN = ConfigOptions.key((String)"clustering.plan.strategy.partition.regex.pattern").stringType().defaultValue((Object)"").withDescription("Filter clustering partitions that matched regex pattern");
    @AdvancedConfig
    public static final ConfigOption<String> CLUSTERING_PLAN_STRATEGY_PARTITION_SELECTED = ConfigOptions.key((String)"clustering.plan.strategy.partition.selected").stringType().defaultValue((Object)"").withDescription("Partitions to run clustering");
    @AdvancedConfig
    public static final ConfigOption<String> CLUSTERING_PLAN_STRATEGY_CLASS = ConfigOptions.key((String)"clustering.plan.strategy.class").stringType().defaultValue((Object)FlinkSizeBasedClusteringPlanStrategy.class.getName()).withDescription("Config to provide a strategy class (subclass of ClusteringPlanStrategy) to create clustering plan i.e select what file groups are being clustered. Default strategy, looks at the last N (determined by " + CLUSTERING_TARGET_PARTITIONS.key() + ") day based partitions picks the small file slices within those partitions.");
    @AdvancedConfig
    public static final ConfigOption<String> CLUSTERING_PLAN_PARTITION_FILTER_MODE_NAME = ConfigOptions.key((String)"clustering.plan.partition.filter.mode").stringType().defaultValue((Object)ClusteringPlanPartitionFilterMode.NONE.name()).withDescription("Partition filter mode used in the creation of clustering plan. Available values are - NONE: do not filter table partition and thus the clustering plan will include all partitions that have clustering candidate.RECENT_DAYS: keep a continuous range of partitions, worked together with configs '" + CLUSTERING_TARGET_PARTITIONS.key() + "' and '" + CLUSTERING_PLAN_STRATEGY_SKIP_PARTITIONS_FROM_LATEST.key() + ".SELECTED_PARTITIONS: keep partitions that are in the specified range ['" + CLUSTERING_PLAN_STRATEGY_CLUSTER_BEGIN_PARTITION.key() + "', '" + CLUSTERING_PLAN_STRATEGY_CLUSTER_END_PARTITION.key() + "'].DAY_ROLLING: clustering partitions on a rolling basis by the hour to avoid clustering all partitions each time, which strategy sorts the partitions asc and chooses the partition of which index is divided by 24 and the remainder is equal to the current hour.");
    public static final ConfigOption<Long> CLUSTERING_PLAN_STRATEGY_TARGET_FILE_MAX_BYTES = ConfigOptions.key((String)"clustering.plan.strategy.target.file.max.bytes").longType().defaultValue((Object)0x40000000L).withDescription("Each group can produce 'N' (CLUSTERING_MAX_GROUP_SIZE/CLUSTERING_TARGET_FILE_SIZE) output file groups, default 1 GB");
    public static final ConfigOption<Long> CLUSTERING_PLAN_STRATEGY_SMALL_FILE_LIMIT = ConfigOptions.key((String)"clustering.plan.strategy.small.file.limit").longType().defaultValue((Object)600L).withDescription("Files smaller than the size specified here are candidates for clustering, default 600 MB");
    @AdvancedConfig
    public static final ConfigOption<String> CLUSTERING_SORT_COLUMNS = ConfigOptions.key((String)"clustering.plan.strategy.sort.columns").stringType().defaultValue((Object)"").withDescription("Columns to sort the data by when clustering");
    @AdvancedConfig
    public static final ConfigOption<Integer> CLUSTERING_MAX_NUM_GROUPS = ConfigOptions.key((String)"clustering.plan.strategy.max.num.groups").intType().defaultValue((Object)30).withDescription("Maximum number of groups to create as part of ClusteringPlan. Increasing groups will increase parallelism, default is 30");
    public static final ConfigOption<Boolean> HIVE_SYNC_ENABLED = ConfigOptions.key((String)"hive_sync.enabled").booleanType().defaultValue((Object)false).withFallbackKeys(new String[]{"hive_sync.enable"}).withDescription("Asynchronously sync Hive meta to HMS, default false");
    @AdvancedConfig
    public static final ConfigOption<String> HIVE_SYNC_DB = ConfigOptions.key((String)"hive_sync.db").stringType().defaultValue((Object)"default").withDescription("Database name for hive sync, default 'default'");
    @AdvancedConfig
    public static final ConfigOption<String> HIVE_SYNC_TABLE = ConfigOptions.key((String)"hive_sync.table").stringType().defaultValue((Object)"unknown").withDescription("Table name for hive sync, default 'unknown'");
    @AdvancedConfig
    public static final ConfigOption<String> HIVE_SYNC_FILE_FORMAT = ConfigOptions.key((String)"hive_sync.file_format").stringType().defaultValue((Object)"PARQUET").withDescription("File format for hive sync, default 'PARQUET'");
    public static final ConfigOption<String> HIVE_SYNC_MODE = ConfigOptions.key((String)"hive_sync.mode").stringType().defaultValue((Object)HiveSyncMode.HMS.name()).withDescription("Mode to choose for Hive ops. Valid values are hms, jdbc and hiveql, default 'hms'");
    @AdvancedConfig
    public static final ConfigOption<String> HIVE_SYNC_USERNAME = ConfigOptions.key((String)"hive_sync.username").stringType().defaultValue((Object)"hive").withDescription("Username for hive sync, default 'hive'");
    @AdvancedConfig
    public static final ConfigOption<String> HIVE_SYNC_PASSWORD = ConfigOptions.key((String)"hive_sync.password").stringType().defaultValue((Object)"hive").withDescription("Password for hive sync, default 'hive'");
    public static final ConfigOption<String> HIVE_SYNC_JDBC_URL = ConfigOptions.key((String)"hive_sync.jdbc_url").stringType().defaultValue((Object)"jdbc:hive2://localhost:10000").withDescription("Jdbc URL for hive sync, default 'jdbc:hive2://localhost:10000'");
    public static final ConfigOption<String> HIVE_SYNC_METASTORE_URIS = ConfigOptions.key((String)"hive_sync.metastore.uris").stringType().defaultValue((Object)"").withDescription("Metastore uris for hive sync, default ''");
    @AdvancedConfig
    public static final ConfigOption<String> HIVE_SYNC_PARTITION_FIELDS = ConfigOptions.key((String)"hive_sync.partition_fields").stringType().defaultValue((Object)"").withDescription("Partition fields for hive sync, default ''");
    @AdvancedConfig
    public static final ConfigOption<String> HIVE_SYNC_PARTITION_EXTRACTOR_CLASS_NAME = ConfigOptions.key((String)"hive_sync.partition_extractor_class").stringType().defaultValue((Object)MultiPartKeysValueExtractor.class.getName()).withDescription("Tool to extract the partition value from HDFS path, default 'MultiPartKeysValueExtractor'");
    @AdvancedConfig
    public static final ConfigOption<Boolean> HIVE_SYNC_ASSUME_DATE_PARTITION = ConfigOptions.key((String)"hive_sync.assume_date_partitioning").booleanType().defaultValue((Object)false).withDescription("Assume partitioning is yyyy/mm/dd, default false");
    @AdvancedConfig
    public static final ConfigOption<Boolean> HIVE_SYNC_USE_JDBC = ConfigOptions.key((String)"hive_sync.use_jdbc").booleanType().defaultValue((Object)true).withDescription("Use JDBC when hive synchronization is enabled, default true");
    @AdvancedConfig
    public static final ConfigOption<Boolean> HIVE_SYNC_AUTO_CREATE_DB = ConfigOptions.key((String)"hive_sync.auto_create_db").booleanType().defaultValue((Object)true).withDescription("Auto create hive database if it does not exists, default true");
    @AdvancedConfig
    public static final ConfigOption<Boolean> HIVE_SYNC_IGNORE_EXCEPTIONS = ConfigOptions.key((String)"hive_sync.ignore_exceptions").booleanType().defaultValue((Object)false).withDescription("Ignore exceptions during hive synchronization, default false");
    @AdvancedConfig
    public static final ConfigOption<Boolean> HIVE_SYNC_SKIP_RO_SUFFIX = ConfigOptions.key((String)"hive_sync.skip_ro_suffix").booleanType().defaultValue((Object)false).withDescription("Skip the _ro suffix for Read optimized table when registering, default false");
    @AdvancedConfig
    public static final ConfigOption<Boolean> HIVE_SYNC_SUPPORT_TIMESTAMP = ConfigOptions.key((String)"hive_sync.support_timestamp").booleanType().defaultValue((Object)true).withDescription("INT64 with original type TIMESTAMP_MICROS is converted to hive timestamp type.\nDisabled by default for backward compatibility.");
    @AdvancedConfig
    public static final ConfigOption<String> HIVE_SYNC_TABLE_PROPERTIES = ConfigOptions.key((String)"hive_sync.table_properties").stringType().noDefaultValue().withDescription("Additional properties to store with table, the data format is k1=v1\nk2=v2");
    @AdvancedConfig
    public static final ConfigOption<String> HIVE_SYNC_TABLE_SERDE_PROPERTIES = ConfigOptions.key((String)"hive_sync.serde_properties").stringType().noDefaultValue().withDescription("Serde properties to hive table, the data format is k1=v1\nk2=v2");
    @AdvancedConfig
    public static final ConfigOption<String> HIVE_SYNC_CONF_DIR = ConfigOptions.key((String)"hive_sync.conf.dir").stringType().noDefaultValue().withDescription("The hive configuration directory, where the hive-site.xml lies in, the file should be put on the client machine");
    @AdvancedConfig
    public static final ConfigOption<String> HIVE_SYNC_TABLE_STRATEGY = ConfigOptions.key((String)"hive_sync.table.strategy").stringType().defaultValue((Object)HoodieSyncTableStrategy.ALL.name()).withDescription("Hive table synchronization strategy. Available option: RO, RT, ALL.");
    private static final String PROPERTIES_PREFIX = "properties.";

    private FlinkOptions() {
    }

    public static Map<String, String> getPropertiesWithPrefix(Map<String, String> options, String prefix) {
        HashMap<String, String> hoodieProperties = new HashMap<String, String>();
        if (FlinkOptions.hasPropertyOptions(options, prefix)) {
            options.keySet().stream().filter(key -> key.startsWith(prefix)).forEach(key -> {
                String value = (String)options.get(key);
                String subKey = key.substring(prefix.length());
                hoodieProperties.put(subKey, value);
            });
        }
        return hoodieProperties;
    }

    public static Configuration flatOptions(Configuration conf) {
        HashMap<String, String> propsMap = new HashMap<String, String>();
        conf.toMap().forEach((key, value) -> {
            String subKey = key.startsWith(PROPERTIES_PREFIX) ? key.substring(PROPERTIES_PREFIX.length()) : key;
            propsMap.put(subKey, (String)value);
        });
        return FlinkOptions.fromMap(propsMap);
    }

    private static boolean hasPropertyOptions(Map<String, String> options, String prefix) {
        return options.keySet().stream().anyMatch(k -> k.startsWith(prefix));
    }

    public static Configuration fromMap(Map<String, String> map) {
        Configuration configuration = new Configuration();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            configuration.setString(entry.getKey().trim(), entry.getValue());
        }
        return configuration;
    }

    public static <T> boolean isDefaultValueDefined(Configuration conf, ConfigOption<T> option) {
        return !conf.getOptional(option).isPresent() || conf.get(option).equals(option.defaultValue());
    }

    public static Set<ConfigOption<?>> optionalOptions() {
        HashSet options = new HashSet(FlinkOptions.allOptions());
        options.remove(PATH);
        return options;
    }

    public static List<ConfigOption<?>> allOptions() {
        return OptionsResolver.allOptions(FlinkOptions.class);
    }
}

