/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.timeline;

import java.io.Serializable;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hudi.common.table.timeline.HoodieInstantTimeGenerator;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.storage.StoragePathInfo;

public class HoodieInstant
implements Serializable,
Comparable<HoodieInstant> {
    private static final Pattern NAME_FORMAT = Pattern.compile("^(\\d+)(\\.\\w+)(\\.\\D+)?$");
    private static final String DELIMITER = ".";
    private static final String FILE_NAME_FORMAT_ERROR = "The provided file name %s does not conform to the required format";
    private static final Map<String, String> COMPARABLE_ACTIONS = HoodieInstant.createComparableActionsMap();
    public static final Comparator<HoodieInstant> ACTION_COMPARATOR = Comparator.comparing(instant -> HoodieInstant.getComparableAction(instant.getAction()));
    public static final Comparator<HoodieInstant> COMPARATOR = Comparator.comparing(HoodieInstant::getTimestamp).thenComparing(ACTION_COMPARATOR).thenComparing(HoodieInstant::getState);
    public static final Comparator<HoodieInstant> STATE_TRANSITION_COMPARATOR = Comparator.comparing(HoodieInstant::getStateTransitionTime).thenComparing(COMPARATOR);
    public static final String EMPTY_FILE_EXTENSION = "";
    private final State state;
    private final String action;
    private final String timestamp;
    private final String stateTransitionTime;

    public static String getComparableAction(String action) {
        return COMPARABLE_ACTIONS.getOrDefault(action, action);
    }

    public static String extractTimestamp(String fileName) throws IllegalArgumentException {
        Matcher matcher = NAME_FORMAT.matcher(fileName);
        if (matcher.find()) {
            return matcher.group(1);
        }
        throw new IllegalArgumentException("Failed to retrieve timestamp from name: " + String.format(FILE_NAME_FORMAT_ERROR, fileName));
    }

    public static String getTimelineFileExtension(String fileName) {
        Objects.requireNonNull(fileName);
        Matcher matcher = NAME_FORMAT.matcher(fileName);
        if (matcher.find()) {
            return fileName.substring(matcher.group(1).length());
        }
        return EMPTY_FILE_EXTENSION;
    }

    public HoodieInstant(StoragePathInfo pathInfo) {
        String fileName = pathInfo.getPath().getName();
        Matcher matcher = NAME_FORMAT.matcher(fileName);
        if (matcher.find()) {
            this.timestamp = matcher.group(1);
            if (matcher.group(2).equals(".inflight")) {
                this.action = "commit";
                this.state = State.INFLIGHT;
            } else {
                this.action = matcher.group(2).replaceFirst(DELIMITER, EMPTY_FILE_EXTENSION);
                this.state = matcher.groupCount() == 3 && matcher.group(3) != null ? State.valueOf(matcher.group(3).replaceFirst(DELIMITER, EMPTY_FILE_EXTENSION).toUpperCase()) : State.COMPLETED;
            }
        } else {
            throw new IllegalArgumentException("Failed to construct HoodieInstant: " + String.format(FILE_NAME_FORMAT_ERROR, fileName));
        }
        this.stateTransitionTime = HoodieInstantTimeGenerator.formatDate(new Date(pathInfo.getModificationTime()));
    }

    public HoodieInstant(boolean isInflight, String action, String timestamp) {
        this.state = isInflight ? State.INFLIGHT : State.COMPLETED;
        this.action = action;
        this.timestamp = timestamp;
        this.stateTransitionTime = null;
    }

    public HoodieInstant(State state, String action, String timestamp) {
        this.state = state;
        this.action = action;
        this.timestamp = timestamp;
        this.stateTransitionTime = null;
    }

    public HoodieInstant(State state, String action, String timestamp, String stateTransitionTime) {
        this.state = state;
        this.action = action;
        this.timestamp = timestamp;
        this.stateTransitionTime = stateTransitionTime;
    }

    public boolean isCompleted() {
        return this.state == State.COMPLETED;
    }

    public boolean isInflight() {
        return this.state == State.INFLIGHT;
    }

    public boolean isRequested() {
        return this.state == State.REQUESTED;
    }

    public String getAction() {
        return this.action;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public String getFileName() {
        if ("commit".equals(this.action)) {
            return this.isInflight() ? HoodieTimeline.makeInflightCommitFileName(this.timestamp) : (this.isRequested() ? HoodieTimeline.makeRequestedCommitFileName(this.timestamp) : HoodieTimeline.makeCommitFileName(this.timestamp));
        }
        if ("clean".equals(this.action)) {
            return this.isInflight() ? HoodieTimeline.makeInflightCleanerFileName(this.timestamp) : (this.isRequested() ? HoodieTimeline.makeRequestedCleanerFileName(this.timestamp) : HoodieTimeline.makeCleanerFileName(this.timestamp));
        }
        if ("rollback".equals(this.action)) {
            return this.isInflight() ? HoodieTimeline.makeInflightRollbackFileName(this.timestamp) : (this.isRequested() ? HoodieTimeline.makeRequestedRollbackFileName(this.timestamp) : HoodieTimeline.makeRollbackFileName(this.timestamp));
        }
        if ("savepoint".equals(this.action)) {
            return this.isInflight() ? HoodieTimeline.makeInflightSavePointFileName(this.timestamp) : HoodieTimeline.makeSavePointFileName(this.timestamp);
        }
        if ("deltacommit".equals(this.action)) {
            return this.isInflight() ? HoodieTimeline.makeInflightDeltaFileName(this.timestamp) : (this.isRequested() ? HoodieTimeline.makeRequestedDeltaFileName(this.timestamp) : HoodieTimeline.makeDeltaFileName(this.timestamp));
        }
        if ("compaction".equals(this.action)) {
            if (this.isInflight()) {
                return HoodieTimeline.makeInflightCompactionFileName(this.timestamp);
            }
            if (this.isRequested()) {
                return HoodieTimeline.makeRequestedCompactionFileName(this.timestamp);
            }
            return HoodieTimeline.makeCommitFileName(this.timestamp);
        }
        if ("logcompaction".equals(this.action)) {
            if (this.isInflight()) {
                return HoodieTimeline.makeInflightLogCompactionFileName(this.timestamp);
            }
            if (this.isRequested()) {
                return HoodieTimeline.makeRequestedLogCompactionFileName(this.timestamp);
            }
            return HoodieTimeline.makeDeltaFileName(this.timestamp);
        }
        if ("restore".equals(this.action)) {
            return this.isInflight() ? HoodieTimeline.makeInflightRestoreFileName(this.timestamp) : (this.isRequested() ? HoodieTimeline.makeRequestedRestoreFileName(this.timestamp) : HoodieTimeline.makeRestoreFileName(this.timestamp));
        }
        if ("replacecommit".equals(this.action)) {
            return this.isInflight() ? HoodieTimeline.makeInflightReplaceFileName(this.timestamp) : (this.isRequested() ? HoodieTimeline.makeRequestedReplaceFileName(this.timestamp) : HoodieTimeline.makeReplaceFileName(this.timestamp));
        }
        if ("indexing".equals(this.action)) {
            return this.isInflight() ? HoodieTimeline.makeInflightIndexFileName(this.timestamp) : (this.isRequested() ? HoodieTimeline.makeRequestedIndexFileName(this.timestamp) : HoodieTimeline.makeIndexCommitFileName(this.timestamp));
        }
        if ("schemacommit".equals(this.action)) {
            return this.isInflight() ? HoodieTimeline.makeInflightSchemaFileName(this.timestamp) : (this.isRequested() ? HoodieTimeline.makeRequestSchemaFileName(this.timestamp) : HoodieTimeline.makeSchemaFileName(this.timestamp));
        }
        throw new IllegalArgumentException("Cannot get file name for unknown action " + this.action);
    }

    private static final Map<String, String> createComparableActionsMap() {
        HashMap<String, String> comparableMap = new HashMap<String, String>();
        comparableMap.put("compaction", "commit");
        comparableMap.put("logcompaction", "deltacommit");
        return comparableMap;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HoodieInstant that = (HoodieInstant)o;
        return this.state == that.state && Objects.equals(this.action, that.action) && Objects.equals(this.timestamp, that.timestamp);
    }

    public State getState() {
        return this.state;
    }

    public String getStateTransitionTime() {
        return this.stateTransitionTime;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.state, this.action, this.timestamp});
    }

    @Override
    public int compareTo(HoodieInstant o) {
        return COMPARATOR.compare(this, o);
    }

    public String toString() {
        return "[" + (this.isInflight() || this.isRequested() ? "==>" : EMPTY_FILE_EXTENSION) + this.timestamp + "__" + this.action + "__" + (Object)((Object)this.state) + (StringUtils.isNullOrEmpty(this.stateTransitionTime) ? EMPTY_FILE_EXTENSION : "__" + this.stateTransitionTime) + "]";
    }

    public static enum State {
        REQUESTED,
        INFLIGHT,
        COMPLETED,
        NIL;

    }
}

