/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.log.block;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.common.config.HoodieConfig;
import org.apache.hudi.common.config.HoodieReaderConfig;
import org.apache.hudi.common.config.HoodieStorageConfig;
import org.apache.hudi.common.model.HoodieFileFormat;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.table.log.block.HoodieDataBlock;
import org.apache.hudi.common.table.log.block.HoodieLogBlock;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.TypeUtils;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.common.util.collection.ClosableIterator;
import org.apache.hudi.common.util.collection.CloseableMappingIterator;
import org.apache.hudi.io.SeekableDataInputStream;
import org.apache.hudi.io.storage.HoodieAvroHFileReaderImplBase;
import org.apache.hudi.io.storage.HoodieFileReader;
import org.apache.hudi.io.storage.HoodieIOFactory;
import org.apache.hudi.org.apache.avro.Schema;
import org.apache.hudi.org.apache.avro.generic.GenericRecord;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StorageConfiguration;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.storage.inline.InLineFSUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HoodieHFileDataBlock
extends HoodieDataBlock {
    private static final Logger LOG = LoggerFactory.getLogger(HoodieHFileDataBlock.class);
    private final Option<String> compressionCodec;
    private final StoragePath pathForReader;
    private final HoodieConfig hFileReaderConfig;

    public HoodieHFileDataBlock(Supplier<SeekableDataInputStream> inputStreamSupplier, Option<byte[]> content, boolean readBlockLazily, HoodieLogBlock.HoodieLogBlockContentLocation logBlockContentLocation, Option<Schema> readerSchema, Map<HoodieLogBlock.HeaderMetadataType, String> header, Map<HoodieLogBlock.HeaderMetadataType, String> footer, boolean enablePointLookups, StoragePath pathForReader, boolean useNativeHFileReader) {
        super(content, inputStreamSupplier, readBlockLazily, Option.of(logBlockContentLocation), readerSchema, header, footer, "key", enablePointLookups);
        this.compressionCodec = Option.empty();
        this.pathForReader = pathForReader;
        this.hFileReaderConfig = this.getHFileReaderConfig(useNativeHFileReader);
    }

    public HoodieHFileDataBlock(List<HoodieRecord> records, Map<HoodieLogBlock.HeaderMetadataType, String> header, String compressionCodec, StoragePath pathForReader, boolean useNativeHFileReader) {
        super(records, header, new HashMap<HoodieLogBlock.HeaderMetadataType, String>(), "key");
        this.compressionCodec = Option.of(compressionCodec);
        this.pathForReader = pathForReader;
        this.hFileReaderConfig = this.getHFileReaderConfig(useNativeHFileReader);
    }

    @Override
    public HoodieLogBlock.HoodieLogBlockType getBlockType() {
        return HoodieLogBlock.HoodieLogBlockType.HFILE_DATA_BLOCK;
    }

    @Override
    protected byte[] serializeRecords(List<HoodieRecord> records, HoodieStorage storage) throws IOException {
        Schema writerSchema = new Schema.Parser().parse(super.getLogBlockHeader().get((Object)HoodieLogBlock.HeaderMetadataType.SCHEMA));
        return HoodieIOFactory.getIOFactory(storage).getFileFormatUtils(HoodieFileFormat.HFILE).serializeRecordsToLogBlock(storage, records, writerSchema, this.getSchema(), this.getKeyFieldName(), Collections.singletonMap(HoodieStorageConfig.HFILE_COMPRESSION_ALGORITHM_NAME.key(), this.compressionCodec.get()));
    }

    @Override
    protected <T> ClosableIterator<HoodieRecord<T>> deserializeRecords(byte[] content, HoodieRecord.HoodieRecordType type) throws IOException {
        ValidationUtils.checkState(this.readerSchema != null, "Reader's schema has to be non-null");
        StorageConfiguration<?> storageConf = this.getBlockContentLocation().get().getStorage().getConf().getInline();
        HoodieStorage inlineStorage = this.getBlockContentLocation().get().getStorage().newInstance(this.pathForReader, storageConf);
        try (HoodieFileReader reader = HoodieIOFactory.getIOFactory(inlineStorage).getReaderFactory(HoodieRecord.HoodieRecordType.AVRO).getContentReader(this.hFileReaderConfig, this.pathForReader, HoodieFileFormat.HFILE, inlineStorage, content, Option.of(this.getSchemaFromHeader()));){
            ClosableIterator closableIterator = (ClosableIterator)TypeUtils.unsafeCast(reader.getRecordIterator(this.readerSchema));
            return closableIterator;
        }
    }

    @Override
    protected <T> ClosableIterator<HoodieRecord<T>> lookupRecords(List<String> sortedKeys, boolean fullKey) throws IOException {
        HoodieLogBlock.HoodieLogBlockContentLocation blockContentLoc = this.getBlockContentLocation().get();
        StorageConfiguration<?> inlineConf = this.getBlockContentLocation().get().getStorage().getConf().getInline();
        StoragePath inlinePath = InLineFSUtils.getInlineFilePath(blockContentLoc.getLogFile().getPath(), blockContentLoc.getLogFile().getPath().toUri().getScheme(), blockContentLoc.getContentPositionInLogFile(), blockContentLoc.getBlockSize());
        HoodieStorage inlineStorage = this.getBlockContentLocation().get().getStorage().newInstance(inlinePath, inlineConf);
        try (HoodieAvroHFileReaderImplBase reader = (HoodieAvroHFileReaderImplBase)HoodieIOFactory.getIOFactory(inlineStorage).getReaderFactory(HoodieRecord.HoodieRecordType.AVRO).getFileReader(this.hFileReaderConfig, inlinePath, HoodieFileFormat.HFILE, Option.of(this.getSchemaFromHeader()));){
            ClosableIterator recordIterator = fullKey ? reader.getRecordsByKeysIterator(sortedKeys, this.readerSchema) : reader.getRecordsByKeyPrefixIterator(sortedKeys, this.readerSchema);
            CloseableMappingIterator<HoodieRecord, HoodieRecord> closeableMappingIterator = new CloseableMappingIterator<HoodieRecord, HoodieRecord>(recordIterator, data -> data);
            return closeableMappingIterator;
        }
    }

    private void printRecord(String msg, byte[] bs, Schema schema) throws IOException {
        GenericRecord record = HoodieAvroUtils.bytesToAvro(bs, schema);
        byte[] json = HoodieAvroUtils.avroToJson(record, true);
        LOG.error(String.format("%s: %s", msg, new String(json)));
    }

    private HoodieConfig getHFileReaderConfig(boolean useNativeHFileReader) {
        HoodieConfig config = new HoodieConfig();
        config.setValue(HoodieReaderConfig.USE_NATIVE_HFILE_READER, Boolean.toString(useNativeHFileReader));
        return config;
    }
}

