/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.log;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.hudi.common.model.DeleteRecord;
import org.apache.hudi.common.model.HoodiePreCombineAvroRecordMerger;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordMerger;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.log.AbstractHoodieLogRecordReader;
import org.apache.hudi.common.table.log.InstantRange;
import org.apache.hudi.common.util.HoodieRecordUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.internal.schema.InternalSchema;
import org.apache.hudi.org.apache.avro.Schema;
import org.apache.hudi.storage.HoodieStorage;

public class HoodieUnMergedLogRecordScanner
extends AbstractHoodieLogRecordReader {
    private final LogRecordScannerCallback callback;

    private HoodieUnMergedLogRecordScanner(HoodieStorage storage, String basePath, List<String> logFilePaths, Schema readerSchema, String latestInstantTime, boolean reverseReader, int bufferSize, LogRecordScannerCallback callback, Option<InstantRange> instantRange, InternalSchema internalSchema, boolean enableOptimizedLogBlocksScan, HoodieRecordMerger recordMerger, Option<HoodieTableMetaClient> hoodieTableMetaClientOption) {
        super(storage, basePath, logFilePaths, readerSchema, latestInstantTime, reverseReader, bufferSize, instantRange, false, true, Option.empty(), internalSchema, Option.empty(), enableOptimizedLogBlocksScan, recordMerger, hoodieTableMetaClientOption);
        this.callback = callback;
    }

    public final void scan() {
        this.scan(false);
    }

    public final void scan(boolean skipProcessingBlocks) {
        this.scanInternal(Option.empty(), skipProcessingBlocks);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @Override
    public <T> void processNextRecord(HoodieRecord<T> hoodieRecord) throws Exception {
        this.callback.apply(hoodieRecord.copy());
    }

    @Override
    protected void processNextDeletedRecord(DeleteRecord deleteRecord) {
        throw new IllegalStateException("Not expected to see delete records in this log-scan mode. Check Job Config");
    }

    public static class Builder
    extends AbstractHoodieLogRecordReader.Builder {
        private HoodieStorage storage;
        private String basePath;
        private List<String> logFilePaths;
        private Schema readerSchema;
        private InternalSchema internalSchema;
        private String latestInstantTime;
        private boolean reverseReader;
        private int bufferSize;
        private Option<InstantRange> instantRange = Option.empty();
        private LogRecordScannerCallback callback;
        private boolean enableOptimizedLogBlocksScan;
        private HoodieRecordMerger recordMerger = HoodiePreCombineAvroRecordMerger.INSTANCE;
        private HoodieTableMetaClient hoodieTableMetaClient;

        @Override
        public Builder withStorage(HoodieStorage storage) {
            this.storage = storage;
            return this;
        }

        @Override
        public Builder withBasePath(String basePath) {
            this.basePath = basePath;
            return this;
        }

        @Override
        public Builder withLogFilePaths(List<String> logFilePaths) {
            this.logFilePaths = logFilePaths.stream().filter(p -> !p.endsWith(".cdc")).collect(Collectors.toList());
            return this;
        }

        @Override
        public Builder withReaderSchema(Schema schema) {
            this.readerSchema = schema;
            return this;
        }

        @Override
        public Builder withInternalSchema(InternalSchema internalSchema) {
            this.internalSchema = internalSchema;
            return this;
        }

        @Override
        public Builder withLatestInstantTime(String latestInstantTime) {
            this.latestInstantTime = latestInstantTime;
            return this;
        }

        @Override
        public Builder withReverseReader(boolean reverseReader) {
            this.reverseReader = reverseReader;
            return this;
        }

        @Override
        public Builder withBufferSize(int bufferSize) {
            this.bufferSize = bufferSize;
            return this;
        }

        @Override
        public Builder withInstantRange(Option<InstantRange> instantRange) {
            this.instantRange = instantRange;
            return this;
        }

        public Builder withLogRecordScannerCallback(LogRecordScannerCallback callback) {
            this.callback = callback;
            return this;
        }

        @Override
        public Builder withOptimizedLogBlocksScan(boolean enableOptimizedLogBlocksScan) {
            this.enableOptimizedLogBlocksScan = enableOptimizedLogBlocksScan;
            return this;
        }

        @Override
        public Builder withRecordMerger(HoodieRecordMerger recordMerger) {
            this.recordMerger = HoodieRecordUtils.mergerToPreCombineMode(recordMerger);
            return this;
        }

        @Override
        public Builder withTableMetaClient(HoodieTableMetaClient hoodieTableMetaClient) {
            this.hoodieTableMetaClient = hoodieTableMetaClient;
            return this;
        }

        @Override
        public HoodieUnMergedLogRecordScanner build() {
            ValidationUtils.checkArgument(this.recordMerger != null);
            return new HoodieUnMergedLogRecordScanner(this.storage, this.basePath, this.logFilePaths, this.readerSchema, this.latestInstantTime, this.reverseReader, this.bufferSize, this.callback, this.instantRange, this.internalSchema, this.enableOptimizedLogBlocksScan, this.recordMerger, Option.ofNullable(this.hoodieTableMetaClient));
        }
    }

    @FunctionalInterface
    public static interface LogRecordScannerCallback {
        public void apply(HoodieRecord<?> var1) throws Exception;
    }
}

