/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.model;

import java.io.IOException;
import java.util.Properties;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.model.HoodieAvroIndexedRecord;
import org.apache.hudi.common.model.HoodieAvroRecord;
import org.apache.hudi.common.model.HoodiePreCombineAvroRecordMerger;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordMerger;
import org.apache.hudi.common.model.OperationModeAwareness;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.org.apache.avro.Schema;
import org.apache.hudi.org.apache.avro.generic.IndexedRecord;

public class HoodieAvroRecordMerger
implements HoodieRecordMerger,
OperationModeAwareness {
    public static final HoodieAvroRecordMerger INSTANCE = new HoodieAvroRecordMerger();

    @Override
    public String getMergingStrategy() {
        return "eeb8d96f-b1e4-49fd-bbf8-28ac514178e5";
    }

    @Override
    public Option<Pair<HoodieRecord, Schema>> merge(HoodieRecord older, Schema oldSchema, HoodieRecord newer, Schema newSchema, TypedProperties props) throws IOException {
        return this.combineAndGetUpdateValue(older, newer, newSchema, props).map(r -> Pair.of(new HoodieAvroIndexedRecord((IndexedRecord)r), r.getSchema()));
    }

    @Override
    public HoodieRecord.HoodieRecordType getRecordType() {
        return HoodieRecord.HoodieRecordType.AVRO;
    }

    private Option<IndexedRecord> combineAndGetUpdateValue(HoodieRecord older, HoodieRecord newer, Schema schema, Properties props) throws IOException {
        Option<IndexedRecord> previousAvroData = older.toIndexedRecord(schema, props).map(HoodieRecord::getData);
        if (!previousAvroData.isPresent()) {
            return Option.empty();
        }
        return ((HoodieAvroRecord)newer).getData().combineAndGetUpdateValue(previousAvroData.get(), schema, props);
    }

    @Override
    public HoodieRecordMerger asPreCombiningMode() {
        return HoodiePreCombineAvroRecordMerger.INSTANCE;
    }
}

