/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.fs;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeoutException;
import org.apache.hudi.common.fs.ConsistencyGuard;
import org.apache.hudi.common.fs.ConsistencyGuardConfig;
import org.apache.hudi.common.fs.FailSafeConsistencyGuard;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StoragePath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OptimisticConsistencyGuard
extends FailSafeConsistencyGuard {
    private static final Logger LOG = LoggerFactory.getLogger(OptimisticConsistencyGuard.class);

    public OptimisticConsistencyGuard(HoodieStorage storage, ConsistencyGuardConfig consistencyGuardConfig) {
        super(storage, consistencyGuardConfig);
    }

    @Override
    public void waitTillFileAppears(StoragePath filePath) throws TimeoutException {
        try {
            if (!this.checkFileVisibility(filePath, ConsistencyGuard.FileVisibility.APPEAR)) {
                Thread.sleep(this.consistencyGuardConfig.getOptimisticConsistencyGuardSleepTimeMs());
            }
        }
        catch (IOException | InterruptedException ioe) {
            LOG.warn("Got IOException or InterruptedException waiting for file visibility. Ignoring", (Throwable)ioe);
        }
    }

    @Override
    public void waitTillFileDisappears(StoragePath filePath) throws TimeoutException {
    }

    @Override
    public void waitTillAllFilesAppear(String dirPath, List<String> files) throws TimeoutException {
        try {
            if (!this.checkFilesVisibility(1, new StoragePath(dirPath), this.getFilesWithoutSchemeAndAuthority(files), ConsistencyGuard.FileVisibility.APPEAR)) {
                Thread.sleep(this.consistencyGuardConfig.getOptimisticConsistencyGuardSleepTimeMs());
            }
        }
        catch (InterruptedException ie) {
            LOG.warn("Got InterruptedException waiting for file visibility. Ignoring", (Throwable)ie);
        }
    }

    @Override
    public void waitTillAllFilesDisappear(String dirPath, List<String> files) throws TimeoutException {
    }
}

