/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.bootstrap.index.hfile;

import java.io.IOException;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.avro.model.HoodieBootstrapFilePartitionInfo;
import org.apache.hudi.avro.model.HoodieBootstrapIndexInfo;
import org.apache.hudi.avro.model.HoodieBootstrapPartitionMetadata;
import org.apache.hudi.common.bootstrap.index.BootstrapIndex;
import org.apache.hudi.common.bootstrap.index.HFileBootstrapIndex;
import org.apache.hudi.common.bootstrap.index.hfile.HFileBootstrapIndex;
import org.apache.hudi.common.model.BootstrapFileMapping;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.TimelineMetadataUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.org.apache.hadoop.hbase.KeyValue;
import org.apache.hudi.org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hudi.org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hudi.org.apache.hadoop.hbase.io.hfile.HFileContext;
import org.apache.hudi.org.apache.hadoop.hbase.io.hfile.HFileContextBuilder;
import org.apache.hudi.storage.StoragePath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HBaseHFileBootstrapIndexWriter
extends BootstrapIndex.IndexWriter {
    private static final Logger LOG = LoggerFactory.getLogger(HBaseHFileBootstrapIndexWriter.class);
    private final String bootstrapBasePath;
    private final StoragePath indexByPartitionPath;
    private final StoragePath indexByFileIdPath;
    private HFile.Writer indexByPartitionWriter;
    private HFile.Writer indexByFileIdWriter;
    private boolean closed = false;
    private int numPartitionKeysAdded = 0;
    private int numFileIdKeysAdded = 0;
    private final Map<String, List<BootstrapFileMapping>> sourceFileMappings = new HashMap<String, List<BootstrapFileMapping>>();

    public HBaseHFileBootstrapIndexWriter(String bootstrapBasePath, HoodieTableMetaClient metaClient) {
        super(metaClient);
        try {
            metaClient.initializeBootstrapDirsIfNotExists();
            this.bootstrapBasePath = bootstrapBasePath;
            this.indexByPartitionPath = HFileBootstrapIndex.partitionIndexPath(metaClient);
            this.indexByFileIdPath = HFileBootstrapIndex.fileIdIndexPath(metaClient);
            if (metaClient.getStorage().exists(this.indexByPartitionPath) || metaClient.getStorage().exists(this.indexByFileIdPath)) {
                String errMsg = "Previous version of bootstrap index exists. Partition Index Path :" + this.indexByPartitionPath + ", FileId index Path :" + this.indexByFileIdPath;
                LOG.info(errMsg);
                throw new HoodieException(errMsg);
            }
        }
        catch (IOException ioe) {
            throw new HoodieIOException(ioe.getMessage(), ioe);
        }
    }

    private void writeNextPartition(String partitionPath, String bootstrapPartitionPath, List<BootstrapFileMapping> bootstrapFileMappings) {
        try {
            LOG.info("Adding bootstrap partition Index entry for partition :" + partitionPath + ", bootstrap Partition :" + bootstrapPartitionPath + ", Num Entries :" + bootstrapFileMappings.size());
            LOG.info("ADDING entries :" + bootstrapFileMappings);
            HoodieBootstrapPartitionMetadata bootstrapPartitionMetadata = new HoodieBootstrapPartitionMetadata();
            bootstrapPartitionMetadata.setBootstrapPartitionPath(bootstrapPartitionPath);
            bootstrapPartitionMetadata.setPartitionPath(partitionPath);
            bootstrapPartitionMetadata.setFileIdToBootstrapFile(bootstrapFileMappings.stream().map(m -> Pair.of(m.getFileId(), m.getBootstrapFileStatus())).collect(Collectors.toMap(Pair::getKey, Pair::getValue)));
            Option<byte[]> bytes = TimelineMetadataUtils.serializeAvroMetadata(bootstrapPartitionMetadata, HoodieBootstrapPartitionMetadata.class);
            if (bytes.isPresent()) {
                this.indexByPartitionWriter.append(new KeyValue(StringUtils.getUTF8Bytes(HFileBootstrapIndex.getPartitionKey(partitionPath)), new byte[0], new byte[0], Long.MAX_VALUE, KeyValue.Type.Put, bytes.get()));
                ++this.numPartitionKeysAdded;
            }
        }
        catch (IOException e) {
            throw new HoodieIOException(e.getMessage(), e);
        }
    }

    private void writeNextSourceFileMapping(BootstrapFileMapping mapping) {
        try {
            HoodieBootstrapFilePartitionInfo srcFilePartitionInfo = new HoodieBootstrapFilePartitionInfo();
            srcFilePartitionInfo.setPartitionPath(mapping.getPartitionPath());
            srcFilePartitionInfo.setBootstrapPartitionPath(mapping.getBootstrapPartitionPath());
            srcFilePartitionInfo.setBootstrapFileStatus(mapping.getBootstrapFileStatus());
            KeyValue kv = new KeyValue(StringUtils.getUTF8Bytes(HFileBootstrapIndex.getFileGroupKey(mapping.getFileGroupId())), new byte[0], new byte[0], Long.MAX_VALUE, KeyValue.Type.Put, TimelineMetadataUtils.serializeAvroMetadata(srcFilePartitionInfo, HoodieBootstrapFilePartitionInfo.class).get());
            this.indexByFileIdWriter.append(kv);
            ++this.numFileIdKeysAdded;
        }
        catch (IOException e) {
            throw new HoodieIOException(e.getMessage(), e);
        }
    }

    private void commit() {
        try {
            if (!this.closed) {
                HoodieBootstrapIndexInfo partitionIndexInfo = HoodieBootstrapIndexInfo.newBuilder().setCreatedTimestamp(new Date().getTime()).setNumKeys(this.numPartitionKeysAdded).setBootstrapBasePath(this.bootstrapBasePath).build();
                LOG.info("Adding Partition FileInfo :" + partitionIndexInfo);
                HoodieBootstrapIndexInfo fileIdIndexInfo = HoodieBootstrapIndexInfo.newBuilder().setCreatedTimestamp(new Date().getTime()).setNumKeys(this.numFileIdKeysAdded).setBootstrapBasePath(this.bootstrapBasePath).build();
                LOG.info("Appending FileId FileInfo :" + fileIdIndexInfo);
                this.indexByPartitionWriter.appendFileInfo(HFileBootstrapIndex.INDEX_INFO_KEY, TimelineMetadataUtils.serializeAvroMetadata(partitionIndexInfo, HoodieBootstrapIndexInfo.class).get());
                this.indexByFileIdWriter.appendFileInfo(HFileBootstrapIndex.INDEX_INFO_KEY, TimelineMetadataUtils.serializeAvroMetadata(fileIdIndexInfo, HoodieBootstrapIndexInfo.class).get());
                this.close();
            }
        }
        catch (IOException ioe) {
            throw new HoodieIOException(ioe.getMessage(), ioe);
        }
    }

    @Override
    public void close() {
        try {
            if (!this.closed) {
                this.indexByPartitionWriter.close();
                this.indexByFileIdWriter.close();
                this.closed = true;
            }
        }
        catch (IOException ioe) {
            throw new HoodieIOException(ioe.getMessage(), ioe);
        }
    }

    @Override
    public void begin() {
        try {
            HFileContext meta = new HFileContextBuilder().withCellComparator(new HFileBootstrapIndex.HoodieKVComparator()).build();
            this.indexByPartitionWriter = HFile.getWriterFactory(this.metaClient.getStorageConf().unwrapAs(Configuration.class), new CacheConfig(this.metaClient.getStorageConf().unwrapAs(Configuration.class))).withPath((FileSystem)this.metaClient.getStorage().getFileSystem(), new Path(this.indexByPartitionPath.toUri())).withFileContext(meta).create();
            this.indexByFileIdWriter = HFile.getWriterFactory(this.metaClient.getStorageConf().unwrapAs(Configuration.class), new CacheConfig(this.metaClient.getStorageConf().unwrapAs(Configuration.class))).withPath((FileSystem)this.metaClient.getStorage().getFileSystem(), new Path(this.indexByFileIdPath.toUri())).withFileContext(meta).create();
        }
        catch (IOException ioe) {
            throw new HoodieIOException(ioe.getMessage(), ioe);
        }
    }

    @Override
    public void appendNextPartition(String partitionPath, List<BootstrapFileMapping> bootstrapFileMappings) {
        this.sourceFileMappings.put(partitionPath, bootstrapFileMappings);
    }

    @Override
    public void finish() {
        List<String> partitions = this.sourceFileMappings.keySet().stream().sorted().collect(Collectors.toList());
        partitions.forEach(p -> this.writeNextPartition((String)p, this.sourceFileMappings.get(p).get(0).getBootstrapPartitionPath(), this.sourceFileMappings.get(p)));
        this.sourceFileMappings.values().stream().flatMap(Collection::stream).sorted().forEach(this::writeNextSourceFileMapping);
        this.commit();
    }
}

